/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.variable.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.File2ObsUtils;
import com.kingdee.eas.hr.emp.app.util.PersonPhotoUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.dataplatform.VariableConfigException;
import com.kingdee.shr.dataplatform.variable.IVariableService;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.Map;

public class CurPersonPhotoPathService
implements IVariableService {
    public static final String CURRENT_USER_ID = "userId";
    public static final String CURRENT_USER_PERSON_ID = "personId";

    public Object process(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String[] vars = (String[])param.get("variableFunctionParams");
        String personId = "";
        if (vars != null) {
            personId = vars[0];
        } else {
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null) {
                return "";
            }
            personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        String permItemId = (String)param.get("permItemId");
        if (StringUtils.isEmpty((String)permItemId)) {
            throw new VariableConfigException(VariableConfigException.PARAMS_EXCEPTION, new Object[]{"Variable Param [permItemID] not allowed NULL!"});
        }
        String photoPath = this.getPhotoPath(ctx, personId);
        return photoPath;
    }

    protected String getPhotoPath(Context ctx, String personId) throws EASBizException, BOSException {
        BOSUuid.read((String)personId);
        String photoPath = "";
        boolean isUsrOBS = File2ObsUtils.isUseOBS((Context)ctx);
        if (isUsrOBS) {
            String imageData = File2ObsUtils.getPersonPhotoFromOSB((Context)ctx, (String)personId);
            if (null != imageData) {
                photoPath = imageData;
            }
        } else {
            Map photoPathMap = PersonPhotoUtil.getPersonPhotoPath((String)personId, (Context)ctx);
            if (photoPathMap != null && new File((String)photoPathMap.get("server")).exists()) {
                photoPath = (String)photoPathMap.get("web");
            }
        }
        return photoPath;
    }
}

