/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.variable.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.app.util.PersonPhotoUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.dataplatform.VariableConfigException;
import com.kingdee.shr.dataplatform.variable.IVariableService;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SupPersonPhotoPathService
implements IVariableService {
    public static final String TEMP_TABNAME = "T_HR_PersonPhotoPath";

    public Object process(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String permItemId = (String)param.get("permItemId");
        if (StringUtils.isEmpty((String)permItemId)) {
            throw new VariableConfigException(VariableConfigException.PARAMS_EXCEPTION, new Object[]{"Variable Param [permItemID] not allowed NULL!"});
        }
        boolean syn = false;
        String[] vars = (String[])param.get("variableFunctionParams");
        if (vars != null && "SYN".equalsIgnoreCase(vars[0])) {
            syn = true;
        }
        Map<String, String> existMap = this.getExistMap(ctx, TEMP_TABNAME);
        ArrayList<Object[]> inList = new ArrayList<Object[]>();
        ArrayList<Object[]> upList = new ArrayList<Object[]>();
        String insertSql = this.getInsertSql();
        String updateSql = this.getUpdateSql();
        boolean isNeedInsert = false;
        boolean isNeedUpdate = false;
        IRowSet rowSet = this.getUpHierarchy(ctx, userId);
        try {
            while (rowSet.next()) {
                String photoPath;
                String fPersonId = rowSet.getString("FPersonId");
                int fGender = rowSet.getInt("FGender");
                String fCreatorId = userId;
                String fLastUpdateUserID = userId;
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                if (!existMap.containsKey(fPersonId) && !this.isExistOneByPerson(ctx, existMap, fPersonId).booleanValue()) {
                    photoPath = this.getPhotoPath(ctx, fPersonId, fGender);
                    inList.add(new Object[]{fPersonId, fGender, photoPath, fCreatorId, fLastUpdateUserID, timestamp, timestamp});
                    isNeedInsert = true;
                    continue;
                }
                if (!syn && !StringUtils.isEmpty((String)existMap.get(fPersonId))) continue;
                photoPath = this.getPhotoPath(ctx, fPersonId, fGender);
                upList.add(new Object[]{fGender, photoPath, fLastUpdateUserID, timestamp, fPersonId});
                isNeedUpdate = true;
            }
            if (isNeedInsert && inList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)insertSql, inList);
            }
            if (isNeedUpdate && upList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateSql, upList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return 1;
    }

    protected String getPhotoPath(Context ctx, String personId, int fGender) throws EASBizException, BOSException {
        Map personPhotoMap = null;
        personPhotoMap = PersonPhotoUtil.getPersonPhotoPath((String)personId, (Context)ctx);
        if (personPhotoMap != null && !new File((String)personPhotoMap.get("server")).exists()) {
            personPhotoMap.put("web", "");
        }
        String photoPath = (String)personPhotoMap.get("web");
        return photoPath;
    }

    protected String getUpdateSql() {
        String updateSql = "update T_HR_PersonPhotoPath SET FGender=?, FPhotopath=?, FLastUpdateUserID=?, FLastUpdateTime=? where fPersonId = ? ";
        return updateSql;
    }

    protected String getInsertSql() {
        String insertSql = "insert into T_HR_PersonPhotoPath ( FPersonId, FGender, FPhotopath, FCREATORID , FLASTUPDATEUSERID ,FCREATETIME, FLASTUPDATETIME ) values (?,?,?,?,?,?,?) ";
        return insertSql;
    }

    protected Map<String, String> getExistMap(Context ctx, String tabName) throws BOSException {
        String photoPathSql = "SELECT top 128 fPersonId,fPhotopath FROM " + tabName + " ";
        IRowSet photoPathRowSet = DbUtil.executeQuery((Context)ctx, (String)photoPathSql);
        HashMap<String, String> existMap = new HashMap<String, String>(128);
        try {
            while (photoPathRowSet.next()) {
                String fPersonId = photoPathRowSet.getString("fPersonId");
                String fPhotopath = photoPathRowSet.getString("fPhotopath");
                existMap.put(fPersonId, fPhotopath);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return existMap;
    }

    protected Boolean isExistOneByPerson(Context ctx, Map<String, String> existMap, String personId) throws BOSException {
        boolean isExist = false;
        String selectOne = "SELECT top 1 fPersonId,fPhotopath FROM T_HR_PersonPhotoPath where fpersonId = '" + personId + "' ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectOne);
            while (rowSet.next()) {
                String fPersonId = rowSet.getString("fPersonId");
                String fPhotopath = StringUtils.cnulls((String)rowSet.getString("fPhotopath"));
                if (StringUtils.isEmpty((String)fPersonId)) continue;
                existMap.put(fPersonId, fPhotopath);
                isExist = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return isExist;
    }

    protected IRowSet getUpHierarchy(Context ctx, String userId) throws BOSException {
        String selectSql = "select upperson.fid FPersonId, upperson.fgender FGender from T_HR_EmpOrgRelation emprelation inner join T_BD_Person person on emprelation.fpersonid = person.fid inner join T_PM_User pmuser on pmuser.fpersonid = person.fid inner join T_ORG_PositionHierarchy hierarchy on hierarchy.fchildid = emprelation.fpositionid and hierarchy.fparentid != hierarchy.fchildid inner join T_HR_EmpOrgRelation uprelation on hierarchy.fparentid = uprelation.fpositionid inner join T_HR_EmpLaborRelation uplaborrelation on uprelation.flaborrelationid = uplaborrelation.fid inner join T_HR_BDEmployeeType upemptype on uplaborrelation.flaborrelationstateid = upemptype.fid inner join T_ORG_Admin upadmin on uprelation.fadminorgid = upadmin.fid inner join T_ORG_Position upposition on uprelation.fpositionid = upposition.fid inner join T_BD_Person upperson on uprelation.fpersonid = upperson.fid where emprelation.fisinner = 1 and emprelation.fassigntype = 1 and pmuser.fid = '" + userId + "' and emprelation.fleffdt =  {ts'2199-12-31'} and uprelation.fisinner = 1 and upemptype.fisonthestrength = 1 and uprelation.fleffdt =  {ts'2199-12-31'}  and upadmin.fissealup = 0 and upadmin.fisstartshr = 1 and hierarchy.fhierarchyid = '00000000-0000-0000-0000-000000000001396FCAD0' ";
        return DbUtil.executeQuery((Context)ctx, (String)selectSql);
    }
}

