/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.ml.MLServiceFactory;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.LocaleUtils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;

public class MLCacheHelper {
    private static Logger logger = Logger.getLogger(MLCacheHelper.class);
    private static final String CACHE_TYPE = "shr.mlcache";

    private static void setMlCache(String pkg, String fileName, String language, Map obj) {
        CustomCacheService cache = new CustomCacheService(CACHE_TYPE);
        cache.put(MLCacheHelper.getKey(pkg, fileName, language), (Object)obj);
    }

    private static Map getMlCache(String pkg, String fileName, String language) {
        CustomCacheService cache = new CustomCacheService(CACHE_TYPE);
        return (Map)cache.get(MLCacheHelper.getKey(pkg, fileName, language));
    }

    private static String getKey(String pkg, String fileName, String language) {
        return MessageFormat.format("{0}_{1}_{2}", pkg, fileName, language);
    }

    public static void remove(String pkg, String fileName, String language) {
        CustomCacheService cache = new CustomCacheService(CACHE_TYPE);
        cache.remove(MLCacheHelper.getKey(pkg, fileName, language));
    }

    public static void removeAll() {
        CustomCacheService cache = new CustomCacheService(CACHE_TYPE);
        cache.removeAll();
    }

    public static Map getResource(Context ctx, ResourceType pkg, String fileName) throws BOSException, EASBizException {
        if (null == ctx) {
            return Collections.EMPTY_MAP;
        }
        String locale = ctx.getLocale().toString();
        Map m = MLCacheHelper.getMlCache(pkg.getValue(), fileName, locale);
        if (m == null) {
            m = LocaleUtils.locale_zh_CN.toString().equals(com.kingdee.shr.base.syssetting.util.LocaleUtils.getLocal((Context)ctx)) ? MLServiceFactory.getLocalInstance(ctx).getSHRResource(pkg.getValue(), fileName) : SHRServerResource.getFileResource((Context)ctx, (String)pkg.getValue(), (String)fileName);
            MLCacheHelper.setMlCache(pkg.getValue(), fileName, locale, m);
        }
        if (null == m) {
            m = Collections.EMPTY_MAP;
        }
        return m;
    }
}

