/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.tools;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class ShrSqlGenerator {
    private Context ctx;
    private String entityName;

    public ShrSqlGenerator(Context ctx, String entityName) {
        this.ctx = ctx;
        this.entityName = entityName;
    }

    private void genUpdateSQL(String tableName, ColumnInfo mappingField, StringBuffer sqlBuffer, String lan) throws BOSException, SQLException {
        String sql = MessageFormat.format("select FID,{0}_{1} ul,{2}_l2 ol from {3}", mappingField.getName(), lan, mappingField.getName(), tableName);
        IRowSet rs = null;
        if (LocaleUtils.locale_l3.getDisplayName().equals(lan)) {
            String zhTwUpdateSql = MessageFormat.format("select FID,{0}_l3 tw, {1}_l2 zh from {2} where {3}_l3 is null", mappingField.getName(), mappingField.getName(), tableName, mappingField.getName());
            rs = DbUtil.executeQuery((Context)this.ctx, (String)zhTwUpdateSql);
            String updateSQL = MessageFormat.format("update {0} set {1}_l3 = ? where FID = ?", tableName, mappingField.getName());
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rs.next()) {
                if (StringUtils.isEmpty((String)rs.getString("zh"))) continue;
                String zh = rs.getString("zh");
                if (!StringUtils.isEmpty((String)zh)) {
                    zh = zh.replace("\n", "");
                    zh = zh.replace("\t", "");
                } else {
                    zh = "";
                }
                paramsList.add(new Object[]{STConverter.sc2tc((String)zh), rs.getString("FID")});
            }
            if (paramsList.size() > 0) {
                DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, paramsList);
            }
        }
        rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        while (rs.next()) {
            String ul = rs.getString("ul");
            if (!StringUtils.isEmpty((String)ul)) {
                ul = ul.replace("\n", "");
                ul = ul.replace("\t", "");
                ul = ul.replace("'", "''");
            } else {
                ul = "";
            }
            sqlBuffer.append("update ").append(tableName).append(" set ").append(mappingField.getName()).append("_").append(lan).append(" = N'").append(ul).append("' where FID = '").append(rs.getString("FID")).append("';\n");
        }
    }

    public String doGenMultiFieldSql() throws BOSException {
        EntityObjectInfo entityObject = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)this.entityName));
        if (null == entityObject.getBOSType() || entityObject.isAbstract()) {
            return null;
        }
        DataTableInfo dt = entityObject.getTable();
        if (null == dt || StringUtils.isEmpty((String)dt.getName())) {
            return null;
        }
        StringBuffer en_US = new StringBuffer();
        StringBuffer zh_TW = new StringBuffer();
        PropertyCollection ps = entityObject.getPropertiesRuntime();
        try {
            int total = ps.size();
            for (int i = 0; i < total; ++i) {
                OwnPropertyInfo op;
                PropertyInfo p = ps.get(i);
                if (!(p instanceof OwnPropertyInfo) || !(op = (OwnPropertyInfo)p).isMultilingual()) continue;
                this.genUpdateSQL(dt.getName(), op.getMappingField(), en_US, LocaleUtils.locale_l1.getDisplayName());
                this.genUpdateSQL(dt.getName(), op.getMappingField(), zh_TW, LocaleUtils.locale_l3.getDisplayName());
            }
            this.genFile(SHRSyssettingUtil.getIotmpdir(), dt.getName().toLowerCase(), en_US, "en_US");
            this.genFile(SHRSyssettingUtil.getIotmpdir(), dt.getName().toLowerCase(), zh_TW, "zh_TW");
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genFile(String iotmpdir, String tableName, StringBuffer content, String displayName) throws IOException {
        File f;
        String file = iotmpdir + File.separator + displayName + File.separator + tableName + ".sql";
        File dir = new File(iotmpdir + File.separator + displayName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((f = new File(file)).exists()) {
            f.delete();
        }
        FileOutputStream fo = null;
        BufferedOutputStream bo = null;
        try {
            f.createNewFile();
            fo = new FileOutputStream(f);
            bo = new BufferedOutputStream(fo);
            bo.write(content.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bo != null) {
                try {
                    bo.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    bo.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void updateSC2TCForPresetData() throws BOSException {
        PagingHelper pageHelper = new PagingHelper();
        try {
            String sql = "SELECT FID ,FTEXT_ZH_CN FROM T_RES_PRESETDATARES WHERE FTEXT_ZH_CN IS NOT NULL AND FTEXT_ZH_TW IS NULL";
            String updateSQL = "UPDATE T_RES_PRESETDATARES SET FTEXT_ZH_TW = ? WHERE FID = ?";
            int max = 5000;
            String excuteSql = null;
            ArrayList<Object[]> paramsList = null;
            do {
                excuteSql = pageHelper.getPagingSqlNoOptmize(this.ctx, sql, 0, max);
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)excuteSql);
                paramsList = new ArrayList<Object[]>();
                while (rs.next()) {
                    String fid = rs.getString("FID");
                    if (fid == null) continue;
                    String cn = rs.getString("FTEXT_ZH_CN");
                    if (!StringUtils.isEmpty((String)cn)) {
                        paramsList.add(new Object[]{STConverter.sc2tc((String)cn), rs.getString("FID")});
                        continue;
                    }
                    paramsList.add(new Object[]{null, rs.getString("FID")});
                }
                if (paramsList.isEmpty()) continue;
                DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, paramsList);
            } while (!paramsList.isEmpty());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    public void updateEnUsForPresetData() throws BOSException {
        PagingHelper pageHelper = new PagingHelper();
        try {
            String sql = "SELECT FID, FTEXT_ZH_CN FROM T_RES_PRESETDATARES WHERE FTEXT_ZH_CN NOT LIKE '%?%' AND FTEXT_EN_US IS NULL ";
            String updateSQL = "UPDATE T_RES_PRESETDATARES SET FTEXT_EN_US = ? WHERE FID = ?";
            int max = 100000;
            String excuteSql = null;
            ArrayList<Object[]> paramsList = null;
            do {
                excuteSql = pageHelper.getPagingSqlNoOptmize(this.ctx, sql, 0, max);
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)excuteSql);
                paramsList = new ArrayList<Object[]>();
                while (rs.next()) {
                    String cn;
                    String fid = rs.getString("FID");
                    if (fid == null || StringUtils.isEmpty((String)(cn = rs.getString("FTEXT_ZH_CN"))) || MLUtils.containChinese((String)cn)) continue;
                    paramsList.add(new Object[]{cn, rs.getString("FID")});
                }
                if (paramsList.isEmpty()) continue;
                DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, paramsList);
            } while (!paramsList.isEmpty());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    public void updateSC2TCForRes() throws BOSException {
        PagingHelper pageHelper = new PagingHelper();
        String[] resTab = new String[]{"T_RES_UIRESOURCE", "T_RES_RESRESOURCE", "T_RES_ENUMRESOURCE", "T_RES_ENTITYRESOURCE", "T_RES_QUERYRESOURCE", "T_RES_MDBVIEWRESOURCE"};
        String[] mlResTab = new String[]{"T_RES_UIMULTILAN", "T_RES_RESMULTILAN", "T_RES_ENUMMULTILAN", "T_RES_ENTITYMULTILAN", "T_RES_QUERYMULTILAN", "T_RES_MDBVIEWMULTILAN"};
        try {
            for (int i = 0; i < resTab.length; ++i) {
                String sql = "select mlTab.fid mlId, tab.FRes res, tab.FRes2 res2 from " + mlResTab[i] + " mlTab inner join " + resTab[i] + " tab on tab.FID = mlTab.fResId where mlTab.flanguage = 'zh_TW' AND (mlTab.FMLRes IS NULL OR mlTab.FMLRes2 IS NULL)";
                String updateSQL = "update " + mlResTab[i] + " set FMLRes = ?, FMLRes2 = ? where FID = ? ";
                int max = 5000;
                String excuteSql = null;
                ArrayList<Object[]> paramsList = null;
                do {
                    excuteSql = pageHelper.getPagingSqlNoOptmize(this.ctx, sql, 0, max);
                    IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)excuteSql);
                    paramsList = new ArrayList<Object[]>();
                    while (rs.next()) {
                        String mlId = rs.getString("mlId");
                        if (mlId == null) continue;
                        String res = null;
                        if (rs.getString("res") != null) {
                            res = STConverter.sc2tc((String)rs.getString("res"));
                        }
                        String res2 = null;
                        if (rs.getString("res2") != null) {
                            res2 = STConverter.sc2tc((String)rs.getString("res2"));
                        }
                        paramsList.add(new Object[]{res, res2, mlId});
                    }
                    DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, paramsList);
                } while (!paramsList.isEmpty());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    public void updateSC2TCForCommonRes() throws BOSException {
        PagingHelper pageHelper = new PagingHelper();
        String sql = "select t1.FID, t2.FRES  from T_RES_EASMultiLanRes t1 INNER JOIN T_RES_EASResource t2 ON T1.FPARENTID = T2.FID where FLANGUAGEID ='zh_TW' and (FCONTENT ='null' or FCONTENT is null)";
        String updateSQL = "UPDATE T_RES_EASMultiLanRes SET FCONTENT = ?, FISTRANSLATED=1, FTransTime=now() where FID = ?";
        int max = 5000;
        String excuteSql = null;
        IRowSet rs = null;
        try {
            ArrayList<Object[]> paramsList = null;
            do {
                excuteSql = pageHelper.getPagingSqlNoOptmize(this.ctx, sql, 0, max);
                rs = DbUtil.executeQuery((Context)this.ctx, (String)excuteSql);
                paramsList = new ArrayList<Object[]>();
                while (rs.next()) {
                    paramsList.add(new Object[]{STConverter.sc2tc((String)rs.getString("FRES")), rs.getString("FID")});
                }
                DbUtil.executeBatch((Context)this.ctx, (String)updateSQL, paramsList);
            } while (!paramsList.isEmpty());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void updateSC2TC() throws BOSException {
        this.updateSC2TCForCommonRes();
        this.updateSC2TCForRes();
        this.updateSC2TCForPresetData();
    }
}

