/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.util;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class MutilanUtils {
    public static boolean QUOTE_FLAG = false;
    public static boolean LINE_STAR_FLAG = false;
    private static final Pattern CHINESE_PTN = Pattern.compile("^.*?[\\u4e00-\\u9fa5]+.*?$", 32);
    private static final Pattern CHINESE_PTN0 = Pattern.compile("([\\u4e00-\\u9fa5]+)");
    private static final Pattern JSON_STRING_PTN0 = Pattern.compile("\\{.*\\}");

    public static String getChinese(String paramValue) {
        StringBuffer str = new StringBuffer();
        if (StringUtils.isEmpty((String)paramValue)) {
            return paramValue;
        }
        paramValue = paramValue.replaceAll("\"", "");
        Matcher matcher = CHINESE_PTN0.matcher(paramValue);
        while (matcher.find()) {
            str.append(matcher.group(0));
        }
        return str.toString();
    }

    public static String getChineseAttributeValue(String paramValue) {
        StringBuffer str = new StringBuffer();
        if (StringUtils.isEmpty((String)paramValue)) {
            return paramValue;
        }
        Matcher ChineseMatcher = CHINESE_PTN.matcher(paramValue);
        while (ChineseMatcher.find()) {
            str.append(ChineseMatcher.group(0));
        }
        return str.toString();
    }

    public static boolean containsJson(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return false;
        }
        return JSON_STRING_PTN0.matcher(value).matches();
    }

    public static Map<String, String> parseJsonString(String jsonStr) {
        try {
            if (jsonStr.trim().startsWith("[")) {
                HashMap<String, String> map = new HashMap<String, String>();
                JSONArray jsonArray = JSONArray.parseArray((String)jsonStr);
                for (Map mapTemp : jsonArray) {
                    for (Map.Entry entry : mapTemp.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            String alias = (String)entry.getValue();
                            if (StringUtils.isEmpty((String)(alias = MutilanUtils.getChineseAttributeValue(alias)))) continue;
                            if (mapTemp.containsKey("name")) {
                                map.put((String)mapTemp.get("name"), alias);
                                continue;
                            }
                            map.put(String.valueOf(mapTemp.get("value")), alias);
                            continue;
                        }
                        Map<String, String> mapTemp01 = MutilanUtils.parseJsonString(entry.getValue().toString());
                        if (mapTemp01 == null || mapTemp01.size() <= 0) continue;
                        map.putAll(mapTemp01);
                    }
                }
                return map;
            }
            if (jsonStr.trim().startsWith("{")) {
                HashMap<String, String> map = new HashMap<String, String>();
                JSONObject jObject = new JSONObject(jsonStr);
                Iterator it = jObject.keys();
                while (it.hasNext()) {
                    String obj = (String)it.next();
                    Map<String, String> mapTemp = MutilanUtils.parseJsonString(jObject.get(obj).toString());
                    if (mapTemp == null || mapTemp.size() <= 0) continue;
                    map.putAll(mapTemp);
                }
                return map;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    public static StringBuffer analysisLine(String code) {
        StringBuffer sb = new StringBuffer();
        if (code == null) {
            return sb;
        }
        for (int i = 0; i < code.length(); ++i) {
            if (LINE_STAR_FLAG) {
                if (i + 1 >= code.length() || code.charAt(i) != '*' || code.charAt(i + 1) != '/') continue;
                LINE_STAR_FLAG = false;
                ++i;
                continue;
            }
            if (!QUOTE_FLAG) {
                if (code.charAt(i) == '\"') {
                    sb.append(code.charAt(i));
                    QUOTE_FLAG = true;
                    continue;
                }
                if (i + 1 < code.length() && code.charAt(i) == '/') {
                    if (code.charAt(i + 1) == '*') {
                        LINE_STAR_FLAG = true;
                        ++i;
                        continue;
                    }
                    if (code.charAt(i + 1) == '/') {
                        i = code.length();
                        continue;
                    }
                    sb.append(code.charAt(i));
                    continue;
                }
                sb.append(code.charAt(i));
                continue;
            }
            if (code.charAt(i) == '\"' && i > 0 && code.charAt(i - 1) != '\\') {
                sb.append(code.charAt(i));
                QUOTE_FLAG = false;
                continue;
            }
            sb.append(code.charAt(i));
        }
        sb.append("\n");
        return sb;
    }

    public static void resetAnalysisLineFlag() {
        LINE_STAR_FLAG = false;
        QUOTE_FLAG = false;
    }

    public static Map<String, String> setMultiFieldValue(String property, IObjectValue objectValue) {
        HashMap<String, String> m = new HashMap<String, String>();
        String value = null;
        List lml = BOSConfigUtil.getLanguageMapingList();
        Map lang = null;
        int total = lml.size();
        for (int i = 0; i < total; ++i) {
            lang = (Map)lml.get(i);
            value = (String)objectValue.get(property, LocaleUtils.getLocale((String)((String)lang.get("lang"))));
            m.put((String)lang.get("lang"), StringUtils.isEmpty((String)value) ? "" : value);
        }
        return m;
    }

    public static void setMultiFieldValueBeanToBean(IObjectValue objectValueA, String propertyA, IObjectValue objectValueB, String propertyB) {
        if (null == objectValueA || null == objectValueB || StringUtils.isEmpty((String)propertyA) || StringUtils.isEmpty((String)propertyB)) {
            return;
        }
        List lml = BOSConfigUtil.getLanguageMapingList();
        Map lang = null;
        int total = lml.size();
        for (int i = 0; i < total; ++i) {
            lang = (Map)lml.get(i);
            objectValueB.put(propertyB, objectValueA.get(propertyA, LocaleUtils.getLocale((String)((String)lang.get("lang")))), LocaleUtils.getLocale((String)((String)lang.get("lang"))));
        }
        objectValueB.put(propertyB, objectValueA.get(propertyA));
    }

    public static void setMultiFieldValueToBean(Context ctx, String property, IObjectValue objectValue, String value) {
        Object id = objectValue.get("id");
        if (null == id) {
            List lml = BOSConfigUtil.getLanguageMapingList();
            Map lang = null;
            int total = lml.size();
            for (int i = 0; i < total; ++i) {
                lang = (Map)lml.get(i);
                objectValue.put(property, (Object)value, LocaleUtils.getLocale((String)((String)lang.get("lang"))));
            }
        }
        objectValue.put(property, (Object)value, ctx.getLocale());
        objectValue.put(property, (Object)value);
    }

    public static void setMultiFieldValueToBean(Context ctx, String property, IObjectValue objectValue, Map<String, String> value) {
        Object id = objectValue.get("id");
        if (null == id) {
            List lml = BOSConfigUtil.getLanguageMapingList();
            Map lang = null;
            int total = lml.size();
            for (int i = 0; i < total; ++i) {
                lang = (Map)lml.get(i);
                objectValue.put(property, (Object)value.get(lang.get("lang")), LocaleUtils.getLocale((String)((String)lang.get("lang"))));
            }
        }
        objectValue.put(property, (Object)MutilanUtils.getCurrentMultiFieldValue(ctx, value), ctx.getLocale());
        objectValue.put(property, (Object)MutilanUtils.getCurrentMultiFieldValue(ctx, value));
    }

    public static void setMultiFieldValueToBean1(Context ctx, String property, IObjectValue objectValue, Map<String, String> value) {
        Object id = objectValue.get("id");
        List lml = BOSConfigUtil.getLanguageMapingList();
        Map lang = null;
        int total = lml.size();
        for (int i = 0; i < total; ++i) {
            lang = (Map)lml.get(i);
            objectValue.put(property, (Object)value.get(lang.get("lang")), LocaleUtils.getLocale((String)((String)lang.get("lang"))));
        }
        objectValue.put(property, (Object)MutilanUtils.getCurrentMultiFieldValue(ctx, value), ctx.getLocale());
        objectValue.put(property, (Object)MutilanUtils.getCurrentMultiFieldValue(ctx, value));
    }

    public static String getCurrentMultiFieldValue(Context ctx, Map<String, String> value) {
        return value.get(LocaleUtils.getShortCode((Context)ctx));
    }

    public static List<Attribute> getAttributeContainZh(Element ele) {
        List attributes = ele.getAttributes();
        if (null == attributes || attributes.size() <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Attribute> attributesZh = new ArrayList<Attribute>();
        for (Attribute attr : attributes) {
            boolean isZh = MLUtils.containChinese((String)attr.getValue());
            if (!isZh) continue;
            attributesZh.add(attr);
        }
        return attributesZh;
    }

    public static String getXPath(Element ele) throws BOSException {
        Element elee = ele;
        ArrayList<String> xpathList = new ArrayList<String>();
        HashSet<String> zhAttributes = new HashSet<String>();
        try {
            String excludes;
            Properties p = SHRSyssettingUtil.getPropertiesFileByPath((String)SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"MultiLan_Config.properties"));
            if (null != p && null != p.get("EXCLUDE_ATTRIBUTES") && !StringUtils.isEmpty((String)(excludes = (String)p.get("EXCLUDE_ATTRIBUTES")))) {
                for (String str : excludes.split(",")) {
                    if (StringUtils.isEmpty((String)str)) continue;
                    zhAttributes.add(str.trim());
                }
            }
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        while (null != elee && elee.getParent() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(elee.getName());
            List attributes0 = elee.getAttributes();
            if (null == attributes0 || attributes0.size() <= 0) {
                xpathList.add(sb.toString());
                elee = elee.getParentElement();
                continue;
            }
            for (Attribute attr0 : attributes0) {
                if (zhAttributes.contains(attr0.getName())) continue;
                HashSet<String> ZHAttributesOthers = new HashSet<String>();
                if (MLUtils.containChinese((String)attr0.getValue())) {
                    if (ZHAttributesOthers.contains(attr0.getName())) continue;
                    ZHAttributesOthers.add(attr0.getName());
                    continue;
                }
                sb.append("[@").append(attr0.getName()).append("='").append(attr0.getValue()).append("']");
            }
            xpathList.add(sb.toString());
            elee = elee.getParentElement();
        }
        StringBuffer xPath = new StringBuffer();
        xPath.append("\\").append(ele.getDocument().getRootElement().getName());
        for (int j = xpathList.size() - 1; j >= 0; --j) {
            xPath.append("\\").append((String)xpathList.get(j));
        }
        return xPath.toString();
    }

    public static final String getMD5Key(String realKey) {
        return MLUtils.md5HashCode((String)realKey);
    }
}

