/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontDetector;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.autodetect.FontFileFinder;
import org.apache.fop.util.LogUtil;

public class CustomerDefaultFontDetector
implements FontDetector {
    private static Log log = LogFactory.getLog(CustomerDefaultFontDetector.class);

    public void detect(FontManager fontManager, FontAdder fontAdder, boolean strict, FontEventListener eventListener, List<EmbedFontInfo> fontInfoList) throws FOPException {
        try {
            FontFileFinder fontFileFinder = new FontFileFinder(eventListener);
            URI fontBaseURI = fontManager.getResourceResolver().getBaseURI();
            File fontBase = FileUtils.toFile((URL)fontBaseURI.toURL());
            if (fontBase != null) {
                List fontURLList = fontFileFinder.find(fontBase.getAbsolutePath());
                fontAdder.add(fontURLList, fontInfoList);
            }
            List systemFontList = fontFileFinder.find();
            fontAdder.add(systemFontList, fontInfoList);
        }
        catch (IOException e) {
            LogUtil.handleException((Log)log, (Exception)e, (boolean)strict);
        }
        catch (URISyntaxException use) {
            LogUtil.handleException((Log)log, (Exception)use, (boolean)strict);
        }
    }
}

