/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.api.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.util.StringUtils;
import java.util.Set;

public abstract class SHRFunctionPermissionService {
    public static void checkFunctionPermission(Context ctx, String userId, PermItemInfo permItemInfo) throws BOSException, EASBizException {
        SHRFunctionPermissionService.checkFunctionPermission(ctx, userId, null, permItemInfo);
    }

    public static void checkCurrnetUserFunctionPermission(Context ctx, PermItemInfo permItemInfo) throws BOSException, EASBizException {
        if (null == permItemInfo) {
            // empty if block
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        SHRFunctionPermissionService.checkFunctionPermission(ctx, userId, null, permItemInfo);
    }

    public static void checkFunctionPermission(Context ctx, String userId, Set<String> hrOrgIdSet, PermItemInfo permItemInfo) throws BOSException, EASBizException {
        try {
            UserInfo u = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (!UserType.SYSTEM.equals((Object)u.getType()) && OrgType.HRO.equals((Object)permItemInfo.getOrgRelation()) && (PermItemType.BIZ_FUNCTION.equals((Object)permItemInfo.getType()) || PermItemType.INTEGRATION_FUNCTION.equals((Object)permItemInfo.getType()))) {
                Set<String> set = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet(ctx, userId, permItemInfo.getId().toString());
                if (set != null && !set.isEmpty()) {
                    return;
                }
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            SHRFunctionPermissionService.checkEmptyHrOrgFunctionPermission(ctx, permission, permItemInfo);
        }
        catch (PermissionException e) {
            if (e.getSubCode().equals(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION.getCode())) {
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
            throw e;
        }
    }

    public static void checkEmptyHrOrgFunctionPermission(Context ctx, IPermission permission, PermItemInfo permItemInfo) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String permItemName = permItemInfo.getName();
        ObjectUuidPK userPK = null;
        if (!StringUtils.isEmpty((String)userId)) {
            userPK = new ObjectUuidPK(userId);
        }
        OrgUnitInfo org = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        ObjectUuidPK orgPK = new ObjectUuidPK(org.getId());
        permission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItemName);
    }
}

