/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.ISensitiveConfig;
import com.kingdee.shr.base.permission.SensitiveConfigEntryCollection;
import com.kingdee.shr.base.permission.SensitiveConfigEntryInfo;
import com.kingdee.shr.base.permission.SensitiveConfigFactory;
import com.kingdee.shr.base.permission.SensitiveConfigInfo;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShrSensitiveCacheHelper {
    private static Logger logger = Logger.getLogger(ShrSensitiveCacheHelper.class);
    private static final String CACHE_TYPE = "shr.sensitiveConfig";

    public static Map<String, Map<String, Object>> getSensitiveConfigByFullName(Context ctx, String fullName) throws EASBizException, BOSException {
        Map<String, Map<String, Object>> sensitiveConfig = ShrSensitiveCacheHelper.getSensitiveConfigFromCacheByFullName(ctx, fullName);
        if (null == sensitiveConfig && null != (sensitiveConfig = ShrSensitiveCacheHelper.getSensitiveConfigFromDBByByFullName(ctx, fullName))) {
            ShrSensitiveCacheHelper.addSensitiveConfigToCacheByFullName(ctx, fullName, sensitiveConfig);
        }
        return sensitiveConfig;
    }

    public static void removeSensitiveConfigFromCacheByFullName(Context ctx, String fullName) throws BOSException {
        Map<String, Map<String, Object>> sensitiveConfig = ShrSensitiveCacheHelper.getSensitiveConfigFromCacheByFullName(ctx, fullName);
        if (null != sensitiveConfig) {
            CacheService.getInstance().remove(CACHE_TYPE, fullName);
        }
    }

    public static void removeAll() {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }

    public static Map<String, Map<String, Object>> getSensitiveConfigFromCacheByFullName(Context ctx, String fullName) throws BOSException {
        Object obj = CacheService.getInstance().get(CACHE_TYPE, fullName);
        if (null == obj) {
            return null;
        }
        return (Map)obj;
    }

    public static Map<String, Map<String, Object>> getSensitiveConfigFromDBByByFullName(Context ctx, String fullName) throws EASBizException, BOSException {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        SensitiveConfigInfo dbInfo = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fullName", (Object)fullName, CompareType.EQUALS));
        filter.setMaskString("#0");
        ISensitiveConfig iSensitiveConfig = null;
        iSensitiveConfig = null == ctx ? SensitiveConfigFactory.getRemoteInstance() : SensitiveConfigFactory.getLocalInstance(ctx);
        String oql = "select entries.property,entries.sRule.number,entries.sRuleExt.number where fullName = '" + fullName + "'";
        if (iSensitiveConfig.exists(filter)) {
            dbInfo = iSensitiveConfig.getSensitiveConfigInfo(oql);
        }
        if (dbInfo != null && dbInfo.getEntries() != null) {
            SensitiveConfigEntryCollection entries = dbInfo.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                SensitiveConfigEntryInfo entry = entries.get(i);
                String ruleName = "";
                ruleName = entry.getSRuleExt() != null && !StringUtils.isEmpty((String)entry.getSRuleExt().getNumber()) ? entry.getSRuleExt().getNumber() : entry.getSRule().getNumber();
                if ("unhandled".equals(ruleName)) {
                    map.put("name", "default");
                    map.put("isOpen", false);
                } else {
                    map.put("name", ruleName);
                    map.put("isOpen", true);
                }
                result.put(entry.getProperty(), map);
            }
        }
        return result;
    }

    public static void addSensitiveConfigToCacheByFullName(Context ctx, String fullName, Map<String, Map<String, Object>> info) throws BOSException {
        CacheService.getInstance().put(CACHE_TYPE, ShrSensitiveCacheHelper.generateKeyByEntityName(ctx, fullName), info);
    }

    private static String generateKeyByEntityName(Context ctx, String entityName) throws BOSException {
        if (null == ctx) {
            throw new BOSException("context should not be null!");
        }
        return MessageFormat.format("{0}", entityName);
    }
}

