/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.shr.base.permission.client.CheckBoxTreeLabel;
import com.kingdee.shr.base.permission.client.CheckBoxTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;

public class CheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    protected JCheckBox check;
    protected CheckBoxTreeLabel label;
    protected KDPanel kDTablePanel;

    public CheckBoxTreeCellRenderer(KDPanel kDTablePanel) {
        this.setLayout(null);
        this.check = new JCheckBox();
        this.add(this.check);
        this.label = new CheckBoxTreeLabel();
        this.add(this.label);
        this.check.setBackground(UIManager.getColor("Tree.textBackground"));
        this.label.setForeground(UIManager.getColor("Tree.textForeground"));
        this.kDTablePanel = kDTablePanel;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        this.check.setSelected(((CheckBoxTreeNode)((Object)value)).isSelected());
        this.label.setFont(tree.getFont());
        this.label.setText(stringValue);
        this.label.setSelected(selected);
        this.label.setFocus(hasFocus);
        if (leaf) {
            this.label.setIcon(UIManager.getIcon("Tree.leafIcon"));
        } else if (expanded) {
            this.label.setIcon(UIManager.getIcon("Tree.openIcon"));
        } else {
            this.label.setIcon(UIManager.getIcon("Tree.closedIcon"));
        }
        if (selected) {
            TitledBorder titledBorder = (TitledBorder)this.kDTablePanel.getBorder();
            titledBorder.setTitle(MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"permission_org_range"), stringValue));
            titledBorder.setTitleColor(Color.RED);
            this.kDTablePanel.repaint();
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dCheck = this.check.getPreferredSize();
        Dimension dLabel = this.label.getPreferredSize();
        return new Dimension(dCheck.width + dLabel.width, dCheck.height < dLabel.height ? dLabel.height : dCheck.height);
    }

    @Override
    public void doLayout() {
        Dimension dCheck = this.check.getPreferredSize();
        Dimension dLabel = this.label.getPreferredSize();
        int yCheck = 0;
        int yLabel = 0;
        if (dCheck.height < dLabel.height) {
            yCheck = (dLabel.height - dCheck.height) / 2;
        } else {
            yLabel = (dCheck.height - dLabel.height) / 2;
        }
        this.check.setLocation(0, 0);
        this.check.setBounds(0, 0, dCheck.width, dCheck.height - 4);
        this.label.setLocation(dCheck.width, yLabel + 2);
        this.label.setBounds(dCheck.width, yLabel, dLabel.width, dCheck.height - 4);
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }
}

