/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class CheckBoxTreeLabel
extends JLabel {
    private boolean isSelected;
    private boolean hasFocus;

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    @Override
    public void paint(Graphics g) {
        String str = this.getText();
        if (str != null && 0 < str.length()) {
            if (this.isSelected) {
                g.setColor(new ColorUIResource(Color.LIGHT_GRAY));
            } else {
                g.setColor(UIManager.getColor("Tree.textBackground"));
            }
            Dimension d = this.getPreferredSize();
            int imageOffset = 0;
            Icon currentIcon = this.getIcon();
            if (currentIcon != null) {
                imageOffset = currentIcon.getIconWidth() + Math.max(0, this.getIconTextGap() - 2);
            }
            g.fillRect(imageOffset, 0, d.width - imageOffset, d.height);
            if (this.hasFocus) {
                g.setColor(new ColorUIResource(Color.LIGHT_GRAY));
                g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
            }
        }
        super.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void setFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
    }
}

