/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.shr.base.permission.ISHRUserAdminOrgPermFacade;
import com.kingdee.shr.base.permission.SHRUserAdminOrgPermFacadeFactory;
import com.kingdee.shr.base.permission.client.AbstractExportDetailConfigUI;
import com.kingdee.shr.base.permission.client.OrgRangeSettingUI;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class ExportDetailConfigUI
extends AbstractExportDetailConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(ExportDetailConfigUI.class);
    private static final int BTNSTATUS_DEFAULT = 0;
    private static final int BTNSTATUS_EXPORTING = 1;
    private static final int BTNSTATUS_EXPORT_COMPLETE = 2;
    private int currentExportStatus = 0;
    private OrgRangeSettingUI parentUI = null;
    private Object excelFile = null;
    private IObjectPK targetUserPK = null;
    protected ExportExcelConfigParam configParam = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"export_hrpermission_data"));
        this.targetUserPK = this.getTargetUserPK();
        Map context = super.getUIContext();
        Object parent = context.get("Owner");
        if (parent instanceof CoreUI) {
            this.parentUI = (OrgRangeSettingUI)((Object)parent);
        }
        this.lableExporting.setVisible(false);
    }

    private IObjectPK getTargetUserPK() {
        return (IObjectPK)this.getUIContext().get("targetID");
    }

    protected void initConfigParam(ExportExcelConfigParam configParam) {
        this.configParam = configParam;
        this.radioVer2007.setSelected(configParam.isExportExcel2007());
        this.radioVer2003.setSelected(configParam.isExportExcel2003());
        if (configParam.isExportSelect()) {
            this.radioSelect.setSelected(true);
        } else {
            this.radioFull.setSelected(true);
        }
        this.textPath.setText(new File(configParam.getSavePath(), this.bulidFileName(true)).getAbsolutePath());
    }

    private String getDefaultFilePath() {
        String suffix = this.getConfigParamFromUI().isExportExcel2007() ? ".xlsx" : ".xls";
        return this.getSystemTempFile(suffix).getPath();
    }

    public File getSystemTempFile(String suffix) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("eastemp", suffix);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return tempFile;
    }

    @Override
    public void actionChoosePath_actionPerformed(ActionEvent e) throws Exception {
        this.initSaveDialog();
    }

    private void initSaveDialog() throws Exception {
        KDFileChooser fileChooser = this.initKDFileChooser();
        this.excelFile = this.getConfigParamFromUI().isExportExcel2007() ? this.initFile(fileChooser, ".xlsx") : this.initFile(fileChooser, ".xls");
    }

    private KDFileChooser initKDFileChooser() throws Exception {
        String title = !this.getConfigParamFromUI().isExportSelect() ? EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ExportToExcel") : EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ExportSelected");
        String FileName = this.bulidFileName(true);
        String suffix = this.getConfigParamFromUI().isExportExcel2007() ? ".xlsx" : ".xls";
        KDFileChooser fileChooser = this.getKDFileChooser(title, this.configParam.getSavePath(), FileName, suffix);
        return fileChooser;
    }

    private String bulidFileName(boolean isShowTime) {
        String dateTime = "";
        if (isShowTime) {
            SimpleDateFormat tempDate = new SimpleDateFormat("yyyyMMddHHmmss");
            dateTime = tempDate.format(new Date());
        }
        StringBuffer name = new StringBuffer();
        String fileName = EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"hrpermission_data");
        name.append(fileName).append(dateTime);
        if (this.getConfigParamFromUI().isExportExcel2007()) {
            name.append(".xlsx");
        } else {
            name.append(".xls");
        }
        return name.toString();
    }

    private File initFile(KDFileChooser fileChooser, String suffix) throws Exception {
        if (fileChooser != null) {
            int result = fileChooser.showSaveDialog(null);
            File file = fileChooser.getSelectedFile();
            if (result != 0) {
                return null;
            }
            if (!file.getAbsolutePath().endsWith(suffix)) {
                file = new File(file.getAbsolutePath() + suffix);
            }
            if (file.exists()) {
                int select = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"56_ExportExcelConfigUI"));
                if (select == 2) {
                    return null;
                }
                if (select == 0 && !file.renameTo(file)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"57_ExportExcelConfigUI"));
                    return null;
                }
            }
            this.textPath.setText(file.getAbsolutePath());
            return file;
        }
        return null;
    }

    private KDFileChooser getKDFileChooser(String title, String path, String fileName, String suffix) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(new File(path, fileName));
        fileChooser.setFileFilter(this.bulidFilter(suffix));
        return fileChooser;
    }

    private FileFilter bulidFilter(final String suffix) throws Exception {
        FileFilter fileFilter = new FileFilter(){
            private static final String suffix_2003 = "xls";
            private static final String suffix_2007 = "xlsx";

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null) {
                    return extension.equalsIgnoreCase(this.getFilterSuffix());
                }
                return false;
            }

            private String getExtension(File f) {
                String ext = null;
                String fileName = f.getName();
                int i = fileName.lastIndexOf(".");
                if (i > 0 && i < fileName.length() - 1) {
                    ext = fileName.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            @Override
            public String getDescription() {
                return suffix + "(*." + this.getFilterSuffix() + ")";
            }

            private String getFilterSuffix() {
                if (".xlsx".equals(suffix)) {
                    return suffix_2007;
                }
                return suffix_2003;
            }
        };
        return fileFilter;
    }

    private ExportExcelConfigParam getConfigParamFromUI() {
        ExportExcelConfigParam uiParam = new ExportExcelConfigParam();
        uiParam.setExcelVersion(this.radioVer2007.isSelected() ? 0 : 1);
        uiParam.setExportSelect(this.radioSelect.isSelected());
        File file = new File(this.textPath.getText());
        uiParam.setSavePath(file.getParent());
        uiParam.setFileName(file.getName());
        return uiParam;
    }

    @Override
    public void actionStartToExport_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.parentUI.getMainTable();
        int rowCount = table.getRowCount();
        ArrayList ids = new ArrayList();
        String path = this.textPath.getStringValue();
        if (this.radioSelect.isSelected()) {
            ids = this.parentUI.getSelectedIdValuesArrayList();
            if (ids.size() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_need_export_item"));
                return;
            }
        } else {
            for (int i = 0; i < rowCount; ++i) {
                ICell cell = table.getRow(i).getCell("id");
                ids.add(cell.getValue().toString());
            }
        }
        ISHRUserAdminOrgPermFacade iFacade = SHRUserAdminOrgPermFacadeFactory.getRemoteInstance();
        List userAdminSubOrgPerm = new ArrayList();
        if ((userAdminSubOrgPerm = iFacade.getUserAdminSubOrgPerm(this.targetUserPK, ids, userAdminSubOrgPerm)).size() > 10000) {
            MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"total_rows_please_wait"), userAdminSubOrgPerm.size()));
        }
        this.export2Excel(userAdminSubOrgPerm, path, table);
        this.lableExporting.setVisible(false);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"export_success"));
        this.disposeUIWindow();
    }

    private void export2Excel(List userAdminSubOrgPerm, String path, KDTable table) throws Exception {
        IRow headRow = table.getHeadRow(0);
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        SXSSFSheet sheet = wb.createSheet();
        this.setTableHeader(wb, (Sheet)sheet, headRow);
        this.setTableBody(wb, (Sheet)sheet, userAdminSubOrgPerm, path);
    }

    private void setTableBody(SXSSFWorkbook wb, Sheet sheet, List userAdminSubOrgPerm, String path) throws Exception {
        CellStyle bodyStyle = wb.createCellStyle();
        bodyStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setFontName("Dialog.plain");
        font.setFontHeight(9.0);
        bodyStyle.setFont((Font)font);
        int size = userAdminSubOrgPerm.size();
        int cycle = size % 100 == 0 ? size / 100 : size / 100 + 1;
        block0: for (int i = 0; i < cycle; ++i) {
            for (int j = 0; j < 100; ++j) {
                Row row = sheet.createRow(i * 100 + j + 1);
                if (i * 100 + j >= size) continue block0;
                Map map = (Map)userAdminSubOrgPerm.get(i * 100 + j);
                Cell cell00 = row.createCell(0);
                Cell cell01 = row.createCell(1);
                Cell cell02 = row.createCell(2);
                Cell cell03 = row.createCell(3);
                Cell cell04 = row.createCell(4);
                Cell cell05 = row.createCell(5);
                cell00.setCellValue((String)map.get("parentName"));
                cell01.setCellValue((String)map.get("permItemNumber"));
                cell02.setCellValue((String)map.get("permItemAlias"));
                cell03.setCellValue((String)map.get("orgNumber"));
                cell04.setCellValue((String)map.get("orgName"));
                cell05.setCellValue((String)map.get("orgLongNumber"));
                cell00.setCellStyle(bodyStyle);
                cell01.setCellStyle(bodyStyle);
                cell02.setCellStyle(bodyStyle);
                cell03.setCellStyle(bodyStyle);
                cell04.setCellStyle(bodyStyle);
                cell05.setCellStyle(bodyStyle);
            }
        }
        FileOutputStream fops = new FileOutputStream(path);
        wb.write((OutputStream)fops);
        fops.close();
        wb.dispose();
    }

    private void setTableHeader(SXSSFWorkbook wb, Sheet sheet, IRow headRow) {
        Row header = sheet.createRow(0);
        Cell cell00 = header.createCell(0);
        Cell cell01 = header.createCell(1);
        Cell cell02 = header.createCell(2);
        Cell cell03 = header.createCell(3);
        Cell cell04 = header.createCell(4);
        Cell cell05 = header.createCell(5);
        cell00.setCellValue(headRow.getCell("parent.name").getValue().toString());
        cell01.setCellValue(headRow.getCell("permItem.number").getValue().toString());
        cell02.setCellValue(headRow.getCell("permItem.alias").getValue().toString());
        cell03.setCellValue(headRow.getCell("org.number").getValue().toString());
        cell04.setCellValue(headRow.getCell("org.name").getValue().toString());
        cell05.setCellValue(headRow.getCell("org.longNumber").getValue().toString());
        CellStyle headerStyle = wb.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.index);
        headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setFontName("Dialog.plain");
        font.setFontHeight(9.0);
        headerStyle.setFont((Font)font);
        cell00.setCellStyle(headerStyle);
        cell01.setCellStyle(headerStyle);
        cell02.setCellStyle(headerStyle);
        cell03.setCellStyle(headerStyle);
        cell04.setCellStyle(headerStyle);
        cell05.setCellStyle(headerStyle);
    }

    @Override
    public void actionDoCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentExportStatus == 1) {
            this.currentExportStatus = 0;
        }
        this.disposeUIWindow();
    }

    public void disposeUIWindow() {
        if (this.currentExportStatus != 1) {
            super.disposeUIWindow();
        }
    }
}

