/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RoleInfoWithNumber;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgRangeF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.shr.base.permission.ISHRRoleAdminOrgPerm;
import com.kingdee.shr.base.permission.ISHRUserOrgPermFacade;
import com.kingdee.shr.base.permission.SHRRoleAdminOrgPermFactory;
import com.kingdee.shr.base.permission.SHRUserOrgPermFacadeFactory;
import com.kingdee.shr.base.permission.client.AbstractOrgPermDistributeByRoleUI;
import com.kingdee.shr.base.permission.client.SHRAdminOrgRangeF7PromptDialog;
import com.kingdee.shr.base.permission.client.helper.OrgRangeSettingTreeHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class OrgPermDistributeByRoleUI
extends AbstractOrgPermDistributeByRoleUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgPermDistributeByRoleUI.class);
    private OrgRangeSettingTreeHelper treeHelper = null;
    private UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
    KDTree kdTree = new KDTree();
    private List<String> selectOrgList = new ArrayList<String>();
    private List<String> selectOrgLongNumberList = new ArrayList<String>();
    private List subOrgSelectedList = new ArrayList();
    private FullOrgUnitCollection orgCol = null;
    private IObjectPK sourceUserPK = null;
    private IObjectPK targetUserPK = null;
    private IObjectPK orgPK = null;
    private UserInfo userInfo = null;
    private String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    OrgRangeF7PromptDialog accreditF7Dialog = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeHelper = new OrgRangeSettingTreeHelper();
        this.sourceUserPK = this.getCurrentUserPK();
        this.targetUserPK = this.getTargetUserPK();
        this.orgPK = this.getHROrgPK();
        this.orgCol = this.getOrgCol();
        this.setUITitle(EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"distribute_byrole"));
        this.initAllRoleList();
        this.initSelectRoleList();
        this.execQuery();
        this.actionSelectAdminOrg.setEnabled(false);
        this.initTab();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon addAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAddAll.setText(null);
        this.btnAddAll.setIcon(addAllIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(deleteIcon);
        Icon deleteAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_left");
        this.btnDeleteAll.setText(null);
        this.btnDeleteAll.setIcon(deleteAllIcon);
    }

    private void initTab() {
        IColumn idCol = this.tblMain.getColumn("id");
        IColumn cuidCol = this.tblMain.getColumn("cu.id");
        idCol.setWidth(0);
        cuidCol.setWidth(0);
        IColumn isIncludeSubOrgCol = this.tblMain.getColumn("isIncludeSubOrg");
        KDCheckBox kdCheckBox = new KDCheckBox();
        if (isIncludeSubOrgCol != null) {
            isIncludeSubOrgCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)kdCheckBox));
        }
        this.tblMain.getStyleAttributes().setLocked(true);
        IColumn includeSubColumn = this.tblMain.getColumn("isIncludeSubOrg");
        if (includeSubColumn != null) {
            includeSubColumn.getStyleAttributes().setLocked(false);
        }
        kdCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OrgPermDistributeByRoleUI.this.doIncludeSubOrg(e);
            }
        });
    }

    private void doIncludeSubOrg(ItemEvent e) {
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        Boolean isIncludeSubOrg = (Boolean)row.getCell("isIncludeSubOrg").getValue();
        if (e.getStateChange() == 1 && !isIncludeSubOrg.booleanValue()) {
            IRow irow;
            int i;
            String orgId = (String)row.getCell("id").getValue();
            this.subOrgSelectedList.add(orgId);
            String longNumber = (String)row.getCell("longNumber").getValue();
            String model = longNumber + "!";
            int oldSize = this.selectOrgList.size();
            for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                String id;
                String value;
                irow = this.tblMain.getRow(i);
                if (irow == null || !(value = (String)irow.getCell("longNumber").getValue()).startsWith(model) || !this.selectOrgList.contains(id = (String)irow.getCell("id").getValue())) continue;
                this.selectOrgList.remove(id);
                this.selectOrgLongNumberList.remove(value);
            }
            if (oldSize != this.selectOrgList.size()) {
                this.execQuery();
                for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                    irow = this.tblMain.getRow(i);
                    String id = (String)irow.getCell("id").getValue();
                    if (!this.subOrgSelectedList.contains(id) || !this.selectOrgList.contains(id)) continue;
                    ICell cell = irow.getCell("isIncludeSubOrg");
                    cell.setValue((Object)true);
                }
            }
        }
    }

    private FullOrgUnitCollection getOrgCol() throws Exception {
        FullOrgUnitCollection ret = new FullOrgUnitCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)this.targetUserPK.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)10, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("org.isHROrgUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("org.id"));
        selectorCol.add(new SelectorItemInfo("org.orgTypeStr"));
        entityViewInfo.setSelector(selectorCol);
        entityViewInfo.setFilter(filterInfo);
        OrgRangeCollection coll = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection(entityViewInfo);
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                OrgRangeInfo orgRangeInfo = coll.get(i);
                ret.add(orgRangeInfo.getOrg());
            }
        } else if (this.orgPK != null) {
            FullOrgUnitInfo info = new FullOrgUnitInfo();
            info.setId(BOSUuid.read((String)this.orgPK.toString()));
            ret.add(info);
        }
        return ret;
    }

    public ISHRUserOrgPermFacade getNewBizInterface() throws BOSException {
        return SHRUserOrgPermFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionSelectAdminOrg_actionPerformed(ActionEvent e) throws Exception {
        final ArrayList old = new ArrayList();
        SHRAdminOrgRangeF7PromptDialog orgF7 = new SHRAdminOrgRangeF7PromptDialog((IUIObject)this, this.getCurrentUser()){

            public void viewDidShow() {
                super.getInnerF7UI().setCancel(false);
                OrgPermDistributeByRoleUI.this.initSnapshot(this, old);
                super.getInnerF7UI().setCancel(true);
            }

            protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
                OrgAssistInfo info = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
                info.setNeedAddOrgRange(false);
                info.setNeedAddUserCU(false);
                info.setNeedAddCU(false);
                info.setIgnoreUnionGroup(true);
                info.setNeedConsiderFaultTree(true);
                StringBuffer extraFilters = new StringBuffer();
                extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FControlUnitID IN (").append(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, (IObjectPK)ToolUtils.getCurrentUserPK())).append(")");
                extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FID in (select fid from t_org_admin where fisstartshr = 1)");
                info.setExtraFilters(extraFilters.toString());
                return info;
            }

            public FilterInfo getOuterFilterInfo() {
                FilterInfo filter = new FilterInfo();
                try {
                    StringBuffer result = new StringBuffer();
                    result.append("UNIT.CU.id in (").append(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, (IObjectPK)ToolUtils.getCurrentUserPK())).append(")");
                    filter.mergeFilter(new FilterInfo(result.toString()), "and");
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                return filter;
            }
        };
        if (this.selectOrgList.size() > 0) {
            HashSet<String> orgIds = new HashSet<String>();
            for (String object : this.selectOrgList) {
                orgIds.add(object);
            }
            orgF7.setSelectedOrgIds(orgIds);
        }
        orgF7.show();
        if (!orgF7.isCanceled()) {
            this.selectOrgList.clear();
            this.selectOrgLongNumberList.clear();
            Object obj = orgF7.getData();
            OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
            for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                this.selectOrgList.add(orgUnitInfoAry[i].getId().toString());
                this.selectOrgLongNumberList.add(orgUnitInfoAry[i].getLongNumber());
            }
        }
        this.execQuery();
    }

    public void initSnapshot(SHRAdminOrgRangeF7PromptDialog dialog, List old) {
        FullOrgUnitInfo[] tmp = PermissionUIHelper.getOrgs((Object)dialog.getData());
        if (tmp == null) {
            return;
        }
        for (FullOrgUnitInfo info : tmp) {
            old.add(info);
        }
    }

    protected void execQuery() {
        FilterInfo filterInfo = this.getDefaultFilteInfo();
        if (this.mainQuery != null && filterInfo != null) {
            this.mainQuery.setFilter(filterInfo);
            this.setSortInfo(this.mainQuery);
        } else if (this.mainQuery != null && filterInfo == null) {
            try {
                FilterInfo none = new FilterInfo("number = 1 and number = -1");
                this.mainQuery.setFilter(none);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        super.execQuery();
    }

    private FilterInfo getDefaultFilteInfo() {
        FilterInfo myFilterInfo = new FilterInfo();
        String idStr = this.getAccreditOrgIdStr();
        if (StringUtils.isEmpty((String)idStr)) {
            return null;
        }
        myFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INCLUDE));
        return myFilterInfo;
    }

    private String getAccreditOrgIdStr() {
        if (this.selectOrgList == null || this.selectOrgList.isEmpty()) {
            return null;
        }
        return ToolUtils.aryToStr(this.selectOrgList, (boolean)false);
    }

    private void setSortInfo(EntityViewInfo targetQuery) {
        targetQuery.getSorter().clear();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        targetQuery.getSorter().add(sorterItemInfo);
    }

    private List<Boolean> getIsSelectedSubOrgList() {
        ArrayList<Boolean> isSelectedSubOrg = new ArrayList<Boolean>();
        for (int i = 0; i < this.selectOrgList.size(); ++i) {
            Boolean value = (Boolean)this.tblMain.getRow(i).getCell("isIncludeSubOrg").getValue();
            isSelectedSubOrg.add(value);
        }
        return isSelectedSubOrg;
    }

    private IObjectPK getTargetUserPK() {
        return (IObjectPK)this.getUIContext().get("targetID");
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private IObjectPK getHROrgPK() {
        IObjectPK pk = null;
        if (this.getUIContext().get("orgPK") instanceof IObjectPK) {
            pk = (IObjectPK)this.getUIContext().get("orgPK");
        } else if (this.getUIContext().get("orgPK") instanceof String) {
            pk = new ObjectUuidPK(String.valueOf(this.getUIContext().get("orgPK")));
        }
        return pk;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AdminOrgUnitFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private void initAllRoleList() throws BOSException, EASBizException {
        IUserRoleOrgManager userRoleOrgManager = UserRoleOrgManagerFactory.getRemoteInstance();
        RoleCollection roleCollection = userRoleOrgManager.getAllUserRole(this.targetUserPK);
        DefaultListModel<RoleInfoWithNumber> assignModel = new DefaultListModel<RoleInfoWithNumber>();
        for (int i = 0; i < roleCollection.size(); ++i) {
            assignModel.addElement(this.toRoleInfoWithNumber(roleCollection.get(i)));
        }
        this.kDListRoleFrom.setModel(assignModel);
        this.kDListRoleFrom.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    OrgPermDistributeByRoleUI.this.addRoleToSelecte();
                }
            }
        });
    }

    private void initSelectRoleList() {
        this.kDListRoleTo.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    OrgPermDistributeByRoleUI.this.deleteRoleSelect();
                }
            }
        });
    }

    private RoleInfoWithNumber toRoleInfoWithNumber(RoleInfo role) {
        RoleInfoWithNumber ret = new RoleInfoWithNumber();
        ret.setName(role.getName());
        ret.setNumber(role.getNumber());
        ret.setId(role.getId());
        ret.setSimpleName(role.getSimpleName());
        ret.setCU(role.getCU());
        return ret;
    }

    private void addRoleToSelecte() {
        if (this.kDListRoleFrom.getSelectedIndex() == -1) {
            return;
        }
        Object[] objects = this.kDListRoleFrom.getSelectedValues();
        for (int i = 0; i < objects.length; ++i) {
            RoleInfo roleInfo = (RoleInfo)objects[i];
            if (this.isAssignRoleExists(roleInfo)) continue;
            this.kDListRoleTo.addElement((Object)roleInfo);
        }
        this.actionSelectAdminOrg.setEnabled(true);
    }

    private void deleteRoleSelect() {
        Object[] objects = this.kDListRoleTo.getSelectedValues();
        for (int i = 0; i < objects.length; ++i) {
            this.kDListRoleTo.removeElement(objects[i]);
        }
        if (this.kDListRoleTo.getModel().getSize() <= 0) {
            this.actionSelectAdminOrg.setEnabled(false);
        }
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kDListRoleFrom.getModel().getSize(); ++i) {
            RoleInfo roleInfo = (RoleInfo)this.kDListRoleFrom.getModel().getElementAt(i);
            if (this.isAssignRoleExists(roleInfo)) continue;
            this.kDListRoleTo.addElement((Object)roleInfo);
        }
        this.actionSelectAdminOrg.setEnabled(true);
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        this.addRoleToSelecte();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        this.deleteRoleSelect();
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        for (int i = this.kDListRoleTo.getModel().getSize(); i > 0; --i) {
            this.kDListRoleTo.removeElementAt(i - 1);
        }
        this.actionSelectAdminOrg.setEnabled(false);
    }

    private boolean isAssignRoleExists(RoleInfo roleInfo) {
        for (int i = 0; i < this.kDListRoleTo.getModel().getSize(); ++i) {
            RoleInfo info = (RoleInfo)this.kDListRoleTo.getModel().getElementAt(i);
            if (!info.getId().equals((Object)roleInfo.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        super.actionDistribute_actionPerformed(e);
        if (this.selectOrgList.size() < 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_adminorg"));
            return;
        }
        if (this.kDListRoleTo.getModel().getSize() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_role"));
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_assign_perm_to_user")) == 0) {
            List<Boolean> isSelectedSubOrg = this.getIsSelectedSubOrgList();
            ArrayList<String> roleList = new ArrayList<String>();
            for (int i = 0; i < this.kDListRoleTo.getModel().getSize(); ++i) {
                RoleInfo info = (RoleInfo)this.kDListRoleTo.getModel().getElementAt(i);
                roleList.add(info.getId().toString());
            }
            try {
                ISHRRoleAdminOrgPerm orgPerm = SHRRoleAdminOrgPermFactory.getRemoteInstance();
                orgPerm.saveUserAdminOrgPerm(this.targetUserPK, roleList, this.selectOrgList, isSelectedSubOrg, this.selectOrgLongNumberList);
            }
            catch (BOSException e1) {
                throw new Exception(e1.getMessage(), e1);
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"assign_success"));
            this.disposeUIWindow();
        }
    }
}

