/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.helper.PermissionUIHelper;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgAssistInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgRangeF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.shr.base.permission.ISHRUserAdminOrgPermFacade;
import com.kingdee.shr.base.permission.ISHRUserOrgPermFacade;
import com.kingdee.shr.base.permission.SHRUserAdminOrgPermFacadeFactory;
import com.kingdee.shr.base.permission.SHRUserOrgPermFacadeFactory;
import com.kingdee.shr.base.permission.client.AbstractOrgPermDistributeUI;
import com.kingdee.shr.base.permission.client.SHRAdminOrgRangeF7PromptDialog;
import com.kingdee.shr.base.permission.client.helper.OrgRangeSettingTreeHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OrgPermDistributeUI
extends AbstractOrgPermDistributeUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgPermDistributeUI.class);
    private OrgRangeSettingTreeHelper treeHelper = null;
    private UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
    KDTree kdTree = new KDTree();
    private List selectOrgList = new ArrayList();
    private List subOrgSelectedList = new ArrayList();
    private FullOrgUnitCollection orgCol = null;
    private IObjectPK sourceUserPK = null;
    private IObjectPK targetUserPK = null;
    private IObjectPK orgPK = null;
    private UserInfo userInfo = null;
    private String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    OrgRangeF7PromptDialog accreditF7Dialog = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeHelper = new OrgRangeSettingTreeHelper();
        this.sourceUserPK = this.getCurrentUserPK();
        this.targetUserPK = this.getTargetUserPK();
        this.orgPK = this.getHROrgPK();
        this.orgCol = this.getOrgCol();
        this.buildAllTree();
        this.initTree();
        this.execQuery();
        this.actionSelectAdminOrg.setEnabled(false);
        this.initTab();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon addAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAddAll.setText(null);
        this.btnAddAll.setIcon(addAllIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(deleteIcon);
        Icon deleteAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_left");
        this.btnDeleteAll.setText(null);
        this.btnDeleteAll.setIcon(deleteAllIcon);
    }

    private void initTab() {
        IColumn idCol = this.tblMain.getColumn("id");
        IColumn cuidCol = this.tblMain.getColumn("cu.id");
        idCol.setWidth(0);
        cuidCol.setWidth(0);
        IColumn isIncludeSubOrgCol = this.tblMain.getColumn("isIncludeSubOrg");
        KDCheckBox kdCheckBox = new KDCheckBox();
        if (isIncludeSubOrgCol != null) {
            isIncludeSubOrgCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)kdCheckBox));
        }
        this.tblMain.getStyleAttributes().setLocked(true);
        IColumn includeSubColumn = this.tblMain.getColumn("isIncludeSubOrg");
        if (includeSubColumn != null) {
            includeSubColumn.getStyleAttributes().setLocked(false);
        }
        kdCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OrgPermDistributeUI.this.doIncludeSubOrg(e);
            }
        });
    }

    private void doIncludeSubOrg(ItemEvent e) {
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        Boolean isIncludeSubOrg = (Boolean)row.getCell("isIncludeSubOrg").getValue();
        if (e.getStateChange() == 1 && !isIncludeSubOrg.booleanValue()) {
            IRow irow;
            int i;
            String orgId = (String)row.getCell("id").getValue();
            this.subOrgSelectedList.add(orgId);
            String longNumber = (String)row.getCell("longNumber").getValue();
            String model = longNumber + "!";
            int oldSize = this.selectOrgList.size();
            for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                String id;
                String value;
                irow = this.tblMain.getRow(i);
                if (irow == null || !(value = (String)irow.getCell("longNumber").getValue()).startsWith(model) || !this.selectOrgList.contains(id = (String)irow.getCell("id").getValue())) continue;
                this.selectOrgList.remove(id);
            }
            if (oldSize != this.selectOrgList.size()) {
                this.execQuery();
                for (i = 0; i < this.tblMain.getRowCount(); ++i) {
                    irow = this.tblMain.getRow(i);
                    String id = (String)irow.getCell("id").getValue();
                    if (!this.subOrgSelectedList.contains(id) || !this.selectOrgList.contains(id)) continue;
                    ICell cell = irow.getCell("isIncludeSubOrg");
                    cell.setValue((Object)true);
                }
            }
        }
    }

    private void initTree() {
        try {
            this.initSourceTree();
            this.initTargetTree();
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private void buildAllTree() {
        try {
            this.buildTopSourceTree();
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private void initSourceTree() throws Exception {
        this.treeSourcePerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    OrgPermDistributeUI.this.buildLevelSourceTree(curNode);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void buildLevelSourceTree(KDTreeNode parent) throws Exception {
        if (parent == null || this.treeHelper.isLeaf(parent) || this.treeHelper.isExpended(parent)) {
            return;
        }
        ISHRUserOrgPermFacade iuopFacade = this.getNewBizInterface();
        IObjectPK sourceUserPK = this.getCurrentUserPK();
        IObjectPK targetUserPK = this.getTargetUserPK();
        PermItemInfo parentPerm = this.treeHelper.getPermItem(parent);
        UserOrgPermCollection userOrgPerms = iuopFacade.getLevelSourceUOPs(sourceUserPK, targetUserPK, this.orgCol, parentPerm, false, 10);
        this.treeHelper.buildLevelSourceTree(parent, (IObjectCollection)userOrgPerms, null);
    }

    private void initTargetTree() {
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot(null);
        this.treeAuthorizedPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    OrgPermDistributeUI.this.buildLevelTargetTree(curNode);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void buildLevelTargetTree(KDTreeNode parent) throws Exception {
        if (parent == null || this.treeHelper.isLeaf(parent) || this.treeHelper.isExpended(parent)) {
            return;
        }
        ISHRUserOrgPermFacade iuopFacade = this.getNewBizInterface();
        IObjectPK sourceUserPK = this.getCurrentUserPK();
        IObjectPK targetUserPK = this.getTargetUserPK();
        PermItemInfo parentPerm = this.treeHelper.getPermItem(parent);
        UserOrgPermCollection userOrgPerms = null;
        boolean sourceFlag = false;
        if (this.treeHelper.isSourceFlag(parent)) {
            userOrgPerms = iuopFacade.getLevelSourceUOPs(sourceUserPK, targetUserPK, this.orgCol, parentPerm, true, 10);
            sourceFlag = true;
        } else {
            userOrgPerms = iuopFacade.getLevelTargetUOPs(sourceUserPK, targetUserPK, this.orgCol, parentPerm, 10);
        }
        this.treeHelper.buildLevelTargetTree(parent, (IObjectCollection)userOrgPerms, 30, sourceFlag);
    }

    private void buildTopSourceTree() throws Exception {
        ISHRUserOrgPermFacade iuopFacade = this.getNewBizInterface();
        IObjectPK sourceUserPK = this.getCurrentUserPK();
        IObjectPK targetUserPK = this.getTargetUserPK();
        if (this.orgCol != null && this.orgCol.size() > 0) {
            UserOrgPermCollection userOrgPerms = iuopFacade.getHRPerms(sourceUserPK, targetUserPK, this.orgCol, 10);
            if (userOrgPerms.size() > 1) {
                this.treeHelper.buildTopSourceTree(this.treeSourcePerm, (IObjectCollection)userOrgPerms, null);
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission"));
                ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
            }
        } else {
            ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
        }
    }

    private FullOrgUnitCollection getOrgCol() throws Exception {
        FullOrgUnitCollection ret = new FullOrgUnitCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)this.targetUserPK.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)10, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("org.isHROrgUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("org.id"));
        selectorCol.add(new SelectorItemInfo("org.orgTypeStr"));
        entityViewInfo.setSelector(selectorCol);
        entityViewInfo.setFilter(filterInfo);
        OrgRangeCollection coll = OrgRangeFactory.getRemoteInstance().getOrgRangeCollection(entityViewInfo);
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                OrgRangeInfo orgRangeInfo = coll.get(i);
                ret.add(orgRangeInfo.getOrg());
            }
        } else if (this.orgPK != null) {
            FullOrgUnitInfo info = new FullOrgUnitInfo();
            info.setId(BOSUuid.read((String)this.orgPK.toString()));
            ret.add(info);
        }
        return ret;
    }

    public ISHRUserOrgPermFacade getNewBizInterface() throws BOSException {
        return SHRUserOrgPermFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionSelectAdminOrg_actionPerformed(ActionEvent e) throws Exception {
        final ArrayList old = new ArrayList();
        SHRAdminOrgRangeF7PromptDialog orgF7 = new SHRAdminOrgRangeF7PromptDialog((IUIObject)this, this.getCurrentUser()){

            public void viewDidShow() {
                super.getInnerF7UI().setCancel(false);
                OrgPermDistributeUI.this.initSnapshot(this, old);
                super.getInnerF7UI().setCancel(true);
            }

            protected OrgAssistInfo buildNewOrgF7AssistInfo(OrgViewType orgViewType, OrgTreeInfo orgTreeInfo, CoreBaseInfo userObject) throws EASBizException, BOSException {
                OrgAssistInfo info = super.buildNewOrgF7AssistInfo(orgViewType, orgTreeInfo, userObject);
                info.setNeedAddOrgRange(false);
                info.setNeedAddUserCU(false);
                info.setNeedAddCU(false);
                info.setIgnoreUnionGroup(true);
                info.setNeedConsiderFaultTree(true);
                StringBuffer extraFilters = new StringBuffer();
                extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FControlUnitID IN (").append(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, (IObjectPK)ToolUtils.getCurrentUserPK())).append(")");
                extraFilters.append(" AND ").append("\"BASEUNIT\"").append(".FID in (select fid from t_org_admin where fisstartshr = 1)");
                info.setExtraFilters(extraFilters.toString());
                return info;
            }

            public void setContainSealUp(boolean isShowSealUp) {
                super.setContainSealUp(false);
            }

            public FilterInfo getOuterFilterInfo() {
                FilterInfo filter = new FilterInfo();
                try {
                    StringBuffer result = new StringBuffer();
                    result.append("UNIT.CU.id in (").append(PermissionRangeHelper.getBizUserCUOrgRangeSQL(null, (IObjectPK)ToolUtils.getCurrentUserPK())).append(")");
                    filter.mergeFilter(new FilterInfo(result.toString()), "and");
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                return filter;
            }
        };
        if (this.selectOrgList.size() > 0) {
            HashSet orgIds = new HashSet();
            for (Object object : this.selectOrgList) {
                orgIds.add(object);
            }
            orgF7.setSelectedOrgIds(orgIds);
        }
        orgF7.show();
        if (!orgF7.isCanceled()) {
            this.selectOrgList.clear();
            Object obj = orgF7.getData();
            OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
            for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                this.selectOrgList.add(orgUnitInfoAry[i].getId().toString());
            }
        }
        this.execQuery();
    }

    public void initSnapshot(SHRAdminOrgRangeF7PromptDialog dialog, List old) {
        FullOrgUnitInfo[] tmp = PermissionUIHelper.getOrgs((Object)dialog.getData());
        if (tmp == null) {
            return;
        }
        for (FullOrgUnitInfo info : tmp) {
            old.add(info);
        }
    }

    protected void execQuery() {
        FilterInfo filterInfo = this.getDefaultFilteInfo();
        if (this.mainQuery != null && filterInfo != null) {
            this.mainQuery.setFilter(filterInfo);
            this.setSortInfo(this.mainQuery);
        } else if (this.mainQuery != null && filterInfo == null) {
            try {
                FilterInfo none = new FilterInfo("number = 1 and number = -1");
                this.mainQuery.setFilter(none);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        super.execQuery();
    }

    private FilterInfo getDefaultFilteInfo() {
        FilterInfo myFilterInfo = new FilterInfo();
        String idStr = this.getAccreditOrgIdStr();
        if (StringUtils.isEmpty((String)idStr)) {
            return null;
        }
        myFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INCLUDE));
        return myFilterInfo;
    }

    private String getAccreditOrgIdStr() {
        if (this.selectOrgList == null || this.selectOrgList.isEmpty()) {
            return null;
        }
        return ToolUtils.aryToStr((List)this.selectOrgList, (boolean)false);
    }

    private void setSortInfo(EntityViewInfo targetQuery) {
        targetQuery.getSorter().clear();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        targetQuery.getSorter().add(sorterItemInfo);
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        TreePath[] treePaths = this.treeSourcePerm.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            Set extendedNodes = this.treeHelper.getExpendedNodes(this.treeSourcePerm);
            this.treeHelper.addNodes(this.treeAuthorizedPerm, treeNodes, extendedNodes);
            this.treeHelper.setDefaultIcon((KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot());
        }
        if (this.treeAuthorizedPerm.getModel().getRoot() != null) {
            this.actionSelectAdminOrg.setEnabled(true);
        }
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        Object object = this.treeSourcePerm.getModel().getRoot();
        if (object != null && object instanceof KDTreeNode) {
            Set extendedNodes = this.treeHelper.getExpendedNodes(this.treeSourcePerm);
            this.treeHelper.addNodes(this.treeAuthorizedPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
            this.treeHelper.setDefaultIcon((KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot());
        }
        if (this.treeAuthorizedPerm.getModel().getRoot() != null) {
            this.actionSelectAdminOrg.setEnabled(true);
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        TreePath[] treePaths = null;
        treePaths = this.treeAuthorizedPerm.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            this.treeHelper.removeNodes(this.treeAuthorizedPerm, treeNodes);
        }
        if (this.treeAuthorizedPerm.getModel().getRoot() == null) {
            this.actionSelectAdminOrg.setEnabled(false);
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        KDTreeNode object = (KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot();
        if (object != null) {
            KDTreeNode[] treeNodes = new KDTreeNode[]{object};
            this.treeHelper.removeNodes(this.treeAuthorizedPerm, treeNodes);
        }
        if (this.treeAuthorizedPerm.getModel().getRoot() == null) {
            this.actionSelectAdminOrg.setEnabled(false);
        }
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        super.actionDistribute_actionPerformed(e);
        if (this.selectOrgList.size() < 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_need_permission_org"));
            return;
        }
        KDTreeNode rootNode = (KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot();
        PermItemCollection coll = new PermItemCollection();
        UserOrgPermCollection userOrgPerms = this.treeHelper.getUserOrgPermFromTree(this.treeAuthorizedPerm, this.targetUserPK, null, PermType.NORMAL);
        int size = userOrgPerms.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo userOrgPermInfo = userOrgPerms.get(i);
            coll.add(userOrgPermInfo.getPermItem());
        }
        if (coll.size() < 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_need_assign_perm_item"));
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_assign_perm_to_user")) == 0) {
            List<Boolean> isSelectedSubOrg = this.getIsSelectedSubOrgList();
            ISHRUserAdminOrgPermFacade iFacade = SHRUserAdminOrgPermFacadeFactory.getRemoteInstance();
            try {
                iFacade.saveUserAdminOrgPerm(this.sourceUserPK, this.targetUserPK, coll, this.selectOrgList, this.orgCol, isSelectedSubOrg);
            }
            catch (BOSException e1) {
                if (e1.getMessage().equals("500000")) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"rows_over_50"));
                    return;
                }
                throw new Exception(e1.getMessage(), e1);
            }
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"assign_success"));
            this.disposeUIWindow();
        }
    }

    private List<Boolean> getIsSelectedSubOrgList() {
        ArrayList<Boolean> isSelectedSubOrg = new ArrayList<Boolean>();
        for (int i = 0; i < this.selectOrgList.size(); ++i) {
            Boolean value = (Boolean)this.tblMain.getRow(i).getCell("isIncludeSubOrg").getValue();
            isSelectedSubOrg.add(value);
        }
        return isSelectedSubOrg;
    }

    private IObjectPK getTargetUserPK() {
        return (IObjectPK)this.getUIContext().get("targetID");
    }

    private UserInfo getUser() {
        ObjectUuidPK userPK = new ObjectUuidPK((String)this.getUIContext().get("targetID"));
        if (this.userInfo == null) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("*"));
            selectors.add(new SelectorItemInfo("defOrgUnit.*"));
            try {
                this.userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)userPK, selectors);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this.userInfo;
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private IObjectPK getHROrgPK() {
        IObjectPK pk = null;
        if (this.getUIContext().get("orgPK") instanceof IObjectPK) {
            pk = (IObjectPK)this.getUIContext().get("orgPK");
        } else if (this.getUIContext().get("orgPK") instanceof String) {
            pk = new ObjectUuidPK(String.valueOf(this.getUIContext().get("orgPK")));
        }
        return pk;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AdminOrgUnitFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

