/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.permission.client.OrgRangeListUI;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.FindDialog;
import com.kingdee.eas.framework.client.ListFind;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigManager;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.shr.base.permission.ISHRRoleAdminOrgPerm;
import com.kingdee.shr.base.permission.ISHRUserAdminOrgPermFacade;
import com.kingdee.shr.base.permission.SHRAdminOrgRangeInSubOrgFactory;
import com.kingdee.shr.base.permission.SHRRoleAdminOrgPermCollection;
import com.kingdee.shr.base.permission.SHRRoleAdminOrgPermFactory;
import com.kingdee.shr.base.permission.SHRRoleAdminOrgPermInfo;
import com.kingdee.shr.base.permission.SHRUserAdminOrgPermFacadeFactory;
import com.kingdee.shr.base.permission.SHRUserOrgPermFacadeFactory;
import com.kingdee.shr.base.permission.client.AbstractOrgRangeSettingUI;
import com.kingdee.shr.base.permission.client.ExportDetailConfigUI;
import com.kingdee.shr.base.permission.client.OrgPermDistributeByRoleUI;
import com.kingdee.shr.base.permission.client.OrgPermDistributeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class OrgRangeSettingUI
extends AbstractOrgRangeSettingUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgRangeSettingUI.class);
    private OrgRangeSettingUI UI = null;
    private IObjectPK targetUserPK = null;
    private Integer distributeType = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"mainten_hr_special_perm"));
        this.targetUserPK = this.getTargetUserPK();
        this.setUserInfo();
        this.initTblRole();
    }

    protected String[] getLocateNames() {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            return new String[]{"parent.name", "permItem.number", "permItem.alias", "org.number", "org.name", "isIncludeSubOrg", "org.longNumber"};
        }
        return new String[]{"roleName", "orgAdminCode", "orgAdminName", "isInclude", "orgAdminLongCode"};
    }

    private void setUserInfo() throws EASBizException, BOSException {
        Object positionName;
        String userId = this.targetUserPK.toString();
        Map userInfo = SHRUserOrgPermFacadeFactory.getRemoteInstance().getUserInfo(userId);
        if (null == userInfo || userInfo.isEmpty()) {
            return;
        }
        this.textUser.setText(userInfo.get("userNumber").toString());
        this.textName.setText(userInfo.get("personName").toString());
        Object adminDisplayName = userInfo.get("adminOrgLongName");
        if (adminDisplayName != null) {
            this.textAdminOrg.setText(adminDisplayName.toString());
        }
        if ((positionName = userInfo.get("postionName")) != null) {
            this.textPosition.setText(positionName.toString());
        }
    }

    private IObjectPK getTargetUserPK() {
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnDistribute.addAssistMenuItem((JMenuItem)this.miDistribute);
        this.btnDistribute.addAssistMenuItem((JMenuItem)this.miDistribueByRole);
        this.btnDistribute.addAssistMenuItem((JMenuItem)this.miCancelDistribute);
        this.btnDistribute.addAssistMenuItem((JMenuItem)this.miCancelAllDistribute);
        this.btnSetInSubOrg.addAssistMenuItem((JMenuItem)this.miSetIsSubOrg);
        this.btnSetInSubOrg.addAssistMenuItem((JMenuItem)this.miSetNotSubOrg);
        this.btnExportList.addAssistMenuItem((JMenuItem)this.miExportList);
        this.btnExportList.addAssistMenuItem((JMenuItem)this.miExportDetails);
        this.btnDistribute.setIcon(EASResource.getIcon((String)"imgTbtn_popedomsetting"));
        this.btnSetInSubOrg.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
        this.btnQueryAdminOrgRange.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnExportList.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.tipText.setForeground(Color.BLUE);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SHRAdminOrgRangeInSubOrgFactory.getRemoteInstance();
    }

    private ISHRUserAdminOrgPermFacade getNewInterface() throws Exception {
        return SHRUserAdminOrgPermFacadeFactory.getRemoteInstance();
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = new FilterInfo();
        FilterInfo targetFilter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)this.targetUserPK.toString(), CompareType.EQUALS));
        try {
            targetFilter.mergeFilter(viewInfo.getFilter(), "AND");
            targetFilter.mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        viewInfo.setFilter(targetFilter);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        OrgRangeCollection orgCol = this.getOrgCol();
        if (orgCol == null || orgCol.size() < 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"targetID", (Object)this.getTargetUserPK());
        uiContext.put((Object)"openModel", (Object)"frame");
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create(OrgPermDistributeUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
            SysUtil.abort();
        }
        ((JDialog)window).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    OrgRangeSettingUI.this.distributeType = 0;
                    OrgRangeSettingUI.this.actionRefresh_actionPerformed(OrgRangeSettingUI.this.getActionEvent());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        window.show();
    }

    private OrgRangeCollection getOrgCol() throws Exception {
        FullOrgUnitCollection ret = new FullOrgUnitCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)this.targetUserPK.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)10, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("org.isHROrgUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        entityViewInfo.setSelector(selectorCol);
        entityViewInfo.setFilter(filterInfo);
        return OrgRangeFactory.getRemoteInstance().getOrgRangeCollection(entityViewInfo);
    }

    @Override
    public void actionCancelDistribute_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            boolean result = this.cancelDistribute();
            if (result) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"cancel_assign_success"));
                this.actionRefresh_actionPerformed(e);
            }
        } else {
            boolean result = this.cancelDistributeRole();
            if (result) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"cancel_assign_success"));
                this.initTblRole();
            }
        }
    }

    private boolean cancelDistribute() throws Exception {
        boolean result = false;
        ArrayList listIds = this.getSelectedIdValues();
        if (listIds.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_del_item_least_one"));
            return result;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_cancel_assign_perm")) == 0) {
            ISHRUserAdminOrgPermFacade iFacade = this.getNewInterface();
            iFacade.deleteUserAdminOrgPermById(listIds);
            result = true;
        }
        return result;
    }

    private boolean cancelDistributeRole() throws Exception {
        boolean result = false;
        ArrayList listIds = this.getInnerListUISelectValuesArrayListByRole();
        if (listIds.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_del_item_least_one"));
            return result;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_cancel_assign_perm")) == 0) {
            ISHRRoleAdminOrgPerm orgPerm = SHRRoleAdminOrgPermFactory.getRemoteInstance();
            IObjectPK[] pks = new IObjectPK[listIds.size()];
            for (int i = 0; i < listIds.size(); ++i) {
                pks[i] = new ObjectUuidPK((String)listIds.get(i));
            }
            orgPerm.deleteBatchData(pks);
            orgPerm.clearPermCache(this.targetUserPK);
            result = true;
        }
        return result;
    }

    @Override
    public void actionCancelAllDistribute_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            boolean result = this.cancelAllDistribute();
            if (result) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"cancel_assign_all_success"));
                this.actionRefresh_actionPerformed(e);
            }
        } else {
            boolean result = this.cancelAllDistributeRole();
            if (result) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"cancel_assign_all_success"));
                this.initTblRole();
            }
        }
    }

    private boolean cancelAllDistribute() throws Exception {
        int count = this.tblMain.getRowCount();
        boolean result = false;
        if (count == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission_2"));
            return result;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_cancel_assign_all")) == 0) {
            ISHRUserAdminOrgPermFacade iFacade = this.getNewInterface();
            iFacade.deleteUserAdminOrgPermByUserId(this.targetUserPK);
            result = true;
        }
        return result;
    }

    private boolean cancelAllDistributeRole() throws Exception {
        int count = this.tblRole.getRowCount();
        boolean result = false;
        if (count == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission_2"));
            return result;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_cancel_assign_all")) == 0) {
            ISHRRoleAdminOrgPerm orgPerm = SHRRoleAdminOrgPermFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("user.id", (Object)this.targetUserPK.toString());
            orgPerm.delete(filter);
            orgPerm.clearPermCache(this.targetUserPK);
            result = true;
        }
        return result;
    }

    @Override
    public void actionQueryAdminOrgRange_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryAdminOrgRange_actionPerformed(e);
        IObjectPK userPK = this.getTargetUserPK();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"userPK", (Object)userPK);
        try {
            IUIWindow iWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrgRangeListUI.class.getName(), (Map)uiContext, null);
            iWin.show();
        }
        catch (UIException ex) {
            logger.error((Object)"", (Throwable)ex);
            this.handleException((Exception)((Object)ex));
        }
    }

    @Override
    public void actionSetIsSubOrg_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            if (this.tblMain.getRowCount() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission_2"));
                return;
            }
            ArrayList listIds = this.getSelectedIdValues();
            if (listIds.size() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_cantain_sub_perm"));
                return;
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_cantain_sub_perm")) == 0) {
                ISHRUserAdminOrgPermFacade iFacade = this.getNewInterface();
                iFacade.updateIsIncludeSubOrg(this.targetUserPK, true, listIds);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"cantain_sub_perm_success"));
                this.distributeType = 0;
                this.actionRefresh_actionPerformed(e);
                this.distributeType = null;
            }
        } else {
            if (this.tblRole.getRowCount() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission_2"));
                return;
            }
            ArrayList listIds = this.getInnerListUISelectValuesArrayListByRole();
            if (listIds.size() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_cantain_sub_perm"));
                return;
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_cantain_sub_perm")) == 0) {
                ISHRRoleAdminOrgPerm orgPerm = SHRRoleAdminOrgPermFactory.getRemoteInstance();
                orgPerm.updateIsIncludeSubOrg(this.targetUserPK, true, listIds);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"cantain_sub_perm_success"));
                this.initTblRole();
            }
        }
    }

    @Override
    public void actionSetNotSubOrg_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            if (this.tblMain.getRowCount() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission_2"));
                return;
            }
            ArrayList listIds = this.getSelectedIdValues();
            if (listIds.size() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_cancel_item_least_one"));
                return;
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_cancel_org_cantain_sub_perm")) == 0) {
                ISHRUserAdminOrgPermFacade iFacade = this.getNewInterface();
                iFacade.updateIsIncludeSubOrg(this.targetUserPK, false, listIds);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"cancel_org_cantain_sub_perm_success"));
                this.actionRefresh_actionPerformed(e);
            }
        } else {
            if (this.tblRole.getRowCount() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission_2"));
                return;
            }
            ArrayList listIds = this.getInnerListUISelectValuesArrayListByRole();
            if (listIds.size() == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"select_cancel_item_least_one"));
                return;
            }
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"sure_cancel_org_cantain_sub_perm")) == 0) {
                ISHRRoleAdminOrgPerm orgPerm = SHRRoleAdminOrgPermFactory.getRemoteInstance();
                orgPerm.updateIsIncludeSubOrg(this.targetUserPK, false, listIds);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"cancel_org_cantain_sub_perm_success"));
                this.initTblRole();
            }
        }
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        int count = this.getMainTable().getRowCount();
        if (count < 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission_2"));
            return;
        }
        super.actionExport_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExport_actionPerformed(e);
    }

    @Override
    public void actionExportDetails_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            super.actionExportDetails_actionPerformed(e);
            int count = this.tblMain.getRowCount();
            if (count == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"noany_org_permission_2"));
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"targetID", (Object)this.getTargetUserPK());
            IUIWindow window = null;
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                window = uiFactory.create(ExportDetailConfigUI.class.getName(), (Map)uiContext, null, null);
            }
            catch (UIException ex) {
                ExceptionHandler.handle((Throwable)ex);
                SysUtil.abort();
            }
            final IUIWindow window1 = window;
            if (window1 instanceof JDialog) {
                WindowListener[] Listeners = ((JDialog)window1).getWindowListeners();
                ((JDialog)window1).removeWindowListener(Listeners[0]);
                ((JDialog)window1).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (window1.getUIObject() instanceof ExportDetailConfigUI) {
                            ((ExportDetailConfigUI)window1.getUIObject()).disposeUIWindow();
                        }
                    }
                });
            }
            ExportDetailConfigUI exportDetailConfigUI = (ExportDetailConfigUI)window.getUIObject();
            ExportExcelConfigParam param = ExportExcelConfigManager.loadExportExcelConfig();
            exportDetailConfigUI.initConfigParam(param);
            window.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"notsuppor_export_detail"));
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public int getMaxReturnRowCount() {
        return 100000;
    }

    @Override
    public void actionDistributeByRole_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow window;
        IUserRoleOrgManager userRoleOrgManager = UserRoleOrgManagerFactory.getRemoteInstance();
        RoleCollection roleCollection = userRoleOrgManager.getAllUserRole(this.targetUserPK);
        if (roleCollection.size() > 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"targetID", (Object)this.getTargetUserPK());
            uiContext.put((Object)"openModel", (Object)"frame");
            window = null;
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                window = uiFactory.create(OrgPermDistributeByRoleUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            }
            catch (UIException ex) {
                ExceptionHandler.handle((Throwable)ex);
                SysUtil.abort();
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"user_no_role"));
            return;
        }
        ((JDialog)window).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    OrgRangeSettingUI.this.initTblRole();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        window.show();
    }

    private void initTblRole() throws BOSException {
        this.tblRole.removeRows();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("role.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("adminOrg.longNumber"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("isIncludeSubOrg"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)this.targetUserPK.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)0));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(sic);
        ISHRRoleAdminOrgPerm shrRoleAdminOrgPerm = SHRRoleAdminOrgPermFactory.getRemoteInstance();
        SHRRoleAdminOrgPermCollection coll = shrRoleAdminOrgPerm.getSHRRoleAdminOrgPermCollection(entityViewInfo);
        for (int i = 0; i < coll.size(); ++i) {
            SHRRoleAdminOrgPermInfo info = coll.get(i);
            IRow row = this.tblRole.addRow();
            row.getCell("id").setValue((Object)info.getId());
            row.getCell("roleName").setValue((Object)info.getRole().getName());
            row.getCell("orgAdminCode").setValue((Object)info.getAdminOrg().getNumber());
            row.getCell("orgAdminName").setValue((Object)info.getAdminOrg().getName());
            row.getCell("isInclude").setValue((Object)(info.isIsIncludeSubOrg() ? EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"yes") : EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"no")));
            row.getCell("orgAdminLongCode").setValue((Object)info.getAdminOrg().getLongNumber());
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0 || null != this.distributeType && this.distributeType == 0) {
            super.actionRefresh_actionPerformed(e);
            this.distributeType = null;
        } else {
            this.initTblRole();
        }
    }

    protected FindDialog getFindDialog() throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            return super.getFindDialog();
        }
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        ArrayList<ListFind> FindPropertyName = new ArrayList<ListFind>();
        for (int i = 0; i < this.getLocateNames().length; ++i) {
            if (this.tblRole.getColumn(this.getLocateNames()[i]) == null) continue;
            ListFind cEnum = new ListFind(this.getLocateNames()[i], this.tblRole.getHeadRow(0).getCell(this.getLocateNames()[i]).getValue().toString());
            FindPropertyName.add(cEnum);
        }
        if (FindPropertyName.size() == 0) {
            return null;
        }
        FindDialog findDialog = win instanceof Frame ? new FindDialog((Frame)win, "", FindPropertyName, true) : new FindDialog((Dialog)win, "", FindPropertyName, true);
        findDialog.addFindListListener(this.getFindListListener());
        return findDialog;
    }

    public KDTable getMainTable() {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            return this.tblMain;
        }
        return this.tblRole;
    }

    private ArrayList getInnerListUISelectValuesArrayListByRole() {
        int mode = 0;
        ArrayList blockList = this.tblRole.getSelectManager().getBlocks();
        if (blockList != null && blockList.size() == 1) {
            mode = ((IBlock)this.tblRole.getSelectManager().getBlocks().get(0)).getMode();
        }
        if (this.isIgnoreRowCount() && mode == 8) {
            this.tblRole.setRowCount(this.getRowCountFromDB());
            this.tblRole.reLayoutAndPaint();
        }
        ArrayList selectList = new ArrayList();
        List selectKeyIdFields = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblRole);
        if (mode == 8 && selectRows.length >= KDTDataRequestManager.defaultPageRow - 1) {
            selectKeyIdFields = this.getQueryPkList();
        }
        return ListUiHelper.getSelectedIdValues((KDTable)this.tblRole, (String)this.getKeyFieldName(), selectList, selectKeyIdFields);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getMainTable();
        this.preparePrintPage(table);
        table.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getMainTable();
        this.preparePrintPage(table);
        table.getPrintManager().printPreview();
    }

    protected KDTable getTableForCommon() {
        return this.getMainTable();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            super.actionQuery_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"notsuppor_query"));
        }
    }

    public int getRowCount() {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            return super.getRowCount();
        }
        return this.tblRole.getRowCount();
    }
}

