/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.FindDialog;
import com.kingdee.eas.framework.client.ListFind;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.shr.base.permission.ISHRRoleAdminOrgPerm;
import com.kingdee.shr.base.permission.SHRAdminOrgRangeInSubOrgFactory;
import com.kingdee.shr.base.permission.SHRRoleAdminOrgPermCollection;
import com.kingdee.shr.base.permission.SHRRoleAdminOrgPermFactory;
import com.kingdee.shr.base.permission.SHRRoleAdminOrgPermInfo;
import com.kingdee.shr.base.permission.client.AbstractSHRUserAdminOrgPermReportUI;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SHRUserAdminOrgPermReportUI
extends AbstractSHRUserAdminOrgPermReportUI {
    private static final Logger logger = CoreUIObject.getLogger(SHRUserAdminOrgPermReportUI.class);
    private IObjectPK loginUserPK = null;
    private int roleTableRowCount = 0;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loginUserPK = (IObjectPK)this.getUIContext().get("USER.PK");
        this.initTblRole();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = new FilterInfo();
        FilterInfo targetFilter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("loginUser.id", (Object)this.loginUserPK.toString(), CompareType.EQUALS));
        try {
            targetFilter.mergeFilter(viewInfo.getFilter(), "AND");
            targetFilter.mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        viewInfo.setFilter(targetFilter);
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String[] getLocateNames() {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            return new String[]{"user.number", "user.name", "parent.name", "permItem.number", "permItem.alias", "org.number", "org.name", "isIncludeSubOrg", "org.longNumber"};
        }
        return new String[]{"userAccount", "userName", "roleName", "orgNumber", "orgName", "isIncludeSubOrg", "orgLongNumber"};
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    public int getMaxReturnRowCount() {
        return 100000;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SHRAdminOrgRangeInSubOrgFactory.getRemoteInstance();
    }

    private void initTblRole() throws BOSException {
        this.tblRole.removeRows();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("user.number"));
        sic.add(new SelectorItemInfo("user.name"));
        sic.add(new SelectorItemInfo("role.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("adminOrg.longNumber"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("isIncludeSubOrg"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)0));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(sic);
        ISHRRoleAdminOrgPerm shrRoleAdminOrgPerm = SHRRoleAdminOrgPermFactory.getRemoteInstance();
        SHRRoleAdminOrgPermCollection coll = shrRoleAdminOrgPerm.getSHRRoleAdminOrgPermCollection(entityViewInfo);
        for (int i = 0; i < coll.size(); ++i) {
            SHRRoleAdminOrgPermInfo info = coll.get(i);
            IRow row = this.tblRole.addRow();
            row.getCell("id").setValue((Object)info.getId());
            row.getCell("userAccount").setValue((Object)info.getUser().getNumber());
            row.getCell("userName").setValue((Object)info.getUser().getName());
            row.getCell("roleName").setValue((Object)info.getRole().getName());
            row.getCell("orgNumber").setValue((Object)info.getAdminOrg().getNumber());
            row.getCell("orgName").setValue((Object)info.getAdminOrg().getName());
            row.getCell("isIncludeSubOrg").setValue((Object)(info.isIsIncludeSubOrg() ? EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"yes") : EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"no")));
            row.getCell("orgLongNumber").setValue((Object)info.getAdminOrg().getLongNumber());
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            super.actionRefresh_actionPerformed(e);
        } else {
            this.initTblRole();
        }
    }

    public KDTable getMainTable() {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            return this.tblMain;
        }
        return this.tblRole;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getMainTable();
        this.preparePrintPage(table);
        table.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getMainTable();
        this.preparePrintPage(table);
        table.getPrintManager().printPreview();
    }

    protected KDTable getTableForCommon() {
        return this.getMainTable();
    }

    protected FindDialog getFindDialog() throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            return super.getFindDialog();
        }
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        ArrayList<ListFind> FindPropertyName = new ArrayList<ListFind>();
        for (int i = 0; i < this.getLocateNames().length; ++i) {
            if (this.tblRole.getColumn(this.getLocateNames()[i]) == null) continue;
            ListFind cEnum = new ListFind(this.getLocateNames()[i], this.tblRole.getHeadRow(0).getCell(this.getLocateNames()[i]).getValue().toString());
            FindPropertyName.add(cEnum);
        }
        if (FindPropertyName.size() == 0) {
            return null;
        }
        FindDialog findDialog = win instanceof Frame ? new FindDialog((Frame)win, "", FindPropertyName, true) : new FindDialog((Dialog)win, "", FindPropertyName, true);
        findDialog.addFindListListener(super.getFindListListener());
        return findDialog;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            super.actionQuery_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.shr.base.permission.ShrPermissionResource", (String)"notsuppor_query"));
        }
    }

    public int getRowCount() {
        if (this.tabPanelDataTb.getSelectedIndex() == 0) {
            return super.getRowCount();
        }
        return this.tblRole.getRowCount();
    }
}

