/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.field.form;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.formula.evaluator.FormulaEvaluatorEnum;
import com.kingdee.shr.base.formula.evaluator.FormulaExpressInfo;
import com.kingdee.shr.base.formula.evaluator.IShrFormulaEvaluator;
import com.kingdee.shr.base.formula.evaluator.ShrFormulaEvaluatorManager;
import com.kingdee.shr.base.permission.FieldPermConfigCollection;
import com.kingdee.shr.base.permission.FieldPermConfigEntryInfo;
import com.kingdee.shr.base.permission.FieldPermConfigInfo;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.field.UserFieldPermInfoHelper;
import com.kingdee.shr.base.permission.field.form.ShrFieldPermForm;
import com.kingdee.shr.base.permission.util.CoreBaseInfoUtil;
import com.kingdee.util.StringUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShrFieldPermCustomPage {
    private Context ctx;
    private String modelNumber;
    private Set<String> noPermFieldSet = new HashSet<String>();
    protected IShrFormulaEvaluator shrFormulaEvaluator;
    protected FieldPermConfigCollection fieldPermConfigCollection = new FieldPermConfigCollection();

    public ShrFieldPermCustomPage(Context ctx, String modelNumber) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.modelNumber = modelNumber;
        this.shrFormulaEvaluator = ShrFormulaEvaluatorManager.getFormulaEvaluatorInstance(FormulaEvaluatorEnum.AVIATOR, ctx);
        this.getFieldPermByCurrentUser(modelNumber);
    }

    public CoreBaseInfo filterForView(CoreBaseInfo model) throws EASBizException, BOSException {
        return this.filterForForm(model, ShrFieldPermForm.FormType.VIEW, false);
    }

    public CoreBaseInfo filterForEdit(CoreBaseInfo model) throws BOSException, EASBizException {
        return this.filterForForm(model, ShrFieldPermForm.FormType.EDIT, false);
    }

    protected CoreBaseInfo filterForForm(CoreBaseInfo model, ShrFieldPermForm.FormType formType, boolean isEntry) throws EASBizException, BOSException {
        if (null != this.fieldPermConfigCollection && this.fieldPermConfigCollection.size() > 0) {
            Enumeration enumeration = model.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object value = model.get(key);
                if (value == null) continue;
                if (!this.isAllowView(key, model)) {
                    this.setModelFieldNoPerm(model, key, isEntry);
                }
                if (formType.equals((Object)ShrFieldPermForm.FormType.EDIT) && !this.isAllowEdit(key)) {
                    this.setModelFieldNoPerm(model, key, isEntry);
                }
                if (value instanceof AbstractObjectCollection) {
                    AbstractObjectCollection coll = (AbstractObjectCollection)value;
                    for (int k = 0; k < coll.size(); ++k) {
                        this.filterForForm((CoreBaseInfo)coll.getObject(k), formType, true);
                    }
                    continue;
                }
                if (!(value instanceof CoreBaseInfo)) continue;
                this.filterForForm((CoreBaseInfo)value, formType, isEntry);
            }
        }
        return model;
    }

    public boolean isAllowView(String field, Map<String, Object> dataMap) throws BOSException, EASBizException {
        for (int i = 0; i < this.fieldPermConfigCollection.size(); ++i) {
            FieldPermConfigInfo info = this.fieldPermConfigCollection.get(i);
            if (!info.getModel().equals(this.modelNumber)) continue;
            for (int m = 0; m < info.getEntrys().size(); ++m) {
                FormulaExpressInfo formulaExpressInfo;
                Boolean formulaResult;
                FieldPermConfigEntryInfo fieldInfo = info.getEntrys().get(m);
                if (!field.equalsIgnoreCase(fieldInfo.getFieldFlag()) || !(!StringUtils.isEmpty((String)fieldInfo.getCondition()) ? (formulaResult = (Boolean)this.shrFormulaEvaluator.execute((formulaExpressInfo = (FormulaExpressInfo)JSONUtils.convertJsonToObject((Context)this.ctx, (String)fieldInfo.getCondition(), FormulaExpressInfo.class)).getFormula(), dataMap)) == false && fieldInfo.isHasShow() || formulaResult != false && !fieldInfo.isHasShow() : !fieldInfo.isHasShow())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAllowView(String field, CoreBaseInfo model) throws BOSException, EASBizException {
        for (int i = 0; i < this.fieldPermConfigCollection.size(); ++i) {
            FieldPermConfigInfo info = this.fieldPermConfigCollection.get(i);
            if (!info.getModel().equals(this.modelNumber)) continue;
            for (int m = 0; m < info.getEntrys().size(); ++m) {
                FieldPermConfigEntryInfo fieldInfo = info.getEntrys().get(m);
                if (!field.equalsIgnoreCase(fieldInfo.getFieldFlag())) continue;
                if (!StringUtils.isEmpty((String)fieldInfo.getCondition())) {
                    FormulaExpressInfo formulaExpressInfo = (FormulaExpressInfo)JSONUtils.convertJsonToObject((Context)this.ctx, (String)fieldInfo.getCondition(), FormulaExpressInfo.class);
                    HashMap<String, Object> formulaDataMap = new HashMap<String, Object>();
                    for (String paramField : formulaExpressInfo.getParam()) {
                        formulaDataMap.put(paramField, model.get(paramField));
                    }
                    Boolean formulaResult = (Boolean)this.shrFormulaEvaluator.execute(formulaExpressInfo.getFormula(), formulaDataMap);
                    if ((formulaResult.booleanValue() || !fieldInfo.isHasShow()) && (!formulaResult.booleanValue() || fieldInfo.isHasShow())) continue;
                    return false;
                }
                if (fieldInfo.isHasShow()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAllowEdit(String field) throws BOSException, EASBizException {
        for (int i = 0; i < this.fieldPermConfigCollection.size(); ++i) {
            FieldPermConfigInfo info = this.fieldPermConfigCollection.get(i);
            if (!info.getModel().equals(this.modelNumber)) continue;
            for (int m = 0; m < info.getEntrys().size(); ++m) {
                FieldPermConfigEntryInfo fieldInfo = info.getEntrys().get(m);
                if (!field.equalsIgnoreCase(fieldInfo.getFieldFlag()) || fieldInfo.isHasModify()) continue;
                return false;
            }
        }
        return true;
    }

    public void filterForSave(CoreBaseInfo model) throws BOSException, EASBizException {
        if (null != this.fieldPermConfigCollection && this.fieldPermConfigCollection.size() > 0) {
            this.filterForSaveMap(model);
        }
    }

    public List filterForList(List rows) throws EASBizException, BOSException {
        if (null != rows && rows.size() > 0 && null != this.fieldPermConfigCollection && this.fieldPermConfigCollection.size() > 0) {
            for (int i = 0; i < this.fieldPermConfigCollection.size(); ++i) {
                FieldPermConfigInfo info = this.fieldPermConfigCollection.get(i);
                if (!info.getModel().equals(this.modelNumber)) continue;
                for (int n = 0; n < rows.size(); ++n) {
                    String[] keySet;
                    Map map = (Map)rows.get(n);
                    for (String key : keySet = map.keySet().toArray(new String[map.keySet().size()])) {
                        for (int m = 0; m < info.getEntrys().size(); ++m) {
                            FieldPermConfigEntryInfo fieldInfo = info.getEntrys().get(m);
                            if (!key.equalsIgnoreCase(fieldInfo.getFieldFlag())) continue;
                            if (!StringUtils.isEmpty((String)fieldInfo.getCondition())) {
                                FormulaExpressInfo formulaExpressInfo = (FormulaExpressInfo)JSONUtils.convertJsonToObject((Context)this.ctx, (String)fieldInfo.getCondition(), FormulaExpressInfo.class);
                                HashMap<String, Object> formulaDataMap = new HashMap<String, Object>();
                                for (String paramField : formulaExpressInfo.getParam()) {
                                    formulaDataMap.put(paramField, map.get(paramField));
                                }
                                Boolean formulaResult = (Boolean)this.shrFormulaEvaluator.execute(formulaExpressInfo.getFormula(), formulaDataMap);
                                if ((formulaResult.booleanValue() || !fieldInfo.isHasShow()) && (!formulaResult.booleanValue() || fieldInfo.isHasShow())) continue;
                                this.setMapValNoPerm(map, key);
                                continue;
                            }
                            if (fieldInfo.isHasShow()) continue;
                            this.setMapValNoPerm(map, key);
                        }
                    }
                }
            }
        }
        return rows;
    }

    protected void filterForSaveMap(CoreBaseInfo model) throws EASBizException, BOSException {
        if (null != this.fieldPermConfigCollection && this.fieldPermConfigCollection.size() > 0) {
            Enumeration enumeration = model.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                Object value = model.get(key);
                if (value == null) continue;
                if (!this.isAllowEdit(key)) {
                    throw new ShrPermissionException(ShrPermissionException.NO_ENTITYFIELD_PERM, new Object[]{this.modelNumber, key});
                }
                if (value instanceof AbstractObjectCollection) {
                    AbstractObjectCollection coll = (AbstractObjectCollection)value;
                    for (int k = 0; k < coll.size(); ++k) {
                        this.filterForSaveMap((CoreBaseInfo)coll.getObject(k));
                    }
                    continue;
                }
                if (!(value instanceof CoreBaseInfo)) continue;
                this.filterForSaveMap((CoreBaseInfo)value);
            }
        }
    }

    protected void getFieldPermByCurrentUser(String modelName) throws EASBizException, BOSException {
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        FieldPermConfigCollection coll = UserFieldPermInfoHelper.getUserCustompageFieldPermWithCache(this.ctx, currentUserInfo.getId().toString());
        if (null != coll && !coll.isEmpty()) {
            for (int i = 0; i < coll.size(); ++i) {
                FieldPermConfigInfo info = coll.get(i);
                if (!info.getModel().equals(modelName)) continue;
                this.fieldPermConfigCollection.add(info);
            }
        }
    }

    protected void setModelFieldNoPerm(CoreBaseInfo model, String key, boolean isShowColumn) throws EASBizException {
        if (!isShowColumn) {
            CoreBaseInfoUtil.remove(model, key);
        } else {
            CoreBaseInfoUtil.setValue(model, key, "***");
        }
        Object valObj = CoreBaseInfoUtil.getValue(model, "_noPermFields");
        if (null != valObj) {
            this.noPermFieldSet = (Set)valObj;
            this.noPermFieldSet.add(key);
        } else {
            this.noPermFieldSet.add(key);
        }
        CoreBaseInfoUtil.setValue(model, "_noPermFields", this.noPermFieldSet);
    }

    protected void setMapValNoPerm(Map map, String key) {
        Object objVal = map.get(key);
        if (null != objVal) {
            if (objVal instanceof String && objVal.toString().length() == 0) {
                return;
            }
            map.put(key, "***");
            if (null != map.get("_noPermFields")) {
                this.noPermFieldSet = (Set)map.get("_noPermFields");
                this.noPermFieldSet.add(key);
            } else {
                this.noPermFieldSet.add(key);
            }
            map.put("_noPermFields", this.noPermFieldSet);
        }
    }

    public String[] getNoPermFields() {
        return this.noPermFieldSet.toArray(new String[this.noPermFieldSet.size()]);
    }
}

