/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;

public abstract class BasePermissionHelper {
    protected static final String FIELD_PEMESSION = "fieldPermission";
    protected static final FieldPermission FIELDPERMISSION_EMPTY = new FieldPermission();

    public void checkPermission() {
    }

    public static void checkFunctionPermission(Context ctx, String permItemName, OrgUnitInfo mainOrg) throws BOSException, EASBizException {
        IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK orgPK = null;
        OrgUnitInfo org = mainOrg;
        if (org == null) {
            org = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        }
        if (org != null) {
            orgPK = new ObjectUuidPK(org.getId());
        }
        ObjectUuidPK userPK = null;
        CoreBaseInfo user = (CoreBaseInfo)ctx.get((Object)"UserInfo");
        if (user != null) {
            userPK = new ObjectUuidPK(user.getId());
        }
        perm.checkFunctionPermission(userPK, (IObjectPK)orgPK, permItemName);
    }

    public static void checkFunctionPermission(Context ctx, String permItemName) throws BOSException, EASBizException {
        BasePermissionHelper.checkFunctionPermission(ctx, permItemName, null);
    }

    public static void checkUIPermission(Context ctx, IMetaDataPK uiMedataPK) throws EASBizException, BOSException {
        BasePermissionHelper.checkUIPermission(ctx, uiMedataPK, null);
    }

    public static void checkUIPermission(Context ctx, IMetaDataPK uiMedataPK, OrgUnitInfo mainOrg) throws EASBizException, BOSException {
        ObjectUuidPK orgPK = null;
        OrgUnitInfo org = mainOrg;
        if (org == null) {
            org = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        }
        if (org != null) {
            orgPK = new ObjectUuidPK(org.getId());
        }
        ObjectUuidPK userPK = null;
        CoreBaseInfo user = (CoreBaseInfo)ctx.get((Object)"UserInfo");
        if (user != null) {
            userPK = new ObjectUuidPK(user.getId());
        }
        MetaDataPK actionPK = MetaDataPK.create((String)"initalizeAction");
        BasePermissionHelper.checkActionPermission(ctx, (IObjectPK)userPK, (IObjectPK)orgPK, uiMedataPK, (IMetaDataPK)actionPK);
    }

    public static void checkActionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        if (uiPK == null || actionPK == null) {
            return;
        }
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(ctx);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.WEBPAGEOBJECT, uiPK, actionPK);
        if (bind != null) {
            IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)bind[i].getName())) continue;
                String permItemName = bind[i].getName();
                perm.checkFunctionPermission(userPK, orgPK, permItemName);
            }
        }
    }
}

