/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class DBCommonUtil {
    private static final Logger logger = Logger.getLogger(DBCommonUtil.class);
    private static final int MAX_DATA_ROW = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultSet executeQuery(Context ctx, String sql, Object[] params) {
        ResultSet i222;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i222 = 0; i222 < params.length; ++i222) {
                ps.setObject(i222 + 1, params[i222]);
            }
            i222 = resultSet = ps.executeQuery();
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("[ DBCommonUtil executeQuery Exception , The SQL is ]" + sql));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)resultSet, (Statement)ps, (Connection)conn);
            return resultSet;
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)ps, (Connection)conn);
        return i222;
    }

    public static void executeBatch(Context ctx, String sql, List<Object[]> paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = DBCommonUtil.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 10000) {
                    flag = true;
                }
                if (i <= k * 10000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("[ DBCommonUtil.executeBatch Exception , The SQL is ] " + sql));
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
        }
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException e) {
            logger.error((Object)("[ DBCommonUtil.executeBatch Exception , The SQL is ] " + sql));
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }

    public static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }
}

