/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission.expfilter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.ExpFilterConfigCollection;
import com.kingdee.shr.base.permission.ExpFilterConfigFactory;
import com.kingdee.shr.base.permission.ExpFilterConfigInfo;
import com.kingdee.shr.base.permission.ExpTypeEnum;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.permission.expfilter.IPermissionExpFilterService;
import com.kingdee.shr.base.syssetting.permission.expfilter.impl.PermissionExpFilterService;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExpFilterUtils {
    public static final String FEXPFILTERID = "fexpfilterid";
    public static final String FUSERID = "fuserid";
    private static Logger logger = Logger.getLogger(ExpFilterUtils.class);

    public static FilterInfo getPermssionExpFilterInfo(Context ctx, String uipk) throws EASBizException, BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uiview.uipk", (Object)uipk, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)20, CompareType.EQUALS));
        String userExpSelectSql = ExpFilterUtils.getUserExpSelectSql(FEXPFILTERID, user.getId().toString());
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)userExpSelectSql, CompareType.INNER));
        view.setFilter(filter);
        ExpFilterConfigCollection coll = ExpFilterConfigFactory.getLocalInstance(ctx).getExpFilterConfigCollection(view);
        if (null == coll || coll.size() <= 0) {
            return null;
        }
        IPermissionExpFilterService service = null;
        FilterInfo tempFilter = null;
        FilterInfo resultFilter = new FilterInfo();
        int total = coll.size();
        for (int i = 0; i < total; ++i) {
            ExpFilterConfigInfo model = coll.get(i);
            service = ExpFilterUtils.getIPermissionExpFilterService(model);
            service.setContext(ctx);
            String config = ExpFilterUtils.convertConfigForMultiLan(ctx, model);
            service.setConfig(config);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("name {0},number:{1},config:{2}", model.getName(), model.getNumber(), config));
            }
            tempFilter = service.getExpFilterInfo();
            resultFilter.mergeFilter(tempFilter, "AND");
        }
        return resultFilter;
    }

    private static String convertConfigForMultiLan(Context ctx, ExpFilterConfigInfo model) {
        if (ExpTypeEnum.AdvanceFilterExp.equals((Object)model.getExpType()) && !StringUtils.isEmpty((String)model.getConfig())) {
            HashMap advancedFilter = JSONUtils.convertJsonToObject((Context)ctx, (String)model.getConfig());
            Map filterItemMaping = (Map)advancedFilter.get("filterItemMaping");
            if (null == filterItemMaping) {
                return model.getConfig();
            }
            Set keyCondtion = filterItemMaping.keySet();
            Iterator iterator = keyCondtion.iterator();
            while (iterator.hasNext()) {
                Map eachCondtion = (Map)filterItemMaping.get(iterator.next());
                String type = (String)eachCondtion.get("type");
                if (!"String".equals(type) || !(eachCondtion.get("valueMultiLang") instanceof Map)) continue;
                Map valueMultiLang = (Map)eachCondtion.get("valueMultiLang");
                eachCondtion.put("value", valueMultiLang.get(ctx.getLocale().toString()));
            }
            return JSONUtils.convertObjectToJson((Context)ctx, (Object)advancedFilter);
        }
        return model.getConfig();
    }

    private static IPermissionExpFilterService getIPermissionExpFilterService(ExpFilterConfigInfo model) throws EASBizException, BOSException {
        Class<?> clazz;
        block8: {
            if (ExpTypeEnum.AdvanceFilterExp.equals((Object)model.getExpType())) {
                return new PermissionExpFilterService();
            }
            clazz = null;
            try {
                clazz = MsfClassLoaderFactory.forName((String)model.getExpHandler());
            }
            catch (ClassNotFoundException e) {
                try {
                    clazz = Class.forName(model.getExpHandler());
                }
                catch (ClassNotFoundException e1) {
                    throw new BOSException((Throwable)e1);
                }
                if (clazz != null) break block8;
                throw new BOSException((Throwable)e);
            }
        }
        try {
            return (IPermissionExpFilterService)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getUserExpSelectSql(String type, String value) {
        StringBuffer subSb = new StringBuffer(200);
        if (FEXPFILTERID.equals(type)) {
            subSb.append("\tselect eu.fexpfilterid from T_HR_ExpFilterUser eu join  T_PM_User u on eu.FUserID = u.fid where u.fid = '" + value + "'");
            subSb.append("\tUNION ");
            subSb.append("\tselect er.fexpfilterid from T_HR_ExpFilterRole er join T_PM_UserRoleOrg ur on er.FRoleID = ur.FRoleID join T_PM_User u on ur.FUserID = u.fid where u.fid = '" + value + "'");
        } else if (FUSERID.equals(type)) {
            subSb.append("\tselect u.fid from T_HR_ExpFilterUser eu join  T_PM_User u on eu.FUserID = u.fid where eu.fexpfilterid = '" + value + "'");
            subSb.append("\tUNION ");
            subSb.append("\tselect u.fid from T_HR_ExpFilterRole er join T_PM_UserRoleOrg ur on er.FRoleID = ur.FRoleID join T_PM_User u on ur.FUserID = u.fid where er.fexpfilterid = '" + value + "'");
        }
        return subSb.toString();
    }
}

