/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perself.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.DayTypeEnum;
import com.kingdee.eas.hr.ats.HolidayLimitCollection;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.ScheduleShiftInfo;
import com.kingdee.eas.hr.ats.ScheduleShiftItemCollection;
import com.kingdee.eas.hr.ats.ScheduleShiftItemInfo;
import com.kingdee.eas.hr.ats.decimalPlace.util.DecimalPlaceUtil;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsScheduleShiftUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.perself.PerselfBizException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class AttendanceResultMainPage {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.perself.util.AttendanceResultMainPage");
    private static final String ATS_HOLIDAYTYPE_YEAR_ID = "3T54RtSQRIqAL6cffMh60P0tUpg=";
    private static final double LOW_LIMTT_VALUE = 0.01;
    private static final int ACCURACY_VALUE = 2;

    public Map<Object, Object> getCurrentMonthDataAction(Context ctx, Map param) throws BOSException {
        Calendar cal = Calendar.getInstance();
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        String lastDate = new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
        String startDate = lastDate.substring(0, 7) + "-01";
        logger.info((Object)("startDate:" + startDate + ".....lastDate:" + lastDate));
        String personId = AttendanceResultMainPage.getPersonId(ctx);
        Map<Object, Object> attendResult = this.getAttendResultByDateAndPersonId(ctx, personId, startDate, lastDate);
        int exception = 0;
        BigDecimal overtime = BigDecimal.valueOf(0L);
        overtime = (BigDecimal)attendResult.get("overtime");
        exception = (Integer)attendResult.get("late") + (Integer)attendResult.get("early") + (Integer)attendResult.get("absence");
        logger.info((Object)("overtime:" + overtime + "........exception:" + exception));
        ConcurrentHashMap<Object, Object> result = new ConcurrentHashMap<Object, Object>();
        result.put("overtime", overtime);
        result.put("exception", exception);
        return result;
    }

    public Map<Object, Object> getYesterdayDataAction(Context ctx, Map param) throws BOSException {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.get(5) - 1);
        String startDate = new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
        logger.info((Object)("startDate:" + startDate));
        ConcurrentHashMap<Object, Object> result = new ConcurrentHashMap<Object, Object>();
        String personId = AttendanceResultMainPage.getPersonId(ctx);
        Map<Object, Object> attendanceFileMap = this.isLackAttendanceFile(ctx, personId, startDate);
        AttendanceFileHISCollection attendanceFileHISCollection = null;
        if ("true".equals(attendanceFileMap.get("flag"))) {
            result.put("error", "true");
            return result;
        }
        if ("false".equals(attendanceFileMap.get("flag"))) {
            attendanceFileHISCollection = (AttendanceFileHISCollection)attendanceFileMap.get("file");
        }
        Map<Object, Object> attendResult = this.getAttendResultByDateAndPersonId(ctx, personId, startDate);
        ScheduleShiftInfo scheduleShiftInfo = AtsScheduleShiftUtil.getScheduleShiftByPriority((Context)ctx, (String)personId, (String)startDate);
        Map<Object, Map<Object, Object>> punchCardAndScheduleShift = this.getPunchCardAndScheduleShift(ctx, personId, startDate, attendanceFileHISCollection, scheduleShiftInfo, attendResult);
        if ("false".equals(punchCardAndScheduleShift.get("error").get("error").toString())) {
            Map<Object, Object> punchCard = punchCardAndScheduleShift.get("card");
            Map<Object, Object> scheduleShift = punchCardAndScheduleShift.get("shift");
            logger.info((Object)("Map<Object, Object> punchCard:" + punchCard + ".....Map<Object, Object> scheduleShift:" + scheduleShift));
            result.put("attendence_card", punchCard.get("attendence_card"));
            result.put("attendence_shift", scheduleShift.get("attendence_shift"));
        }
        Map<Object, Object> attendanceDetail = this.getAttendanceDetail(ctx, personId, startDate, attendanceFileHISCollection, scheduleShiftInfo, attendResult);
        if ("false".equals(punchCardAndScheduleShift.get("error").get("error").toString())) {
            logger.info((Object)("Map<Object, Object> attendanceDetail:" + attendanceDetail));
            result.put("attendence_result", attendanceDetail.get("attendence_result"));
        }
        if ("true".equals(punchCardAndScheduleShift.get("error").get("error").toString()) || "true".equals(attendanceDetail.get("error").toString())) {
            result.put("error", "true");
        } else {
            result.put("error", "false");
        }
        return result;
    }

    public Map<String, String> getAnnualLeaveDataAction(Context ctx, Map param) throws BOSException {
        String personId = AttendanceResultMainPage.getPersonId(ctx);
        logger.info((Object)("personnel ID\uff1a" + personId));
        ConcurrentHashMap<String, String> resMap = new ConcurrentHashMap<String, String>();
        String remainLimitValue = "0";
        String percentValue = "0";
        int decimalPlaceSystem = DecimalPlaceUtil.getDecimalPlaceSystem((Context)ctx);
        HolidayLimitCollection holidayLimitCollection = new HolidayLimitCollection();
        String dateString = AtsDateUtils.dateShortToString((java.util.Date)new java.util.Date());
        holidayLimitCollection = this.getHolidayLimitCollectionByPersonIdAndStartEndTimeImpl(ctx, personId, ATS_HOLIDAYTYPE_YEAR_ID, dateString, dateString);
        if (holidayLimitCollection == null || holidayLimitCollection.size() == 0) {
            resMap.put("annualleave", remainLimitValue);
            resMap.put("percent", percentValue);
        } else {
            BigDecimal remainLimit = BigDecimal.valueOf(0L);
            BigDecimal realLimit = BigDecimal.valueOf(0L);
            BigDecimal percent = BigDecimal.valueOf(0L);
            holidayLimitCollection.sort("cyclebegindate");
            holidayLimitCollection.sort("delaydate");
            for (int i = 0; i < holidayLimitCollection.size(); ++i) {
                realLimit = realLimit.add(holidayLimitCollection.get(i).getRealLimit());
                if (i == holidayLimitCollection.size() - 1) {
                    remainLimit = remainLimit.add(holidayLimitCollection.get(i).getRemainLimit());
                    continue;
                }
                if (holidayLimitCollection.get(i).getRemainLimit().compareTo(BigDecimal.ZERO) != 1) continue;
                remainLimit = remainLimit.add(holidayLimitCollection.get(i).getRemainLimit());
            }
            remainLimit = remainLimit.setScale(decimalPlaceSystem, 4);
            realLimit = realLimit.setScale(2, 4);
            if (remainLimit.compareTo(BigDecimal.ZERO) != 0 && realLimit.compareTo(BigDecimal.ZERO) != 0) {
                percent = remainLimit.divide(realLimit, 2, 4);
                if (percent.compareTo(BigDecimal.valueOf(1L)) > 0) {
                    percent = BigDecimal.valueOf(1L);
                }
                NumberFormat nt = NumberFormat.getPercentInstance();
                nt.setMinimumFractionDigits(0);
                remainLimitValue = remainLimit.stripTrailingZeros().toPlainString();
                if (percent.compareTo(BigDecimal.ZERO) > 0) {
                    percentValue = nt.format(percent);
                }
            }
            logger.info((Object)("Remaining amount of annual leave\uff1a" + remainLimitValue));
            logger.info((Object)("Annual leave percentage\uff1a" + percentValue));
            resMap.put("annualleave", new BigDecimal(remainLimitValue).setScale(decimalPlaceSystem, 4).toString());
            resMap.put("percent", percentValue.substring(0, percentValue.length() - 1));
        }
        return resMap;
    }

    public Map<Object, Object> getAttendanceDetail(Context ctx, String personId, String date, AttendanceFileHISCollection attendanceFileHISCollection, ScheduleShiftInfo scheduleShiftInfo, Map<Object, Object> attendResult) throws BOSException {
        ConcurrentHashMap<String, Object> detail = new ConcurrentHashMap<String, Object>();
        ConcurrentHashMap<Object, Object> result = new ConcurrentHashMap<Object, Object>();
        BigDecimal standardHour = BigDecimal.valueOf(0L);
        String strHour = SHRServerResource.getString((String)"com.kingdee.shr.perself.PerselfResourse", (String)"hour", (Context)ctx);
        String strMinute = SHRServerResource.getString((String)"com.kingdee.shr.perself.PerselfResourse", (String)"minute", (Context)ctx);
        String strDay = SHRServerResource.getString((String)"com.kingdee.shr.perself.PerselfResourse", (String)"day", (Context)ctx);
        standardHour = scheduleShiftInfo != null && null != scheduleShiftInfo.getStandardHour() ? scheduleShiftInfo.getStandardHour() : this.getStandardHourFromAttendanceFileHIS(attendanceFileHISCollection);
        if (standardHour == null) {
            result.put("error", "true");
            return result;
        }
        if (!this.isAttendResultByDateAndPersonId(ctx, personId, date, date)) {
            detail.put("attendence_type", "9");
            result.put("attendence_result", detail);
            result.put("error", "false");
            return result;
        }
        if (((BigDecimal)attendResult.get("absenceTime")).compareTo(BigDecimal.valueOf(0.01)) >= 0) {
            detail.put("attendence_type", "0");
            detail.put("attendence_unit", strHour);
            detail.put("attendence_time", attendResult.get("absenceTime"));
            String percentValue = "0";
            if (standardHour.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal percent = ((BigDecimal)attendResult.get("absenceTime")).divide(standardHour, 2, 4);
                if (percent.compareTo(BigDecimal.valueOf(1L)) > 0) {
                    percent = BigDecimal.valueOf(1L);
                }
                NumberFormat nt = NumberFormat.getPercentInstance();
                nt.setMinimumFractionDigits(0);
                percentValue = nt.format(percent);
            }
            detail.put("attendence_percent", percentValue.substring(0, percentValue.length() - 1));
        } else if (((BigDecimal)attendResult.get("lateTime")).compareTo(BigDecimal.valueOf(0.01)) >= 0) {
            detail.put("attendence_type", "1");
            detail.put("attendence_unit", strMinute);
            detail.put("attendence_time", attendResult.get("lateTime"));
            String percentValue = "0";
            if (standardHour.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal percent = ((BigDecimal)attendResult.get("lateTime")).divide(standardHour.multiply(BigDecimal.valueOf(60L)), 2, 4);
                if (percent.compareTo(BigDecimal.valueOf(1L)) > 0) {
                    percent = BigDecimal.valueOf(1L);
                }
                NumberFormat nt = NumberFormat.getPercentInstance();
                nt.setMinimumFractionDigits(0);
                percentValue = nt.format(percent);
            }
            detail.put("attendence_percent", percentValue.substring(0, percentValue.length() - 1));
        } else if (((BigDecimal)attendResult.get("earlyTime")).compareTo(BigDecimal.valueOf(0.01)) >= 0) {
            detail.put("attendence_type", "2");
            detail.put("attendence_unit", strMinute);
            detail.put("attendence_time", attendResult.get("earlyTime"));
            String percentValue = "0";
            if (standardHour.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal percent = ((BigDecimal)attendResult.get("earlyTime")).divide(standardHour.multiply(BigDecimal.valueOf(60L)), 2, 4);
                if (percent.compareTo(BigDecimal.valueOf(1L)) > 0) {
                    percent = BigDecimal.valueOf(1L);
                }
                NumberFormat nt = NumberFormat.getPercentInstance();
                nt.setMinimumFractionDigits(0);
                percentValue = nt.format(percent);
            }
            detail.put("attendence_percent", percentValue.substring(0, percentValue.length() - 1));
        } else if (((BigDecimal)attendResult.get("leave")).compareTo(BigDecimal.valueOf(0.01)) >= 0) {
            detail.put("attendence_type", "3");
            detail.put("attendence_unit", strDay);
            detail.put("attendence_time", attendResult.get("leave"));
            String percentValue = "0";
            if (standardHour.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal percent = (BigDecimal)attendResult.get("leave");
                if (percent.compareTo(BigDecimal.valueOf(1L)) > 0) {
                    percent = BigDecimal.valueOf(1L);
                }
                NumberFormat nt = NumberFormat.getPercentInstance();
                nt.setMinimumFractionDigits(0);
                percentValue = nt.format(percent);
            }
            detail.put("attendence_percent", percentValue.substring(0, percentValue.length() - 1));
        } else if (((BigDecimal)attendResult.get("evection")).compareTo(BigDecimal.valueOf(0.01)) >= 0) {
            detail.put("attendence_type", "4");
            detail.put("attendence_unit", strDay);
            detail.put("attendence_time", attendResult.get("evection"));
            String percentValue = "0";
            if (standardHour.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal percent = (BigDecimal)attendResult.get("evection");
                if (percent.compareTo(BigDecimal.valueOf(1L)) > 0) {
                    percent = BigDecimal.valueOf(1L);
                }
                NumberFormat nt = NumberFormat.getPercentInstance();
                nt.setMinimumFractionDigits(0);
                percentValue = nt.format(percent);
            }
            detail.put("attendence_percent", percentValue.substring(0, percentValue.length() - 1));
        } else if (((BigDecimal)attendResult.get("overtime")).compareTo(BigDecimal.valueOf(0.01)) >= 0) {
            detail.put("attendence_type", "5");
            detail.put("attendence_unit", strHour);
            detail.put("attendence_time", attendResult.get("overtime"));
            String percentValue = "0";
            if (standardHour.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal percent = ((BigDecimal)attendResult.get("overtime")).divide(standardHour, 2, 4);
                if (percent.compareTo(BigDecimal.valueOf(1L)) > 0) {
                    percent = BigDecimal.valueOf(1L);
                }
                NumberFormat nt = NumberFormat.getPercentInstance();
                nt.setMinimumFractionDigits(0);
                percentValue = nt.format(percent);
            }
            detail.put("attendence_percent", percentValue.substring(0, percentValue.length() - 1));
        } else {
            if (null != scheduleShiftInfo && scheduleShiftInfo.getDefaultShift() == null || "0".equals(attendanceFileHISCollection.get(0).getIsAttendance().getValue())) {
                int dayType = 0;
                boolean isAttendance = true;
                if ("0".equals(attendanceFileHISCollection.get(0).getIsAttendance().getValue())) {
                    dayType = this.getWorkCalendarItem(ctx, date, attendanceFileHISCollection);
                    isAttendance = false;
                }
                if (null != scheduleShiftInfo && null != scheduleShiftInfo.getDayType()) {
                    if (isAttendance && 2 == scheduleShiftInfo.getDayType().getValue() || 2 == dayType) {
                        detail.put("attendence_type", "8");
                        result.put("attendence_result", detail);
                        result.put("error", "false");
                        return result;
                    }
                    if (isAttendance && 1 == scheduleShiftInfo.getDayType().getValue() || 1 == dayType) {
                        detail.put("attendence_type", "7");
                        result.put("attendence_result", detail);
                        result.put("error", "false");
                        return result;
                    }
                }
            }
            detail.put("attendence_type", "6");
            detail.put("attendence_unit", strHour);
            if (((BigDecimal)attendResult.get("work")).compareTo(BigDecimal.valueOf(0.01)) >= 0) {
                detail.put("attendence_time", attendResult.get("work"));
                String percentValue = "0";
                if (standardHour.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal percent = ((BigDecimal)attendResult.get("work")).divide(standardHour, 2, 4);
                    if (percent.compareTo(BigDecimal.valueOf(1L)) > 0) {
                        percent = BigDecimal.valueOf(1L);
                    }
                    NumberFormat nt = NumberFormat.getPercentInstance();
                    nt.setMinimumFractionDigits(0);
                    percentValue = nt.format(percent);
                }
                detail.put("attendence_percent", percentValue.substring(0, percentValue.length() - 1));
            } else {
                detail.put("attendence_time", 0);
                detail.put("attendence_percent", 0);
            }
        }
        result.put("attendence_result", detail);
        result.put("error", "false");
        return result;
    }

    public Map<Object, Object> getAttendResultByDateAndPersonId(Context ctx, String personId, String startDate, String lastDate) throws BOSException {
        ConcurrentHashMap<Object, Object> resultMap = new ConcurrentHashMap<Object, Object>();
        BigDecimal overtime = BigDecimal.valueOf(0L);
        BigDecimal leave = BigDecimal.valueOf(0L);
        BigDecimal evection = BigDecimal.valueOf(0L);
        BigDecimal work = BigDecimal.valueOf(0L);
        int late = 0;
        int early = 0;
        int absence = 0;
        BigDecimal lateTime = BigDecimal.valueOf(0L);
        BigDecimal earlyTime = BigDecimal.valueOf(0L);
        BigDecimal absenceTime = BigDecimal.valueOf(0L);
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select sum(S18) as late ,sum(S20) as early,sum(S22) as absence,sum(S17) as work,sum(S19) as lateTime,sum(S21) as earlyTime,sum(S23) as absenceTime,sum(S65) as overtime,sum(S30) as evection,sum(S28) as leave from  T_HR_ATS_AttendanceResult result ");
        sqlStr.append("where result.FAttenceDate >= { ts'" + startDate + " 00:00:00'} ");
        sqlStr.append("and result.FAttenceDate <= { ts'" + lastDate + " 23:59:59'} ");
        sqlStr.append("and result.FPROPOSERID = '" + personId + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        try {
            if (rowSet.next()) {
                late = rowSet.getInt("late");
                early = rowSet.getInt("early");
                absence = rowSet.getInt("absence");
                work = rowSet.getBigDecimal("work") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("work").stripTrailingZeros();
                lateTime = rowSet.getBigDecimal("lateTime") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("lateTime").stripTrailingZeros();
                earlyTime = rowSet.getBigDecimal("earlyTime") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("earlyTime").stripTrailingZeros();
                absenceTime = rowSet.getBigDecimal("absenceTime") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("absenceTime").stripTrailingZeros();
                overtime = rowSet.getBigDecimal("overtime") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("overtime").stripTrailingZeros();
                evection = rowSet.getBigDecimal("evection") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("evection").stripTrailingZeros();
                leave = rowSet.getBigDecimal("leave") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("leave").stripTrailingZeros();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        int decimalPlaceSystem = DecimalPlaceUtil.getDecimalPlaceSystem((Context)ctx);
        leave = leave.setScale(decimalPlaceSystem, 4);
        resultMap.put("work", work);
        resultMap.put("late", late);
        resultMap.put("early", early);
        resultMap.put("absence", absence);
        resultMap.put("lateTime", lateTime);
        resultMap.put("earlyTime", earlyTime);
        resultMap.put("absenceTime", absenceTime);
        resultMap.put("overtime", overtime);
        resultMap.put("evection", evection);
        resultMap.put("leave", leave);
        return resultMap;
    }

    public Map<Object, Object> getAttendResultByDateAndPersonId(Context ctx, String personId, String date) throws BOSException {
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        BigDecimal overtime = BigDecimal.valueOf(0L);
        BigDecimal leave = BigDecimal.valueOf(0L);
        BigDecimal evection = BigDecimal.valueOf(0L);
        BigDecimal work = BigDecimal.valueOf(0L);
        int late = 0;
        int early = 0;
        int absence = 0;
        BigDecimal lateTime = BigDecimal.valueOf(0L);
        BigDecimal earlyTime = BigDecimal.valueOf(0L);
        BigDecimal absenceTime = BigDecimal.valueOf(0L);
        Date s1 = null;
        Date s2 = null;
        Date s3 = null;
        Date s4 = null;
        Date s5 = null;
        Date s6 = null;
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select S1, S2, S3, S4, S5, S6, S18 as late ,S20 as early, S22 as absence, S17 as work, S19 as lateTime, S21 as earlyTime, S23 as absenceTime, S65 as overtime, S30 as evection, S28 as leave from  T_HR_ATS_AttendanceResult result ");
        sqlStr.append("where result.FAttenceDate >= { ts'" + date + " 00:00:00'} ");
        sqlStr.append("and result.FAttenceDate <= { ts'" + date + " 23:59:59'} ");
        sqlStr.append("and result.FPROPOSERID = '" + personId + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        try {
            if (rowSet.next()) {
                late = rowSet.getInt("late");
                early = rowSet.getInt("early");
                absence = rowSet.getInt("absence");
                work = rowSet.getBigDecimal("work") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("work").stripTrailingZeros();
                lateTime = rowSet.getBigDecimal("lateTime") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("lateTime").stripTrailingZeros();
                earlyTime = rowSet.getBigDecimal("earlyTime") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("earlyTime").stripTrailingZeros();
                absenceTime = rowSet.getBigDecimal("absenceTime") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("absenceTime").stripTrailingZeros();
                overtime = rowSet.getBigDecimal("overtime") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("overtime").stripTrailingZeros();
                evection = rowSet.getBigDecimal("evection") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("evection").stripTrailingZeros();
                leave = rowSet.getBigDecimal("leave") == null ? BigDecimal.valueOf(0L) : rowSet.getBigDecimal("leave").stripTrailingZeros();
                s1 = rowSet.getDate("S1");
                s2 = rowSet.getDate("S2");
                s3 = rowSet.getDate("S3");
                s4 = rowSet.getDate("S4");
                s5 = rowSet.getDate("S5");
                s6 = rowSet.getDate("S6");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        int decimalPlaceSystem = DecimalPlaceUtil.getDecimalPlaceSystem((Context)ctx);
        leave = leave.setScale(decimalPlaceSystem, 4);
        resultMap.put("work", work);
        resultMap.put("late", late);
        resultMap.put("early", early);
        resultMap.put("absence", absence);
        resultMap.put("lateTime", lateTime);
        resultMap.put("earlyTime", earlyTime);
        resultMap.put("absenceTime", absenceTime);
        resultMap.put("overtime", overtime);
        resultMap.put("evection", evection);
        resultMap.put("leave", leave);
        resultMap.put("s1", s1);
        resultMap.put("s2", s2);
        resultMap.put("s3", s3);
        resultMap.put("s4", s4);
        resultMap.put("s5", s5);
        resultMap.put("s6", s6);
        return resultMap;
    }

    public Map<Object, Map<Object, Object>> getPunchCardAndScheduleShift(Context ctx, String personId, String date, AttendanceFileHISCollection attendanceFileHISCollection, ScheduleShiftInfo scheduleShiftInfo, Map<Object, Object> attendResult) throws BOSException {
        ConcurrentHashMap<Object, Map<Object, Object>> result = new ConcurrentHashMap<Object, Map<Object, Object>>();
        JSONArray card = new JSONArray();
        JSONArray shift = new JSONArray();
        ConcurrentHashMap<String, String> cardMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> shiftMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> error = new ConcurrentHashMap<String, String>();
        if ("1".equals(attendanceFileHISCollection.get(0).getIsAttendance().getValue())) {
            if (scheduleShiftInfo == null) {
                shiftMap.put("attendence_shift", "noshift");
                cardMap.put("attendence_card", "nocard");
                result.put("shift", shiftMap);
                result.put("card", cardMap);
                error.put("error", "false");
                result.put("error", error);
                return result;
            }
            ScheduleShiftItemCollection scheduleShiftItemCollection = scheduleShiftInfo.getItems();
            if (scheduleShiftItemCollection != null && scheduleShiftItemCollection.size() != 0) {
                ConcurrentHashMap<String, ScheduleShiftItemInfo> scheduleShiftItemMap = new ConcurrentHashMap<String, ScheduleShiftItemInfo>();
                for (int i = 0; i < scheduleShiftItemCollection.size(); ++i) {
                    ScheduleShiftItemInfo temInfo = scheduleShiftItemCollection.get(i);
                    scheduleShiftItemMap.put(temInfo.getSegment().getValue(), temInfo);
                }
                java.util.Date s1 = (java.util.Date)attendResult.get("s1");
                java.util.Date s2 = (java.util.Date)attendResult.get("s2");
                java.util.Date s3 = (java.util.Date)attendResult.get("s3");
                java.util.Date s4 = (java.util.Date)attendResult.get("s4");
                java.util.Date s5 = (java.util.Date)attendResult.get("s5");
                java.util.Date s6 = (java.util.Date)attendResult.get("s6");
                JSONObject cardOne = new JSONObject();
                JSONObject cardTwo = new JSONObject();
                JSONObject cardThree = new JSONObject();
                JSONObject shiftOne = new JSONObject();
                JSONObject shiftTwo = new JSONObject();
                JSONObject shiftThree = new JSONObject();
                Timestamp tp = ((ScheduleShiftItemInfo)scheduleShiftItemMap.get("1")).getPreDateTime();
                SimpleDateFormat formatTest = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long righTime = 0L;
                long leftTime = 0L;
                if (tp != null) {
                    try {
                        righTime = formatTest.parse(tp.toString().substring(0, 10) + " 23:59:59").getTime();
                        leftTime = formatTest.parse(tp.toString().substring(0, 10) + " 00:00:00").getTime();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                shiftOne.put((Object)"starttime", (Object)((ScheduleShiftItemInfo)scheduleShiftItemMap.get("1")).getPreTime());
                shiftOne.put((Object)"endtime", (Object)((ScheduleShiftItemInfo)scheduleShiftItemMap.get("1")).getNextTime());
                shift.add((Object)shiftOne);
                cardOne.put((Object)"starttime", (Object)(s1 == null ? "" : AtsDateUtils.dateLongToString((java.util.Date)s1).substring(11, 16)));
                cardOne.put((Object)"endtime", (Object)(s2 == null ? "" : AtsDateUtils.dateLongToString((java.util.Date)s2).substring(11, 16)));
                cardOne.put((Object)"starttimeflag", (Object)this.setTimeFlag(s1, righTime, leftTime));
                cardOne.put((Object)"endtimeflag", (Object)this.setTimeFlag(s2, righTime, leftTime));
                card.add((Object)cardOne);
                if (scheduleShiftItemCollection.size() >= 2) {
                    shiftTwo.put((Object)"starttime", (Object)((ScheduleShiftItemInfo)scheduleShiftItemMap.get("2")).getPreTime());
                    shiftTwo.put((Object)"endtime", (Object)((ScheduleShiftItemInfo)scheduleShiftItemMap.get("2")).getNextTime());
                    shift.add((Object)shiftTwo);
                    cardTwo.put((Object)"starttime", (Object)(s3 == null ? "" : AtsDateUtils.dateLongToString((java.util.Date)s3).substring(11, 16)));
                    cardTwo.put((Object)"endtime", (Object)(s4 == null ? "" : AtsDateUtils.dateLongToString((java.util.Date)s4).substring(11, 16)));
                    cardTwo.put((Object)"starttimeflag", (Object)this.setTimeFlag(s3, righTime, leftTime));
                    cardTwo.put((Object)"endtimeflag", (Object)this.setTimeFlag(s4, righTime, leftTime));
                    card.add((Object)cardTwo);
                }
                if (scheduleShiftItemCollection.size() >= 3) {
                    shiftThree.put((Object)"starttime", (Object)((ScheduleShiftItemInfo)scheduleShiftItemMap.get("3")).getPreTime());
                    shiftThree.put((Object)"endtime", (Object)((ScheduleShiftItemInfo)scheduleShiftItemMap.get("3")).getNextTime());
                    shift.add((Object)shiftThree);
                    cardThree.put((Object)"starttime", (Object)(s5 == null ? "" : AtsDateUtils.dateLongToString((java.util.Date)s5).substring(11, 16)));
                    cardThree.put((Object)"endtime", (Object)(s6 == null ? "" : AtsDateUtils.dateLongToString((java.util.Date)s6).substring(11, 16)));
                    cardThree.put((Object)"starttimeflag", (Object)this.setTimeFlag(s5, righTime, leftTime));
                    cardThree.put((Object)"endtimeflag", (Object)this.setTimeFlag(s6, righTime, leftTime));
                    card.add((Object)cardThree);
                }
            } else if (scheduleShiftItemCollection.size() == 0) {
                if (scheduleShiftInfo.getDayType() == DayTypeEnum.legalHoliday) {
                    shiftMap.put("attendence_shift", "legalHolidayShift");
                    cardMap.put("attendence_card", "legalHolidayCard");
                } else if (scheduleShiftInfo.getDayType() == DayTypeEnum.restDay) {
                    shiftMap.put("attendence_shift", "restShift");
                    cardMap.put("attendence_card", "restCard");
                }
                result.put("shift", shiftMap);
                result.put("card", cardMap);
                error.put("error", "false");
                result.put("error", error);
                return result;
            }
        }
        cardMap.put("attendence_card", (String)card);
        shiftMap.put("attendence_shift", (String)shift);
        result.put("shift", shiftMap);
        result.put("card", cardMap);
        error.put("error", "false");
        result.put("error", error);
        return result;
    }

    public static String getPersonId(Context ctx) {
        PersonInfo personInfo = null;
        try {
            personInfo = AttendanceResultMainPage.getCurrPersonInfo(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String personId = "";
        if (personInfo != null) {
            personId = personInfo.getId().toString();
        }
        return personId;
    }

    public static PersonInfo getCurrPersonInfo(Context ctx) throws Exception {
        String userName = ctx.getUserName();
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        StringBuffer sql = new StringBuffer();
        sql.append(" select pmuser.fid from t_pm_user pmuser inner join t_bd_person person on pmuser.fpersonid=person.fid ");
        sql.append(" where pmuser.fnumber='" + userInfo.getNumber() + "'");
        sql.append(" and pmuser.fpersonid is not null");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowset.size() <= 0) {
                throw new PerselfBizException(PerselfBizException.NO_MEMBER);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        PersonInfo personInfo = null;
        personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (personInfo == null) {
            throw new PerselfBizException(PerselfBizException.NO_MEMBER);
        }
        return personInfo;
    }

    public HolidayLimitCollection getHolidayLimitCollectionByPersonIdAndStartEndTimeImpl(Context ctx, String personId, String holidayType, String startTime, String endTime) throws BOSException {
        HolidayLimitCollection holidayLimitCollection = this.getHolidayLimitCollectionByPersonIdAndHolidayTypeId(ctx, personId, holidayType, startTime, endTime);
        return holidayLimitCollection;
    }

    public HolidayLimitCollection getHolidayLimitCollectionByPersonIdAndHolidayTypeId(Context ctx, String personId, String holidayTypeId, String startDate, String endDate) throws BOSException {
        HolidayLimitCollection holidayLimitCollection = HolidayLimitFactory.getLocalInstance((Context)ctx).getHolidayLimitCollection(" where proposer='" + personId + "' and   holidayPolicy.holidayType='" + holidayTypeId + "' and effectDate <= {ts'" + startDate + "'} and delayDate>= {ts'" + endDate + "'}");
        return holidayLimitCollection;
    }

    public BigDecimal getStandardHourFromAttendanceFileHIS(AttendanceFileHISCollection attendanceFileHISCollection) throws BOSException {
        BigDecimal standardHour = null;
        AttendanceFileHISInfo attendanceFileHIS = attendanceFileHISCollection.get(0);
        if (attendanceFileHIS != null && attendanceFileHIS.getAtsShift() != null) {
            standardHour = attendanceFileHIS.getAtsShift().getStandardHour();
        }
        return standardHour;
    }

    public boolean isAttendResultByDateAndPersonId(Context ctx, String personId, String startDate, String lastDate) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select count(*) from T_HR_ATS_AttendanceResult result ");
        sqlStr.append("where result.FAttenceDate >= { ts'" + startDate + " 00:00:00'} ");
        sqlStr.append("and result.FAttenceDate <= { ts'" + lastDate + " 23:59:59'} ");
        sqlStr.append("and result.FPROPOSERID = '" + personId + "' ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        try {
            if (rowSet.next() && rowSet.getInt(1) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public Map<Object, Object> isLackAttendanceFile(Context ctx, String personId, String date) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        ConcurrentHashMap<Object, Object> result = new ConcurrentHashMap<Object, Object>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("attendanceNum"));
        sic.add(new SelectorItemInfo("attendFileState"));
        sic.add(new SelectorItemInfo("isAttendance"));
        sic.add(new SelectorItemInfo("EFFDT"));
        sic.add(new SelectorItemInfo("LEFFDT"));
        sic.add(new SelectorItemInfo("atsShift.*"));
        sic.add(new SelectorItemInfo("proposer.*"));
        sic.add(new SelectorItemInfo("holidayPolicySet.*"));
        sic.add(new SelectorItemInfo("attencePolicy.*"));
        entityViewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("proposer", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("attendFileState", (Object)"1"));
        filterInfo.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)date, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)date, CompareType.GREATER_EQUALS));
        entityViewInfo.setFilter(filterInfo);
        AttendanceFileHISCollection attendanceFileCollection = AttendanceFileHISFactory.getLocalInstance((Context)ctx).getAttendanceFileHISCollection(entityViewInfo);
        if (attendanceFileCollection == null || attendanceFileCollection.size() == 0) {
            result.put("flag", "true");
            return result;
        }
        AttendanceFileHISInfo attendanceFileInfo = attendanceFileCollection.get(0);
        if (attendanceFileInfo.getAtsShift() == null || attendanceFileInfo.getAttencePolicy() == null) {
            result.put("flag", "true");
            return result;
        }
        result.put("flag", "false");
        result.put("file", attendanceFileCollection);
        return result;
    }

    public int getWorkCalendarItem(Context ctx, String date, AttendanceFileHISCollection attendanceFileHISCollection) throws BOSException {
        int dayType = 0;
        String workCalendarId = attendanceFileHISCollection.get(0).getAttencePolicy().getWorkCalendar().getId().toString();
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append("select FDayType as dayType from T_HR_ATS_WorkCalendarItem ");
        sqlStr.append("where FDate >= { ts'" + date + " 00:00:00'} ");
        sqlStr.append("and FDate <= { ts'" + date + " 23:59:59'} ");
        sqlStr.append("and FCalendarGroupID = '" + workCalendarId + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        try {
            if (rowSet.next()) {
                dayType = rowSet.getInt("dayType");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dayType;
    }

    public String setTimeFlag(java.util.Date s, long righTime, long leftTime) {
        if (s != null) {
            if (s.getTime() > righTime) {
                return "1";
            }
            if (s.getTime() < leftTime) {
                return "-1";
            }
        }
        return "0";
    }
}

