/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.self.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class HRConfigUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.manager.util.HRManagerConfigUtil");

    public static ArrayList getDCList() {
        ArrayList newList = new ArrayList();
        try {
            newList = DCManager.getInstance().getDCList();
        }
        catch (Exception e1) {
            logger.error((Object)("FaRebuildViewService.newList = " + e1.getMessage()));
        }
        return newList;
    }

    public static boolean DCisNotNull(Context ctx) {
        return ctx != null && ctx.getAIS() != null && ctx.getAIS().trim().length() != 0;
    }

    public static String getDBType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2";
            }
        }
        return "Oracle";
    }

    public static String escape(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String[] convertStringToArray(String strs) {
        String[] str = null;
        if (!StringUtils.isEmpty((String)strs)) {
            strs = strs.substring(1, strs.length() - 1);
            str = strs.split(",");
        }
        return str;
    }

    public static boolean convertStringToBoolean(String str) {
        boolean b = false;
        if (!StringUtils.isEmpty((String)str)) {
            b = Boolean.parseBoolean(str);
        }
        return b;
    }

    public static double convertStringToDouble(String str) {
        double d = 0.0;
        if (!StringUtils.isEmpty((String)str)) {
            d = Double.parseDouble(str);
        }
        return d;
    }

    public static int convertStringToInt(String str) {
        int d = 0;
        if (!StringUtils.isEmpty((String)str)) {
            d = Integer.parseInt(str);
        }
        return d;
    }

    public static Map convertJSONObjectToMap(Object o) throws BOSException {
        if (o == null) {
            return new HashMap();
        }
        try {
            JSONObject jsonObj = JSONObject.fromObject((Object)o);
            return HRConfigUtil.convertJSONMap(jsonObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static HashMap convertJSONMap(JSONObject jsonObj) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator iter = jsonObj.keys();
        String key = null;
        while (iter.hasNext()) {
            key = iter.next().toString();
            Object obj = jsonObj.get(key);
            if (obj == null) {
                result.put(key, null);
                continue;
            }
            if (obj instanceof JSONArray) {
                result.put(key, HRConfigUtil.convertJSONArray((JSONArray)obj));
                continue;
            }
            if (obj instanceof JSONObject) {
                result.put(key, HRConfigUtil.convertJSONMap((JSONObject)obj));
                continue;
            }
            result.put(key, obj);
        }
        return result;
    }

    public static ArrayList convertJSONArray(JSONArray jsonArray) throws Exception {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObj = jsonArray.getJSONObject(i);
            list.add(HRConfigUtil.convertJSONMap(jsonObj));
        }
        return list;
    }
}

