/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.wssc.CallSSCInterfaceFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.shareservice.ShareServiceException;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSCShareCenterUtils {
    private static final Logger logger = LoggerFactory.getLogger(SSCShareCenterUtils.class);

    public static boolean isShareCenterUseHRO(Context ctx) throws BOSException, SQLException {
        boolean isUseHRO = false;
        String orgTypeStr = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).getImportOrgType(null);
        if (orgTypeStr.equals("16")) {
            isUseHRO = true;
        }
        return isUseHRO;
    }

    public static String getPermissionOrg(Context ctx, String EASUserId, String permissionId) throws BOSException, EASBizException {
        String permItemName = "";
        String orgSetIDs = "''";
        Set orgSet = new HashSet();
        String sql = "SELECT fnumber FROM t_pm_permitem where fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{permissionId});
        try {
            if (rs.next()) {
                permItemName = rs.getString("fnumber");
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6743\u9650\u9879\u7f16\u7801\u5931\u8d25,sql====>:" + sql);
        }
        try {
            if (!"".equals(permItemName) && !permItemName.isEmpty() && permItemName != null && (orgSet = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(EASUserId), OrgType.ShareCenterOrgType, null, permItemName)) != null && orgSet.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (String orgStr : orgSet) {
                    sb.append(orgStr + ",");
                }
                orgSetIDs = sb.toString().substring(0, sb.length() - 1);
            }
        }
        catch (EASBizException e) {
            logger.error("\u83b7\u53d6\u5171\u4eab\u4e2d\u5fc3\u5931\u8d25,permissionId:" + permissionId, (Throwable)e);
        }
        return orgSetIDs;
    }

    public static void checkSSCUser(Context ctx, String userId) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null == userId) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        params.put("userId", userId);
        JsonObject result = SSCTaskAppUtil.operateTaskAll(ctx, "userexistsharecenter", params);
        JsonElement successJe = result.get("success");
        if ("false".equals(successJe.getAsString())) {
            throw new ShareServiceException(ShareServiceException.CUSTOM_EXCEPTION, new Object[]{result.get("data").getAsString()});
        }
    }

    public static void checkSSCManager(Context ctx, String userId) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null == userId) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        }
        params.put("userId", userId);
        JsonObject jo = SSCTaskAppUtil.operateTaskAll(ctx, "USERROLETYP", params);
        if (jo.get("dataType") != null && "JsonArray".equals(jo.get("dataType").getAsString())) {
            JsonArray dataArray = jo.get("data").getAsJsonArray();
            boolean isPass = false;
            for (int i = 0; i < dataArray.size(); ++i) {
                String role = dataArray.get(i).getAsString();
                if (!"hEw8bwRNR8qPRPajcUdX4C0WZ4A=".equals(role)) continue;
                isPass = true;
                break;
            }
            if (!isPass) {
                throw new ShareServiceException(ShareServiceException.NO_MANAGE_ROLE_PERMISSION);
            }
        }
    }
}

