/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.CallSSCInterfaceFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.shareservice.AssembleRuleFacadeFactory;
import com.kingdee.shr.shareservice.ExternalSysExchangeLogFactory;
import com.kingdee.shr.shareservice.ExternalSysExchangeLogInfo;
import com.kingdee.shr.shareservice.IExternalSysExchangeLog;
import com.kingdee.shr.shareservice.app.SSCTaskReultException;
import com.kingdee.shr.shareservice.util.AssembleUtils;
import com.kingdee.shr.shareservice.util.SSCTaskAppConstants;
import com.kingdee.shr.shareservice.util.SaveFailLogUtils;
import com.kingdee.shr.shareservice.util.XMLDocUtil;
import com.kingdee.shr.shareservice.vo.SSCQueryDataDTO;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSCTaskAppUtil {
    private static final Logger logger = LoggerFactory.getLogger(SSCTaskAppUtil.class);
    public static final int MAX_FETCH_RECORDS = 8000;

    public static boolean createJob(Context ctx, Map<String, Object> param) throws EASBizException {
        boolean success = false;
        String operation = "createJob";
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Map genParam = SSCTaskAppUtil.genShareCenter(ctx, param);
            map.put("taskCenterAttribute", JSONObject.toJSONString((Object)genParam));
            String operationAttribute = XMLDocUtil.getOperationXml(operation, map);
            String sscNumber = SSCTaskAppUtil.getSSCNumber(ctx, null);
            logger.debug("==== com.kingdee.shr.shareservice.util.SSCTaskAppUtil.createJob operationAttribute:" + operationAttribute + "; sscNumber" + sscNumber);
            XMLUtil.parseXML((String)operationAttribute);
            String result = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).taskOperation(operationAttribute, sscNumber);
            logger.debug("==== com.kingdee.shr.shareservice.util.SSCTaskAppUtil.createJob result:" + result);
            success = true;
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SSCTaskReultException(SSCTaskReultException.SUCCESS_FALSE);
        }
        return success;
    }

    private static Map genShareCenter(Context ctx, Map<String, Object> param) throws BOSException {
        String sscNumber = param.get("sscNumber").toString();
        String subject = param.get("subject").toString();
        String billofDocumentID = param.get("billofDocumentID").toString();
        String orgNumber = param.get("orgNumber").toString();
        String businessAttribute = param.get("businessAttribute").toString();
        String jobCreateID = param.get("jobCreateID").toString();
        String jobPriority = param.get("jobPriority") != null ? param.get("jobPriority").toString() : "20";
        Boolean isPhotoCopy = true;
        String level = param.get("level") != null ? param.get("level").toString() : "0";
        Boolean autoApprove = param.get("autoApprove") != null ? "true".equalsIgnoreCase(param.get("autoApprove").toString()) : true;
        String isLastLevel = param.get("isLastLevel") != null ? param.get("isLastLevel").toString() : "false";
        Map shareCenterMap = BillImageMapFactory.getLocalInstance((Context)ctx).createShareCenter_V10(jobPriority, isPhotoCopy.booleanValue(), subject, orgNumber, businessAttribute, billofDocumentID, level, autoApprove.booleanValue(), isLastLevel, jobCreateID, sscNumber);
        Map<String, Map<String, Object>> assembleMap = SSCTaskAppUtil.assembleDYValues(ctx, billofDocumentID, businessAttribute);
        if (assembleMap != null && !assembleMap.isEmpty()) {
            shareCenterMap.putAll(assembleMap.get(billofDocumentID));
        }
        return shareCenterMap;
    }

    public static JsonObject viewJobDetail(Context ctx, String jobId) throws BOSException, EASBizException {
        String result;
        JsonObject resultData;
        Object jo = null;
        String sscNumber = SSCTaskAppUtil.getSSCNumber(ctx, null);
        if (logger.isDebugEnabled()) {
            logger.debug("==== com.kingdee.shr.shareservice.util.SSCTaskAppUtil.viewJobDetail jobId:" + jobId + "; sscNumber" + sscNumber);
        }
        if (null != (resultData = SSCTaskAppUtil.parseSSCResult(ctx, result = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).viewJobDetail(jobId, sscNumber))).get("success") && !resultData.get("success").getAsBoolean()) {
            throw new SSCTaskReultException(SSCTaskReultException.CUSTOM_EXCEPTION, new Object[]{resultData.get("data").getAsString()});
        }
        return resultData;
    }

    public static String getSSCNumber(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        String sscNumber = "EAS";
        return sscNumber;
    }

    public static JsonObject queryJabList(Context ctx, String queryCondition) throws BOSException, EASBizException {
        String result = "";
        String sscNumber = SSCTaskAppUtil.getSSCNumber(ctx, null);
        if (logger.isDebugEnabled()) {
            logger.debug("==== com.kingdee.shr.shareservice.util.SSCTaskAppUtil.queryJabList queryCondition:" + queryCondition + "; sscNumber" + sscNumber);
        }
        XMLUtil.parseXML((String)queryCondition);
        result = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).queryJobList(queryCondition, sscNumber);
        JsonObject resultData = SSCTaskAppUtil.parseSSCResult(ctx, result);
        if (null != resultData.get("success") && !resultData.get("success").getAsBoolean()) {
            throw new SSCTaskReultException(SSCTaskReultException.CUSTOM_EXCEPTION, new Object[]{resultData.get("data").getAsString()});
        }
        return resultData;
    }

    public static JsonObject operateTask(Context ctx, String operationAttribute) throws EASBizException, BOSException {
        String result = "";
        try {
            String sscNumber = SSCTaskAppUtil.getSSCNumber(ctx, null);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCTaskAppUtil operateTask :" + operationAttribute);
            }
            XMLUtil.parseXML((String)operationAttribute);
            result = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).taskOperation(operationAttribute, sscNumber);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCTaskAppUtil operateTask result :" + result);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SSCTaskReultException(SSCTaskReultException.SUCCESS_FALSE);
        }
        catch (Exception e) {
            logger.error("SSCTaskAppUtil operateTask Exception : " + e.getMessage(), (Throwable)e);
            throw new SSCTaskReultException(SSCTaskReultException.SUCCESS_FALSE);
        }
        JsonObject resultData = SSCTaskAppUtil.parseSSCResult(ctx, result);
        if (null != resultData.get("success") && !resultData.get("success").getAsBoolean()) {
            throw new SSCTaskReultException(SSCTaskReultException.CUSTOM_EXCEPTION, new Object[]{resultData.get("data").getAsString()});
        }
        return resultData;
    }

    @Deprecated
    public static JsonObject operateTask(Context ctx, String operation, Map<String, Object> params) throws BOSException, EASBizException {
        Map<String, Object> joMap = SSCTaskAppUtil._operateTask(ctx, operation, params);
        String exception = "";
        Object resultObj = joMap.get("result");
        String resultStr = "";
        if (resultObj != null) {
            resultStr = (String)resultObj;
        }
        if (joMap.get("easBizException") != null) {
            String easBizException = (String)joMap.get("easBizException");
            if ("1".equals(easBizException)) {
                exception = (String)joMap.get("exception");
                SSCTaskAppUtil.saveFailLog(resultStr, exception, ctx, operation, params);
                if (null == joMap.get("e")) {
                    throw new EASBizException(SSCTaskReultException.SUCCESS_FALSE);
                }
                if (null == joMap.get("eType")) {
                    throw new EASBizException(SSCTaskReultException.SUCCESS_FALSE);
                }
                if ("eas".equals((String)joMap.get("eType"))) {
                    throw (EASBizException)((Object)joMap.get("e"));
                }
                if ("bos".equals((String)joMap.get("eType"))) {
                    throw (BOSException)((Object)joMap.get("e"));
                }
            }
        } else {
            if (joMap.get("xmlException") != null) {
                exception = (String)joMap.get("xmlException");
            } else if (joMap.get("resultEmpty") != null) {
                exception = (String)joMap.get("resultEmpty");
            } else {
                return (JsonObject)joMap.get("jo");
            }
            SSCTaskAppUtil.saveFailLog(resultStr, exception, ctx, operation, params);
        }
        JsonObject resultData = (JsonObject)joMap.get("jo");
        if (null != resultData.get("success") && !resultData.get("success").getAsBoolean()) {
            throw new SSCTaskReultException(SSCTaskReultException.CUSTOM_EXCEPTION, new Object[]{resultData.get("data").getAsString()});
        }
        return resultData;
    }

    public static void saveFailLog(String resultStr, String exception, Context ctx, String operation, Map<String, Object> params) {
        try {
            IExternalSysExchangeLog iExternalSysExchangeLog = ExternalSysExchangeLogFactory.getLocalInstance(ctx);
            String jobId = params.get("jobId") == null ? "" : (String)params.get("jobId");
            String billId = params.get("billofDocumentID") == null ? "" : (String)params.get("billofDocumentID");
            ExternalSysExchangeLogInfo externalSysExchangeLog = new ExternalSysExchangeLogInfo();
            externalSysExchangeLog.setJobId(jobId);
            externalSysExchangeLog.setBizBillId(billId);
            externalSysExchangeLog.setJobOperateType(operation);
            String paramStr = "";
            if (params != null && params.toString().length() > 10000) {
                paramStr = params.toString().substring(0, 10000);
            }
            if (resultStr != null && resultStr.length() > 10000) {
                resultStr = resultStr.substring(0, 10000);
            }
            if (exception != null && exception.length() > 10000) {
                exception = exception.substring(0, 10000);
            }
            externalSysExchangeLog.setJobParams(paramStr);
            externalSysExchangeLog.setJobResult(resultStr);
            externalSysExchangeLog.setExceptionMsg(exception);
            iExternalSysExchangeLog.save((CoreBaseInfo)externalSysExchangeLog);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, Object> _operateTask(Context ctx, String operation, Map<String, Object> params) {
        String result = "";
        String resultData = "";
        String operationAttribute = null;
        HashMap<String, Object> joMap = new HashMap<String, Object>();
        try {
            SSCTaskAppUtil.checkCanDeal(ctx, operation, (String)params.get("jobId"));
            String sscNumber = SSCTaskAppUtil.getSSCNumber(ctx, null);
            operationAttribute = XMLDocUtil.getOperationXml(operation, params);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCTaskAppUtil operateTask :" + operationAttribute);
            }
            XMLUtil.parseXML((String)operationAttribute);
            result = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).taskOperation(operationAttribute, sscNumber);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCTaskAppUtil operateTask result :" + result);
            }
        }
        catch (EASBizException e) {
            logger.error("SSCTaskAppUtil operateTask Exception : " + e.getMessage(), (Throwable)e);
            joMap.put("easBizException", "1");
            joMap.put("exception", SaveFailLogUtils.stackTraceToString((Exception)((Object)e)));
            joMap.put("result", result);
            joMap.put("e", (Object)e);
            joMap.put("eType", "eas");
            return joMap;
        }
        catch (BOSException e) {
            logger.error("SSCTaskAppUtil operateTask Exception : " + e.getMessage(), (Throwable)e);
            joMap.put("easBizException", "1");
            joMap.put("exception", SaveFailLogUtils.stackTraceToString((Exception)((Object)e)));
            joMap.put("result", result);
            joMap.put("e", (Object)e);
            joMap.put("eType", "bos");
            return joMap;
        }
        catch (Exception e) {
            logger.error("SSCTaskAppUtil operateTask Exception : " + e.getMessage(), (Throwable)e);
            joMap.put("easBizException", "1");
            joMap.put("exception", SaveFailLogUtils.stackTraceToString(e));
            joMap.put("result", result);
            return joMap;
        }
        try {
            boolean success = XMLDocUtil.getResultIsSuccess(result);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCTaskAppUtil operateTask success :" + success);
            }
            if (!success) {
                joMap.put("easBizException", "1");
                joMap.put("exception", "SSCTaskAppUtil operateTask success :" + success);
                joMap.put("result", result);
                return joMap;
            }
            resultData = XMLDocUtil.getQueryResultData(result);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            joMap.put("xmlException", "exception happen in xml parsing :\n" + SaveFailLogUtils.stackTraceToString((Exception)((Object)e)));
            joMap.put("result", result);
        }
        JsonObject jo = new JsonObject();
        try {
            if (!StringUtils.isEmpty((String)resultData)) {
                JsonElement je = new JsonParser().parse(resultData);
                if (je.isJsonArray()) {
                    jo.add("data", (JsonElement)je.getAsJsonArray());
                    jo.addProperty("dataType", "JsonArray");
                    joMap.put("jo", jo);
                    return joMap;
                }
                if (je.isJsonObject()) {
                    joMap.put("jo", je.getAsJsonObject());
                    return joMap;
                }
                jo.add("data", je);
                jo.addProperty("dataType", "String");
            } else {
                joMap.put("resultEmpty", "StringUtils.isEmpty(resultData) == true");
                joMap.put("result", result);
            }
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            joMap.put("jo", jo);
            return joMap;
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            joMap.put("jo", jo);
            return joMap;
        }
        joMap.put("jo", jo);
        return joMap;
    }

    public static JsonObject operateTaskAll(Context ctx, String operation, Map<String, Object> params) throws BOSException, EASBizException {
        Map<String, Object> joMap = SSCTaskAppUtil._operateTaskAll(ctx, operation, params);
        String exception = "";
        Object resultObj = joMap.get("result");
        String resultStr = "";
        if (resultObj != null) {
            resultStr = (String)resultObj;
        }
        if (joMap.get("easBizException") != null) {
            String easBizException = (String)joMap.get("easBizException");
            if ("1".equals(easBizException)) {
                exception = (String)joMap.get("exception");
                SSCTaskAppUtil.saveFailLog(resultStr, exception, ctx, operation, params);
                if (null == joMap.get("e")) {
                    throw new EASBizException(SSCTaskReultException.SUCCESS_FALSE);
                }
                if (null == joMap.get("eType")) {
                    throw new EASBizException(SSCTaskReultException.SUCCESS_FALSE);
                }
                if ("eas".equals((String)joMap.get("eType"))) {
                    throw (EASBizException)((Object)joMap.get("e"));
                }
                if ("bos".equals((String)joMap.get("eType"))) {
                    throw (BOSException)((Object)joMap.get("e"));
                }
            }
        } else {
            if (joMap.get("xmlException") != null) {
                exception = (String)joMap.get("xmlException");
            } else if (joMap.get("resultEmpty") != null) {
                exception = (String)joMap.get("resultEmpty");
            } else {
                return (JsonObject)joMap.get("jo");
            }
            SSCTaskAppUtil.saveFailLog(resultStr, exception, ctx, operation, params);
        }
        JsonObject resultData = (JsonObject)joMap.get("jo");
        if (null != resultData.get("success") && !resultData.get("success").getAsBoolean()) {
            throw new SSCTaskReultException(SSCTaskReultException.CUSTOM_EXCEPTION, new Object[]{resultData.get("data").getAsString()});
        }
        return resultData;
    }

    public static Map<String, Object> _operateTaskAll(Context ctx, String operation, Map<String, Object> params) {
        String result = "";
        String resultData = "";
        boolean success = false;
        String operationAttribute = null;
        JsonObject jo = new JsonObject();
        HashMap<String, Object> joMap = new HashMap<String, Object>();
        try {
            SSCTaskAppUtil.checkCanDeal(ctx, operation, (String)params.get("jobId"));
            String sscNumber = SSCTaskAppUtil.getSSCNumber(ctx, null);
            operationAttribute = XMLDocUtil.getOperationXml(operation, params);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCTaskAppUtil operateTaskAll : " + operationAttribute);
            }
            XMLUtil.parseXML((String)operationAttribute);
            result = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).taskOperation(operationAttribute, sscNumber);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCTaskAppUtil operateTaskAll result :" + result);
            }
        }
        catch (EASBizException e) {
            logger.error("SSCTaskAppUtil operateTaskAll Exception : " + e.getMessage(), (Throwable)e);
            joMap.put("easBizException", "1");
            joMap.put("exception", SaveFailLogUtils.stackTraceToString((Exception)((Object)e)));
            joMap.put("result", result);
            joMap.put("e", (Object)e);
            joMap.put("eType", "eas");
            return joMap;
        }
        catch (BOSException e) {
            logger.error("SSCTaskAppUtil operateTaskAll Exception : " + e.getMessage(), (Throwable)e);
            joMap.put("easBizException", "1");
            joMap.put("exception", SaveFailLogUtils.stackTraceToString((Exception)((Object)e)));
            joMap.put("result", result);
            joMap.put("e", (Object)e);
            joMap.put("eType", "bos");
            return joMap;
        }
        catch (Exception e) {
            logger.error("SSCTaskAppUtil operateTaskAll Exception : " + e.getMessage(), (Throwable)e);
            joMap.put("easBizException", "1");
            joMap.put("exception", SaveFailLogUtils.stackTraceToString(e));
            joMap.put("result", result);
            return joMap;
        }
        try {
            success = XMLDocUtil.getResultIsSuccess(result);
            if (logger.isDebugEnabled()) {
                logger.debug("SSCTaskAppUtil operateTaskAll success :" + success);
            }
            resultData = XMLDocUtil.getQueryResultDataAll(result);
            if (!success) {
                logger.error("SSCTaskAppUtil operateTaskAll Fail, resultData : " + resultData);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            joMap.put("xmlException", "exception happen in xml parsing :\n" + SaveFailLogUtils.stackTraceToString((Exception)((Object)e)));
            joMap.put("result", result);
            joMap.put("jo", jo);
            return joMap;
        }
        try {
            if (success) {
                jo.addProperty("success", Boolean.valueOf(true));
            } else {
                jo.addProperty("success", Boolean.valueOf(false));
            }
            if (!resultData.startsWith("[") && !resultData.startsWith("{")) {
                jo.addProperty("data", resultData);
                jo.addProperty("dataType", "String");
                joMap.put("jo", jo);
                return joMap;
            }
            if (!StringUtils.isEmpty((String)resultData)) {
                JsonElement je = new JsonParser().parse(resultData);
                if (je.isJsonArray()) {
                    jo.add("data", (JsonElement)je.getAsJsonArray());
                    jo.addProperty("dataType", "JsonArray");
                    joMap.put("jo", jo);
                    return joMap;
                }
                if (je.isJsonObject()) {
                    joMap.put("jo", je.getAsJsonObject());
                    return joMap;
                }
                if (je.isJsonNull()) {
                    jo.addProperty("data", resultData);
                    jo.addProperty("dataType", "String");
                } else {
                    jo.add("data", je);
                    jo.addProperty("dataType", "String");
                }
            } else {
                joMap.put("resultEmpty", "StringUtils.isEmpty(resultData) == true");
                joMap.put("result", result);
            }
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            jo.addProperty("data", resultData);
            jo.addProperty("dataType", "String");
            joMap.put("jo", jo);
            return joMap;
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            jo.addProperty("data", resultData);
            jo.addProperty("dataType", "Other");
            joMap.put("jo", jo);
            return joMap;
        }
        catch (RuntimeException e) {
            jo.addProperty("data", resultData);
            jo.addProperty("dataType", "String");
            joMap.put("jo", jo);
            return joMap;
        }
        joMap.put("jo", jo);
        return joMap;
    }

    public static JsonObject getApprovalBasicData(Context ctx, String condition) throws BOSException, EASBizException {
        JsonObject resultData;
        String result = "";
        String sscNumber = SSCTaskAppUtil.getSSCNumber(ctx, null);
        if (logger.isDebugEnabled()) {
            logger.debug("==== com.kingdee.shr.shareservice.util.SSCTaskAppUtil.getApprovalBasicData condition:" + condition + "; sscNumber" + sscNumber);
        }
        XMLUtil.parseXML((String)condition);
        result = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).getApprovalBasicData(condition, sscNumber);
        if (logger.isDebugEnabled()) {
            logger.debug("SSCTaskAppUtil getApprovalBasicData result : " + result);
        }
        if (null != (resultData = SSCTaskAppUtil.parseSSCResult(ctx, result)).get("success") && !resultData.get("success").getAsBoolean()) {
            throw new SSCTaskReultException(SSCTaskReultException.CUSTOM_EXCEPTION, new Object[]{resultData.get("data").getAsString()});
        }
        return resultData;
    }

    public static Map<String, Object> createBussattr(Context ctx, String userId, Map params) throws EASBizException, BOSException {
        String number = (String)params.get("number");
        String name = (String)params.get("name");
        String billtype = (String)params.get("billtype");
        String jobclassification = (String)params.get("jobclassification");
        ArrayList paramList = new ArrayList();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("number", number);
        paramMap.put("name", name);
        paramMap.put("billtype", billtype);
        paramMap.put("jobclassification", jobclassification == null ? "3" : jobclassification);
        paramList.add(paramMap);
        HashMap<String, Object> serviceParam = new HashMap<String, Object>();
        serviceParam.put("userId", userId);
        serviceParam.put("bussparam", JSON.parseObject((String)JSON.toJSONString(paramMap)));
        if (logger.isDebugEnabled()) {
            logger.debug("==== com.kingdee.shr.shareservice.util.SSCTaskAppUtil.createBussattr serviceParam:" + serviceParam);
        }
        JsonObject result = SSCTaskAppUtil.operateTask(ctx, "CREATEBUSSATTR", serviceParam);
        if (logger.isDebugEnabled()) {
            logger.debug("==== com.kingdee.shr.shareservice.util.SSCTaskAppUtil.createBussattr result:" + result);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", result);
        return resultMap;
    }

    public static JsonArray getBussattrPullConfig(Context ctx, String bussId) throws BOSException, EASBizException {
        JsonObject resultData;
        String shareCenterId = SSCTaskAppUtil.getCurrentUserShareCenterId(ctx);
        String result = "";
        HashMap<String, Object> serviceParam = new HashMap<String, Object>();
        serviceParam.put("shareCenterId", shareCenterId);
        serviceParam.put("bussId", bussId);
        String operationXml = null;
        operationXml = XMLDocUtil.getOperationXml("bussattrpullconfig", serviceParam);
        String sscNumber = "EAS";
        if (logger.isDebugEnabled()) {
            logger.debug("SSCTaskAppUtil getBussattrPullConfig operationXml :" + operationXml);
        }
        result = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).taskOperation(operationXml, sscNumber);
        if (logger.isDebugEnabled()) {
            logger.debug("SSCTaskAppUtil getBussattrPullConfig result :" + result);
        }
        if (null != (resultData = SSCTaskAppUtil.parseSSCResult(ctx, result)).get("success") && !resultData.get("success").getAsBoolean()) {
            throw new SSCTaskReultException(SSCTaskReultException.CUSTOM_EXCEPTION, new Object[]{resultData.get("data").getAsString()});
        }
        return resultData.get("data").getAsJsonArray();
    }

    public static String getCurrentUserShareCenterId(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String shareCenterId = null;
        if (userInfo != null) {
            shareCenterId = userInfo.getDefOrgUnit().getId().toString();
        }
        return shareCenterId;
    }

    public static Map<String, Map<String, Object>> assembleDYValues(Context ctx, String billID, String bussAttrNum) throws BOSException {
        JsonObject ruleFields;
        HashMap<String, Object> dyparam = new HashMap<String, Object>();
        dyparam.put("bussTypeNumber", bussAttrNum);
        String shareCenterId = AssembleRuleFacadeFactory.getLocalInstance(ctx).getShareCenter();
        dyparam.put("shareCenterId", shareCenterId);
        try {
            ruleFields = SSCTaskAppUtil.operateTaskAll(ctx, "GETDYNAMICATTRIBUTE", dyparam);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        if (ruleFields != null) {
            JsonElement bussEle = ruleFields.get(bussAttrNum);
            if (null == bussEle) {
                return null;
            }
            JsonObject busstrRule = bussEle.getAsJsonObject();
            if (busstrRule != null) {
                HashMap<String, Object> moduleMap = new HashMap<String, Object>();
                HashMap<String, Object> ownDef = new HashMap<String, Object>();
                HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
                for (Map.Entry entry : busstrRule.entrySet()) {
                    boolean isFromBill;
                    JsonObject rule;
                    JsonElement fromBillEle;
                    JsonElement ruleElement = (JsonElement)entry.getValue();
                    if (ruleElement == null || (fromBillEle = (rule = ruleElement.getAsJsonObject()).get("fromBill")) == null) continue;
                    boolean bl = isFromBill = "1".equals(fromBillEle.getAsString());
                    if (isFromBill) {
                        moduleMap.put((String)entry.getKey(), null);
                        continue;
                    }
                    ownDef.put((String)entry.getKey(), null);
                }
                Map<String, Map<String, Object>> assmoduleMap = AssembleUtils.assembleModule(ctx, moduleMap, billID);
                Map<String, Map<String, Object>> assownDef = AssembleUtils.assembleOwnDef(ctx, ownDef, billID);
                String[] billIDs = billID.split(",");
                for (int i = 0; i < billIDs.length; ++i) {
                    String id = billIDs[i];
                    if (assmoduleMap != null && assmoduleMap.get(id) != null) {
                        Map<String, Object> assmresultMap = assmoduleMap.get(id);
                        if (null != assownDef && null != assownDef.get(id)) {
                            assmresultMap.putAll(assownDef.get(id));
                        }
                        resultMap.put(id, assmresultMap);
                        continue;
                    }
                    if (assownDef == null || assownDef.get(id) == null) continue;
                    resultMap.put(id, assownDef.get(id));
                }
                return resultMap;
            }
        }
        return null;
    }

    public static Map<String, String> getRuleFieldByBTNum(Context ctx, String billTypeNum) throws EASBizException, BOSException {
        HashMap<String, String> ruleMap = new HashMap<String, String>();
        HashMap<String, Object> dyparam = new HashMap<String, Object>();
        dyparam.put("billTypeNumber", billTypeNum);
        String shareCenterId = AssembleRuleFacadeFactory.getLocalInstance(ctx).getShareCenter();
        dyparam.put("shareCenterId", shareCenterId);
        JsonObject ruleFields = SSCTaskAppUtil.operateTaskAll(ctx, "GETDYNAMICATTRIBUTE", dyparam);
        if (ruleFields != null) {
            String[] billTypes = billTypeNum.split(",");
            for (int i = 0; i < billTypes.length; ++i) {
                String billType = billTypes[i];
                JsonObject busstrRule = ruleFields.get(billType).getAsJsonObject();
                if (busstrRule == null) continue;
                for (Map.Entry entry : busstrRule.entrySet()) {
                    JsonObject rule;
                    JsonElement fromBillEle;
                    JsonElement ruleElement = (JsonElement)entry.getValue();
                    if (ruleElement == null || (fromBillEle = (rule = ruleElement.getAsJsonObject()).get("type")) == null) continue;
                    ruleMap.put(((String)entry.getKey()).trim(), fromBillEle.getAsString().trim());
                }
            }
        }
        return ruleMap;
    }

    public static void taskDoneRuleSyn(Context ctx, String billID, String bussAttrNum) {
        try {
            Map<String, Map<String, Object>> assemData = SSCTaskAppUtil.assembleDYValues(ctx, billID, bussAttrNum);
            if (null != assemData && !assemData.isEmpty()) {
                JSONObject dyValues = new JSONObject();
                String[] ids = billID.split(",");
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i];
                    dyValues.put(id, (Object)new JSONObject(assemData.get(id)));
                }
                HashMap<String, Object> taskParam = new HashMap<String, Object>();
                taskParam.put("mapValue", dyValues);
                taskParam.put("isUpdateHis", true);
                JsonObject updateResult = SSCTaskAppUtil.operateTaskAll(ctx, "UPDATEDYNAMICVALUE", taskParam);
                logger.info("taskDoneRuleSyn" + updateResult);
            }
        }
        catch (EASBizException e) {
            logger.error("taskDoneRuleSyn:" + e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("taskDoneRuleSyn:" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("taskDoneRuleSyn:" + e.getMessage(), (Throwable)e);
        }
    }

    public static void syncRuleSSCBYAttrNum(Context ctx, String billID, String bussAttrNum, boolean isHis) {
        try {
            Map<String, Map<String, Object>> assemData = SSCTaskAppUtil.assembleDYValues(ctx, billID, bussAttrNum);
            if (null != assemData && !assemData.isEmpty()) {
                JSONObject dyValues = new JSONObject();
                String[] ids = billID.split(",");
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i];
                    dyValues.put(id, (Object)new JSONObject(assemData.get(id)));
                }
                HashMap<String, Object> taskParam = new HashMap<String, Object>();
                taskParam.put("mapValue", dyValues);
                taskParam.put("isUpdateHis", isHis);
                JsonObject updateResult = SSCTaskAppUtil.operateTaskAll(ctx, "UPDATEDYNAMICVALUE", taskParam);
                logger.info("syncRuleSSCBYAttrNum" + updateResult);
            }
        }
        catch (EASBizException e) {
            logger.error("syncRuleSSCBYAttrNum:" + e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("syncRuleSSCBYAttrNum:" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("syncRuleSSCBYAttrNum:" + e.getMessage(), (Throwable)e);
        }
    }

    public static JsonObject parseSSCResult(Context ctx, String result) {
        String resultData = "";
        boolean success = true;
        try {
            success = XMLDocUtil.getResultIsSuccess(result);
            logger.debug("Is task operation API calling success : " + success);
            resultData = XMLDocUtil.getQueryResultDataAll(result);
            if (!success) {
                logger.error("call task center WS task operation API fail and the result is " + resultData);
            }
        }
        catch (BOSException e) {
            logger.error("parseSSCResult:" + e.getMessage(), (Throwable)e);
        }
        JsonObject jo = new JsonObject();
        try {
            if (success) {
                jo.addProperty("success", Boolean.valueOf(true));
            } else {
                jo.addProperty("success", Boolean.valueOf(false));
            }
            if (!resultData.startsWith("[") && !resultData.startsWith("{")) {
                jo.addProperty("data", resultData);
                jo.addProperty("dataType", "String");
                return jo;
            }
            if (!StringUtils.isEmpty((String)resultData)) {
                JsonElement je = new JsonParser().parse(resultData);
                if (je.isJsonArray()) {
                    jo.add("data", (JsonElement)je.getAsJsonArray());
                    jo.addProperty("dataType", "JsonArray");
                    return jo;
                }
                if (je.isJsonObject()) {
                    if (null != je.getAsJsonObject().get("errorMsg")) {
                        jo.addProperty("data", je.getAsJsonObject().get("errorMsg").getAsString());
                        jo.addProperty("dataType", "String");
                        return jo;
                    }
                    return je.getAsJsonObject();
                }
                if (je.isJsonNull()) {
                    jo.addProperty("data", resultData);
                    jo.addProperty("dataType", "String");
                } else {
                    jo.add("data", je);
                    jo.addProperty("dataType", "String");
                }
            }
        }
        catch (JsonParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return jo;
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return jo;
        }
        return jo;
    }

    public static List<Map<String, String>> getQuerySourceData(Context ctx, String query) throws BOSException, EASBizException {
        JsonElement dataJE;
        JsonArray data;
        String dataType;
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("queryPK", query);
        param.put("cu", false);
        param.put("displayNum", 200);
        param.put("queryFilterItems", "");
        param.put("isShowHistory", false);
        JsonObject result = SSCTaskAppUtil.operateTask(ctx, "GETQUERYSOURCEDATA", param);
        JsonElement dataTypeJE = result.get("dataType");
        if (dataTypeJE != null && "JsonArray".equals(dataType = dataTypeJE.getAsString()) && (data = (dataJE = result.get("data")).getAsJsonArray()).size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                JsonObject dataOBJ = data.get(i).getAsJsonObject();
                String id = dataOBJ.get("value").getAsString();
                dataMap.put("id", id);
                dataMap.put("value", id);
                dataMap.put("name", dataOBJ.get("alias").getAsString());
                resultList.add(dataMap);
            }
        }
        return resultList;
    }

    public static String getQuerySourceDataStr(Context ctx, String query, Map<String, Object> params) throws BOSException, EASBizException {
        JsonElement dataJE;
        JsonArray data;
        String dataType;
        if (null == params) {
            params = new HashMap<String, Object>();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("queryPK", query);
        param.put("cu", false);
        param.put("displayNum", 200);
        param.put("filterItems", params.get("filterItems"));
        param.put("isShowHistory", null == params.get("isShowHistory") ? Boolean.valueOf(false) : params.get("isShowHistory"));
        JsonObject result = SSCTaskAppUtil.operateTaskAll(ctx, "GETQUERYSOURCEDATA", param);
        JsonElement dataTypeJE = result.get("dataType");
        if (dataTypeJE != null && "JsonArray".equals(dataType = dataTypeJE.getAsString()) && (data = (dataJE = result.get("data")).getAsJsonArray()).size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < data.size(); ++i) {
                JsonObject dataOBJ = data.get(i).getAsJsonObject();
                String id = dataOBJ.get("value").getAsString();
                if (data.size() == 1) {
                    return id;
                }
                if (i != data.size() - 1) {
                    sb.append(id);
                    sb.append(",");
                    continue;
                }
                sb.append(id);
            }
            return sb.toString();
        }
        return null;
    }

    public static String getSourceDataStr(Context ctx, String operation, Map<String, Object> params) throws BOSException, EASBizException {
        JsonObject result = SSCTaskAppUtil.operateTaskAll(ctx, operation, params);
        return SSCTaskAppUtil.getResultIds(result);
    }

    private static String getResultIds(JsonObject result) {
        JsonElement dataTypeJE = result.get("dataType");
        if (dataTypeJE != null) {
            String dataType = dataTypeJE.getAsString();
            if ("JsonArray".equals(dataType)) {
                JsonElement dataJE = result.get("data");
                JsonArray data = dataJE.getAsJsonArray();
                if (data.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < data.size(); ++i) {
                        if (null == data.get(i) || !data.get(i).isJsonObject()) {
                            return "";
                        }
                        JsonObject dataOBJ = data.get(i).getAsJsonObject();
                        String id = dataOBJ.get("id").getAsString();
                        if (data.size() == 1) {
                            return id;
                        }
                        if (i != data.size() - 1) {
                            sb.append(id);
                            sb.append(",");
                            continue;
                        }
                        sb.append(id);
                    }
                    return sb.toString();
                }
            } else if ("String".equalsIgnoreCase(dataType)) {
                String data = result.get("data").getAsString();
                return data;
            }
        }
        return null;
    }

    public static String getStrFromList(List list) {
        StringBuffer sb = new StringBuffer();
        if (list == null || list.size() == 0) {
            return "";
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("'");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("'");
        }
        return sb.toString();
    }

    public static String getStrFromListStr(List list) {
        StringBuffer sb = new StringBuffer();
        if (list == null || list.size() == 0) {
            return "";
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append((String)list.get(i));
                continue;
            }
            if (i != size - 1) {
                sb.append((String)list.get(i));
                sb.append(",");
                continue;
            }
            sb.append((String)list.get(i));
        }
        return sb.toString();
    }

    public static List<Map<String, Object>> getSSCQueryData(Context ctx, Map params) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String COMMAND = "GETQUERYDATA";
        params.put("rows", 1);
        params.put("page", 1);
        JsonObject countResult = SSCTaskAppUtil.operateTaskAll(ctx, "GETQUERYDATA", params);
        SSCQueryDataDTO data = (SSCQueryDataDTO)JSON.parseObject((String)countResult.toString(), SSCQueryDataDTO.class);
        int totalCount = data.getTotal();
        int pageCount = totalCount / 8000;
        if (totalCount % 8000 > 0) {
            ++pageCount;
        }
        params.put("rows", 8000);
        for (int i = 0; i < pageCount; ++i) {
            params.put("page", i + 1);
            JsonObject pageResult = SSCTaskAppUtil.operateTaskAll(ctx, "GETQUERYDATA", params);
            if (StringUtils.isEmpty((String)pageResult.toString())) continue;
            SSCQueryDataDTO pageData = (SSCQueryDataDTO)JSON.parseObject((String)pageResult.toString(), SSCQueryDataDTO.class);
            resultList.addAll(pageData.getRows());
        }
        return resultList;
    }

    public static void checkCanDeal(Context ctx, String operation, String jobId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)jobId)) {
            return;
        }
        if (SSCTaskAppConstants.CHECK_STATE_SET.contains(operation.toLowerCase())) {
            String[] jobArray = jobId.split(",");
            for (int i = 0; i < jobArray.length; ++i) {
                JsonObject jobDetailJO = SSCTaskAppUtil.viewJobDetail(ctx, jobArray[i]);
                JsonElement jobPoolingTypeJe = jobDetailJO.get("jobPoolingType");
                JsonElement jobStateJe = jobDetailJO.get("jobState");
                if (jobPoolingTypeJe == null || jobPoolingTypeJe.isJsonNull() || jobStateJe == null || jobStateJe.isJsonNull()) continue;
                JsonElement jobStateValueJe = jobPoolingTypeJe.getAsJsonObject().get("value");
                JsonElement jobStateJeValueJe = jobStateJe.getAsJsonObject().get("value");
                if ("2".equals(jobStateValueJe.getAsString()) && "2".equals(jobStateJeValueJe.getAsString())) continue;
                throw new SSCTaskReultException(SSCTaskReultException.NOT_DEAL);
            }
        }
    }
}

