/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.shareservice.CoJobPoolingType;
import com.kingdee.shr.shareservice.Jobclassification;
import com.kingdee.shr.ssccompensation.app.SubmitTerminalEnum;
import com.kingdee.shr.ssccompensation.app.trace.SubmitBillActivityInfo;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalInfo;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ActivityUtils {
    private static final Logger LOG = Logger.getLogger(ActivityUtils.class);
    private static final String VIEW_WORKFLOW_OSF_SERVICE_NAME = "getJobInfoByBillIdService";
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static List<SubmitBillActivityInfo> getActivityBillInfo(Context ctx, List<String> billIds) throws BOSException {
        List<SubmitBillActivityInfo> coList = ActivityUtils.getCoActivityBillInfo(ctx, billIds);
        List<SubmitBillActivityInfo> sscList = ActivityUtils.getSscActivityBillInfo(ctx, billIds);
        if (!sscList.isEmpty()) {
            coList.addAll(sscList);
        }
        return coList;
    }

    public static List<SubmitBillActivityInfo> getCoActivityBillInfo(Context ctx, List<String> billIds) throws BOSException {
        ArrayList<SubmitBillActivityInfo> list = new ArrayList<SubmitBillActivityInfo>();
        CmpInSql instance = CmpInSqlFactory.getInstance();
        String inCondition = instance.createInSqlBaseOnFId(ctx, billIds);
        String sql = ActivityUtils.getCoActivityQuerySQL(ctx, inCondition);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String operatorId;
                String fJobState;
                SubmitBillActivityInfo activityInfo = new SubmitBillActivityInfo();
                activityInfo.setJobId(rs.getString("jobId"));
                activityInfo.setId(BOSUuid.create((BOSObjectType)activityInfo.getBOSType()));
                String activityId = rs.getString("activityId");
                String activityName = rs.getString("activityName");
                activityInfo.setActivityName(activityName);
                activityInfo.setActivityId(activityId);
                String submitTerminalId = rs.getString("FSubmitTerminalId");
                if (!StringUtils.isEmpty((String)submitTerminalId)) {
                    DistributionSubmitTerminalInfo terminal = new DistributionSubmitTerminalInfo();
                    terminal.setId(BOSUuid.read((String)submitTerminalId));
                    activityInfo.setTerminal(terminal);
                }
                activityInfo.setActivityType(SubmitTerminalEnum.WORKBENCH_COORDINATION);
                String launcher = rs.getString("launcher");
                if (!StringUtils.isEmpty((String)launcher)) {
                    PersonInfo person = new PersonInfo();
                    person.setId(BOSUuid.read((String)launcher));
                    activityInfo.setLauncher(person);
                }
                Date launchDate = rs.getDate("fDistributeDate");
                activityInfo.setLaunchDate((java.util.Date)launchDate);
                String description = rs.getString("description");
                activityInfo.setDescription(description);
                activityInfo.setCompleteDate((java.util.Date)rs.getDate("fCompleteTme"));
                activityInfo.setIsExpired(rs.getBoolean("FIsExpired"));
                activityInfo.setReceiveDate((java.util.Date)rs.getDate("fReceiveTime"));
                String jobPoolingType = rs.getString("fJobPoolingType");
                if (!StringUtils.isEmpty((String)jobPoolingType)) {
                    activityInfo.setJobPoolingType(CoJobPoolingType.getEnum((String)jobPoolingType));
                }
                if (!StringUtils.isEmpty((String)(fJobState = rs.getString("fJobState")))) {
                    activityInfo.setJobState(JobState.getEnum((String)fJobState));
                }
                if (!StringUtils.isEmpty((String)(operatorId = rs.getString("operatorId")))) {
                    UserInfo operator = new UserInfo();
                    operator.setId(BOSUuid.read((String)operatorId));
                    activityInfo.setOperator(operator);
                }
                BatchSubmitShemeBillInfo billInfo = new BatchSubmitShemeBillInfo();
                billInfo.setId(BOSUuid.read((String)rs.getString("fBillId")));
                activityInfo.setSubmitBill(billInfo);
                int jobClassification = rs.getInt("fJobClassification");
                if (jobClassification > 0) {
                    activityInfo.setJobClassification(Jobclassification.getEnum((int)jobClassification));
                }
                list.add(activityInfo);
            }
            ArrayList<SubmitBillActivityInfo> arrayList = list;
            return arrayList;
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e);
        }
        finally {
            instance.release(ctx);
        }
    }

    private static String getCoActivityQuerySQL(Context ctx, String inCondition) {
        String lan = LocaleUtils.getShortCode((Context)ctx);
        return "select job.fBillId, rel.fActivity activityId, job.fJobState, job.fJobPoolingType, billRel.fSubmitTerminalId, usr.fPersonId launcher, job.FCompleteTme, job.fReceiveTime, job.fCreateTime, job.FIsExpired, opr.fUser operatorId, act.fJobClassification , term.fSubmitTerminal, billRel.fDistributeDate, prd.fDescription_" + lan + " description, job.fid jobId, act.fName_" + lan + " activityName  from T_HR_CoActivityJob job  left join T_HR_CoActivityExecutor opr on job.fid = opr.fCoActivity left join T_HR_STerminalSubmitBillRel billRel on job.fBillId = billRel.fSubmitBillId left join T_PM_User usr on billRel.FDistributeUserId = usr.fid left join T_HR_DistributionSubmitTerm term on billRel.fSubmitTerminalId = term.fid left join T_HR_SDistributionPeriod prd on term.fBillId = prd.fid left join T_SHR_ActivityJobInfo rel on job.fid = rel.fJobId left join T_SHR_Activity act on rel.FActivity = act.fid where job.fBillId in " + inCondition;
    }

    public static List<SubmitBillActivityInfo> getSscActivityBillInfo(Context ctx, List<String> billIds) throws BOSException {
        ArrayList<SubmitBillActivityInfo> list = new ArrayList<SubmitBillActivityInfo>();
        CmpInSql instance = CmpInSqlFactory.getInstance();
        String inCondition = instance.createInSqlBaseOnFId(ctx, billIds);
        String sql = "SELECT bill.fid billId, bill.FProposerID, bill.FSubmitTime, bill.fDescription, term.fid termId, rel.FDistributeDate, psn.fid personId  from T_HR_SBatchSubmitShemeBill bill  left join T_HR_STerminalSubmitBillRel rel on bill.fid = rel.FSubmitBillID  left join T_PM_User usr on rel.FDistributeUserId = usr.fid  left join T_BD_Person psn on usr.FPersonId = psn.fid  left join T_HR_DistributionSubmitTerm term on rel.FSubmitTerminalID = term.fid  where bill.fid in " + inCondition;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.size() == 0) {
                ArrayList<SubmitBillActivityInfo> arrayList = list;
                return arrayList;
            }
            String language = LocaleUtils.getShortCode((Context)ctx);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("selector", ActivityUtils.getSscFieldSelector());
            param.put("type", "3");
            while (rs.next()) {
                String billId = rs.getString("billId");
                param.put("billId", billId);
                Object result = OSFExecutor.executeOSF((Context)ctx, param, (String)VIEW_WORKFLOW_OSF_SERVICE_NAME);
                JsonObject jsonObject = (JsonObject)result;
                if (null == jsonObject) continue;
                LOG.debug((Object)("getJobInfoByBillIdService result for [" + billId + "]" + jsonObject.toString()));
                JsonArray jsonArray = (JsonArray)jsonObject.get("data");
                if (null == jsonArray || jsonArray.isJsonNull()) continue;
                for (int j = 0; j < jsonArray.size(); ++j) {
                    String terminalId;
                    JsonElement jobId;
                    JsonElement jobState;
                    JsonElement receiveTime;
                    JsonElement jobPoolingType;
                    JsonElement isExpired;
                    Date distributeDate;
                    JsonObject row = (JsonObject)jsonArray.get(j);
                    SubmitBillActivityInfo activityInfo = new SubmitBillActivityInfo();
                    activityInfo.setId(BOSUuid.create((BOSObjectType)activityInfo.getBOSType()));
                    BatchSubmitShemeBillInfo billInfo = new BatchSubmitShemeBillInfo();
                    billInfo.setId(BOSUuid.read((String)billId));
                    activityInfo.setSubmitBill(billInfo);
                    PersonInfo person = new PersonInfo();
                    String proposerId = rs.getString("FProposerID");
                    String personId = rs.getString("personId");
                    if (!StringUtils.isEmpty((String)proposerId)) {
                        person.setId(BOSUuid.read((String)proposerId));
                    } else if (!StringUtils.isEmpty((String)personId)) {
                        person.setId(BOSUuid.read((String)personId));
                    }
                    activityInfo.setLauncher(person);
                    JsonElement sscActivityId = ActivityUtils.getJsonObjectValue(row, "bussAttrID.id");
                    if (ActivityUtils.isNotNull(sscActivityId)) {
                        activityInfo.setActivityId(sscActivityId.getAsString());
                    }
                    if (null == (distributeDate = rs.getDate("FDistributeDate"))) {
                        distributeDate = rs.getDate("FSubmitTime");
                    }
                    activityInfo.setLaunchDate((java.util.Date)distributeDate);
                    JsonElement sscActivity = ActivityUtils.getJsonObjectValue(row, "bussAttrID.name." + language);
                    if (ActivityUtils.isNotNull(sscActivity)) {
                        activityInfo.setActivityName(sscActivity.getAsString());
                    }
                    activityInfo.setIsExpired((isExpired = ActivityUtils.getJsonObjectValue(row, "isExpired")) != null && isExpired.getAsBoolean());
                    JsonElement completeTme = ActivityUtils.getJsonObjectValue(row, "completeTme");
                    if (ActivityUtils.isNotNull(completeTme)) {
                        activityInfo.setCompleteDate(CmpDateUtil.parseDate((String)completeTme.getAsString(), (DateFormat)DF));
                    }
                    if (ActivityUtils.isNotNull(jobPoolingType = ActivityUtils.getJsonObjectValue(row, "jobPoolingType.value"))) {
                        activityInfo.setJobPoolingType(CoJobPoolingType.getEnum((String)jobPoolingType.getAsString()));
                    }
                    activityInfo.setActivityType(SubmitTerminalEnum.WORKBENCH_TASK);
                    JsonElement userId = ActivityUtils.getJsonObjectValue(row, "personnelID.easUserId");
                    if (ActivityUtils.isNotNull(userId)) {
                        UserInfo operator = new UserInfo();
                        operator.setId(BOSUuid.read((String)userId.getAsString()));
                        activityInfo.setOperator(operator);
                    }
                    if (ActivityUtils.isNotNull(receiveTime = ActivityUtils.getJsonObjectValue(row, "receiveTime"))) {
                        activityInfo.setReceiveDate(CmpDateUtil.parseDate((String)receiveTime.getAsString(), (DateFormat)DF));
                    }
                    activityInfo.setDescription(rs.getString("fDescription"));
                    JsonElement jobClassification = ActivityUtils.getJsonObjectValue(row, "bussAttrID.jobClassification.value");
                    if (ActivityUtils.isNotNull(jobClassification)) {
                        activityInfo.setJobClassification(Jobclassification.getEnum((int)jobClassification.getAsInt()));
                    }
                    if (ActivityUtils.isNotNull(jobState = ActivityUtils.getJsonObjectValue(row, "jobState.value"))) {
                        activityInfo.setJobState(JobState.getEnum((String)jobState.getAsString()));
                    }
                    if (ActivityUtils.isNotNull(jobId = ActivityUtils.getJsonObjectValue(row, "id"))) {
                        activityInfo.setJobId(jobId.getAsString());
                    }
                    if (!StringUtils.isEmpty((String)(terminalId = rs.getString("termId")))) {
                        DistributionSubmitTerminalInfo terminalInfo = new DistributionSubmitTerminalInfo();
                        terminalInfo.setId(BOSUuid.read((String)terminalId));
                        activityInfo.setTerminal(terminalInfo);
                    }
                    list.add(activityInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            instance.release(ctx);
        }
        return list;
    }

    private static boolean isNotNull(JsonElement element) {
        return null != element && !element.isJsonNull();
    }

    private static JsonElement getJsonObjectValue(JsonObject jsonObject, String key) {
        if (!key.contains(".")) {
            return jsonObject.get(key);
        }
        String first = key.substring(0, key.indexOf("."));
        String remain = key.substring(key.indexOf(".") + 1);
        JsonElement element = jsonObject.get(first);
        if (null == element || element.isJsonNull()) {
            return element;
        }
        return ActivityUtils.getJsonObjectValue((JsonObject)element, remain);
    }

    private static String getSscFieldSelector() {
        return "id, personnelID.easUserId, bussAttrID.name, bussAttrID.id, bussAttrID.jobClassification, jobPoolingType, jobState, completeTme, isExpired, receiveTime";
    }
}

