/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.AdvanceFilterService;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.ssccompensation.app.distributionRule.DistributionRuleInfo;
import com.kingdee.shr.ssccompensation.app.distributionRule.RangeConfigEntryCollection;
import com.kingdee.shr.ssccompensation.app.distributionRule.RangeConfigEntryFactory;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalCollection;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalFactory;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodFactory;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodInfo;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalCollection;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalFactory;
import com.kingdee.shr.ssccompensation.utils.CmpSscUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class SubmitEmployeeRangeHelper {
    public static final String RULE = "rule";
    public static final String PERIOD = "period";

    public static RangeConfigEntryCollection getRangeConfig(Context ctx, String distributionRuleId) throws BOSException {
        String oql = "";
        if (!StringUtils.isEmpty((String)distributionRuleId)) {
            oql = "select *, submitElementCollection.*, submitElementCollection.submitElement.* where distributionRule.id = " + CmpSscUtil.toSqlId(distributionRuleId);
            return RangeConfigEntryFactory.getLocalInstance((Context)ctx).getRangeConfigEntryCollection(oql);
        }
        return null;
    }

    public static List<CoreBaseInfo> getAdminList(Context ctx, String id, String adminOrgId, String type) throws BOSException {
        ArrayList coll;
        block3: {
            block2: {
                coll = Lists.newArrayList();
                if (!RULE.equals(type)) break block2;
                SubmitAdminOrgAndTerminalCollection submitAdminByRule = SubmitEmployeeRangeHelper.getSubmitAdminByRule(ctx, id, adminOrgId);
                for (int i = 0; i < submitAdminByRule.size(); ++i) {
                    coll.add(submitAdminByRule.get(i));
                }
                break block3;
            }
            if (!PERIOD.equals(type)) break block3;
            DistributionSubmitTerminalCollection submitAdminByPeriod = SubmitEmployeeRangeHelper.getSubmitAdminByPeriod(ctx, id);
            for (int i = 0; i < submitAdminByPeriod.size(); ++i) {
                coll.add(submitAdminByPeriod.get(i));
            }
        }
        return coll;
    }

    public static SubmitAdminOrgAndTerminalCollection getSubmitAdminByRule(Context ctx, String distributionRuleId, String adminOrgId) throws BOSException {
        String oql = "select adminOrgUnit.id, isDownward where bill.distributionRule.id = '" + distributionRuleId + "' and adminOrgUnit.id = '" + adminOrgId + "'";
        return SubmitAdminOrgAndTerminalFactory.getLocalInstance((Context)ctx).getSubmitAdminOrgAndTerminalCollection(oql);
    }

    public static DistributionSubmitTerminalCollection getSubmitAdminByPeriod(Context ctx, String distributionPeriodId) throws BOSException {
        String oql = "select adminOrgUnit.id, isDownward where bill.id = " + CmpSscUtil.toSqlId(distributionPeriodId);
        return DistributionSubmitTerminalFactory.getLocalInstance((Context)ctx).getDistributionSubmitTerminalCollection(oql);
    }

    public static String getConfigFilter(Context ctx, String filter, String adminFilter, String hrOrgFilter) throws BOSException {
        JSONObject object;
        String advanceStr;
        AdvanceFilterService advanceFilterService = new AdvanceFilterService(ctx);
        FilterInfo advanceFilter = new FilterInfo();
        if (!StringUtils.isEmpty((String)filter) && !StringUtils.isEmpty((String)(advanceStr = (object = JSONObject.parseObject((String)filter)).getString("advancedFilter")))) {
            advanceFilter = advanceFilterService.parse(advanceStr);
        }
        FilterInfo customFilter = new FilterInfo();
        customFilter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)adminFilter, CompareType.INNER));
        customFilter.mergeFilter(advanceFilter, "AND");
        FilterInfo hrFilter = new FilterInfo();
        hrFilter.getFilterItems().add(new FilterItemInfo("cmpHROrgUnit.id", (Object)hrOrgFilter, CompareType.EQUALS));
        customFilter.mergeFilter(hrFilter, "AND");
        try {
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put("cmpEmpORelation.id", "fid");
            selectMapping.put("adminOrgUnit.id", "adminOrgId");
            selectMapping.put("position.id", "positionId");
            selectMapping.put("person.id", "personId");
            selectMapping.put("empOrgRelation.assignType", "assignType");
            selectMapping.put("cmpEmpORelation.effectDate", "effectDate");
            selectMapping.put("cmpEmpORelation.leffectDate", "leffectDate");
            SqlParam sqlParam = new SqlParam();
            sqlParam.setSelectMapping(selectMapping);
            sqlParam.setFilterInfo(customFilter);
            sqlParam.setScheme("006_SSC");
            sqlParam.setHistoryMode(true);
            sqlParam.setNeedDistinct(Boolean.TRUE.booleanValue());
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            String tempTable = SQLHandleUtil.createTempTableName((Context)ctx);
            String creatTable = "select * into " + tempTable + " from ( " + sql + " ) t where 1=1 ";
            DbUtil.execute((Context)ctx, (String)creatTable);
            return tempTable;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static DistributionRuleInfo getRuleByDistributionPeriod(Context ctx, String distributionPeriodId) throws BOSException {
        String oql = "select distributionRule.* where id = " + CmpSscUtil.toSqlId(distributionPeriodId);
        try {
            DistributionPeriodInfo info = DistributionPeriodFactory.getLocalInstance((Context)ctx).getDistributionPeriodInfo(oql);
            return info != null ? info.getDistributionRule() : null;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getParent2Children(Context ctx, List<CoreBaseInfo> adminList) throws BOSException {
        CmpInSql instance = CmpInSqlFactory.getInstance();
        ArrayList subList = Lists.newArrayList();
        ArrayList ownList = Lists.newArrayList();
        for (int i = 0; i < adminList.size(); ++i) {
            CoreBaseInfo coreBaseInfo = adminList.get(i);
            boolean isDownward = coreBaseInfo.getBoolean("isDownward");
            AdminOrgUnitInfo objectValue = (AdminOrgUnitInfo)coreBaseInfo.getObjectValue("adminOrgUnit");
            if (isDownward) {
                subList.add(objectValue.getId().toString());
                continue;
            }
            ownList.add(objectValue.getId().toString());
        }
        String sqlIds = instance.createInSqlBaseOnFId(ctx, (Collection)subList);
        String sql = " SELECT parent.FID FParentId, child.FID FID  FROM t_org_admin parent inner join t_org_admin child on (charindex(concat(parent.flongnumber,'!'),child.flongnumber) > 0 or parent.flongnumber = child.flongnumber)  where parent.fid in " + sqlIds;
        String tempTableName = "";
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            String creatTableSql = String.format("SELECT FParentId, FID INTO %s FROM %s WHERE 1<>1", tempTableName, "T_Org_Admin");
            DbUtil.execute((Context)ctx, (String)creatTableSql);
            String insertSql = "insert into " + tempTableName + " values (?, ?)";
            ArrayList params = Lists.newArrayList();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                Object[] object = new Object[]{rs.getString("FParentId"), rs.getString("FID")};
                params.add(object);
            }
            ownList.stream().forEach(a -> params.add(new Object[]{a, a}));
            DbUtil.executeBatch((Context)ctx, (String)insertSql, (List)params);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            instance.release(ctx);
        }
        return tempTableName;
    }
}

