/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service.classloader;

import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ComponentLibScanHelper {
    private final Logger logger = Logger.getLogger(ComponentLibScanHelper.class);
    String seperateChar = ";";

    public void deleteOneCompoent(String componentName) {
        File path = new File(this.getLocalPath());
        if (!path.exists()) {
            this.logger.debug((Object)("component not exists -- ----------" + path.getName()));
        } else {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) continue;
                files[i].delete();
            }
        }
    }

    public String scan() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDevelopClassPath());
        String path = this.getLocalPath();
        String customerPath = path + this.getCustomAppPath();
        String customerLibPath = this.scanComponents(customerPath);
        sb.append(customerLibPath);
        String addonLibPath = this.scanComponents(path);
        sb.append(this.removeCustomerLib(addonLibPath, customerLibPath));
        return sb.toString();
    }

    private String removeCustomerLib(String addonLibPath, String customerLibPath) {
        if (StringUtils.isEmpty((String)customerLibPath)) {
            return addonLibPath;
        }
        String[] libs = customerLibPath.split(this.seperateChar);
        String lib2 = null;
        int index = -1;
        for (String lib2 : libs) {
            index = addonLibPath.indexOf(lib2);
            if (index == -1) continue;
            addonLibPath = addonLibPath.substring(0, index) + addonLibPath.substring(index + lib2.length() + 1);
        }
        return addonLibPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDevelopClassPath() {
        File file;
        String developMode = System.getProperty("DEVELOP_MODE");
        String addonUserLiblist = FilenameUtils.normalize((String)System.getProperty("addon.user.liblist"));
        StringBuilder sb = new StringBuilder();
        if ("true".equalsIgnoreCase(developMode) && !StringUtils.isEmpty((String)addonUserLiblist) && (file = new File(addonUserLiblist)).exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file.getCanonicalFile()));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append(this.seperateChar);
                }
            }
            catch (FileNotFoundException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return sb.toString();
    }

    public String scanComponents(String servicePath) {
        StringBuilder metaPath = new StringBuilder();
        this.logger.debug((Object)("begin scan components -- ----------" + servicePath));
        File path = new File(servicePath);
        if (!path.exists()) {
            this.logger.debug((Object)("path not exists -- ----------" + path.getName()));
            return metaPath.toString();
        }
        File[] files = path.listFiles();
        if (files == null || files.length == 0) {
            return metaPath.toString();
        }
        File file = null;
        String libPath = null;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            if (file.isDirectory()) {
                libPath = this.scanComponents(file.getAbsolutePath());
                if (StringUtils.isEmpty((String)libPath)) continue;
                metaPath.append(libPath);
                continue;
            }
            if (!this.isJarFile(file.getName())) continue;
            libPath = file.getAbsolutePath();
            metaPath.append(libPath);
            metaPath.append(this.seperateChar);
        }
        return metaPath.toString();
    }

    private boolean isJarFile(String filename) {
        return filename.endsWith(".zip") || filename.endsWith(".jar");
    }

    private String getLocalPath() {
        this.logger.debug((Object)("[CL_WARN]  EAS_HOME = [" + System.getProperty("EAS_HOME")));
        return FilenameUtils.normalize((String)System.getProperty("EAS_HOME")) + "/server/lib/addon";
    }

    private String getCustomAppPath() {
        return FilenameUtils.normalize((String)System.getProperty("EAS_HOME")) + File.separator + "server" + File.separator + "lib" + File.separator + "sp" + File.separator + "addon";
    }
}

