/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.HRMenuItemCollection;
import com.kingdee.shr.base.syssetting.HRMenuItemFactory;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;

public class HRMenuPermHelper {
    public static final String ALL_MENU_COLLECTION = "allMenuCollection";
    public static final String ALL_SERVICE_COLLECTION = "allServiceCollection";
    private static CustomCacheService menuCustomCache = new CustomCacheService("shr.all_menu");

    public static CustomCacheService getMenuCustomCache() {
        return menuCustomCache;
    }

    private static String getKey(Context ctx, String key) {
        return MessageFormat.format("{0}_{1}", ctx.getLocale().toString(), key);
    }

    public static HRMenuItemCollection getAllMenu(Context ctx) throws BOSException, EASBizException {
        String key = HRMenuPermHelper.getKey(ctx, ALL_MENU_COLLECTION);
        Object obj = menuCustomCache.get(key);
        HRMenuItemCollection collection = null;
        if (obj == null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("longNumber"));
            entityViewInfo.setSorter(sorter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("isLeaf"));
            selector.add(new SelectorItemInfo("model"));
            selector.add(new SelectorItemInfo("type"));
            selector.add(new SelectorItemInfo("parent.id"));
            selector.add(new SelectorItemInfo("url"));
            selector.add(new SelectorItemInfo("uri"));
            selector.add(new SelectorItemInfo("service"));
            selector.add(new SelectorItemInfo("permItem.id"));
            selector.add(new SelectorItemInfo("longNumber"));
            selector.add(new SelectorItemInfo("index"));
            entityViewInfo.setSelector(selector);
            collection = HRMenuItemFactory.getLocalInstance(ctx).getHRMenuItemCollection(entityViewInfo);
            menuCustomCache.put(key, (Object)collection);
        } else {
            collection = (HRMenuItemCollection)((Object)obj);
        }
        return collection;
    }

    public static HashSet<String> getUserPermItemIdSetByMenu(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        String permissionSql = iPerm.getFunctionPermissionsByMenu();
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT FPermItemID FROM T_BD_HRMenuItem").append(" where FPermItemID in (").append(permissionSql).append(") ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        HashSet<String> permIdSet = new HashSet<String>();
        try {
            while (rows.next()) {
                permIdSet.add(rows.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return permIdSet;
    }

    public static HashSet<String> getUserPermItemIdByService(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        String permissionSql = iPerm.getFunctionPermissionsByMenu();
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT fpermissionid FROM t_bs_service").append(" where fpermissionid in (").append(permissionSql).append(") ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        HashSet<String> permIdSet = new HashSet<String>();
        try {
            while (rows.next()) {
                permIdSet.add(rows.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return permIdSet;
    }

    public static void removeMenuCache(Context ctx, String cacheName) {
        if (StringUtils.isEmpty((String)cacheName)) {
            menuCustomCache.remove(HRMenuPermHelper.getKey(ctx, ALL_MENU_COLLECTION));
        } else {
            menuCustomCache.remove(cacheName);
        }
        try {
            MenuCacheFactory.getLocalInstance((Context)ctx).updateAllMenuCache();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void removeServiceCache(Context ctx, String cacheName) {
        try {
            MenuCacheFactory.getLocalInstance((Context)ctx).updateAllMenuCache();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

