/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.api.logSearch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.PrivacyInformationInLogFactory;
import com.kingdee.shr.base.syssetting.PrivacyInformationInLogInfo;
import com.kingdee.shr.base.syssetting.api.file.IMultiEngineExcutor;
import com.kingdee.shr.base.syssetting.api.logSearch.RuleEngineer;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LogSearcher
extends ORMObject
implements IMultiEngineExcutor {
    private static Logger logger = Logger.getLogger(LogSearcher.class);

    @Override
    public void excute(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        File[] files;
        String sourceDir = SHRSyssettingUtil.getLogsPath(SHRSyssettingUtil.getCurrentLoginServer());
        String targetDir = sourceDir.replace("logs", "logsBak");
        String batchNumber = (String)param.get("batchNumber");
        String url = (String)param.get("url");
        File source = new File(sourceDir);
        File target = new File(targetDir);
        if (!source.exists()) {
            logger.error((Object)"Source dir is not exist !");
            return;
        }
        if (!target.exists()) {
            target.mkdir();
        }
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (File file : files = source.listFiles()) {
            String targetFileName;
            List<Map<String, String>> fileRows;
            String fileName = file.getName();
            if (!file.isFile() || !fileName.contains("apusic") || !"log".equals(fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase(Locale.ENGLISH)) || (fileRows = RuleEngineer.match(file, targetFileName = this.getTargetFilePath(targetDir, file.getName(), batchNumber))).isEmpty()) continue;
            rows.addAll(fileRows);
            this.copy(file, targetFileName);
        }
        this.saveBatchData(ctx, rows, batchNumber, url);
    }

    private void saveBatchData(Context ctx, List<Map<String, String>> rows, String batchNumber, String url) throws BOSException, EASBizException {
        CoreBaseCollection colls = new CoreBaseCollection();
        String serverName = SHRSyssettingUtil.getCurrentLoginServer();
        for (Map<String, String> map : rows) {
            PrivacyInformationInLogInfo privacyInformationInLogInfo = new PrivacyInformationInLogInfo();
            privacyInformationInLogInfo.setBatchNumber(batchNumber);
            privacyInformationInLogInfo.setLogPath(map.get("logPath"));
            privacyInformationInLogInfo.setLogLine(map.get("logLine"));
            privacyInformationInLogInfo.setMatchInfo(map.get("matchInfo"));
            privacyInformationInLogInfo.setServerName(MessageFormat.format("{0}_{1}", url, serverName));
            privacyInformationInLogInfo.setIsFixed(false);
            privacyInformationInLogInfo.setCreateTime(this.getTime());
            privacyInformationInLogInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            privacyInformationInLogInfo.setLastUpdateTime(this.getTime());
            privacyInformationInLogInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            privacyInformationInLogInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            colls.add((CoreBaseInfo)privacyInformationInLogInfo);
        }
        PrivacyInformationInLogFactory.getLocalInstance(ctx).saveBatchData(colls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copy(File file, String targetFileName) {
        File targetFile = new File(targetFileName);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            fos = new FileOutputStream(targetFile);
            bos = new BufferedOutputStream(fos);
            byte[] buffer = new byte[8192];
            int len = 0;
            while ((len = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, len);
            }
            ((BufferedOutputStream)bos).flush();
            if (logger.isDebugEnabled()) {
                logger.error((Object)("file copy success \uff1a" + file.getName()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return targetFile;
    }

    private String getTargetFilePath(String targetDir, String fileName, String batchNumber) {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(targetDir).append(File.separator).append(batchNumber).append("_").append(this.getTimeStamp()).append("_").append(fileName);
        return sBuffer.toString();
    }

    private String getTimeStamp() {
        return new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

