/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.InterpreterException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveBoolean;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveByte;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveCharacter;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveDouble;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveFloat;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveInt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveLong;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveNumber;
import com.kingdee.shr.base.syssetting.fieldrule.formula.runtime.PrimitiveShort;
import com.kingdee.util.Null;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeUtils {
    static BigInteger BYTE_MAX = new BigInteger(Byte.toString((byte)127));
    static BigInteger BYTE_MIN = new BigInteger(Byte.toString((byte)-128));
    static BigInteger SHORT_MAX = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    static BigInteger SHORT_MIN = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    static BigInteger INT_MAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    static BigInteger INT_MIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    static BigInteger LONG_MAX = new BigInteger(Long.toString(Long.MAX_VALUE));
    static BigInteger LONG_MIN = new BigInteger(Long.toString(Long.MIN_VALUE));
    static BigDecimal FLOAT_MAX = BigDecimal.valueOf(3.4028234663852886E38);
    static BigDecimal FLOAT_MIN = BigDecimal.valueOf(1.4E-45f);
    static BigDecimal DOUBLE_MAX = BigDecimal.valueOf(Double.MAX_VALUE);
    static BigDecimal DOUBLE_MIN = BigDecimal.valueOf(Double.MIN_VALUE);
    private static final Set<String> notFoundClasses = Collections.synchronizedSet(new HashSet());

    private TypeUtils() {
    }

    public static Object castNumber(Class<?> c, BigInteger num) {
        if (c.equals(Byte.class)) {
            if (num.compareTo(BYTE_MAX) <= 0 && num.compareTo(BYTE_MIN) >= 0) {
                return num.byteValue();
            }
            if (num.compareTo(SHORT_MAX) <= 0 && num.compareTo(SHORT_MAX) >= 0) {
                return num.shortValue();
            }
            if (num.compareTo(INT_MAX) <= 0 && num.compareTo(INT_MIN) >= 0) {
                return num.intValue();
            }
            if (num.compareTo(LONG_MAX) <= 0 && num.compareTo(LONG_MIN) >= 0) {
                return (long)num.intValue();
            }
        }
        if (c.equals(Short.TYPE) || c.equals(PrimitiveByte.class)) {
            if (num.compareTo(BYTE_MAX) <= 0 && num.compareTo(BYTE_MIN) >= 0) {
                return new PrimitiveByte(num.byteValue());
            }
            if (num.compareTo(SHORT_MAX) <= 0 && num.compareTo(SHORT_MAX) >= 0) {
                return new PrimitiveShort(num.shortValue());
            }
            if (num.compareTo(INT_MAX) <= 0 && num.compareTo(INT_MIN) >= 0) {
                return new PrimitiveInt(num.intValue());
            }
            if (num.compareTo(LONG_MAX) <= 0 && num.compareTo(LONG_MIN) >= 0) {
                return new PrimitiveLong(num.intValue());
            }
        }
        if (c.equals(Short.class)) {
            if (num.compareTo(SHORT_MAX) <= 0 && num.compareTo(SHORT_MAX) >= 0) {
                return num.shortValue();
            }
            if (num.compareTo(INT_MAX) <= 0 && num.compareTo(INT_MIN) >= 0) {
                return num.intValue();
            }
            if (num.compareTo(LONG_MAX) <= 0 && num.compareTo(LONG_MIN) >= 0) {
                return (long)num.intValue();
            }
        }
        if (c.equals(Short.TYPE) || c.equals(PrimitiveShort.class)) {
            if (num.compareTo(SHORT_MAX) <= 0 && num.compareTo(SHORT_MAX) >= 0) {
                return new PrimitiveShort(num.shortValue());
            }
            if (num.compareTo(INT_MAX) <= 0 && num.compareTo(INT_MIN) >= 0) {
                return new PrimitiveInt(num.intValue());
            }
            if (num.compareTo(LONG_MAX) <= 0 && num.compareTo(LONG_MIN) >= 0) {
                return new PrimitiveLong(num.intValue());
            }
        }
        if (c.equals(Integer.class)) {
            if (num.compareTo(INT_MAX) <= 0 && num.compareTo(INT_MIN) >= 0) {
                return num.intValue();
            }
            if (num.compareTo(LONG_MAX) <= 0 && num.compareTo(LONG_MIN) >= 0) {
                return (long)num.intValue();
            }
        }
        if (c.equals(Integer.TYPE) || c.equals(PrimitiveInt.class)) {
            if (num.compareTo(INT_MAX) <= 0 && num.compareTo(INT_MIN) >= 0) {
                return new PrimitiveInt(num.intValue());
            }
            if (num.compareTo(LONG_MAX) <= 0 && num.compareTo(LONG_MIN) >= 0) {
                return new PrimitiveLong(num.intValue());
            }
        }
        if (c.equals(Long.class) && num.compareTo(LONG_MAX) <= 0 && num.compareTo(LONG_MIN) >= 0) {
            return (long)num.intValue();
        }
        if ((c.equals(Long.TYPE) || c.equals(PrimitiveLong.class)) && num.compareTo(LONG_MAX) <= 0 && num.compareTo(LONG_MIN) >= 0) {
            return new PrimitiveLong(num.intValue());
        }
        return num;
    }

    public static Object castNumber(Class<?> c, BigDecimal num) {
        if (c.equals(Byte.TYPE) || c.equals(Short.TYPE) || c.equals(Integer.TYPE) || c.equals(Long.TYPE) || c.equals(PrimitiveByte.class) || c.equals(PrimitiveShort.class) || c.equals(PrimitiveInt.class) || c.equals(PrimitiveLong.class) || c.equals(Byte.class) || c.equals(Short.class) || c.equals(Integer.class) || c.equals(Long.class) || c.equals(BigInteger.class)) {
            BigDecimal unscaleValue = new BigDecimal(num.toBigInteger());
            if (num.compareTo(unscaleValue) == 0) {
                return TypeUtils.castNumber(c, num.toBigInteger());
            }
            if (c.equals(Byte.TYPE) || c.equals(Short.TYPE) || c.equals(Integer.TYPE) || c.equals(Long.TYPE) || c.equals(PrimitiveByte.class) || c.equals(PrimitiveShort.class) || c.equals(PrimitiveInt.class) || c.equals(PrimitiveLong.class)) {
                c = Float.TYPE;
            } else if (c.equals(Byte.class) || c.equals(Short.class) || c.equals(Integer.class) || c.equals(Long.class)) {
                c = Float.class;
            }
        }
        if (c.equals(Float.class)) {
            if (num.compareTo(FLOAT_MAX) <= 0 && num.compareTo(FLOAT_MIN) >= 0 && num.scale() <= 7) {
                return Float.valueOf(num.floatValue());
            }
            if (num.compareTo(DOUBLE_MAX) <= 0 && num.compareTo(DOUBLE_MIN) >= 0 && num.scale() <= 16) {
                return num.doubleValue();
            }
        }
        if (c.equals(Float.TYPE) || c.equals(PrimitiveFloat.class)) {
            if (num.compareTo(FLOAT_MAX) <= 0 && num.compareTo(FLOAT_MIN) >= 0 && num.scale() <= 7) {
                return Float.valueOf(num.floatValue());
            }
            if (num.compareTo(DOUBLE_MAX) <= 0 && num.compareTo(DOUBLE_MIN) >= 0 && num.scale() <= 16) {
                return num.doubleValue();
            }
        }
        if (c.equals(Double.class) && num.compareTo(DOUBLE_MAX) <= 0 && num.compareTo(DOUBLE_MIN) >= 0 && num.scale() <= 16) {
            return num.doubleValue();
        }
        if ((c.equals(Double.TYPE) || c.equals(PrimitiveDouble.class)) && num.compareTo(DOUBLE_MAX) <= 0 && num.compareTo(DOUBLE_MIN) >= 0 && num.scale() <= 16) {
            return num.doubleValue();
        }
        return num;
    }

    public static Field findField(Class<?> c, String fieldName) {
        Field[] fieldArray = c.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equals(fieldName) || !Modifier.isPublic(fieldArray[i].getModifiers())) continue;
            return fieldArray[i];
        }
        return null;
    }

    public static Class<?> classForName(List<String> namespaces, Map<String, Object> classMap, String className) {
        int i;
        String componentTypeName;
        if (classMap.containsKey(className)) {
            Object clazz = classMap.get(className);
            if (clazz == Null.NULL) {
                return null;
            }
            return (Class)clazz;
        }
        Class<?> type = null;
        StringBuffer arrayBuff = new StringBuffer();
        if (className.startsWith("[")) {
            StringBuffer componentTypeNameBuff = new StringBuffer();
            for (int i2 = 0; i2 < className.length(); ++i2) {
                char ch = className.charAt(i2);
                if (ch == '[') {
                    char next_char;
                    arrayBuff.append('[');
                    if (i2 >= className.length() - 1 || (next_char = className.charAt(i2 + 1)) != 'L') continue;
                    arrayBuff.append('L');
                    ++i2;
                    continue;
                }
                componentTypeNameBuff.append(ch);
            }
            componentTypeName = componentTypeNameBuff.toString();
        } else {
            componentTypeName = className;
        }
        String arrayPrix = arrayBuff.toString();
        if (className.indexOf(46) == -1) {
            for (i = 0; i < namespaces.size(); ++i) {
                String fullName = arrayPrix + namespaces.get(i) + "." + componentTypeName;
                type = TypeUtils.classForName(fullName);
                if (type != null) {
                    classMap.put(className, type);
                } else {
                    fullName = arrayPrix + namespaces.get(i) + "$" + componentTypeName;
                    type = TypeUtils.classForName(fullName);
                    if (type == null) continue;
                    classMap.put(className, type);
                }
                break;
            }
        } else {
            String fullName = arrayPrix + componentTypeName;
            type = TypeUtils.classForName(fullName);
            if (type != null) {
                classMap.put(className, type);
            } else {
                for (i = 0; i < namespaces.size(); ++i) {
                    fullName = arrayPrix + namespaces.get(i) + "." + componentTypeName;
                    type = TypeUtils.classForName(fullName);
                    if (type != null) {
                        classMap.put(className, type);
                    } else {
                        fullName = arrayPrix + namespaces.get(i) + "&" + componentTypeName;
                        type = TypeUtils.classForName(fullName);
                        if (type == null) continue;
                        classMap.put(className, type);
                    }
                    break;
                }
            }
        }
        if (type == null) {
            classMap.put(className, Null.NULL);
        }
        return type;
    }

    private static Class<?> classForName(String className) {
        if (notFoundClasses.contains(className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            notFoundClasses.add(className);
            return null;
        }
    }

    public static Object leftShift(Object leftVal, Object rightVal) throws InterpreterException {
        if (leftVal instanceof BigInteger || rightVal instanceof BigInteger) {
            throw (InterpreterException)new InterpreterException("the operator '<<' only for integer.").setInfoId("SHIFT_OP_ERROR").addArg(">>").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return new PrimitiveInt(((Number)leftVal).intValue() << ((Number)rightVal).intValue());
        }
        throw (InterpreterException)new InterpreterException("the operator '<<' only for integer.").setInfoId("SHIFT_OP_ERROR").addArg(">>").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
    }

    public static Object rightShift(Object leftVal, Object rightVal) throws InterpreterException {
        if (leftVal instanceof BigInteger || rightVal instanceof BigInteger) {
            throw (InterpreterException)new InterpreterException("not support '>>' with BigInteger").setInfoId("SHIFT_OP_ERROR").addArg(">>").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return new PrimitiveInt(((Number)leftVal).intValue() >> ((Number)rightVal).intValue());
        }
        throw (InterpreterException)new InterpreterException("the operator '>>' only for integer.").setInfoId("SHIFT_OP_ERROR").addArg(">>").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
    }

    public static Object rightUnsignShift(Object leftVal, Object rightVal) throws InterpreterException {
        if (leftVal instanceof BigInteger || rightVal instanceof BigInteger) {
            throw (InterpreterException)new InterpreterException("the operator '>>>' only for integer.").setInfoId("SHIFT_OP_ERROR").addArg(">>>").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return new PrimitiveInt(((Number)leftVal).intValue() >>> ((Number)rightVal).intValue());
        }
        throw (InterpreterException)new InterpreterException("the operator '>>>' only for integer.").setInfoId("SHIFT_OP_ERROR").addArg(">>>").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
    }

    public static Object bitwiseAnd(Object leftVal, Object rightVal) throws InterpreterException {
        if (leftVal instanceof BigInteger || rightVal instanceof BigInteger) {
            throw (InterpreterException)new InterpreterException("not support '&' with Big Integer.").setInfoId("bitwise_OP_ERROR").addArg("&").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return new PrimitiveInt(((Number)leftVal).intValue() & ((Number)rightVal).intValue());
        }
        if (leftVal instanceof Set && rightVal instanceof Set) {
            Set leftSet = (Set)leftVal;
            Set rightSet = (Set)rightVal;
            HashSet rtnSet = new HashSet();
            for (Object item : leftSet) {
                if (!rightSet.contains(item)) continue;
                rtnSet.add(item);
            }
            return rtnSet;
        }
        throw (InterpreterException)new InterpreterException("the operator '&' only for integer.").setInfoId("bitwise_OP_ERROR").addArg("&").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
    }

    public static Object bitwiseOr(Object leftVal, Object rightVal) throws InterpreterException {
        if (leftVal instanceof BigInteger || rightVal instanceof BigInteger) {
            throw (InterpreterException)new InterpreterException("not support '|' with Big Integer value").setInfoId("bitwise_OP_ERROR").addArg("|").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return new PrimitiveInt(((Number)leftVal).intValue() | ((Number)rightVal).intValue());
        }
        if (leftVal instanceof Set && rightVal instanceof Set) {
            Set leftSet = (Set)leftVal;
            Set rightSet = (Set)rightVal;
            HashSet rtnSet = new HashSet();
            rtnSet.addAll(leftSet);
            rtnSet.addAll(rightSet);
            return rtnSet;
        }
        throw (InterpreterException)new InterpreterException("the operator '|' only for integer.").setInfoId("bitwise_OP_ERROR").addArg("|").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
    }

    public static Object bitwiseXor(Object leftVal, Object rightVal) throws InterpreterException {
        if (leftVal instanceof BigInteger || rightVal instanceof BigInteger) {
            throw (InterpreterException)new InterpreterException("bitwiseXor Error").setInfoId("bitwise_OP_ERROR").addArg("^").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return new PrimitiveInt(((Number)leftVal).intValue() ^ ((Number)rightVal).intValue());
        }
        if (leftVal instanceof Set && rightVal instanceof Set) {
            Set leftSet = (Set)leftVal;
            Set rightSet = (Set)rightVal;
            HashSet rtnSet = new HashSet(rightSet);
            for (Object item : leftSet) {
                if (rtnSet.contains(item)) {
                    rtnSet.remove(item);
                    continue;
                }
                rtnSet.add(item);
            }
            return rtnSet;
        }
        throw (InterpreterException)new InterpreterException("the operator '^' only for integer.").setInfoId("bitwise_OP_ERROR").addArg("^").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
    }

    public static Object evalInstanceOf(Object leftVal, Object rightVal) throws InterpreterException {
        if (leftVal == null) {
            throw new InterpreterException("leftVal is null");
        }
        return leftVal.getClass().equals(rightVal) ? PrimitiveBoolean.TRUE : PrimitiveBoolean.FALSE;
    }

    public static Object add(Object leftValue, Object rightValue) throws InterpreterException {
        if (leftValue == null) {
            if (rightValue instanceof String) {
                return "null" + rightValue.toString();
            }
            if (rightValue == null) {
                return "nullnull";
            }
            return null;
        }
        if (rightValue == null) {
            if (leftValue instanceof String) {
                return leftValue.toString() + "null";
            }
            return null;
        }
        if (leftValue instanceof String || rightValue instanceof String) {
            return leftValue.toString() + rightValue.toString();
        }
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number leftNum = (Number)leftValue;
            Number rightNum = (Number)rightValue;
            if (leftNum instanceof BigDecimal || rightNum instanceof BigDecimal) {
                BigDecimal leftBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, leftNum);
                BigDecimal rightBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, rightNum);
                return leftBigVal.add(rightBigVal);
            }
            if (leftNum instanceof BigInteger || rightNum instanceof BigInteger) {
                BigInteger leftBigInt = (BigInteger)TypeUtils.castObject(BigInteger.class, leftNum);
                BigInteger rightBigInt = (BigInteger)TypeUtils.castObject(BigInteger.class, rightNum);
                return leftBigInt.add(rightBigInt);
            }
            if (leftNum instanceof PrimitiveNumber || rightNum instanceof PrimitiveNumber) {
                if (leftNum instanceof PrimitiveDouble || leftNum instanceof Double || rightNum instanceof PrimitiveDouble || rightNum instanceof Double) {
                    return new PrimitiveDouble(leftNum.doubleValue() + rightNum.doubleValue());
                }
                if (leftNum instanceof PrimitiveFloat || leftNum instanceof Float || rightNum instanceof PrimitiveFloat || rightNum instanceof Float) {
                    return new PrimitiveFloat(leftNum.floatValue() + rightNum.floatValue());
                }
                if (leftNum instanceof PrimitiveLong || leftNum instanceof Long || rightNum instanceof PrimitiveLong || rightNum instanceof Long) {
                    return new PrimitiveLong(leftNum.longValue() + rightNum.longValue());
                }
                if (leftNum instanceof PrimitiveInt || leftNum instanceof Integer || rightNum instanceof PrimitiveInt || rightNum instanceof Integer) {
                    return new PrimitiveInt(leftNum.intValue() + rightNum.intValue());
                }
                if (leftNum instanceof PrimitiveShort || leftNum instanceof Short || rightNum instanceof PrimitiveShort || rightNum instanceof Short) {
                    return new PrimitiveShort(leftNum.shortValue() + rightNum.shortValue());
                }
                if (leftNum instanceof PrimitiveByte || leftNum instanceof Byte || rightNum instanceof PrimitiveByte || rightNum instanceof Byte) {
                    return new PrimitiveByte(leftNum.byteValue() + rightNum.byteValue());
                }
            } else {
                if (leftNum instanceof Double || rightNum instanceof Double) {
                    return new PrimitiveDouble(leftNum.doubleValue() + rightNum.doubleValue());
                }
                if (leftNum instanceof Float || rightNum instanceof Float) {
                    return new PrimitiveFloat(leftNum.floatValue() + rightNum.floatValue());
                }
                if (leftNum instanceof Long || rightNum instanceof Long) {
                    return new PrimitiveLong(leftNum.longValue() + rightNum.longValue());
                }
                if (leftNum instanceof Integer || rightNum instanceof Integer) {
                    return new PrimitiveInt(leftNum.intValue() + rightNum.intValue());
                }
                if (leftNum instanceof Short || rightNum instanceof Short) {
                    return new PrimitiveShort(leftNum.shortValue() + rightNum.shortValue());
                }
                if (leftNum instanceof Byte || rightNum instanceof Byte) {
                    return new PrimitiveByte(leftNum.byteValue() + rightNum.byteValue());
                }
            }
        }
        throw (InterpreterException)new InterpreterException("TODO, left class is : '" + leftValue.getClass().getName() + ", right class is : '" + rightValue.getClass().getName() + "'").setInfoId("MATH_OP_ERROR").addArg("+").addArg(leftValue).addArg(leftValue.getClass()).addArg(rightValue).addArg(rightValue.getClass());
    }

    public static Object sub(Object leftValue, Object rightValue) throws InterpreterException {
        if (leftValue == null) {
            throw new InterpreterException("leftValue is null.");
        }
        if (rightValue == null) {
            throw new InterpreterException("rightValue is null.");
        }
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number leftNum = (Number)leftValue;
            Number rightNum = (Number)rightValue;
            if (leftNum instanceof BigDecimal || rightNum instanceof BigDecimal) {
                BigDecimal leftBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, leftNum);
                BigDecimal rightBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, rightNum);
                return leftBigVal.subtract(rightBigVal);
            }
            if (leftNum instanceof BigInteger || rightNum instanceof BigInteger) {
                BigInteger leftBigInt = (BigInteger)TypeUtils.castObject(BigInteger.class, leftNum);
                BigInteger rightBigInt = (BigInteger)TypeUtils.castObject(BigInteger.class, rightNum);
                return leftBigInt.subtract(rightBigInt);
            }
            if (leftNum instanceof PrimitiveNumber || rightNum instanceof PrimitiveNumber) {
                if (leftNum instanceof PrimitiveDouble || leftNum instanceof Double || rightNum instanceof PrimitiveDouble || rightNum instanceof Double) {
                    return new PrimitiveDouble(leftNum.doubleValue() - rightNum.doubleValue());
                }
                if (leftNum instanceof PrimitiveFloat || leftNum instanceof Float || rightNum instanceof PrimitiveFloat || rightNum instanceof Float) {
                    return new PrimitiveFloat(leftNum.floatValue() - rightNum.floatValue());
                }
                if (leftNum instanceof PrimitiveLong || leftNum instanceof Long || rightNum instanceof PrimitiveLong || rightNum instanceof Long) {
                    return new PrimitiveLong(leftNum.longValue() - rightNum.longValue());
                }
                if (leftNum instanceof PrimitiveInt || leftNum instanceof Integer || rightNum instanceof PrimitiveInt || rightNum instanceof Integer) {
                    return new PrimitiveInt(leftNum.intValue() - rightNum.intValue());
                }
                if (leftNum instanceof PrimitiveShort || leftNum instanceof Short || rightNum instanceof PrimitiveShort || rightNum instanceof Short) {
                    return new PrimitiveShort(leftNum.shortValue() - rightNum.shortValue());
                }
                if (leftNum instanceof PrimitiveByte || leftNum instanceof Byte || rightNum instanceof PrimitiveByte || rightNum instanceof Byte) {
                    return new PrimitiveByte(leftNum.byteValue() - rightNum.byteValue());
                }
            } else {
                if (leftNum instanceof Double || rightNum instanceof Double) {
                    return new PrimitiveDouble(leftNum.doubleValue() - rightNum.doubleValue());
                }
                if (leftNum instanceof Float || rightNum instanceof Float) {
                    return new PrimitiveFloat(leftNum.floatValue() - rightNum.floatValue());
                }
                if (leftNum instanceof Long || rightNum instanceof Long) {
                    return new PrimitiveLong(leftNum.longValue() - rightNum.longValue());
                }
                if (leftNum instanceof Integer || rightNum instanceof Integer) {
                    return new PrimitiveInt(leftNum.intValue() - rightNum.intValue());
                }
                if (leftNum instanceof Short || rightNum instanceof Short) {
                    return new PrimitiveShort(leftNum.shortValue() - rightNum.shortValue());
                }
                if (leftNum instanceof Byte || rightNum instanceof Byte) {
                    return new PrimitiveByte(leftNum.byteValue() - rightNum.byteValue());
                }
            }
        }
        if (leftValue instanceof Set && rightValue instanceof Set) {
            Set leftSet = (Set)leftValue;
            Set rightSet = (Set)rightValue;
            HashSet rtnSet = new HashSet(leftSet);
            for (Object item : rightSet) {
                if (!rtnSet.contains(item)) continue;
                rtnSet.remove(item);
            }
            return rtnSet;
        }
        throw (InterpreterException)new InterpreterException("TODO, left class is : '" + leftValue.getClass().getName() + ", right class is : '" + rightValue.getClass().getName() + "'").setInfoId("MATH_OP_ERROR").addArg("-").addArg(leftValue).addArg(leftValue.getClass()).addArg(rightValue).addArg(rightValue.getClass());
    }

    public static Object booleanAnd(Object leftVal, Object rightVal) throws InterpreterException {
        boolean right;
        boolean left;
        if (leftVal instanceof PrimitiveBoolean) {
            left = (Boolean)((PrimitiveBoolean)leftVal).getBoxValue();
        } else if (leftVal instanceof Boolean) {
            left = (Boolean)leftVal;
        } else {
            Class<?> cls1 = null;
            Class<?> cls2 = null;
            if (leftVal != null) {
                cls1 = leftVal.getClass();
            }
            if (rightVal != null) {
                cls2 = rightVal.getClass();
            }
            throw (InterpreterException)new InterpreterException("NotSupport.").setInfoId("BOOL_OP_ERROR").addArg("&&").addArg(leftVal).addArg(cls1).addArg(rightVal).addArg(cls2);
        }
        if (rightVal instanceof PrimitiveBoolean) {
            right = (Boolean)((PrimitiveBoolean)rightVal).getBoxValue();
        } else if (rightVal instanceof Boolean) {
            right = (Boolean)rightVal;
        } else {
            Class<?> cls1 = null;
            Class<?> cls2 = null;
            if (leftVal != null) {
                cls1 = leftVal.getClass();
            }
            if (rightVal != null) {
                cls2 = rightVal.getClass();
            }
            throw (InterpreterException)new InterpreterException("NotSupport.").setInfoId("BOOL_OP_ERROR").addArg("&&").addArg(leftVal).addArg(cls1).addArg(rightVal).addArg(cls2);
        }
        return left && right ? PrimitiveBoolean.TRUE : PrimitiveBoolean.FALSE;
    }

    public static Object booleanOr(Object leftVal, Object rightVal) throws InterpreterException {
        boolean right;
        boolean left;
        if (leftVal instanceof PrimitiveBoolean) {
            left = (Boolean)((PrimitiveBoolean)leftVal).getBoxValue();
        } else if (leftVal instanceof Boolean) {
            left = (Boolean)leftVal;
        } else {
            throw (InterpreterException)new InterpreterException("NotSupport.").setInfoId("BOOL_OP_ERROR").addArg("||").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
        }
        if (rightVal instanceof PrimitiveBoolean) {
            right = (Boolean)((PrimitiveBoolean)rightVal).getBoxValue();
        } else if (rightVal instanceof Boolean) {
            right = (Boolean)rightVal;
        } else {
            throw (InterpreterException)new InterpreterException("NotSupport.").setInfoId("BOOL_OP_ERROR").addArg("||").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
        }
        return left || right ? PrimitiveBoolean.TRUE : PrimitiveBoolean.FALSE;
    }

    public static Object mod(Object leftVal, Object rightVal) throws InterpreterException {
        if (leftVal instanceof BigInteger || rightVal instanceof BigInteger) {
            throw (InterpreterException)new InterpreterException("the operator '%' only for integer.").setInfoId("MATH_OP_ERROR").addArg("*").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
        }
        if (leftVal instanceof Number && rightVal instanceof Number) {
            return new PrimitiveInt(((Number)leftVal).intValue() % ((Number)rightVal).intValue());
        }
        throw (InterpreterException)new InterpreterException("the operator '%' only for integer.").setInfoId("MATH_OP_ERROR").addArg("*").addArg(leftVal).addArg(leftVal.getClass()).addArg(rightVal).addArg(rightVal.getClass());
    }

    public static Object multi(Object leftValue, Object rightValue) throws InterpreterException {
        if (leftValue == null) {
            throw new InterpreterException("leftValue is null.");
        }
        if (rightValue == null) {
            throw new InterpreterException("rightValue is null.");
        }
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number leftNum = (Number)leftValue;
            Number rightNum = (Number)rightValue;
            if (leftNum instanceof BigDecimal || rightNum instanceof BigDecimal) {
                BigDecimal leftBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, leftNum);
                BigDecimal rightBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, rightNum);
                return leftBigVal.multiply(rightBigVal);
            }
            if (leftNum instanceof BigInteger || rightNum instanceof BigInteger) {
                BigInteger leftBigInt = (BigInteger)TypeUtils.castObject(BigInteger.class, leftNum);
                BigInteger rightBigInt = (BigInteger)TypeUtils.castObject(BigInteger.class, rightNum);
                return leftBigInt.multiply(rightBigInt);
            }
            if (leftNum instanceof PrimitiveNumber || rightNum instanceof PrimitiveNumber) {
                if (leftNum instanceof PrimitiveDouble || leftNum instanceof Double || rightNum instanceof PrimitiveDouble || rightNum instanceof Double) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.multiply(rightVal);
                    return TypeUtils.castNumber(Double.TYPE, resultVal);
                }
                if (leftNum instanceof PrimitiveFloat || leftNum instanceof Float || rightNum instanceof PrimitiveFloat || rightNum instanceof Float) {
                    BigDecimal leftVal = new BigDecimal(leftNum.floatValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.floatValue());
                    BigDecimal resultVal = leftVal.multiply(rightVal);
                    return TypeUtils.castNumber(Float.TYPE, resultVal);
                }
                if (leftNum instanceof PrimitiveLong || leftNum instanceof Long || rightNum instanceof PrimitiveLong || rightNum instanceof Long) {
                    BigInteger leftInteger = new BigInteger(leftNum.toString());
                    BigInteger rightInteger = new BigInteger(rightNum.toString());
                    BigInteger resultInteger = leftInteger.multiply(rightInteger);
                    return TypeUtils.castNumber(Long.TYPE, resultInteger);
                }
                if (leftNum instanceof PrimitiveInt || leftNum instanceof Integer || rightNum instanceof PrimitiveInt || rightNum instanceof Integer) {
                    BigInteger leftInteger = new BigInteger(leftNum.toString());
                    BigInteger rightInteger = new BigInteger(rightNum.toString());
                    BigInteger resultInteger = leftInteger.multiply(rightInteger);
                    return TypeUtils.castNumber(Integer.TYPE, resultInteger);
                }
                if (leftNum instanceof PrimitiveShort || leftNum instanceof Short || rightNum instanceof PrimitiveShort || rightNum instanceof Short) {
                    BigInteger leftInteger = new BigInteger(leftNum.toString());
                    BigInteger rightInteger = new BigInteger(rightNum.toString());
                    BigInteger resultInteger = leftInteger.multiply(rightInteger);
                    return TypeUtils.castNumber(Short.TYPE, resultInteger);
                }
                if (leftNum instanceof PrimitiveByte || leftNum instanceof Byte || rightNum instanceof PrimitiveByte || rightNum instanceof Byte) {
                    BigInteger leftInteger = new BigInteger(leftNum.toString());
                    BigInteger rightInteger = new BigInteger(rightNum.toString());
                    BigInteger resultInteger = leftInteger.multiply(rightInteger);
                    return TypeUtils.castNumber(Byte.TYPE, resultInteger);
                }
            } else {
                if (leftNum instanceof Double || rightNum instanceof Double) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.multiply(rightVal);
                    return TypeUtils.castNumber(Double.class, resultVal);
                }
                if (leftNum instanceof Float || rightNum instanceof Float) {
                    BigDecimal leftVal = new BigDecimal(leftNum.floatValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.floatValue());
                    BigDecimal resultVal = leftVal.multiply(rightVal);
                    return TypeUtils.castNumber(Float.class, resultVal);
                }
                if (leftNum instanceof Long || rightNum instanceof Long) {
                    BigInteger leftInteger = new BigInteger(leftNum.toString());
                    BigInteger rightInteger = new BigInteger(rightNum.toString());
                    BigInteger resultInteger = leftInteger.multiply(rightInteger);
                    return TypeUtils.castNumber(Long.class, resultInteger);
                }
                if (leftNum instanceof Integer || rightNum instanceof Integer) {
                    BigInteger leftInteger = new BigInteger(leftNum.toString());
                    BigInteger rightInteger = new BigInteger(rightNum.toString());
                    BigInteger resultInteger = leftInteger.multiply(rightInteger);
                    return TypeUtils.castNumber(Integer.class, resultInteger);
                }
                if (leftNum instanceof Short || rightNum instanceof Short) {
                    BigInteger leftInteger = new BigInteger(leftNum.toString());
                    BigInteger rightInteger = new BigInteger(rightNum.toString());
                    BigInteger resultInteger = leftInteger.multiply(rightInteger);
                    return TypeUtils.castNumber(Short.class, resultInteger);
                }
                if (leftNum instanceof Byte || rightNum instanceof Byte) {
                    int rtnVal = leftNum.byteValue() * rightNum.byteValue();
                    if (rtnVal > 127 || rtnVal < -128) {
                        if (rtnVal >= Short.MIN_VALUE && rtnVal <= Short.MAX_VALUE) {
                            return new PrimitiveShort(rtnVal);
                        }
                        return new PrimitiveInt(rtnVal);
                    }
                    return new PrimitiveByte(rtnVal);
                }
            }
        }
        throw (InterpreterException)new InterpreterException("not support left class is : '" + leftValue.getClass().getName() + ", right class is : '" + rightValue.getClass().getName() + "'").setInfoId("MATH_OP_ERROR").addArg("*").addArg(leftValue).addArg(leftValue.getClass()).addArg(rightValue).addArg(rightValue.getClass());
    }

    public static Object div(Object leftValue, Object rightValue) throws InterpreterException {
        if (leftValue == null) {
            throw new InterpreterException("leftValue is null.");
        }
        if (rightValue == null) {
            throw new InterpreterException("rightValue is null.");
        }
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number leftNum = (Number)leftValue;
            Number rightNum = (Number)rightValue;
            if (leftNum instanceof BigDecimal || rightNum instanceof BigDecimal) {
                BigDecimal leftBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, leftNum);
                BigDecimal rightBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, rightNum);
                return leftBigVal.divide(rightBigVal, 16, 4);
            }
            if (leftNum instanceof BigInteger || rightNum instanceof BigInteger) {
                BigDecimal leftBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, leftNum);
                BigDecimal rightBigVal = (BigDecimal)TypeUtils.castObject(BigDecimal.class, rightNum);
                BigDecimal rtnVal = leftBigVal.divide(rightBigVal, 16, 4);
                Object rtnObj = TypeUtils.castNumber(BigInteger.class, rtnVal);
                return rtnObj;
            }
            if (leftNum instanceof PrimitiveNumber || rightNum instanceof PrimitiveNumber) {
                if (leftNum instanceof PrimitiveDouble || leftNum instanceof Double || rightNum instanceof PrimitiveDouble || rightNum instanceof Double) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Double.TYPE, resultVal);
                }
                if (leftNum instanceof PrimitiveFloat || leftNum instanceof Float || rightNum instanceof PrimitiveFloat || rightNum instanceof Float) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Float.TYPE, resultVal);
                }
                if (leftNum instanceof PrimitiveLong || leftNum instanceof Long || rightNum instanceof PrimitiveLong || rightNum instanceof Long) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Long.TYPE, resultVal);
                }
                if (leftNum instanceof PrimitiveInt || leftNum instanceof Integer || rightNum instanceof PrimitiveInt || rightNum instanceof Integer) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Integer.TYPE, resultVal);
                }
                if (leftNum instanceof PrimitiveShort || leftNum instanceof Short || rightNum instanceof PrimitiveShort || rightNum instanceof Short) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Short.TYPE, resultVal);
                }
                if (leftNum instanceof PrimitiveByte || leftNum instanceof Byte || rightNum instanceof PrimitiveByte || rightNum instanceof Byte) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Byte.TYPE, resultVal);
                }
            } else {
                if (leftNum instanceof Double || rightNum instanceof Double) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Double.class, resultVal);
                }
                if (leftNum instanceof Float || rightNum instanceof Float) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Float.class, resultVal);
                }
                if (leftNum instanceof Long || rightNum instanceof Long) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Long.class, resultVal);
                }
                if (leftNum instanceof Integer || rightNum instanceof Integer) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Integer.class, resultVal);
                }
                if (leftNum instanceof Short || rightNum instanceof Short) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Short.class, resultVal);
                }
                if (leftNum instanceof Byte || rightNum instanceof Byte) {
                    BigDecimal leftVal = new BigDecimal(leftNum.doubleValue());
                    BigDecimal rightVal = new BigDecimal(rightNum.doubleValue());
                    BigDecimal resultVal = leftVal.divide(rightVal, 16, 4);
                    return TypeUtils.castNumber(Byte.class, resultVal);
                }
            }
        }
        throw (InterpreterException)new InterpreterException("TODO, left class is : '" + leftValue.getClass().getName() + ", right class is : '" + rightValue.getClass().getName() + "'").setInfoId("MATH_OP_ERROR").addArg("/").addArg(leftValue).addArg(leftValue.getClass()).addArg(rightValue).addArg(rightValue.getClass());
    }

    public static boolean greaterThan(Object leftValue, Object rightValue) throws InterpreterException {
        if (leftValue == null || rightValue == null) {
            return false;
        }
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number leftNum = (Number)leftValue;
            Number rightNum = (Number)rightValue;
            return leftNum.doubleValue() > rightNum.doubleValue();
        }
        if (leftValue instanceof String && rightValue instanceof String) {
            String leftStr = (String)leftValue;
            String rightStr = (String)rightValue;
            return Collator.getInstance().compare(leftStr, rightStr) > 0;
        }
        if (leftValue instanceof Comparable && leftValue.getClass().isAssignableFrom(rightValue.getClass())) {
            return ((Comparable)leftValue).compareTo(rightValue) > 0;
        }
        if (rightValue.getClass().isAssignableFrom(leftValue.getClass()) && rightValue instanceof Comparable) {
            return ((Comparable)rightValue).compareTo(leftValue) < 0;
        }
        throw new InterpreterException("TODO, greaterThan, left class is : '" + leftValue.getClass().getName() + ", right class is : '" + rightValue.getClass().getName() + "'");
    }

    public static boolean greaterThanOrEqual(Object leftValue, Object rightValue) throws InterpreterException {
        return TypeUtils.greaterThan(leftValue, rightValue) || TypeUtils.equal(leftValue, rightValue);
    }

    public static boolean lessThan(Object leftValue, Object rightValue) throws InterpreterException {
        if (leftValue == null || rightValue == null) {
            return false;
        }
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number leftNum = (Number)leftValue;
            Number rightNum = (Number)rightValue;
            return leftNum.doubleValue() < rightNum.doubleValue();
        }
        if (leftValue instanceof String && rightValue instanceof String) {
            String leftStr = (String)leftValue;
            String rightStr = (String)rightValue;
            return Collator.getInstance().compare(leftStr, rightStr) < 0;
        }
        if (leftValue instanceof Comparable && leftValue.getClass().isAssignableFrom(rightValue.getClass())) {
            return ((Comparable)leftValue).compareTo(rightValue) < 0;
        }
        if (rightValue.getClass().isAssignableFrom(leftValue.getClass()) && rightValue instanceof Comparable) {
            return ((Comparable)rightValue).compareTo(leftValue) > 0;
        }
        throw new InterpreterException("TODO, greaterThan, left class is : '" + leftValue.getClass().getName() + ", right class is : '" + rightValue.getClass().getName() + "'");
    }

    public static boolean equal(Object leftValue, Object rightValue) {
        DynamicEnum dynamicEnum;
        StringEnum strEnum;
        int intEnumVal;
        IntEnum intEnum;
        if (leftValue == rightValue) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        if (leftValue instanceof BOSUuid && rightValue instanceof BOSUuid && leftValue.equals(rightValue)) {
            return true;
        }
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number leftNum = (Number)leftValue;
            Number rightNum = (Number)rightValue;
            return leftNum.doubleValue() == rightNum.doubleValue();
        }
        if (leftValue instanceof String && rightValue instanceof String) {
            return ((String)leftValue).equals(rightValue);
        }
        if (leftValue instanceof String && rightValue instanceof PrimitiveCharacter) {
            return ((String)leftValue).equals(rightValue.toString());
        }
        if (leftValue instanceof Boolean && rightValue instanceof PrimitiveBoolean) {
            return ((Boolean)leftValue).booleanValue() == ((PrimitiveBoolean)rightValue).getValue();
        }
        if (leftValue instanceof PrimitiveBoolean && rightValue instanceof Boolean) {
            return ((Boolean)rightValue).booleanValue() == ((PrimitiveBoolean)leftValue).getValue();
        }
        if (leftValue instanceof IntEnum) {
            intEnum = (IntEnum)leftValue;
            if (rightValue instanceof IntEnum) {
                return intEnum.equals(rightValue);
            }
            intEnumVal = intEnum.getValue();
            if (rightValue instanceof Number) {
                return intEnumVal == ((Number)rightValue).intValue();
            }
        }
        if (rightValue instanceof IntEnum) {
            intEnum = (IntEnum)rightValue;
            if (leftValue instanceof IntEnum) {
                return intEnum.equals(leftValue);
            }
            intEnumVal = intEnum.getValue();
            if (leftValue instanceof Number) {
                return intEnumVal == ((Number)leftValue).intValue();
            }
        }
        if (leftValue instanceof StringEnum) {
            strEnum = (StringEnum)leftValue;
            if (rightValue instanceof StringEnum) {
                return strEnum.equals(rightValue);
            }
            String strEnumVal = strEnum.getValue();
            return strEnumVal.equals(rightValue);
        }
        if (rightValue instanceof StringEnum) {
            strEnum = (StringEnum)rightValue;
            if (leftValue instanceof StringEnum) {
                return strEnum.equals(leftValue);
            }
            String strEnumVal = strEnum.getValue();
            return strEnumVal.equals(leftValue);
        }
        if (leftValue instanceof DynamicEnum) {
            dynamicEnum = (DynamicEnum)leftValue;
            if (rightValue instanceof DynamicEnum) {
                return dynamicEnum.equals(rightValue);
            }
            String dynamicEnumVal = dynamicEnum.getValue();
            String dynamicEnumStr = dynamicEnum.toString();
            return dynamicEnumVal.equals(rightValue) || dynamicEnumStr.equals(rightValue);
        }
        if (rightValue instanceof DynamicEnum) {
            dynamicEnum = (DynamicEnum)rightValue;
            if (leftValue instanceof DynamicEnum) {
                return dynamicEnum.equals(leftValue);
            }
            String dynamicEnumVal = dynamicEnum.getValue();
            String dynamicEnumStr = dynamicEnum.toString();
            return dynamicEnumVal.equals(leftValue) || dynamicEnumStr.equals(leftValue);
        }
        if (rightValue instanceof String && rightValue != null && leftValue != null) {
            return rightValue.equals(leftValue.toString());
        }
        if (leftValue instanceof String && rightValue != null && leftValue != null) {
            return leftValue.equals(rightValue.toString());
        }
        if (leftValue instanceof Comparable && leftValue.getClass().isAssignableFrom(rightValue.getClass())) {
            return ((Comparable)leftValue).compareTo(rightValue) == 0;
        }
        if (rightValue.getClass().isAssignableFrom(leftValue.getClass()) && rightValue instanceof Comparable) {
            return ((Comparable)rightValue).compareTo(leftValue) == 0;
        }
        return false;
    }

    public static Object castObject(Class<?> destType, Object value) throws InterpreterException {
        if (destType.isInstance(value)) {
            return value;
        }
        if (destType.equals(String.class)) {
            return value.toString();
        }
        if (destType.equals(BigDecimal.class)) {
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            if (value instanceof BigDecimal) {
                return value;
            }
            if (!(!(value instanceof Number) || value instanceof Double || value instanceof PrimitiveDouble || value instanceof Float || value instanceof PrimitiveFloat)) {
                return BigDecimal.valueOf(((Number)value).doubleValue());
            }
            String str = value.toString();
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException ex) {
                throw new InterpreterException("can not cast value " + value.toString() + " to " + destType);
            }
        }
        if (destType.equals(BigInteger.class)) {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            if (value instanceof BigInteger) {
                return value;
            }
            if (value instanceof Number) {
                return BigInteger.valueOf(((Number)value).longValue());
            }
            String str = value.toString();
            try {
                return BigInteger.valueOf(Long.parseLong(str));
            }
            catch (NumberFormatException ex) {
                throw new InterpreterException("can not cast value " + value.toString() + " to " + destType);
            }
        }
        if (destType.equals(Byte.class) || destType.equals(Byte.TYPE)) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            return Byte.parseByte(value.toString());
        }
        if (destType.equals(Short.class) || destType.equals(Short.TYPE)) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(value.toString());
        }
        if (destType.equals(Integer.class) || destType.equals(Integer.TYPE)) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        if (destType.equals(Integer.class) || destType.equals(Long.TYPE)) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        if (destType.equals(Float.class) || destType.equals(Float.TYPE)) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (destType.equals(Double.class) || destType.equals(Double.TYPE)) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        if (destType.equals(Boolean.class) || destType.equals(Boolean.TYPE)) {
            if (value instanceof Boolean) {
                return value;
            }
            return new Boolean(value.toString());
        }
        if (destType.equals(Timestamp.class) && value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (destType.equals(java.util.Date.class) && value instanceof Date) {
            return value;
        }
        if (destType.equals(Date.class) && value instanceof Timestamp) {
            return new Date(((Timestamp)value).getTime());
        }
        if (destType.equals(java.util.Date.class) && value instanceof Timestamp) {
            return value;
        }
        if (destType.equals(Date.class) && value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (destType.equals(Timestamp.class) && value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        throw new InterpreterException("TODO. cast from " + value.getClass().getName() + " to " + destType.getName());
    }

    public static boolean lessThanOrEqual(Object leftValue, Object rightValue) throws InterpreterException {
        return TypeUtils.lessThan(leftValue, rightValue) || TypeUtils.equal(leftValue, rightValue);
    }

    public static boolean like(Object leftValue, Object rightValue) {
        if (leftValue == null || rightValue == null) {
            return false;
        }
        if (leftValue instanceof String && rightValue instanceof String) {
            String str = "%";
            String leftStr = (String)leftValue;
            String rightStr = (String)rightValue;
            if (rightStr.indexOf(str) < 0 || rightStr.startsWith(str) && rightStr.endsWith(str)) {
                return leftStr.indexOf(TypeUtils.getValOfLike(rightStr)) > -1;
            }
            if (rightStr.startsWith(str) && !rightStr.endsWith(str)) {
                return leftStr.endsWith(TypeUtils.getValOfLike(rightStr));
            }
            if (!rightStr.startsWith(str) && rightStr.endsWith(str)) {
                return leftStr.startsWith(TypeUtils.getValOfLike(rightStr));
            }
        }
        return false;
    }

    public static String getValOfLike(String val) {
        String str = "%";
        if (val.startsWith(str)) {
            val = val.substring(1);
        }
        if (val.endsWith(str)) {
            val = val.substring(0, val.length() - 1);
        }
        return val;
    }
}

