/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.function;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.fieldrule.formula.FieldRuleFormulaException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.function.FuncInfo;
import com.kingdee.shr.base.syssetting.fieldrule.formula.function.IFunctionProvider;
import com.kingdee.shr.base.syssetting.fieldrule.formula.function.InvokeFunctionException;
import com.kingdee.shr.common.util.DateUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class BaseFieldRuleFunctions
implements IFunctionProvider {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private List<FuncInfo> funcInfos = new ArrayList<FuncInfo>();
    public static final String BASERESOURCE = "com.kingdee.shr.base.syssetting.fieldrule.formula.function.FormulaResource";
    private static final String FUNCTION_ROUND = "round";
    private static final String FUNCTION_SQRT = "sqrt";
    private static final String FUNCTION_INT = "int";
    private static final String FUNCTION_LN = "ln";
    private static final String FUNCTION_LOG = "log";
    private static final String FUNCTION_LOG10 = "log10";
    private static final String FUNCTION_EXP = "exp";
    private static final String FUNCTION_POWER = "power";
    private static final String FUNCTION_MOD = "mod";
    private static final String FUNCTION_PI = "pi";
    private static final String FUNCTION_RAND = "rand";
    private static final String FUNCTION_DEGREES = "degrees";
    private static final String FUNCTION_RADIANS = "radians";
    private static final String FUNCTION_SIN = "sin";
    private static final String FUNCTION_ASIN = "asin";
    private static final String FUNCTION_COS = "cos";
    private static final String FUNCTION_ACOS = "acos";
    private static final String FUNCTION_TAN = "tan";
    private static final String FUNCTION_ATAN = "atan";
    private static final String FUNCTION_CONVERTBIGDECIMAL = "convertBigDecimal";
    private static final String FUNCTION_NOW = "now";
    private static final String FUNCTION_FORMATJAVADATE = "formatJavaDate";
    private static final String FUNCTION_CONVERTJAVADATE = "convertJavaDate";
    private static final String FUNCTION_YEAR = "year";
    private static final String FUNCTION_MONTH = "month";
    private static final String FUNCTION_DATE = "date";
    private static final String FUNCTION_HOUR = "hour";
    private static final String FUNCTION_MINUTE = "minute";
    private static final String FUNCTION_SECOND = "second";
    private static final String FUNCTION_YEARDAY = "yearday";
    private static final String FUNCTION_WEEKDAY = "weekday";
    private static final String FUNCTION_DATEVALUE = "datevalue";
    private static final String FUNCTION_DAYS = "days";
    private static final String FUNCTION_HOURS = "hours";
    private static final String FUNCTION_MILLISECONDS = "milliseconds";
    private static final String FUNCTION_MINUTES = "minutes";
    private static final String FUNCTION_SECONDS = "seconds";
    private static final String FUNCTION_TICKS = "ticks";
    private static final String FUNCTION_TOTALDAYS = "totaldays";
    private static final String FUNCTION_TOTALHOURS = "totalhours";
    private static final String FUNCTION_TOTALMILLISECONDS = "totalmilliseconds";
    private static final String FUNCTION_TOTALMINUTES = "totalminutes";
    private static final String FUNCTION_TOTALSECONDS = "totalseconds";
    private static final String FUNCTION_DATEDIFF = "dateDiff";
    private static final String FUNCTION_DATEADD = "dateAdd";
    private static final String FUNCTION_CONVERTSTRDATE = "convertStrDate";
    private static final String FUNCTION_DATETOMILLISECONDS = "dateToMilliseconds";
    private static final String FUNCTION_JAVADATEDIFF = "javaDateDiff";
    private static final String FUNCTION_JAVADATETIMEDIFF = "javaDateTimeDiff";
    private static final String FUNCTION_HOURANDMINUTEDIFF = "dateHourAndMinuteDiff";
    private static final String FUNCTION_IGNORENULLSTRING = "ignoreNullString";
    private static final String FUNCTION_IGNORENULLNUMBER = "ignoreNullNumber";
    private static final String FUNCTION_TRIM = "trim";
    private static final String FUNCTION_LEFT = "left";
    private static final String FUNCTION_RIGHT = "right";
    private static final String FUNCTION_REPT = "rept";
    private static final String FUNCTION_CONTAINSSTR = "containsStr";
    private static final String FUNCTION_SPLIT = "split";
    private static final String FUNCTION_ISEMPTY = "isEmpty";
    private static final String FUNCTION_UPPER = "upper";
    private static final String FUNCTION_LOWER = "lower";
    private static final String FUNCTION_EQUALS = "equals";
    private static final String FUNCTION_EQUALSIGNORECASE = "equalsIgnoreCase";
    private static final String FUNCTION_REPLACE = "replace";
    private static final String FUNCTION_REPLACEIGNORECASE = "replaceIgnoreCase";
    private static final String FUNCTION_STARTSWITH = "startsWith";
    private static final String FUNCTION_STARTSWITHIGNORECASE = "startsWithIgnoreCase";
    private static final String FUNCTION_ENDSWITH = "endsWith";
    private static final String FUNCTION_ENDSWITHIGNORE = "endsWithIgnore";
    private static final String FUNCTION_INDEXOF = "indexOf";
    private static final String FUNCTION_INDEXOFIGNORECASE = "indexOfIgnoreCase";
    private static final String FUNCTION_LASTINDEXOF = "lastIndexOf";
    private static final String FUNCTION_LASTINDEXOFIGNORE = "lastIndexOfIgnore";
    private static final String FUNCTION_ABS = "abs";
    private static final String FUNCTION_MAX = "MAX";
    private static final String FUNCTION_MIN = "MIN";
    private static final String FUNCTION_PARSEINT = "parseInt";
    private static final String FUNCTION_PARSEFLOAT = "parseFloat";
    private static final String FUNCTION_LEN = "len";
    private static final String FUNCTION_PRINT = "print";
    private static final String FUNCTION_PRINTLN = "println";
    private static final String FUNCTION_EVAL = "eval";
    private static final String FUNCTION_NEWID = "newid";
    private static final String FUNCTION_CONDITIONAL_SUM = "conditional_sum";
    private static final String FUNCTION_CONDITIONAL_AVG = "conditional_avg";
    private static final String FUNCTION_CONDITIONAL_MAX = "conditional_max";
    private static final String FUNCTION_CONDITIONAL_MIN = "conditional_min";
    private static final String FUNCTION_CONDITIONAL_COUNT = "conditional_count";

    public BaseFieldRuleFunctions(Context ctx) {
        String CATEGORY_MATH = SHRServerResource.getString(BASERESOURCE, "69_BaseFormulaFunctions", ctx);
        String CATEGORY_IO = SHRServerResource.getString(BASERESOURCE, "71_BaseFormulaFunctions", ctx);
        String CATEGORY_OTHER = SHRServerResource.getString(BASERESOURCE, "72_BaseFormulaFunctions", ctx);
        String CATEGORY_STRING = SHRServerResource.getString(BASERESOURCE, "73_BaseFormulaFunctions", ctx);
        String CATEGORY_TIME = SHRServerResource.getString(BASERESOURCE, "74_BaseFormulaFunctions", ctx);
        String CATEGORY_NULLJUDGE = SHRServerResource.getString(BASERESOURCE, "75_BaseFormulaFunctions", ctx);
        this.funcInfos.add(new FuncInfo(FUNCTION_ROUND, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "1_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_SQRT, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "2_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_INT, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "3_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_LN, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "4_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_LOG, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "5_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_LOG10, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "6_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_EXP, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "7_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_POWER, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "8_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_MOD, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "9_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_PI, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "10_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_RAND, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "11_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_DEGREES, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "12_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_RADIANS, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "13_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_SIN, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "14_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_ASIN, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "15_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_COS, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "16_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_ACOS, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "17_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_TAN, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "18_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_ATAN, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "19_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_CONVERTBIGDECIMAL, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "20_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_NOW, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "25_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_FORMATJAVADATE, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "110_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_CONVERTJAVADATE, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "26_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_YEAR, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "27_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_MONTH, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "28_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_DATE, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "29_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_HOUR, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "30_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_MINUTE, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "31_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_SECOND, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "32_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_YEARDAY, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "33_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_WEEKDAY, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "34_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_DATEVALUE, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "35_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_DAYS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "36_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_HOURS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "37_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_MILLISECONDS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "38_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_MINUTES, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "39_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_SECONDS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "40_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_TICKS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "41_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_TOTALDAYS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "42_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_TOTALHOURS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "43_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_TOTALMILLISECONDS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "44_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_TOTALMINUTES, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "45_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_TOTALSECONDS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "46_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_DATEDIFF, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "47_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_DATEADD, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "48_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_CONVERTSTRDATE, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "106_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_DATETOMILLISECONDS, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "107_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_JAVADATEDIFF, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "108_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_JAVADATETIMEDIFF, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "109_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_HOURANDMINUTEDIFF, CATEGORY_TIME, SHRServerResource.getString(BASERESOURCE, "111_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_IGNORENULLSTRING, CATEGORY_NULLJUDGE, SHRServerResource.getString(BASERESOURCE, "67_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_IGNORENULLNUMBER, CATEGORY_NULLJUDGE, SHRServerResource.getString(BASERESOURCE, "68_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_TRIM, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "21_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_LEFT, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "22_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_RIGHT, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "23_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_REPT, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "24_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_CONTAINSSTR, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "89_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_SPLIT, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "90_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_ISEMPTY, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "91_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_UPPER, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "92_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_LOWER, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "93_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_EQUALS, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "94_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_EQUALSIGNORECASE, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "95_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_REPLACE, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "96_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_REPLACEIGNORECASE, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "97_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_STARTSWITH, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "98_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_STARTSWITHIGNORECASE, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "99_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_ENDSWITH, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "100_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_ENDSWITHIGNORE, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "101_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_INDEXOF, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "102_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_INDEXOFIGNORECASE, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "103_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_LASTINDEXOF, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "104_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_LASTINDEXOFIGNORE, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "105_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_ABS, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "49_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_PARSEINT, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "50_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_PARSEFLOAT, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "51_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_MAX, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "55_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_MIN, CATEGORY_MATH, SHRServerResource.getString(BASERESOURCE, "56_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_LEN, CATEGORY_STRING, SHRServerResource.getString(BASERESOURCE, "52_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_PRINT, CATEGORY_IO, SHRServerResource.getString(BASERESOURCE, "58_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_PRINTLN, CATEGORY_IO, SHRServerResource.getString(BASERESOURCE, "59_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_EVAL, CATEGORY_OTHER, SHRServerResource.getString(BASERESOURCE, "60_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_NEWID, CATEGORY_OTHER, SHRServerResource.getString(BASERESOURCE, "61_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_CONDITIONAL_SUM, CATEGORY_OTHER, SHRServerResource.getString(BASERESOURCE, "62_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_CONDITIONAL_AVG, CATEGORY_OTHER, SHRServerResource.getString(BASERESOURCE, "63_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_CONDITIONAL_MAX, CATEGORY_OTHER, SHRServerResource.getString(BASERESOURCE, "64_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_CONDITIONAL_MIN, CATEGORY_OTHER, SHRServerResource.getString(BASERESOURCE, "65_BaseFormulaFunctions", ctx)));
        this.funcInfos.add(new FuncInfo(FUNCTION_CONDITIONAL_COUNT, CATEGORY_OTHER, SHRServerResource.getString(BASERESOURCE, "66_BaseFormulaFunctions", ctx)));
    }

    @Override
    public List<FuncInfo> getFunctionsTree() {
        return this.funcInfos;
    }

    @Override
    public boolean existFunction(String funcName) {
        if (funcName == null) {
            return false;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(this.funcInfos.get((int)i).funcName)) continue;
            return true;
        }
        return false;
    }

    public String[] getAllFuncNames() {
        String[] funcNames = new String[this.funcInfos.size()];
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            funcNames[i] = this.funcInfos.get((int)i).funcName;
        }
        return funcNames;
    }

    public String getFuncCategory(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(this.funcInfos.get((int)i).funcName)) continue;
            return this.funcInfos.get((int)i).funcCategory;
        }
        return null;
    }

    public String getFuncDesc(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(this.funcInfos.get((int)i).funcName)) continue;
            return this.funcInfos.get((int)i).funcDesc;
        }
        return null;
    }

    private Object now(List<Object> paramList) throws InvokeFunctionException {
        if (paramList != null && !paramList.isEmpty()) {
            throw new InvokeFunctionException(FUNCTION_NOW, 1);
        }
        SimpleDateFormat nowDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        String pattern = DATE_TIME_FORMAT;
        nowDateFormat.applyPattern(pattern);
        return nowDateFormat.format(new java.util.Date());
    }

    private static Object formatJavaDate(List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(FUNCTION_FORMATJAVADATE, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(FUNCTION_FORMATJAVADATE, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(FUNCTION_FORMATJAVADATE, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof java.util.Date) || !(paramList.get(1) instanceof String)) {
            throw new InvokeFunctionException(FUNCTION_FORMATJAVADATE, 3);
        }
        java.util.Date date = (java.util.Date)paramList.get(0);
        String format = (String)paramList.get(1);
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    private Object convertJavaDate(List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(FUNCTION_CONVERTJAVADATE, 2);
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(FUNCTION_CONVERTJAVADATE, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(FUNCTION_CONVERTJAVADATE, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof java.util.Date)) {
            throw new InvokeFunctionException(FUNCTION_CONVERTJAVADATE, 3);
        }
        SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        dateFormat.applyPattern(DATE_TIME_FORMAT);
        return dateFormat.format((java.util.Date)paramList.get(0));
    }

    private Object convertStrDate(List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(FUNCTION_CONVERTSTRDATE, 2);
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(FUNCTION_CONVERTSTRDATE, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(FUNCTION_CONVERTSTRDATE, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String)) {
            throw new InvokeFunctionException(FUNCTION_CONVERTSTRDATE, 3);
        }
        try {
            return DateTimeUtils.parseDate((String)((String)paramList.get(0)));
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(FUNCTION_CONVERTSTRDATE, 3);
        }
    }

    private Object dateToMilliseconds(List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(FUNCTION_DATETOMILLISECONDS, 2);
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(FUNCTION_DATETOMILLISECONDS, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(FUNCTION_DATETOMILLISECONDS, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof java.util.Date)) {
            throw new InvokeFunctionException(FUNCTION_DATETOMILLISECONDS, 3);
        }
        return ((java.util.Date)paramList.get(0)).getTime();
    }

    private Object javaDateFuncSet2(List<Object> paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        Object date1 = paramList.get(0);
        Object date2 = paramList.get(1);
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        try {
            if (date1 instanceof String) {
                date1 = DateTimeUtils.parseDate((String)((String)date1));
            }
            if (date2 instanceof String) {
                date2 = DateTimeUtils.parseDate((String)((String)date2));
            }
            if (!(date1 instanceof java.util.Date) || !(date2 instanceof java.util.Date)) {
                throw new InvokeFunctionException(funcName, 3);
            }
            if (FUNCTION_JAVADATEDIFF.equals(funcName)) {
                return BaseFieldRuleFunctions.calculateDateDiffInDays((java.util.Date)date1, (java.util.Date)date2);
            }
            if (FUNCTION_DATEDIFF.equals(funcName)) {
                return BaseFieldRuleFunctions.calculateDateDiffInDays((java.util.Date)date1, (java.util.Date)date2);
            }
            if (FUNCTION_HOURANDMINUTEDIFF.equals(funcName)) {
                return BaseFieldRuleFunctions.calculateDateTimeDiffInHoursAndMinutes((java.util.Date)date1, (java.util.Date)date2);
            }
            if (FUNCTION_JAVADATETIMEDIFF.equals(funcName)) {
                return ((java.util.Date)date1).getTime() - ((java.util.Date)date2).getTime();
            }
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, e);
        }
        return null;
    }

    private Object timeFuncSetString(List<Object> paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        try {
            java.util.Date date = DateTimeUtils.parseDate((String)((String)paramList.get(0)));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (FUNCTION_YEAR.equals(funcName)) {
                return calendar.get(1);
            }
            if (FUNCTION_MONTH.equals(funcName)) {
                return calendar.get(2) + 1;
            }
            if (FUNCTION_DATE.equals(funcName)) {
                return calendar.get(5);
            }
            if (FUNCTION_HOUR.equals(funcName)) {
                return calendar.get(11);
            }
            if (FUNCTION_MINUTE.equals(funcName)) {
                return calendar.get(12);
            }
            if (FUNCTION_SECOND.equals(funcName)) {
                return calendar.get(13);
            }
            if (FUNCTION_YEARDAY.equals(funcName)) {
                return calendar.get(6);
            }
            if (FUNCTION_WEEKDAY.equals(funcName)) {
                int dayOfWeek = calendar.get(7);
                return (dayOfWeek + 5) % 7 + 1;
            }
            if (FUNCTION_DATEVALUE.equals(funcName)) {
                return date.getTime();
            }
            return null;
        }
        catch (ParseException e) {
            throw new InvokeFunctionException(funcName, e);
        }
    }

    private static Integer calculateDateDiffInDays(java.util.Date date1, java.util.Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("Dates must not be null");
        }
        LocalDate localDate1 = null;
        LocalDate localDate2 = null;
        if (date1 instanceof Date) {
            localDate1 = ((Date)date1).toLocalDate();
            localDate2 = ((Date)date2).toLocalDate();
        } else {
            localDate1 = DateUtils.toLocalDate((java.util.Date)date1);
            localDate2 = DateUtils.toLocalDate((java.util.Date)date2);
        }
        long diffInDays = localDate1.isAfter(localDate2) ? ChronoUnit.DAYS.between(localDate2, localDate1) : ChronoUnit.DAYS.between(localDate1, localDate2);
        if (diffInDays > Integer.MAX_VALUE || diffInDays < Integer.MIN_VALUE) {
            throw new ArithmeticException("Date difference is too large to fit in an int");
        }
        return (int)diffInDays;
    }

    private static String calculateDateTimeDiffInHoursAndMinutes(java.util.Date date1, java.util.Date date2) {
        long diffInMinutes;
        long diffInHours;
        LocalDateTime localDateTime2;
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("Dates must not be null");
        }
        LocalDateTime localDateTime1 = DateUtils.toLocalDateTime((java.util.Date)date1);
        if (localDateTime1.isAfter(localDateTime2 = DateUtils.toLocalDateTime((java.util.Date)date2))) {
            diffInHours = ChronoUnit.HOURS.between(localDateTime2, localDateTime1);
            diffInMinutes = ChronoUnit.MINUTES.between(localDateTime2, localDateTime1);
        } else {
            diffInHours = ChronoUnit.HOURS.between(localDateTime1, localDateTime2);
            diffInMinutes = ChronoUnit.MINUTES.between(localDateTime1, localDateTime2);
        }
        if (diffInHours > Integer.MAX_VALUE || diffInHours < Integer.MIN_VALUE) {
            throw new ArithmeticException("Date difference is too large to fit in an int");
        }
        return String.format("%d.%d", diffInHours, diffInMinutes % 60L);
    }

    private Object timeFuncDateAdd(List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(FUNCTION_DATEADD, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(FUNCTION_DATEADD, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(FUNCTION_DATEADD, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String) && !(paramList.get(0) instanceof java.util.Date) || !(paramList.get(1) instanceof String) && !(paramList.get(1) instanceof Integer)) {
            throw new InvokeFunctionException(FUNCTION_DATEADD, 3);
        }
        java.util.Date date1 = null;
        if (paramList.get(0) instanceof String) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
                date1 = format.parse(paramList.get(0).toString());
            }
            catch (Exception format) {}
        } else if (paramList.get(0) instanceof java.util.Date) {
            date1 = (java.util.Date)paramList.get(0);
        }
        int offset = 0;
        offset = paramList.get(1) instanceof String ? Integer.parseInt((String)paramList.get(1)) : (Integer)paramList.get(1);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        calendar.set(6, calendar.get(6) + offset);
        SimpleDateFormat nowDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        nowDateFormat.applyPattern(DATE_TIME_FORMAT);
        return nowDateFormat.format(calendar.getTime());
    }

    private Object timeFuncSetInt(List<Object> paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Long) && !(paramList.get(0) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        long time = 0L;
        if (paramList.get(0) instanceof Long) {
            time = (Long)paramList.get(0);
        } else if (paramList.get(0) instanceof Integer) {
            time = ((Integer)paramList.get(0)).intValue();
        }
        if (FUNCTION_DAYS.equals(funcName)) {
            return (int)(time / 86400000L);
        }
        if (FUNCTION_HOURS.equals(funcName)) {
            return (int)(time / 3600000L);
        }
        if (FUNCTION_MILLISECONDS.equals(funcName)) {
            return (int)time;
        }
        if (FUNCTION_MINUTES.equals(funcName)) {
            return (int)(time / 60000L);
        }
        if (FUNCTION_SECONDS.equals(funcName)) {
            return (int)(time / 1000L);
        }
        if (FUNCTION_TICKS.equals(funcName)) {
            return (int)(time / 3600000L);
        }
        if (FUNCTION_TOTALDAYS.equals(funcName)) {
            return (double)time / 8.64E7;
        }
        if (FUNCTION_TOTALHOURS.equals(funcName)) {
            return (double)time / 3600000.0;
        }
        if (FUNCTION_TOTALMILLISECONDS.equals(funcName)) {
            return time;
        }
        if (FUNCTION_TOTALMINUTES.equals(funcName)) {
            return (double)time / 60000.0;
        }
        if (FUNCTION_TOTALSECONDS.equals(funcName)) {
            return (double)time / 1000.0;
        }
        return null;
    }

    private Object trim(List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(FUNCTION_TRIM, 2);
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(FUNCTION_TRIM, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(FUNCTION_TRIM, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String)) {
            throw new InvokeFunctionException(FUNCTION_TRIM, 3);
        }
        return ((String)paramList.get(0)).trim();
    }

    private Object containsStr(List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null || paramList.size() < 2) {
            throw new InvokeFunctionException(FUNCTION_CONTAINSSTR, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(FUNCTION_CONTAINSSTR, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return false;
        }
        if (!(paramList.get(0) instanceof String) || !(paramList.get(1) instanceof String)) {
            throw new InvokeFunctionException(FUNCTION_CONTAINSSTR, 3);
        }
        return ((String)paramList.get(0)).contains((String)paramList.get(1));
    }

    private Object stringFuncSet(List<Object> paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof String) || !(paramList.get(1) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        String inputStr = (String)paramList.get(0);
        int cnt = (Integer)paramList.get(1);
        if (cnt < 0) {
            throw new InvokeFunctionException(funcName, "parameter 2 must be greater than 0!");
        }
        if (FUNCTION_LEFT.equals(funcName)) {
            if (inputStr.length() < cnt) {
                return inputStr;
            }
            return inputStr.substring(0, cnt);
        }
        if (FUNCTION_RIGHT.equals(funcName)) {
            if (inputStr.length() < cnt) {
                return inputStr;
            }
            return inputStr.substring(inputStr.length() - cnt, inputStr.length());
        }
        if (FUNCTION_REPT.equals(funcName)) {
            StringBuilder retStr = new StringBuilder();
            for (int i = 0; i < cnt; ++i) {
                retStr.append(inputStr);
            }
            return retStr.toString();
        }
        return null;
    }

    private Object stringFuncSet1(List<Object> paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        String inputStr = (String)paramList.get(0);
        if (FUNCTION_ISEMPTY.equals(funcName)) {
            return StringUtils.isEmpty((String)inputStr);
        }
        if (FUNCTION_UPPER.equals(funcName)) {
            if (StringUtils.isEmpty((String)inputStr)) {
                return null;
            }
            return inputStr.toUpperCase(Locale.ENGLISH);
        }
        if (FUNCTION_LOWER.equals(funcName)) {
            if (StringUtils.isEmpty((String)inputStr)) {
                return null;
            }
            return inputStr.toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    private Object stringFuncSet2(List<Object> paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (FUNCTION_EQUALS.equals(funcName)) {
            return StringUtils.equals((String)((String)paramList.get(0)), (String)((String)paramList.get(1)));
        }
        if (FUNCTION_EQUALSIGNORECASE.equals(funcName)) {
            return StringUtils.equalsIgnoreCase((String)((String)paramList.get(0)), (String)((String)paramList.get(1)));
        }
        if (!(paramList.get(0) instanceof String) || !(paramList.get(1) instanceof String)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        String inputStr1 = (String)paramList.get(0);
        String inputStr2 = (String)paramList.get(1);
        if (FUNCTION_SPLIT.equals(funcName)) {
            return inputStr1.split(inputStr2);
        }
        if (FUNCTION_ENDSWITH.equals(funcName)) {
            return inputStr1.endsWith(inputStr2);
        }
        if (FUNCTION_ENDSWITHIGNORE.equals(funcName)) {
            return inputStr1.toLowerCase(Locale.ENGLISH).endsWith(inputStr2.toLowerCase(Locale.ENGLISH));
        }
        return null;
    }

    private Object stringFuncSet3(List<Object> paramList, String funcName) throws InvokeFunctionException {
        Object inputStr3;
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 3) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (!(paramList.get(0) instanceof String) || !(paramList.get(1) instanceof String) || paramList.size() == 3 && !(paramList.get(2) instanceof String) && !(paramList.get(2) instanceof Integer)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        String inputStr1 = (String)paramList.get(0);
        String inputStr2 = (String)paramList.get(1);
        Object object = inputStr3 = paramList.size() == 3 ? paramList.get(2) : Integer.valueOf(0);
        if (FUNCTION_REPLACE.equals(funcName)) {
            return StringUtils.replace((String)inputStr1, (String)inputStr2, (String)((String)inputStr3));
        }
        if (FUNCTION_REPLACEIGNORECASE.equals(funcName)) {
            return StringUtils.replaceIgnoreCase((String)inputStr1, (String)inputStr2.toLowerCase(Locale.ENGLISH), (String)((String)inputStr3));
        }
        if (FUNCTION_STARTSWITH.equals(funcName)) {
            return inputStr1.startsWith(inputStr2, (Integer)inputStr3);
        }
        if (FUNCTION_STARTSWITHIGNORECASE.equals(funcName)) {
            return inputStr1.toLowerCase(Locale.ENGLISH).startsWith(inputStr2.toLowerCase(Locale.ENGLISH), (Integer)inputStr3);
        }
        if (FUNCTION_INDEXOF.equals(funcName)) {
            return inputStr1.indexOf(inputStr2, (int)((Integer)inputStr3));
        }
        if (FUNCTION_INDEXOFIGNORECASE.equals(funcName)) {
            return inputStr1.toLowerCase(Locale.ENGLISH).indexOf(inputStr2.toLowerCase(Locale.ENGLISH), (int)((Integer)inputStr3));
        }
        if (FUNCTION_LASTINDEXOF.equals(funcName)) {
            inputStr3 = paramList.size() == 3 ? paramList.get(2) : Integer.valueOf(inputStr1.length());
            return inputStr1.lastIndexOf(inputStr2, (int)((Integer)inputStr3));
        }
        if (FUNCTION_LASTINDEXOFIGNORE.equals(funcName)) {
            inputStr3 = paramList.size() == 3 ? paramList.get(2) : Integer.valueOf(inputStr1.length());
            return inputStr1.toLowerCase(Locale.ENGLISH).lastIndexOf(inputStr2.toLowerCase(Locale.ENGLISH), (int)((Integer)inputStr3));
        }
        return null;
    }

    private Object mathFuncSet0(List<Object> paramList, String funcName) throws InvokeFunctionException {
        if (paramList != null && !paramList.isEmpty()) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (FUNCTION_PI.equals(funcName)) {
            return Math.PI;
        }
        if (FUNCTION_RAND.equals(funcName)) {
            return new SecureRandom().nextDouble();
        }
        return null;
    }

    private Object mathFuncSet1(List<Object> paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        double param1 = Double.parseDouble(paramList.get(0).toString());
        if (FUNCTION_SQRT.equals(funcName)) {
            return Math.sqrt(param1);
        }
        if (FUNCTION_INT.equals(funcName)) {
            return (int)param1;
        }
        if (FUNCTION_LN.equals(funcName)) {
            return Math.log(param1);
        }
        if (FUNCTION_LOG10.equals(funcName)) {
            return Math.log(param1) / Math.log(10.0);
        }
        if (FUNCTION_EXP.equals(funcName)) {
            return Math.pow(10.0, param1);
        }
        if (FUNCTION_DEGREES.equals(funcName)) {
            return Math.toDegrees(param1);
        }
        if (FUNCTION_RADIANS.equals(funcName)) {
            return Math.toRadians(param1);
        }
        if (FUNCTION_SIN.equals(funcName)) {
            return Math.sin(param1);
        }
        if (FUNCTION_ASIN.equals(funcName)) {
            return Math.asin(param1);
        }
        if (FUNCTION_COS.equals(funcName)) {
            return Math.cos(param1);
        }
        if (FUNCTION_ACOS.equals(funcName)) {
            return Math.acos(param1);
        }
        if (FUNCTION_TAN.equals(funcName)) {
            return Math.tan(param1);
        }
        if (FUNCTION_ATAN.equals(funcName)) {
            return Math.atan(param1);
        }
        return null;
    }

    private Object mathFuncSet2(List<Object> paramList, String funcName) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Number) || !(paramList.get(1) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        double param1 = Double.parseDouble(paramList.get(0).toString());
        double param2 = Double.parseDouble(paramList.get(1).toString());
        if (FUNCTION_LOG.equals(funcName)) {
            return Math.log(param2) / Math.log(param1);
        }
        if (FUNCTION_POWER.equals(funcName)) {
            return Math.pow(param1, param2);
        }
        if (FUNCTION_MOD.equals(funcName)) {
            return param1 % param2;
        }
        return null;
    }

    private Object convertBigDecimal(List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null) {
            return 0;
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(FUNCTION_CONVERTBIGDECIMAL, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(FUNCTION_CONVERTBIGDECIMAL, 1);
        }
        if (paramList.get(0) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof BigDecimal)) {
            throw new InvokeFunctionException(FUNCTION_CONVERTBIGDECIMAL, 3);
        }
        return ((BigDecimal)paramList.get(0)).intValue();
    }

    private Object ignoreNull(String funcName, List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null) {
            return null;
        }
        if (paramList.isEmpty()) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 1) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null) {
            if (FUNCTION_IGNORENULLSTRING.equals(funcName)) {
                return "";
            }
            if (FUNCTION_IGNORENULLNUMBER.equals(funcName)) {
                return 0;
            }
        }
        return paramList.get(0);
    }

    private BigDecimal round(String funcName, List<Object> paramList) throws InvokeFunctionException {
        if (paramList == null) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() < 2) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 2) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(0) == null || paramList.get(1) == null) {
            return null;
        }
        if (!(paramList.get(0) instanceof Number) || !(paramList.get(1) instanceof Number)) {
            throw new InvokeFunctionException(funcName, 3);
        }
        BigDecimal dSource = new BigDecimal(paramList.get(0).toString());
        int oldScale = dSource.scale();
        int scale = Integer.parseInt(paramList.get(1).toString());
        if (scale < 0) {
            throw new InvokeFunctionException(funcName, "The scale must be a positive integer or zero");
        }
        if (scale > oldScale) {
            scale = oldScale;
        }
        BigDecimal one = new BigDecimal("1");
        return dSource.divide(one, scale, 4);
    }

    @Override
    public Object evalFunction(String funcName, List<Object> paramList) throws FieldRuleFormulaException {
        if (funcName == null) {
            return null;
        }
        try {
            if (FUNCTION_ROUND.equals(funcName)) {
                return this.round(funcName, paramList);
            }
            if (FUNCTION_NOW.equals(funcName)) {
                return this.now(paramList);
            }
            if (FUNCTION_FORMATJAVADATE.equals(funcName)) {
                return BaseFieldRuleFunctions.formatJavaDate(paramList);
            }
            if (FUNCTION_CONVERTJAVADATE.equals(funcName)) {
                return this.convertJavaDate(paramList);
            }
            if (FUNCTION_CONVERTSTRDATE.equals(funcName)) {
                return this.convertStrDate(paramList);
            }
            if (FUNCTION_DATETOMILLISECONDS.equals(funcName)) {
                return this.dateToMilliseconds(paramList);
            }
            if (FUNCTION_JAVADATEDIFF.equals(funcName) || FUNCTION_DATEDIFF.equals(funcName) || FUNCTION_HOURANDMINUTEDIFF.equals(funcName) || FUNCTION_JAVADATETIMEDIFF.equals(funcName)) {
                return this.javaDateFuncSet2(paramList, funcName);
            }
            if (FUNCTION_YEAR.equals(funcName) || FUNCTION_MONTH.equals(funcName) || FUNCTION_DATE.equals(funcName) || FUNCTION_HOUR.equals(funcName) || FUNCTION_MINUTE.equals(funcName) || FUNCTION_SECOND.equals(funcName) || FUNCTION_YEARDAY.equals(funcName) || FUNCTION_WEEKDAY.equals(funcName) || FUNCTION_DATEVALUE.equals(funcName)) {
                return this.timeFuncSetString(paramList, funcName);
            }
            if (FUNCTION_DATEADD.equals(funcName)) {
                return this.timeFuncDateAdd(paramList);
            }
            if (FUNCTION_DAYS.equals(funcName) || FUNCTION_HOURS.equals(funcName) || FUNCTION_MILLISECONDS.equals(funcName) || FUNCTION_MINUTES.equals(funcName) || FUNCTION_SECONDS.equals(funcName) || FUNCTION_TICKS.equals(funcName) || FUNCTION_TOTALDAYS.equals(funcName) || FUNCTION_TOTALHOURS.equals(funcName) || FUNCTION_TOTALMILLISECONDS.equals(funcName) || FUNCTION_TOTALMINUTES.equals(funcName) || FUNCTION_TOTALSECONDS.equals(funcName)) {
                return this.timeFuncSetInt(paramList, funcName);
            }
            if (FUNCTION_TRIM.equals(funcName)) {
                return this.trim(paramList);
            }
            if (FUNCTION_LEFT.equals(funcName) || FUNCTION_RIGHT.equals(funcName) || FUNCTION_REPT.equals(funcName)) {
                return this.stringFuncSet(paramList, funcName);
            }
            if (FUNCTION_UPPER.equals(funcName) || FUNCTION_LOWER.equals(funcName) || FUNCTION_ISEMPTY.equals(funcName)) {
                return this.stringFuncSet1(paramList, funcName);
            }
            if (FUNCTION_SPLIT.equals(funcName) || FUNCTION_EQUALS.equals(funcName) || FUNCTION_EQUALSIGNORECASE.equals(funcName) || FUNCTION_ENDSWITH.equals(funcName) || FUNCTION_ENDSWITHIGNORE.equals(funcName)) {
                return this.stringFuncSet2(paramList, funcName);
            }
            if (FUNCTION_REPLACE.equals(funcName) || FUNCTION_REPLACEIGNORECASE.equals(funcName) || FUNCTION_STARTSWITH.equals(funcName) || FUNCTION_STARTSWITHIGNORECASE.equals(funcName) || FUNCTION_INDEXOF.equals(funcName) || FUNCTION_INDEXOFIGNORECASE.equals(funcName) || FUNCTION_LASTINDEXOF.equals(funcName) || "lastIndexOfIgnoreCase".equals(funcName)) {
                return this.stringFuncSet3(paramList, funcName);
            }
            if (FUNCTION_CONTAINSSTR.equals(funcName)) {
                return this.containsStr(paramList);
            }
            if (FUNCTION_PI.equals(funcName) || FUNCTION_RAND.equals(funcName)) {
                return this.mathFuncSet0(paramList, funcName);
            }
            if (FUNCTION_SQRT.equals(funcName) || FUNCTION_INT.equals(funcName) || FUNCTION_LN.equals(funcName) || FUNCTION_LOG10.equals(funcName) || FUNCTION_EXP.equals(funcName) || FUNCTION_DEGREES.equals(funcName) || FUNCTION_RADIANS.equals(funcName) || FUNCTION_SIN.equals(funcName) || FUNCTION_ASIN.equals(funcName) || FUNCTION_COS.equals(funcName) || FUNCTION_ACOS.equals(funcName) || FUNCTION_TAN.equals(funcName) || FUNCTION_ATAN.equals(funcName)) {
                return this.mathFuncSet1(paramList, funcName);
            }
            if (FUNCTION_CONVERTBIGDECIMAL.equals(funcName)) {
                return this.convertBigDecimal(paramList);
            }
            if (FUNCTION_LOG.equals(funcName) || FUNCTION_POWER.equals(funcName) || FUNCTION_MOD.equals(funcName)) {
                return this.mathFuncSet2(paramList, funcName);
            }
            if (FUNCTION_IGNORENULLSTRING.equals(funcName) || FUNCTION_IGNORENULLNUMBER.equals(funcName)) {
                return this.ignoreNull(funcName, paramList);
            }
        }
        catch (InvokeFunctionException e) {
            throw new FieldRuleFormulaException(e.toString(), e);
        }
        return null;
    }
}

