/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.formula.parse;

import com.kingdee.shr.base.syssetting.fieldrule.formula.CodeObject;
import com.kingdee.shr.base.syssetting.fieldrule.formula.ParserException;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.AbstractParser;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Lexer;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Source;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.StmtParser;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.Token;
import com.kingdee.shr.base.syssetting.fieldrule.formula.parse.TokenList;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.CodeStmt;
import com.kingdee.shr.base.syssetting.fieldrule.formula.stmt.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FieldRuleScriptParser
extends AbstractParser {
    public final List<String> namespaces;
    public final Map<String, Object> classMap;
    public Source source = null;
    public List<CodeStmt> stmtList = new ArrayList<CodeStmt>();
    public Map<String, Function> functionDeclMap = new HashMap<String, Function>();
    public Map<String, Object> classDeclMap = new HashMap<String, Object>();

    public FieldRuleScriptParser(String text) throws ParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
        this.namespaces = new ArrayList<String>();
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap = new HashMap<String, Object>();
    }

    public FieldRuleScriptParser(TokenList tokList) {
        this._tokenList = tokList;
        this.namespaces = new ArrayList<String>();
        this.namespaces.add("java.lang");
        this.namespaces.add("java.util");
        this.classMap = new HashMap<String, Object>();
    }

    public FieldRuleScriptParser(TokenList tokList, List<String> namespaces, Map<String, Object> classMap) {
        this._tokenList = tokList;
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public FieldRuleScriptParser(String text, List<String> namespaces, Map<String, Object> classMap) throws ParserException {
        this(new Source(text), namespaces, classMap);
    }

    public FieldRuleScriptParser(Source source, List<String> namespaces, Map<String, Object> classMap) throws ParserException {
        this.source = source;
        Lexer lexer = new Lexer(source);
        this._tokenList = new TokenList(lexer);
        this.namespaces = namespaces;
        this.classMap = classMap;
    }

    public void parse() throws ParserException {
        StmtParser stmtParser = new StmtParser(this._tokenList, this.namespaces, this.classMap);
        while (!this._tokenList.lookup(0).equals(Token.EOFToken)) {
            CodeStmt stmt = stmtParser.stmt();
            if (stmt == null) continue;
            stmt.validate();
            this.stmtList.add(stmt);
        }
    }

    public String outputResult() {
        StringBuffer buff = new StringBuffer();
        this.outputResult(buff);
        return buff.toString();
    }

    public void outputResult(StringBuffer buff) {
        boolean flag = false;
        Iterator<CodeObject> iter = this.functionDeclMap.values().iterator();
        while (iter.hasNext()) {
            if (flag) {
                buff.append("\n\n");
            }
            Function funDecl = iter.next();
            funDecl.output(buff, null);
        }
        if (flag) {
            buff.append("\n\n");
        }
        flag = false;
        iter = this.stmtList.iterator();
        while (iter.hasNext()) {
            if (flag) {
                buff.append("\n");
            }
            CodeStmt stmt = (CodeStmt)iter.next();
            stmt.output(buff, null);
            flag = true;
        }
    }
}

