/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.processor;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.shr.base.syssetting.fieldrule.FieldRuleUtils;
import com.kingdee.shr.base.syssetting.fieldrule.IFieldRuleProcessor;
import com.kingdee.shr.base.syssetting.fieldrule.formula.FieldRuleFormulaEngine;
import com.kingdee.shr.base.syssetting.fieldrule.model.DefaultValueConfig;
import com.kingdee.shr.base.syssetting.fieldrule.model.DefaultValueRule;
import com.kingdee.shr.base.syssetting.fieldrule.model.Field;
import com.kingdee.shr.base.syssetting.fieldrule.model.type.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultValueProcessor
implements IFieldRuleProcessor {
    private Context ctx;
    private DefaultValueRule defaultValueRule;

    public DefaultValueProcessor(Context ctx, DefaultValueRule defaultValueRule) {
        this.ctx = ctx;
        this.defaultValueRule = defaultValueRule;
    }

    @Override
    public void exec(Map<String, Object> params) {
        HashMap<String, Object> defaultValueRuleMap = new HashMap<String, Object>();
        this.parseDefaultValueConfig(this.defaultValueRule.getConfig(), defaultValueRuleMap);
        defaultValueRuleMap.put("priority", this.defaultValueRule.getPriority());
        params.put("defaultValueRule", defaultValueRuleMap);
    }

    private void parseDefaultValueConfig(List<DefaultValueConfig> configs, Map<String, Object> defaultValueRuleMap) {
        HashMap<String, Object> editGridFieldValue = new HashMap<String, Object>();
        HashMap<String, Object> groupFieldValue = new HashMap<String, Object>();
        for (DefaultValueConfig defaultValueRuleConfig : configs) {
            if (!defaultValueRuleConfig.isEnable()) continue;
            Field field = defaultValueRuleConfig.getField();
            String dataTypeName = field.getDataType();
            String valueType = defaultValueRuleConfig.getValueType();
            Object value = defaultValueRuleConfig.getValue();
            if (Type.VARIABLE.name().equalsIgnoreCase(valueType)) {
                value = FieldRuleUtils.getVariableValue(this.ctx, (String)value);
            } else if (Type.FUNCTION.name().equalsIgnoreCase(valueType)) {
                String formulaStr = this.getFormulaStr(value);
                value = this.getFunctionValue(formulaStr, this.initParams(editGridFieldValue, groupFieldValue, formulaStr));
            }
            if (DataType.BOOLEAN.getName().equalsIgnoreCase(dataTypeName)) {
                this.setDefaultValue(editGridFieldValue, groupFieldValue, field, FieldRuleUtils.getBooleanFieldValue(value));
                continue;
            }
            if (DataType.OBJECTVALUE.getName().equalsIgnoreCase(dataTypeName)) {
                this.setDefaultValue(editGridFieldValue, groupFieldValue, field, FieldRuleUtils.getF7FieldValue(this.ctx, value, field.getFullName(), field.getSubmitFormat()));
                continue;
            }
            if (DataType.STRING.getName().equalsIgnoreCase(dataTypeName)) {
                this.setDefaultValue(editGridFieldValue, groupFieldValue, field, FieldRuleUtils.getLocalValue(this.ctx, value));
                continue;
            }
            if (DataType.DATE.getName().equalsIgnoreCase(dataTypeName) || DataType.TIME.getName().equalsIgnoreCase(dataTypeName) || DataType.TIMESTAMP.getName().equalsIgnoreCase(dataTypeName)) {
                this.setDefaultValue(editGridFieldValue, groupFieldValue, field, FieldRuleUtils.getDateFieldValue(value));
                continue;
            }
            if (Boolean.TRUE.equals(FieldRuleUtils.isNumberType(dataTypeName))) {
                this.setDefaultValue(editGridFieldValue, groupFieldValue, field, FieldRuleUtils.getNumberFieldValue(dataTypeName, value));
                continue;
            }
            if (DataType.ENUM.getName().equals(dataTypeName)) {
                this.setDefaultValue(editGridFieldValue, groupFieldValue, field, FieldRuleUtils.getEnumFieldValue(field.getFullName(), value));
                continue;
            }
            this.setDefaultValue(editGridFieldValue, groupFieldValue, field, value);
        }
        defaultValueRuleMap.put("groupFieldValue", groupFieldValue);
        defaultValueRuleMap.put("editGridFieldValue", editGridFieldValue);
    }

    private Object getFunctionValue(String formulaStr, Map<String, Object> params) {
        return FieldRuleFormulaEngine.runFormula(formulaStr, params, this.ctx);
    }

    private Map<String, Object> initParams(Map<String, Object> editGridFieldValue, Map<String, Object> groupFieldValue, String value) {
        Map<String, Object> params = FieldRuleFormulaEngine.parseFormulaVariable(this.ctx, value);
        String mainKey = null;
        for (String key : params.keySet()) {
            if (key.indexOf("Main#") == -1) continue;
            mainKey = key;
        }
        Object mainObjectValue = params.get(mainKey);
        if (mainObjectValue instanceof IObjectValue) {
            this.assemableCoreBaseInfo(editGridFieldValue, groupFieldValue, (IObjectValue)mainObjectValue);
            String modelName = mainKey.substring(mainKey.indexOf("Main#") + 5);
            params.put(modelName, mainObjectValue);
            params.remove(mainKey);
        }
        return params;
    }

    private void assemableCoreBaseInfo(Map<String, Object> editGridFieldValue, Map<String, Object> groupFieldValue, IObjectValue coreBaseInfo) {
        for (Map.Entry<String, Object> entry : groupFieldValue.entrySet()) {
            coreBaseInfo.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, List<Object>> dynamicComposeFiledRuntimeClassMapping = new HashMap<String, List<Object>>();
        for (Map.Entry<String, Object> entry : editGridFieldValue.entrySet()) {
            String field = entry.getKey();
            String entryKey = field.split("\\.")[0];
            String entryField = field.split("\\.")[1];
            Object coll = coreBaseInfo.get(entryKey);
            if (!(coll instanceof IObjectCollection)) continue;
            DefaultValueProcessor.setComposeFiledDefaultFieldValue((IObjectCollection)coll, coreBaseInfo, dynamicComposeFiledRuntimeClassMapping, entryKey, entryField, entry.getValue());
        }
    }

    private static IObjectValue setComposeFiledDefaultFieldValue(IObjectCollection coll, IObjectValue coreBaseInfo, Map<String, List<Object>> dynamicRuntimeClassMapping, String entrysKey, String entrysField, Object defaultValue) {
        Class<?> collectionClass = null;
        Class<?> infoClass = null;
        Method addMethod = null;
        Method putMethod = null;
        List<Object> list = null;
        Object collInstance = null;
        Object infoInstance = null;
        try {
            if (null != dynamicRuntimeClassMapping.get(entrysKey)) {
                list = dynamicRuntimeClassMapping.get(entrysKey);
                DefaultValueProcessor.dynamicSetEntrysFiledDefaultValue(list, coll, coreBaseInfo, entrysKey, entrysField, defaultValue);
            } else {
                String collectionClassName = coll.getClass().getName();
                String infoClasName = collectionClassName.substring(0, collectionClassName.lastIndexOf("Collection")) + "Info";
                collectionClass = Class.forName(collectionClassName);
                infoClass = Class.forName(infoClasName);
                addMethod = collectionClass.getMethod("add", infoClass);
                putMethod = infoClass.getMethod("put", String.class, Object.class);
                collInstance = collectionClass.newInstance();
                infoInstance = infoClass.newInstance();
                list = new ArrayList<Object>();
                list.add(addMethod);
                list.add(putMethod);
                list.add(collInstance);
                list.add(infoInstance);
                dynamicRuntimeClassMapping.put(entrysKey, list);
                DefaultValueProcessor.dynamicSetEntrysFiledDefaultValue(list, coll, coreBaseInfo, entrysKey, entrysField, defaultValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return coreBaseInfo;
    }

    private static void dynamicSetEntrysFiledDefaultValue(List<Object> list, IObjectCollection coll, IObjectValue coreBaseInfo, String entryKey, String entrysField, Object defaultValue) {
        try {
            Method addMethod = (Method)list.get(0);
            Method putMethod = (Method)list.get(1);
            Object collInstance = list.get(2);
            Object infoInstance = list.get(3);
            if (coll.isEmpty()) {
                addMethod.invoke(collInstance, infoInstance);
                coreBaseInfo.put(entryKey, collInstance);
            } else {
                infoInstance = coll.getObject(0);
            }
            putMethod.invoke(infoInstance, entrysField, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getFormulaStr(Object value) {
        if (value instanceof Map) {
            Map condition = (Map)value;
            return (String)condition.get("value");
        }
        return null;
    }

    private void setDefaultValue(Map<String, Object> editGridFieldValue, Map<String, Object> groupFieldValue, Field field, Object defaultValue) {
        if (null != defaultValue) {
            String fieldName = field.getName();
            if (field.isEditGridField()) {
                editGridFieldValue.put(fieldName, defaultValue);
            } else {
                groupFieldValue.put(fieldName, defaultValue);
            }
        }
    }
}

