/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.ShrVersion;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.Configuration;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public final class SHRSyssettingUtil {
    private static String PtmNO;
    private static Properties kingdeeSupportConfigProperties;
    private static Logger logger;

    private SHRSyssettingUtil() {
    }

    public static String getShrWebWarPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getEasWebWarPath()).append(File.separator).append("shr_web.war");
        return sb.toString();
    }

    public static String getShrWebWarTmpPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getShrWebWarPath()).append(File.separator).append("tmp");
        return sb.toString();
    }

    public static String getShrWebWarNewZipFolderPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getShrWebWarPath()).append(File.separator).append("newZipFolder");
        return sb.toString();
    }

    public static String getEasWebWarPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getDeployPath()).append(File.separator).append("easweb.ear");
        return sb.toString();
    }

    public static String getEASHomePath() {
        return System.getProperty("EAS_HOME");
    }

    public static String getIotmpdir() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getEASHomePath()).append(File.separator).append("iotmpdir");
        return sb.toString();
    }

    public static String getServerPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getEASHomePath()).append(File.separator).append("server");
        return sb.toString();
    }

    public static String getProperitesPath() {
        return FilenameUtils.normalize((String)System.getProperty("eas.properties.dir"));
    }

    public static String getDeployPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getServerPath()).append(File.separator).append("deploy");
        return sb.toString();
    }

    public static String getDeployEastemplatePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getDeployPath()).append(File.separator).append("eastemplate");
        return sb.toString();
    }

    public static String getDeployEastemplateReportPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getDeployEastemplatePath()).append(File.separator).append("report");
        return sb.toString();
    }

    public static String getShrPropertiesPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getProperitesPath()).append(File.separator).append("shr");
        return sb.toString();
    }

    public static String getPropertiesPathByFileName(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getProperitesPath()).append(File.separator).append(fileName);
        return sb.toString();
    }

    public static String getShrPropertiesPathByFileName(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getShrPropertiesPath()).append(File.separator).append(fileName);
        return sb.toString();
    }

    public static String getShrPropertiesSensitive() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getShrPropertiesPath()).append(File.separator).append("sensitive");
        return sb.toString();
    }

    public static String getMetadataconfigPathByFileName(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getShrPropertiesPath()).append(File.separator).append("metadataconfig").append(File.separator).append(fileName);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFileByPath(String path) throws IOException {
        Properties p = new Properties();
        FileInputStream fis = null;
        Reader in = null;
        if (StringUtils.isEmpty((String)path)) {
            return p;
        }
        File f = new File(path);
        if (!f.exists()) {
            return p;
        }
        try {
            fis = new FileInputStream(new File(SHRCheck.checkFilePath(path)));
            in = new InputStreamReader((InputStream)fis, "UTF-8");
            p.load(in);
        }
        catch (IOException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return p;
    }

    public static Document getXmlFileByPath(String path) throws JDOMException, IOException {
        Document d = new Document();
        if (StringUtils.isEmpty((String)path)) {
            return d;
        }
        File f = new File(SHRCheck.checkFilePath(path));
        if (!f.exists()) {
            return null;
        }
        SAXBuilder builder = new SAXBuilder();
        XMLUtil.setReaderFeature((SAXBuilder)builder);
        d = builder.build(path);
        return d;
    }

    public static String getProfilesPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getServerPath()).append(File.separator).append("profiles");
        return sb.toString();
    }

    public static String getConfigPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getProfilesPath()).append(File.separator).append("{0}").append(File.separator).append("config");
        return MessageFormat.format(sb.toString(), serverName);
    }

    public static String getPortalConfigPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getConfigPath(serverName)).append(File.separator).append("portalConfig");
        return sb.toString();
    }

    public static String getAutoLoginConfigPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getPortalConfigPath(serverName)).append(File.separator).append("autoLoginConfig.properties");
        return sb.toString();
    }

    public static String getEasAuthPatternsPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getPortalConfigPath(serverName)).append(File.separator).append("easAuthPatterns.xml");
        return sb.toString();
    }

    public static String getSsoClientPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getPortalConfigPath(serverName)).append(File.separator).append("ssoClient.properties");
        return sb.toString();
    }

    public static String getListenerConfigPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getConfigPath(serverName)).append(File.separator).append("listenerconfig.data");
        return sb.toString();
    }

    public static String getWebPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("APP_SERVER_HOME")).append(File.separator).append("domains").append(File.separator).append(serverName).append(File.separator).append("config").append(File.separator).append("web.xml");
        return sb.toString();
    }

    public static String getLtpaTokenPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getPortalConfigPath(serverName)).append(File.separator).append("LtpaToken.properties");
        return sb.toString();
    }

    public static String getWebservicePath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getConfigPath(serverName)).append(File.separator).append("webservice.properties");
        return sb.toString();
    }

    public static String getJmxconnectorPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getConfigPath(serverName)).append(File.separator).append("jmxconnector.properties");
        return sb.toString();
    }

    public static String getCurrentLoginServer() {
        String serverName = System.getProperty("EAS_INSTANCE_NAME");
        return serverName;
    }

    public static String getLogsPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getProfilesPath()).append(File.separator).append(serverName).append(File.separator).append("logs");
        return sb.toString();
    }

    public static String getVmPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("APP_SERVER_HOME")).append(File.separator).append("domains").append(File.separator).append(serverName).append(File.separator).append("config").append(File.separator).append("vm.options");
        return sb.toString();
    }

    public static String getLoggingPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("APP_SERVER_HOME")).append(File.separator).append("domains").append(File.separator).append(serverName).append(File.separator).append("config").append(File.separator).append("logging.xml");
        return sb.toString();
    }

    public static String getApusicPath(String serverName) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("APP_SERVER_HOME")).append(File.separator).append("domains").append(File.separator).append(serverName).append(File.separator).append("config").append(File.separator).append("apusic.conf");
        return sb.toString();
    }

    public static String getImageFilePath(String imageFileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getEasWebWarPath()).append(File.separator).append("shr_web.war").append(File.separator).append("images").append(File.separator).append(imageFileName);
        return sb.toString();
    }

    public static int getExceptionCellNumberMaxRows(int coloumLength) {
        String exceptionCellNumber = Configuration.getInstance().getConfigItem("DebugOptions").getProperty("exceptionCellNumber");
        int exceptionCellNumber0 = 1000000;
        if (!StringUtils.isEmpty((String)exceptionCellNumber)) {
            exceptionCellNumber0 = Integer.parseInt(exceptionCellNumber);
        }
        --exceptionCellNumber0;
        if (coloumLength <= 0) {
            return exceptionCellNumber0;
        }
        return exceptionCellNumber0 / coloumLength;
    }

    public static String getPtmNO(Context ctx) {
        if (PtmNO != null) {
            return PtmNO;
        }
        String sql = "select * from T_SYS_DatacenterSHR";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                int major = rowSet.getInt("FMajor");
                int minor = rowSet.getInt("FMinor");
                int build = rowSet.getInt("FBuild");
                int bim = rowSet.getInt("FBim");
                PtmNO = major + "." + minor + "." + build + "." + bim;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return PtmNO;
    }

    public static String getShrUIviewTemplatePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getEasWebWarPath()).append(File.separator).append("shr_web.war").append(File.separator).append("WEB-INF").append(File.separator).append("freemarker").append(File.separator).append("shr").append(File.separator).append("base").append(File.separator).append("view");
        return sb.toString();
    }

    public static Properties getKingdeeSupportConfigProperties() {
        return kingdeeSupportConfigProperties;
    }

    public static String getShrVersion(Context ctx) throws BOSException {
        ShrVersion v = SHRSyssettingUtil.getShrVersion();
        return v.getVersion(ctx);
    }

    public static ShrVersion getShrVersion() throws BOSException {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getProperitesPath()).append(File.separator).append("shr-version.data");
        File f = new File(sb.toString());
        if (!f.exists()) {
            return null;
        }
        SAXBuilder builder = new SAXBuilder();
        XMLUtil.setReaderFeature((SAXBuilder)builder);
        try {
            Document d = builder.build(sb.toString());
            ShrVersion v = new ShrVersion();
            Element e = d.getRootElement();
            v.setDevelopVersion(e.getAttributeValue("developVersion"));
            v.setProductVersion(e.getAttributeValue("productVersion"));
            v.setPatch(e.getAttributeValue("patch"));
            Element i = e.getChild("Information");
            List ls = i.getChildren("FullName");
            HashMap<String, String> fullName = new HashMap<String, String>();
            for (Element l : ls) {
                fullName.put(l.getAttributeValue("language"), l.getText());
            }
            v.setFullName(fullName);
            return v;
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    static {
        kingdeeSupportConfigProperties = new Properties();
        try {
            kingdeeSupportConfigProperties = SHRSyssettingUtil.getPropertiesFileByPath(SHRSyssettingUtil.getShrPropertiesPathByFileName("KingdeeSupportConfig.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger = Logger.getLogger(SHRSyssettingUtil.class);
    }
}

