/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermItemURL;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemURLFactory;
import com.kingdee.eas.base.permission.PermItemURLInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BasicItemType;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public final class SysSettingPermItemUtil {
    private static Logger logger = Logger.getLogger(SysSettingPermItemUtil.class);
    private static Map<String, Map<String, String>> mappingMap = new HashMap<String, Map<String, String>>();
    private static final String COMMON = "common";
    private static final String PERSON = "person";
    private static final String ORG = "org";
    private static final String COMPENSATION = "compensation";
    private static final String INSURANCE = "insurance";
    private static final String ATS = "ats";
    private static final String RECRUIT = "recruit";
    private static final String MAINTAIN = "maintain";
    private static final String AVAVAILABLE = "avavailable";
    private static final String URL = "/dynamic.do?method=initalize#uri=";

    private SysSettingPermItemUtil() {
    }

    private static void init() throws EASBizException {
        StringBuilder sb = new StringBuilder();
        sb.append(SHRSyssettingUtil.getShrPropertiesPath()).append(File.separator).append("levelup").append(File.separator).append("permItemMapping.xml");
        try {
            Document document = SHRSyssettingUtil.getXmlFileByPath(sb.toString());
            Element root = document.getRootElement();
            List list1 = root.getChildren();
            for (Element ele : list1) {
                HashMap<String, String> item = new HashMap<String, String>();
                List list2 = ele.getChildren();
                for (Element elesub : list2) {
                    item.put(elesub.getName(), elesub.getText());
                }
                mappingMap.put(ele.getName(), item);
            }
        }
        catch (JDOMException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{e.getMessage()});
        }
    }

    public static void handlerPermItemUrlInfo(Context ctx, SHRBasicItemInfo shrBasicItemInfo, String enetityAlias, List<String> maintainUipks, List<String> availableUipks) throws BOSException, EASBizException {
        if (null == mappingMap || mappingMap.size() <= 0) {
            SysSettingPermItemUtil.init();
        }
        ArrayList<String> maintainUrls = new ArrayList<String>();
        ArrayList<String> availableUrls = new ArrayList<String>();
        if (null != maintainUipks && !maintainUipks.isEmpty()) {
            for (String uipk : maintainUipks) {
                maintainUrls.add(URL + uipk);
            }
        }
        if (null != availableUipks && !availableUipks.isEmpty()) {
            for (String uipk : availableUipks) {
                availableUrls.add(URL + uipk);
            }
        }
        IPermItem iPermItem = PermItemFactory.getLocalInstance((Context)ctx);
        IPermItemURL iPermItemURL = PermItemURLFactory.getLocalInstance((Context)ctx);
        Map<String, String> map = null;
        if (BasicItemType.COMMON.equals((Object)shrBasicItemInfo.getType())) {
            map = mappingMap.get(COMMON);
        } else if (BasicItemType.ADMIN.equals((Object)shrBasicItemInfo.getType())) {
            map = mappingMap.get(ORG);
        } else if (BasicItemType.PERSON.equals((Object)shrBasicItemInfo.getType())) {
            map = mappingMap.get(PERSON);
        } else if (BasicItemType.COMPENSATION.equals((Object)shrBasicItemInfo.getType())) {
            map = mappingMap.get(COMPENSATION);
        } else if (BasicItemType.INSURANCE.equals((Object)shrBasicItemInfo.getType())) {
            map = mappingMap.get(INSURANCE);
        } else if (BasicItemType.ATS.equals((Object)shrBasicItemInfo.getType())) {
            map = mappingMap.get(ATS);
        } else if (BasicItemType.RECRUIT.equals((Object)shrBasicItemInfo.getType())) {
            map = mappingMap.get(RECRUIT);
        }
        if (null == map || map.size() <= 0) {
            return;
        }
        PermItemInfo maintainPermItem = iPermItem.getPermItemInfo((IObjectPK)new ObjectUuidPK(map.get(MAINTAIN)));
        PermItemInfo avavailablePermItem = iPermItem.getPermItemInfo((IObjectPK)new ObjectUuidPK(map.get(AVAVAILABLE)));
        SysSettingPermItemUtil.handlerUrl(iPermItemURL, maintainPermItem, maintainUrls, enetityAlias);
        SysSettingPermItemUtil.handlerUrl(iPermItemURL, avavailablePermItem, availableUrls, enetityAlias);
    }

    private static void handlerUrl(IPermItemURL iPermItemURL, PermItemInfo model, List<String> urls, String enetityAlias) throws EASBizException, BOSException {
        if (null == urls || urls.isEmpty()) {
            return;
        }
        FilterInfo filter = null;
        for (String url : urls) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("url", (Object)url));
            if (iPermItemURL.exists(filter)) {
                iPermItemURL.delete(filter);
            }
            PermItemURLInfo urlInfo = SysSettingPermItemUtil.generatePermItemURLInfo(model, url, enetityAlias);
            iPermItemURL.save((CoreBaseInfo)urlInfo);
        }
    }

    private static PermItemURLInfo generatePermItemURLInfo(PermItemInfo model, String url, String enetityAlias) {
        PermItemURLInfo info = new PermItemURLInfo();
        info.setUrl(url);
        info.setParent(model);
        info.setName(enetityAlias);
        return info;
    }
}

