/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BaseItemLevelUpRecordInfo;
import com.kingdee.shr.base.syssetting.CustomBaseItemUIViewEnum;
import com.kingdee.shr.base.syssetting.IBaseItemLevelUpRecord;
import com.kingdee.shr.base.syssetting.IUIView;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.util.BaseItemRelationHRUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRFileTemplateUtil;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingPermItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBasicItemUtil;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class SysSettingUIViewUtil {
    private SysSettingUIViewUtil() {
    }

    private static BaseItemLevelUpRecordInfo initBaseItemLevelUpRecord(int batchNumber, SHRBasicItemInfo shrBasicItemInfo, int stepNumber, String stepName, boolean isSuccess, String errorMessage) {
        BaseItemLevelUpRecordInfo model = new BaseItemLevelUpRecordInfo();
        model.setBatchNumber(batchNumber);
        model.setBasicItem(shrBasicItemInfo);
        model.setStepIndex(stepNumber);
        model.setIsSuccess(isSuccess);
        model.setErrorMessage(errorMessage);
        model.setStepName(stepName);
        return model;
    }

    public static IObjectPK batchCreateBaseItemUIViews(Context ctx, UIViewInfo model, boolean isProductionMode, IBaseItemLevelUpRecord iBaseItemLevelUpRecord, int batchNumber) throws EASBizException, BOSException {
        Locale locale;
        IObjectPK maintainListPK = null;
        String errorMessage = "";
        String stepName = SHRSysSettingResourceUtil.getResource("create_views", ctx);
        if (null == model) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{SHRSysSettingResourceUtil.getResource("view_empty", ctx)});
        }
        if (null != model.getId()) {
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{SHRSysSettingResourceUtil.getResource("id_must_be_null", ctx)});
        }
        SHRBasicItemInfo _shrBasicItemInfo_ = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, model.getModel());
        try {
            SysSettingSHRBaseItemUtil.checkEntityNameValid(ctx, model.getModel());
        }
        catch (EASBizException e) {
            errorMessage = SHRSysSettingResourceUtil.getResource("check_error", ctx, e.getMessage());
            iBaseItemLevelUpRecord.save((CoreBaseInfo)SysSettingUIViewUtil.initBaseItemLevelUpRecord(batchNumber, _shrBasicItemInfo_, 6, stepName, false, errorMessage));
            throw e;
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, model.getModel());
        if (null == entityObjectInfo || null == entityObjectInfo.getBOSType()) {
            errorMessage = SHRSysSettingResourceUtil.getResource("entity_not_exist", ctx, model.getModel());
            iBaseItemLevelUpRecord.save((CoreBaseInfo)SysSettingUIViewUtil.initBaseItemLevelUpRecord(batchNumber, _shrBasicItemInfo_, 6, stepName, false, errorMessage));
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{errorMessage});
        }
        if (!SysSettingSHRBaseItemUtil.isSHRBaseItem(entityObjectInfo.getBaseEntity())) {
            errorMessage = SHRSysSettingResourceUtil.getResource("unble_create_view", ctx, model.getModel(), "com.kingdee.shr.base.syssetting.app.SHRBaseItem");
            iBaseItemLevelUpRecord.save((CoreBaseInfo)SysSettingUIViewUtil.initBaseItemLevelUpRecord(batchNumber, _shrBasicItemInfo_, 6, stepName, false, errorMessage));
            throw new BaseItemException(BaseItemException.CUSTOM_EXCEPTION, new Object[]{errorMessage});
        }
        HashMap<String, String> enetityAliasMap = new HashMap<String, String>();
        List<Map<String, String>> languageMapingList = BOSConfigUtil.getLanguageMapingList();
        if (!StringUtils.isEmpty((String)model.getName())) {
            for (Map<String, String> lan : languageMapingList) {
                locale = LocaleUtils.getLocale(lan.get("lang"));
                enetityAliasMap.put(lan.get("lang"), model.getName(locale));
            }
        } else if (StringUtils.isEmpty((String)entityObjectInfo.getAlias())) {
            for (Map<String, String> lan : languageMapingList) {
                locale = LocaleUtils.getLocale(lan.get("lang"));
                enetityAliasMap.put(lan.get("lang"), entityObjectInfo.getName());
            }
        } else {
            for (Map<String, String> lan : languageMapingList) {
                locale = LocaleUtils.getLocale(lan.get("lang"));
                enetityAliasMap.put(lan.get("lang"), entityObjectInfo.getAlias(locale));
            }
        }
        String useUIPK = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".available", ".list");
        String maintainUIPK = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".maintain", ".list");
        ArrayList<String> maintainUipks = new ArrayList<String>();
        ArrayList<String> availableUipks = new ArrayList<String>();
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_MAINTAIN_FORM, maintainUipks, availableUipks);
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_MAINTAIN_SEARCH, maintainUipks, availableUipks);
        maintainListPK = SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_MAINTAIN_LIST, maintainUipks, availableUipks);
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_AVAILABLE_FORM, maintainUipks, availableUipks);
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_AVAILABLE_SEARCH, maintainUipks, availableUipks);
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_AVAILABLE_LIST, maintainUipks, availableUipks);
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_VIEW_DISTRIBUTE_SEARCH, maintainUipks, availableUipks);
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_VIEW_DISTRIBUTE_LIST, maintainUipks, availableUipks);
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_F7, maintainUipks, availableUipks);
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_F7_SEARCH, maintainUipks, availableUipks);
        SysSettingUIViewUtil.createBaseItemUIView(ctx, model, entityObjectInfo, enetityAliasMap, isProductionMode, CustomBaseItemUIViewEnum.BASE_ITEM_FASTFILTER_F7, maintainUipks, availableUipks);
        errorMessage = SHRSysSettingResourceUtil.getResource("unble_create_view", ctx, entityObjectInfo.getFullName());
        iBaseItemLevelUpRecord.save((CoreBaseInfo)SysSettingUIViewUtil.initBaseItemLevelUpRecord(batchNumber, _shrBasicItemInfo_, 6, stepName, true, errorMessage));
        if (!model.isInner()) {
            SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.createOrUpdateBasicItemInfo(ctx, enetityAliasMap, entityObjectInfo.getFullName(), maintainUIPK, useUIPK);
            stepName = SHRSysSettingResourceUtil.getResource("basicitem_ctrl_stra", ctx);
            errorMessage = SHRSysSettingResourceUtil.getResource("upgrade_basicitem_success", ctx, shrBasicItemInfo.getNumber());
            iBaseItemLevelUpRecord.save((CoreBaseInfo)SysSettingUIViewUtil.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 7, stepName, true, errorMessage));
            SysSettingSHRBaseItemUtil.customBaseItemInit(ctx, shrBasicItemInfo);
            errorMessage = SHRSysSettingResourceUtil.getResource("basedata_upgrade_success", ctx);
            stepName = SHRSysSettingResourceUtil.getResource("basedata_upgrade", ctx);
            iBaseItemLevelUpRecord.save((CoreBaseInfo)SysSettingUIViewUtil.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 8, stepName, true, errorMessage));
            BaseItemRelationHRUtil.generateBaseItemToRelation(ctx, shrBasicItemInfo);
            errorMessage = SHRSysSettingResourceUtil.getResource("related_data_upgrade_success", ctx);
            stepName = SHRSysSettingResourceUtil.getResource("related_data_upgrade", ctx);
            iBaseItemLevelUpRecord.save((CoreBaseInfo)SysSettingUIViewUtil.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 9, stepName, true, errorMessage));
            String locale2 = ctx.getLocale().getLanguage().toString();
            SysSettingPermItemUtil.handlerPermItemUrlInfo(ctx, shrBasicItemInfo, (String)enetityAliasMap.get(locale2), maintainUipks, availableUipks);
            errorMessage = SHRSysSettingResourceUtil.getResource("permitem_upgrade_success", ctx);
            stepName = SHRSysSettingResourceUtil.getResource("permitem_upgrade", ctx);
            iBaseItemLevelUpRecord.save((CoreBaseInfo)SysSettingUIViewUtil.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 10, stepName, true, errorMessage));
            SHRFileTemplateUtil.generateCustomImportTemplate(ctx, entityObjectInfo, maintainUIPK, "import", null);
            errorMessage = SHRSysSettingResourceUtil.getResource("import_template_upgrade_success", ctx);
            stepName = SHRSysSettingResourceUtil.getResource("import_template_upgrade", ctx);
            iBaseItemLevelUpRecord.save((CoreBaseInfo)SysSettingUIViewUtil.initBaseItemLevelUpRecord(batchNumber, shrBasicItemInfo, 11, stepName, true, errorMessage));
        }
        return maintainListPK;
    }

    private static IObjectPK createBaseItemUIView(Context ctx, UIViewInfo model, EntityObjectInfo entityObjectInfo, Map<String, String> enetityAliasMap, boolean isProductionMode, CustomBaseItemUIViewEnum uipk, List<String> maintainUipks, List<String> availableUipks) throws EASBizException, BOSException {
        IUIView iUIView = null;
        iUIView = null == ctx ? UIViewFactory.getRemoteInstance() : UIViewFactory.getLocalInstance(ctx);
        UIViewInfo template = SysSettingUIViewUtil.getUIViewFromDB(iUIView, uipk.getValue());
        String uri = null;
        HashMap<String, String> nameMap = new HashMap<String, String>();
        UIType type = null;
        IObjectPK pk = null;
        String context = template.getContent();
        if (null == template.getTree()) {
            model.setTree(template.getTree());
        }
        model.setVarDefine(template.getVarDefine());
        boolean isSetUri = true;
        if (CustomBaseItemUIViewEnum.BASE_ITEM_MAINTAIN_FORM.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".maintain", ".form");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_MAINTAIN_FORM);
            type = UIType.form;
            maintainUipks.add(uri);
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_MAINTAIN_SEARCH.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".maintain", ".search");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_MAINTAIN_SEARCH);
            type = UIType.search;
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_MAINTAIN_LIST.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".maintain", ".list");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_MAINTAIN_LIST);
            context = context.replace("shr.baseinfo.maintain.TestBaseTemplate.search", SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".maintain", ".search"));
            context = context.replace("shr.baseinfo.maintain.TestBaseTemplate.form", SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".maintain", ".form"));
            type = UIType.list;
            maintainUipks.add(uri);
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_AVAILABLE_FORM.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".available", ".form");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_AVAILABLE_FORM);
            type = UIType.form;
            availableUipks.add(uri);
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_AVAILABLE_SEARCH.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".available", ".search");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_AVAILABLE_SEARCH);
            type = UIType.search;
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_AVAILABLE_LIST.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".available", ".list");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_AVAILABLE_LIST);
            context = context.replace("com.kingdee.eas.hr.emp.emp_page.app.TestBaseTemplateQuery", model.getModel() + "Query");
            context = context.replace("shr.baseinfo.available.TestBaseTemplate.search", SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".available", ".search"));
            context = context.replace("shr.baseinfo.available.TestBaseTemplate.form", SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".available", ".form"));
            type = UIType.list;
            availableUipks.add(uri);
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_VIEW_DISTRIBUTE_SEARCH.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".maintain", ".view.search");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_VIEW_DISTRIBUTE_SEARCH);
            type = UIType.search;
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_VIEW_DISTRIBUTE_LIST.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".maintain", ".viewDistribute");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_VIEW_DISTRIBUTE_LIST);
            context = context.replace("com.kingdee.eas.hr.emp.emp_page.app.TestBaseTemplateQuery", model.getModel() + "Query");
            context = context.replace("shr.baseinfo.maintain.TestBaseTemplate.view.search", SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), ".maintain", ".view.search"));
            type = UIType.list;
            maintainUipks.add(uri);
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_F7.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), null, ".F7");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_F7);
            context = context.replace("com.kingdee.eas.hr.emp.emp_page.app.TestBaseTemplateQuery", model.getModel() + "Query");
            context = context.replace("com.kingdee.eas.hr.emp.emp_page.app.TestBaseTemplate.F7.search", SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), null, ".F7.search"));
            context = context.replace("TestBaseTemplate", entityObjectInfo.getName());
            type = UIType.F7;
            isSetUri = false;
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_F7_SEARCH.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), null, ".F7.search");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_F7_SEARCH);
            type = UIType.search;
        } else if (CustomBaseItemUIViewEnum.BASE_ITEM_FASTFILTER_F7.equals((Object)uipk)) {
            uri = SysSettingUIViewUtil.generateURI(entityObjectInfo.getFullName(), null, ".FastFilter.F7");
            SysSettingUIViewUtil.setUIViewName(enetityAliasMap, nameMap, CustomBaseItemUIViewEnum.BASE_ITEM_FASTFILTER_F7);
            context = context.replace("TestBaseTemplateFastFilterF7", entityObjectInfo.getName() + ".FastFilter".replace(".", "") + ".F7".replace(".", ""));
            type = UIType.F7;
        }
        UIViewInfo newModel = new UIViewInfo();
        newModel.setInner(model.isInner());
        newModel.setModel(model.getModel());
        if (null == model.getTree()) {
            newModel.setTree(template.getTree());
        } else {
            newModel.setTree(model.getTree());
        }
        if (StringUtils.isEmpty((String)model.getVarDefine())) {
            newModel.setVarDefine(template.getVarDefine());
        } else {
            newModel.setVarDefine(model.getVarDefine());
        }
        MutilanUtils.setMultiFieldValueToBean((Context)ctx, (String)"name", (IObjectValue)newModel, nameMap);
        newModel.setUipk(uri);
        if (isSetUri) {
            newModel.setUri(uri);
        }
        newModel.setType(type);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uipk", (Object)uri, CompareType.EQUALS));
        if (!iUIView.exists(filter)) {
            if (isProductionMode) {
                newModel.setExtend(context);
                pk = iUIView.extendSave(newModel);
            } else {
                newModel.setContent(context);
                pk = iUIView.save((CoreBaseInfo)newModel);
            }
        } else {
            UIViewInfo oldInfo = SysSettingUIViewUtil.getUIViewFromDB(iUIView, uri);
            pk = new ObjectUuidPK(oldInfo.getId());
        }
        return pk;
    }

    private static void setUIViewName(Map<String, String> enetityAliasMap, Map<String, String> nameMap, CustomBaseItemUIViewEnum UIViewEnum) {
        List<Map<String, String>> languageMapingList = BOSConfigUtil.getLanguageMapingList();
        for (Map<String, String> lan : languageMapingList) {
            Locale locale = LocaleUtils.getLocale(lan.get("lang"));
            nameMap.put(lan.get("lang"), enetityAliasMap.get(lan.get("lang")) + UIViewEnum.getAlias(locale));
        }
    }

    public static String generateURI(String name, String middfix, String suffix) {
        if (StringUtils.isEmpty((String)middfix)) {
            return name + suffix;
        }
        return name + middfix + suffix;
    }

    private static UIViewInfo getUIViewFromDB(IUIView iUIView, String uipk) throws EASBizException, BOSException {
        return iUIView.getValueByUipk(uipk, SysSettingUIViewUtil.getUIViewSelector());
    }

    public static SelectorItemCollection getUIViewSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("content"));
        sic.add(new SelectorItemInfo("model"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("tree"));
        sic.add(new SelectorItemInfo("inner"));
        sic.add(new SelectorItemInfo("uri"));
        sic.add(new SelectorItemInfo("uipk"));
        sic.add(new SelectorItemInfo("varDefine"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        return sic;
    }
}

