/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class URLUtil {
    private static final String EQUALS = "=";

    public static String assembleUrlGet(String url, Map<String, Object> params) {
        StringBuilder redirectUrl = new StringBuilder(url);
        if (params != null && params.size() > 0) {
            if (redirectUrl.indexOf("?") == -1) {
                redirectUrl.append('?');
            } else {
                redirectUrl.append('&');
            }
            String key2 = null;
            String value = null;
            int index = 0;
            for (String key2 : params.keySet()) {
                if (index != 0) {
                    redirectUrl.append('&');
                }
                redirectUrl.append(key2);
                redirectUrl.append(EQUALS);
                value = params.get(key2).toString();
                try {
                    redirectUrl.append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    redirectUrl.append(URLEncoder.encode(value));
                }
                ++index;
            }
        }
        return redirectUrl.toString();
    }

    public static GetMethod getGetMethod(String url, Map<String, Object> params) {
        GetMethod getMethod = new GetMethod(URLUtil.assembleUrlGet(url, params));
        return getMethod;
    }

    public static PostMethod getPostMethod(String url, Map<String, Object> params) {
        PostMethod postMethod = new PostMethod(url);
        postMethod.getParams().setParameter("http.protocol.uri-charset", (Object)"utf-8");
        postMethod.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        if (params != null) {
            Iterator<String> paramIterator = params.keySet().iterator();
            String key = null;
            String value = null;
            while (paramIterator.hasNext()) {
                key = paramIterator.next();
                value = params.get(key).toString();
                postMethod.addParameter(key, value);
            }
        }
        return postMethod;
    }

    public static String getQueryParamValue(String url, String key) {
        URI uri = null;
        String query = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (null != uri) {
            query = uri.getQuery();
        }
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((String)query)) {
            for (String param : query.split("&")) {
                String[] pair = param.split(EQUALS);
                String k = pair[0];
                String v = pair.length > 1 ? pair[1] : "";
                queryParams.put(k, v);
            }
        }
        return (String)queryParams.get(key);
    }

    public static String replaceQueryParamKey(String url, String oldKey, String newKey) {
        String newUrl = "";
        try {
            URI uri = new URI(url);
            String query = uri.getQuery();
            LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
            for (String param : query.split("&")) {
                String[] pair = param.split(EQUALS);
                String key = pair[0];
                String value = pair.length > 1 ? pair[1] : "";
                queryParams.put(key, value);
            }
            String oldValue = (String)queryParams.remove(oldKey);
            if (oldValue != null) {
                queryParams.put(newKey, oldValue);
            }
            StringBuilder sb = new StringBuilder();
            Iterator it = queryParams.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                sb.append((String)entry.getKey()).append(EQUALS).append((String)entry.getValue());
                if (!it.hasNext()) continue;
                sb.append("&");
            }
            String newQuery = sb.toString();
            newUrl = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), newQuery, uri.getFragment()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newUrl;
    }
}

