/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util.custom;

import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizDataType;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.eas.ep.CustomTemplateInfo;
import com.kingdee.eas.ep.updater.CustomizedUnitNodeInfo;
import com.kingdee.shr.base.syssetting.util.custom.SHRUictUtils;
import com.kingdee.util.StringUtils;
import java.util.List;

public class SHRTemplateHelper {
    public static final String UITYPE_GUI = "GUI";
    public static final String UITYPE_WEB = "Web";
    public static final String UITYPE_GUI$WEB = "GUI and Web";

    public static void getRelateMetadata(BizUnitInfo info, List relate, CustomizedUnitNodeInfo cunInfo) throws Exception {
        FunctionObjectInfo fun;
        UIObjectInfo ui;
        CustomizedUnitNodeInfo.MetaDataInfo md;
        EntityObjectInfo entity = info.getEntity();
        if (entity != null) {
            if (entity.getTable() != null) {
                entity.setAlias(info.getAlias() + "\u5b9e\u4f53");
                entity.getTable().setBizUnitPK(info.getFullName());
                entity.setIsGenerateCode(false);
                relate.add(entity.getTable());
            }
            relate.add(entity);
            CustomizedUnitNodeInfo.MetaDataInfo md2 = new CustomizedUnitNodeInfo.MetaDataInfo(entity.getRealPackage(), entity.getRealName(), info.getAlias() + "\u5b9e\u4f53");
            cunInfo.getEntity().add(md2);
            BizFieldCollection fields = info.getFields();
            int n = fields.size();
            for (int i = 0; i < n; ++i) {
                if (BizDataType.OBJECT.equals((Object)fields.get(i).getBizDataType()) && fields.get(i).getDataSource() != null) {
                    EntityObjectCollection extEntityCol;
                    String propName = fields.get(i).getPropertyName();
                    if (propName == null) continue;
                    LinkPropertyInfo lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propName, false);
                    if (lnkProperty != null && lnkProperty.getRelationship() != null) {
                        RelationshipInfo relation = lnkProperty.getRelationship();
                        relate.add(relation);
                    }
                    if ((extEntityCol = info.getExtendEntities()) == null || extEntityCol.size() <= 0) continue;
                    int m = extEntityCol.size();
                    for (int j = 0; j < m; ++j) {
                        lnkProperty = (LinkPropertyInfo)extEntityCol.get(j).getPropertyByName(propName, false);
                        if (lnkProperty == null || lnkProperty.getRelationship() == null) continue;
                        RelationshipInfo relation = lnkProperty.getRelationship();
                        relate.add(relation);
                    }
                    continue;
                }
                if (!(fields.get(i) instanceof BizGroupFieldInfo)) continue;
                BizGroupFieldInfo groupField = (BizGroupFieldInfo)fields.get(i);
                SHRTemplateHelper.getRelateMetadata(info, entity, groupField, relate, cunInfo);
            }
        }
        if (info.getQuery() != null) {
            JoinQueryInfo query = info.getQuery();
            query.setAlias(info.getAlias() + "\u67e5\u8be2");
            relate.add(query);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(query.getRealPackage(), query.getRealName(), info.getAlias() + "\u67e5\u8be2");
            cunInfo.getQuery().add(md);
        }
        if (info.getEditUI() != null) {
            ui = info.getEditUI();
            ui.setAlias(info.getAlias() + "\u7f16\u8f91\u754c\u9762");
            relate.add(ui);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(ui.getRealPackage(), ui.getRealName(), info.getAlias() + "\u7f16\u8f91\u754c\u9762");
            cunInfo.getUi().getEditui().add(md);
            if (info.getEditUI().getRuleSet() != null) {
                relate.add(info.getEditUI().getRuleSet());
            }
        }
        if (info.getListUI() != null) {
            ui = info.getListUI();
            ui.setAlias(info.getAlias() + "\u67e5\u8be2\u754c\u9762");
            relate.add(ui);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(ui.getRealPackage(), ui.getRealName(), info.getAlias() + "\u67e5\u8be2\u754c\u9762");
            cunInfo.getUi().getListui().add(md);
        }
        if (info.getEntityFunction() != null) {
            relate.add(info.getEntityFunction());
        }
        if (info.getEditUIFunction() != null) {
            fun = info.getEditUIFunction();
            fun.setAlias(info.getAlias() + "\u7f16\u8f91\u529f\u80fd");
            relate.add(fun);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(fun.getRealPackage(), fun.getRealName(), fun.getAlias() + "\u7f16\u8f91\u529f\u80fd");
            cunInfo.getFunction().add(md);
        }
        if (info.getListUIFunction() != null) {
            fun = info.getListUIFunction();
            fun.setAlias(info.getAlias() + "\u5217\u8868\u529f\u80fd");
            relate.add(fun);
            md = new CustomizedUnitNodeInfo.MetaDataInfo(fun.getRealPackage(), fun.getRealName(), fun.getAlias() + "\u5217\u8868\u529f\u80fd");
            cunInfo.getFunction().add(md);
        }
    }

    public static void getRelateMetadata(BizUnitInfo info, EntityObjectInfo entity, BizGroupFieldInfo groupField, List list, CustomizedUnitNodeInfo cunInfo) throws Exception {
        JoinQueryInfo subQuery;
        EntityObjectInfo subEntity;
        DataTableInfo table = groupField.getTableObject();
        if (table != null) {
            list.add(table);
        }
        if ((subEntity = groupField.getEntityObject()) != null) {
            LinkPropertyInfo lnkProperty;
            list.add(subEntity);
            subEntity.setAlias(info.getAlias() + "\u5206\u5f55\u5b9e\u4f53");
            subEntity.setIsGenerateCode(false);
            CustomizedUnitNodeInfo.MetaDataInfo md = new CustomizedUnitNodeInfo.MetaDataInfo(subEntity.getRealPackage(), subEntity.getRealName(), info.getAlias() + "\u5206\u5f55\u5b9e\u4f53");
            cunInfo.getEntity().add(md);
            String propName = groupField.getPropertyName();
            if (propName != null && (lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propName, false)) != null && lnkProperty.getRelationship() != null) {
                RelationshipInfo relation = lnkProperty.getRelationship();
                list.add(relation);
            }
            BizFieldCollection subFields = groupField.getFields();
            int m = subFields.size();
            for (int j = 0; j < m; ++j) {
                LinkPropertyInfo lnkProperty2;
                String subPropName;
                if (subFields.get(j) instanceof BizGroupFieldInfo) {
                    SHRTemplateHelper.getRelateMetadata(info, subEntity, (BizGroupFieldInfo)subFields.get(j), list, cunInfo);
                    continue;
                }
                if (!BizDataType.OBJECT.equals((Object)subFields.get(j).getBizDataType()) || subFields.get(j).getDataSource() == null || (subPropName = subFields.get(j).getPropertyName()) == null || (lnkProperty2 = (LinkPropertyInfo)subEntity.getPropertyByName(subPropName, false)) == null || lnkProperty2.getRelationship() == null) continue;
                RelationshipInfo relation = lnkProperty2.getRelationship();
                list.add(relation);
            }
        }
        if ((subQuery = groupField.getQuery()) != null) {
            list.add(subQuery);
            subQuery.setAlias(info.getAlias() + "\u5b50\u67e5\u8be2");
            CustomizedUnitNodeInfo.MetaDataInfo md = new CustomizedUnitNodeInfo.MetaDataInfo(subQuery.getRealPackage(), subQuery.getRealName(), info.getAlias() + "\u5b50\u67e5\u8be2");
            cunInfo.getQuery().add(md);
        }
    }

    public static BizUnitInfo getBizUnit(CustomTemplateInfo template, String uiType) throws Exception {
        BizUnitInfo bizUnitInfo = null;
        if (!StringUtils.isEmpty((String)template.getBizUnit())) {
            MetaDataPK bizUnitPK = new MetaDataPK(template.getBizUnit());
            bizUnitInfo = SHRUictUtils.loadBizUnit((IMetaDataPK)bizUnitPK);
            bizUnitInfo = SHRTemplateHelper.createBizUnitInfo(bizUnitInfo, uiType);
        } else {
            bizUnitInfo = new BizUnitInfo();
            bizUnitInfo.setString("entityPK", template.getEntity());
            bizUnitInfo.setString("queryPK", template.getQuery());
            bizUnitInfo.setString("listUIFunctionPK", template.getListUIFunc());
            bizUnitInfo.setString("editUIFunctionPK", template.getEditUIFunc());
            if (UITYPE_GUI.equals(uiType)) {
                bizUnitInfo.setString("listUIPK", template.getListUI());
                bizUnitInfo.setString("editUIPK", template.getEditUI());
            } else if (UITYPE_WEB.equals(uiType)) {
                bizUnitInfo.setString("webListUIPK", template.getWebListUI());
                bizUnitInfo.setString("webEditUIPK", template.getWebEditUI());
            } else if (UITYPE_GUI$WEB.equals(uiType)) {
                bizUnitInfo.setString("listUIPK", template.getListUI());
                bizUnitInfo.setString("editUIPK", template.getEditUI());
                bizUnitInfo.setString("webListUIPK", template.getWebListUI());
                bizUnitInfo.setString("webEditUIPK", template.getWebEditUI());
            }
        }
        return bizUnitInfo;
    }

    public static BizUnitInfo createBizUnitInfo(BizUnitInfo bizUnit, String uiType) {
        if (bizUnit == null) {
            return null;
        }
        BizUnitInfo bizUnitInfo = new BizUnitInfo();
        bizUnitInfo.setName(bizUnit.getName());
        bizUnitInfo.setPackage(bizUnit.getPackage());
        bizUnitInfo.setBimTemplateType(bizUnit.getBimTemplateType());
        bizUnitInfo.setString("entityPK", bizUnit.getString("entityPK"));
        bizUnitInfo.setString("queryPK", bizUnit.getString("queryPK"));
        if (UITYPE_GUI.equals(uiType)) {
            bizUnitInfo.setString("listUIPK", bizUnit.getString("listUIPK"));
            bizUnitInfo.setString("editUIPK", bizUnit.getString("editUIPK"));
        } else if (UITYPE_WEB.equals(uiType)) {
            bizUnitInfo.setString("webListUIPK", bizUnit.getString("webListUIPK"));
            bizUnitInfo.setString("webEditUIPK", bizUnit.getString("webEditUIPK"));
        } else if (UITYPE_GUI$WEB.equals(uiType)) {
            bizUnitInfo.setString("listUIPK", bizUnit.getString("listUIPK"));
            bizUnitInfo.setString("editUIPK", bizUnit.getString("editUIPK"));
            bizUnitInfo.setString("webListUIPK", bizUnit.getString("webListUIPK"));
            bizUnitInfo.setString("webEditUIPK", bizUnit.getString("webEditUIPK"));
        }
        bizUnitInfo.setString("listUIFunctionPK", bizUnit.getString("listUIFunctionPK"));
        bizUnitInfo.setString("editUIFunctionPK", bizUnit.getString("editUIFunctionPK"));
        bizUnitInfo.setString("relatedEntityPK", bizUnit.getString("relatedEntityPK"));
        bizUnitInfo.setString("relatedTablePK", bizUnit.getString("relatedTablePK"));
        bizUnitInfo.setString("relatedEditUIPK", bizUnit.getString("relatedEditUIPK"));
        return bizUnitInfo;
    }

    public static String getUIType(CustomTemplateInfo tInfo) {
        boolean hasGUI = false;
        boolean hasWEB = false;
        String editUIPK = null;
        String listUIPK = null;
        String webEditUIPK = null;
        String webListUIPK = null;
        if (!StringUtils.isEmpty((String)tInfo.getBizUnit())) {
            MetaDataPK bizUnitPK = new MetaDataPK(tInfo.getBizUnit());
            BizUnitInfo bizUnitInfo = SHRUictUtils.loadBizUnit((IMetaDataPK)bizUnitPK);
            if (!SHRUictUtils.isEmptyMD((AbstractMDValue)bizUnitInfo)) {
                editUIPK = bizUnitInfo.getEditUIPK();
                listUIPK = bizUnitInfo.getListUIPK();
                webEditUIPK = bizUnitInfo.getWebEditUIPK();
                webListUIPK = bizUnitInfo.getWebListUIPK();
            }
        } else {
            editUIPK = tInfo.getEditUI();
            listUIPK = tInfo.getListUI();
            webEditUIPK = tInfo.getWebEditUI();
            webListUIPK = tInfo.getWebListUI();
        }
        if (!StringUtils.isEmpty((String)editUIPK) || !StringUtils.isEmpty((String)listUIPK)) {
            hasGUI = true;
        }
        if (!(!SHRTemplateHelper.supportWeb() || StringUtils.isEmpty((String)webEditUIPK) && StringUtils.isEmpty((String)webListUIPK))) {
            hasWEB = true;
        }
        if (hasGUI && hasWEB) {
            return UITYPE_GUI$WEB;
        }
        if (hasGUI) {
            return UITYPE_GUI;
        }
        if (hasWEB) {
            return UITYPE_WEB;
        }
        return "";
    }

    public static boolean supportWeb() {
        return true;
    }
}

