/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inte.cq.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.kingdee.shr.base.syssetting.web.controller.DataGridController;
import com.kingdee.shr.inte.cq.ex.APIException;
import com.kingdee.shr.inte.cq.msg.ResultCode;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpClientUtil {
    private static Logger logger = Logger.getLogger(DataGridController.class);
    private static int DEFAULT_CONNECTION_TIMEOUT = Integer.getInteger("httpclient.connectionTimeout", 10000);
    private static int DEFAULT_READ_TIMEOUT = Integer.getInteger("httpclient.readTimeout", 20000);
    private static PoolingHttpClientConnectionManager cm = null;

    public static String post(String url, Map<String, String> header, Map<String, Object> bodyMap) throws APIException {
        return HttpClientUtil.post(url, header, bodyMap, true, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static String post(String url, Map<String, String> header, Object bodyObject) throws APIException {
        return HttpClientUtil.post(url, header, bodyObject, true, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static String post(String url, Map<String, String> header, String jsonString) throws APIException {
        return HttpClientUtil.post(url, header, jsonString, true);
    }

    public static String postByXml(String url, Map<String, String> header, String xmlString) throws APIException {
        return HttpClientUtil.post(url, header, xmlString, false);
    }

    public static String post(String url, Map<String, String> header, String requestString, boolean isBodyJson) throws APIException {
        return HttpClientUtil.post(url, header, requestString, isBodyJson, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body, boolean isBodyJson) throws APIException {
        return HttpClientUtil.post(url, header, body, isBodyJson, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static String post(String url, Map<String, Object> body) throws APIException {
        HashMap<String, String> header = new HashMap<String, String>();
        return HttpClientUtil.post(url, header, body, true, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static String post(String url, Map<String, String> header, Object body, boolean isBodyJson, int connectionTimeout, int readTimeout) throws APIException {
        String data = "";
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            client = HttpClientUtil.createClient(true, false, true);
        } else {
            client = HttpClientUtil.createClient(true, false, false);
            post.setConfig(HttpClientUtil.getRequestConfig(connectionTimeout, readTimeout));
        }
        try {
            HttpResponse response;
            HttpEntity resEntity;
            Header resHeader;
            for (Map.Entry<String, String> entry : header.entrySet()) {
                post.setHeader(entry.getKey(), entry.getValue());
            }
            if (body != null) {
                StringEntity entity;
                Iterator<Map.Entry<String, String>> entity1 = null;
                if (isBodyJson) {
                    entity = body instanceof String ? new StringEntity((String)body, "UTF-8") : new StringEntity(JSON.toJSONString((Object)body), "UTF-8");
                    post.setHeader("Content-Type", "application/json");
                } else if (body instanceof String) {
                    entity = new StringEntity((String)body, "UTF-8");
                } else {
                    if (!(body instanceof Map)) {
                        throw APIException.of(ResultCode.BUSINESS_ERROR_CODE_EXCEPTION, "cannot support body dataType");
                    }
                    Map bodyParams = (Map)body;
                    ArrayList<BasicNameValuePair> paramsList = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry entryParams : bodyParams.entrySet()) {
                        paramsList.add(new BasicNameValuePair((String)entryParams.getKey(), (String)entryParams.getValue()));
                    }
                    entity = new UrlEncodedFormEntity(paramsList, "UTF-8");
                }
                post.setEntity((HttpEntity)entity);
            }
            if ((resHeader = (resEntity = (response = client.execute((HttpUriRequest)post)).getEntity()).getContentEncoding()) != null && ("gzip".equalsIgnoreCase(resHeader.getValue()) || "x-gzip".equalsIgnoreCase(resHeader.getValue()))) {
                logger.error((Object)"cannot support gzip or x-gzip header!");
                throw APIException.of(ResultCode.BUSINESS_FAILURE_EXCEPTION, "cannot support gzip or x-gzip header!");
            }
            data = EntityUtils.toString((HttpEntity)resEntity);
        }
        catch (Exception e) {
            logger.error((Object)"Exception error", (Throwable)e);
            throw APIException.of(ResultCode.BUSINESS_ERROR_CODE_EXCEPTION, "Exception error" + e.getMessage(), (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String get(String url) throws APIException {
        return HttpClientUtil.get(url, null, null, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static String get(String url, Map<String, String> header, Map<String, Object> params) throws APIException {
        return HttpClientUtil.get(url, header, params, DEFAULT_CONNECTION_TIMEOUT, DEFAULT_READ_TIMEOUT);
    }

    public static String get(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws APIException {
        String string;
        BufferedReader in = null;
        String content = null;
        String strBody = "";
        try {
            String var16;
            HttpClient client = null;
            if (body != null && !body.isEmpty()) {
                UrlEncodedFormEntity entity = null;
                ArrayList<BasicNameValuePair> paramsList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entryParams : body.entrySet()) {
                    paramsList.add(new BasicNameValuePair(entryParams.getKey(), entryParams.getValue().toString()));
                }
                entity = new UrlEncodedFormEntity(paramsList, "UTF-8");
                strBody = EntityUtils.toString((HttpEntity)entity);
            }
            String destUrl = "";
            destUrl = StringUtils.isEmpty((String)strBody) ? url : url + "?" + strBody;
            URI uri = URI.create(destUrl);
            HttpGet request = new HttpGet(uri);
            request.setConfig(HttpClientUtil.getRequestConfig(connectionTimeout, readTimeout));
            if (header != null && !header.isEmpty()) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    request.setHeader(entry.getKey(), entry.getValue());
                }
            }
            client = "https".equalsIgnoreCase(uri.getScheme()) ? HttpClientUtil.createClient(true, false, true) : HttpClientUtil.createClient(true, false, false);
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer stringBuffer = new StringBuffer();
            String line = "";
            String nl = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                stringBuffer.append(line + nl);
            }
            string = var16 = (content = stringBuffer.toString());
        }
        catch (Exception var20) {
            try {
                logger.error((Object)"IOException error", (Throwable)var20);
                throw APIException.of(ResultCode.BUSINESS_FAILURE_EXCEPTION, "IOException error", (Throwable)var20);
            }
            catch (Throwable throwable) {
                HttpClientUtil.closeQuietly(in);
                throw throwable;
            }
        }
        HttpClientUtil.closeQuietly(in);
        return string;
    }

    private static void closeQuietly(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static RequestConfig getRequestConfig(int connectionTimeout, int readTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectionTimeout).setSocketTimeout(readTimeout).setConnectionRequestTimeout(readTimeout).setCookieSpec("compatibility").build();
        return requestConfig;
    }

    private static HttpClient createHttpClient() {
        CloseableHttpClient client = HttpClients.createDefault();
        return client;
    }

    public static HttpClient createClient(boolean isPooled, boolean isRetry, boolean isSchemaHttps) {
        CloseableHttpClient httpClient = null;
        HttpRequestRetryHandler handler = null;
        if (isRetry) {
            handler = new HttpRequestRetryHandler(){

                public boolean retryRequest(IOException arg0, int retryTimes, HttpContext arg2) {
                    if (retryTimes > 2) {
                        return false;
                    }
                    if (!(arg0 instanceof UnknownHostException) && !(arg0 instanceof ConnectTimeoutException) && arg0 instanceof SSLException && !(arg0 instanceof NoHttpResponseException)) {
                        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)arg2);
                        HttpRequest request = clientContext.getRequest();
                        boolean idempotent = !(request instanceof HttpEntityEnclosingRequest);
                        return idempotent;
                    }
                    return true;
                }
            };
        }
        if (isSchemaHttps) {
            try {
                SSLConnectionSocketFactory scsf = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial((KeyStore)null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                httpClient = isRetry && handler != null ? (isPooled ? HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setSSLSocketFactory((LayeredConnectionSocketFactory)scsf).setRetryHandler(handler).build() : HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)scsf).setRetryHandler(handler).build()) : (isPooled ? HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setSSLSocketFactory((LayeredConnectionSocketFactory)scsf).build() : HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)scsf).build());
                return httpClient;
            }
            catch (Exception var6) {
                logger.error((Object)"error", (Throwable)var6);
                throw APIException.of(ResultCode.BUSINESS_FAILURE_EXCEPTION, "IOException error", (Throwable)var6);
            }
        }
        httpClient = isPooled ? HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler(handler).build() : HttpClients.custom().setRetryHandler(handler).build();
        return httpClient;
    }

    public static boolean isValidJson(String json) {
        try {
            JSON.parseObject((String)json);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    static {
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(1000);
        cm.setDefaultMaxPerRoute(1000);
    }
}

