/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.osf.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.ServiceInfo;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.osf.IServiceLocator;
import com.kingdee.shr.osf.OSFCacheHelper;
import com.kingdee.shr.osf.ServiceLocatorException;
import com.kingdee.shr.osf.service.ServiceFactory;
import com.kingdee.shr.osf.service.ServiceRegistryNotFoundException;

public final class ServiceLocator
implements IServiceLocator {
    private static final IServiceLocator _instance = new ServiceLocator();

    private ServiceLocator() {
        this.init();
    }

    private void init() {
    }

    public static IServiceLocator getInstance() {
        return _instance;
    }

    @Override
    public Object lookupService(Context ctx, String serviceName) throws ServiceLocatorException, BOSException {
        assert (serviceName != null);
        ServiceInfo serviceInfo = this._lookupServiceInfo(ctx, serviceName);
        if (serviceInfo == null) {
            throw new ServiceRegistryNotFoundException(SHRSysSettingResourceUtil.getResource("service_not_found", ctx, ctx.getAIS(), serviceName));
        }
        String serviceClassName = serviceInfo.getServiceClassName();
        String serviceInterfaceName = serviceInfo.getServiceInterfaceName();
        if (serviceClassName == null) {
            throw new ServiceRegistryNotFoundException(SHRSysSettingResourceUtil.getResource("service_not_found", ctx, ctx.getAIS(), serviceName));
        }
        Object serviceInstance = ServiceFactory.createServiceInstance(ctx, serviceName, serviceInterfaceName, serviceClassName);
        return serviceInstance;
    }

    @Override
    public Object createService(Context ctx, String serviceName, String serviceClassName, String serviceInterfaceName) throws ServiceLocatorException {
        assert (serviceName != null);
        Object serviceInstance = ServiceFactory.createServiceInstance(ctx, serviceName, serviceInterfaceName, serviceClassName);
        if (ctx != null) {
            // empty if block
        }
        return serviceInstance;
    }

    @Override
    public ServiceInfo _lookupServiceInfo(Context ctx, String serviceName) throws BOSException {
        assert (serviceName != null);
        ServiceInfo serviceInfo = OSFCacheHelper.getServiceInfo(ctx, serviceName);
        return serviceInfo;
    }
}

