/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service.classloader;

import com.kingdee.bos.bsf.service.classloader.PackageGenerator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class ComponentScanHelper {
    private final Logger logger = Logger.getLogger(ComponentScanHelper.class);

    public void scanComponents(String componentsPath, Hashtable<String, File> packageCache, Hashtable<String, JarFile> jarFileCache, Properties packageToJarMap, int homepathlength) {
        this.logger.debug((Object)("begin scan components -- ----------" + componentsPath));
        File path = new File(componentsPath);
        if (!path.exists()) {
            return;
        }
        File[] files = path.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        File file = null;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            this.logger.debug((Object)("scan file -- ----------" + file.getName()));
            if (!file.isDirectory()) continue;
            this.logger.debug((Object)("scan components -- ----------" + componentsPath));
            this.scanComponent(file.getAbsolutePath(), packageCache, jarFileCache, packageToJarMap, homepathlength);
        }
    }

    public void scanComponent(String componentPath, Hashtable<String, File> packageCache, Hashtable<String, JarFile> jarFileCache, Properties packageToJarMap, int homepathlength) {
        File path = new File(componentPath + File.separator + "lib");
        if (!path.exists()) {
            this.logger.debug((Object)("component not exists -- ----------" + path.getName()));
            return;
        }
        File[] files = path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.substring(filename.lastIndexOf(".") + 1).equalsIgnoreCase("jar") || filename.substring(filename.lastIndexOf(".") + 1).equalsIgnoreCase("zip");
            }
        });
        if (files == null || files.length == 0) {
            return;
        }
        File file = null;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            this.logger.debug((Object)("scan jar  -- ----------" + file.getName()));
            Vector<String> packages = PackageGenerator.scanPackage(file);
            String jarPath = this.getJarPath(homepathlength, file);
            this.addPackes(packages, packageToJarMap, jarPath);
            packageCache.put(jarPath, file);
            try {
                jarFileCache.put(jarPath, new JarFile(file));
                continue;
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getJarPath(int homepathlength, File file) {
        String filename = null;
        String jarPath = "";
        try {
            filename = file.getCanonicalPath();
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (filename != null) {
            filename = filename.replace('\\', '/');
            jarPath = filename.substring(homepathlength);
        }
        return jarPath;
    }

    private void addPackes(Vector<String> packages, Properties packageToJarMap, String jarPath) {
        String packageStr = null;
        for (int i = 0; i < packages.size(); ++i) {
            packageStr = packages.get(i);
            PackageGenerator.addPackageToList(packageStr, jarPath, packageToJarMap);
        }
    }
}

