/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.portal.biz.common.util.XunTongHelper;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubUtil {
    private static Logger logger = LoggerFactory.getLogger(CloudHubUtil.class);

    public static String getIntegrationEid(Context ctx) throws BOSException {
        String eid = "";
        try {
            eid = CloudHubUtil.getEid(ctx);
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
            throw new BOSException(e.getMessage());
        }
        return eid;
    }

    public static String getXunTongServerUrl(Context ctx, boolean isPrivate) throws BOSException {
        String serverUrl = "";
        Map xtInfoMap = XTServiceConfig.getInstance().getXTInfoProperties();
        if (xtInfoMap != null) {
            serverUrl = (String)xtInfoMap.get("xt.pubacct.private.server.url");
        }
        return serverUrl;
    }

    public static Properties getPubAccConfig(Context ctx, String eid, String pubaccName) throws BOSException {
        XTServiceConfig xtServiceConfig = XTServiceConfig.getInstance();
        Properties pubConfig = new Properties();
        boolean pubEnabled = xtServiceConfig.getPubEnabled(eid, pubaccName);
        String pubCode = xtServiceConfig.getPubCode(eid, pubaccName);
        String pubKey = xtServiceConfig.getPubKey(eid, pubaccName);
        if (StringUtils.isEmpty((CharSequence)String.valueOf(pubEnabled)) || StringUtils.isEmpty((CharSequence)pubCode) || StringUtils.isEmpty((CharSequence)pubKey)) {
            logger.error("Please check public address configuration!");
            throw new BOSException(SHRSysSettingResourceUtil.getResource("public_configuration_check", ctx));
        }
        pubConfig.put("enable", (Object)pubEnabled);
        pubConfig.put("pubCode", pubCode);
        pubConfig.put("pubKey", pubKey);
        return pubConfig;
    }

    public static List<String> generateReceiverSequence(Context ctx, IObjectCollection users) throws EASBizException, BOSException {
        ArrayList<String> usersArray = new ArrayList<String>();
        if (users != null) {
            int size = users.size();
            for (int i = 0; i < size; ++i) {
                String userId = ((UserInfo)users.getObject(i)).getId().toString();
                String openId = XunTongHelper.getOpenIdByUserId((Context)ctx, (String)userId);
                try {
                    if (StringUtils.isEmpty((CharSequence)openId)) {
                        throw new BOSException(SHRSysSettingResourceUtil.getResource("openid_not_found", ctx, userId));
                    }
                    usersArray.add(openId);
                    continue;
                }
                catch (BOSException e) {
                    logger.error(e.getMessage());
                    if (size > 1) continue;
                    throw new BOSException(SHRSysSettingResourceUtil.getResource("not_bind_cloudhub", ctx));
                }
            }
        } else {
            usersArray = null;
        }
        return usersArray;
    }

    public static boolean isExistXTTable(Context ctx) {
        Boolean isExist = false;
        String sql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='T_XT_SaveSetting'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() > 0) {
                isExist = true;
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return isExist;
    }

    public static String getEid(Context ctx) throws BOSException, SQLException {
        if (!CloudHubUtil.isExistXTTable(ctx)) {
            throw new BOSException(SHRSysSettingResourceUtil.getResource("table_not_exist", ctx));
        }
        String dataCenterId = ctx.getAIS();
        StringBuilder sql = new StringBuilder();
        Properties config = new Properties();
        sql.append("SELECT TOP 1 FSettingMsg FROM T_XT_SaveSetting ").append("WHERE FSettingMsg like '%").append(dataCenterId).append("%' ").append("ORDER BY FCreateTime DESC");
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (iRowSet != null && iRowSet.next()) {
            String settingMsg = iRowSet.getString("FSettingMsg");
            if (StringUtils.isEmpty((CharSequence)settingMsg)) {
                logger.error("Current datacenter do not integrated with cloudHub, please configure");
                throw new BOSException(SHRSysSettingResourceUtil.getResource("datacenter_not_integrate_cloudhub", ctx));
            }
            String[] str = settingMsg.split(";");
            int length = str.length;
            for (int i = 0; i < length; ++i) {
                String[] val = str[i].split("==");
                config.put(val[0], val[1]);
            }
        } else {
            logger.error("Current datacenter do not integrated with cloudHub, please configure");
            throw new BOSException(SHRSysSettingResourceUtil.getResource("datacenter_not_integrate_cloudhub", ctx));
        }
        return (String)config.get("eip");
    }

    public static String getXTMsgServerURL(Context ctx) {
        String serverURL = "";
        try {
            String sql = "select * from T_HR_CloudHubMsgServiceInfo";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                serverURL = rs.getString("ServiceURL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverURL;
    }
}

