/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCheckHisUtil {
    private static Logger logger = LoggerFactory.getLogger(EntityCheckHisUtil.class);

    public static boolean hasHisEntity(Context ctx, EntityObjectInfo entity) {
        String shrHisEntity;
        if (entity == null || entity.getType() == null) {
            return false;
        }
        String hisEntity = entity.getExtendedProperty(HistoryConstant.hisEntity);
        return !StringUtils.isEmpty((String)hisEntity) || !StringUtils.isEmpty((String)(shrHisEntity = entity.getExtendedProperty("shrHisEntity")));
    }

    public static boolean hasHisEntity(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return false;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        return EntityCheckHisUtil.hasHisEntity(ctx, entity);
    }

    public static String getHisEntity(Context ctx, EntityObjectInfo entity) {
        String shrHisEntity;
        if (entity == null || entity.getType() == null) {
            return null;
        }
        String hisEntity = entity.getExtendedProperty(HistoryConstant.hisEntity);
        if (StringUtils.isEmpty((String)hisEntity) && !StringUtils.isEmpty((String)(shrHisEntity = entity.getExtendedProperty("shrHisEntity")))) {
            return shrHisEntity;
        }
        return hisEntity;
    }

    public static String getHisEntity(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        return EntityCheckHisUtil.getHisEntity(ctx, entity);
    }

    public static EntityObjectInfo getHisEntityObjectInfo(Context ctx, String entityName) {
        if (!StringUtils.isEmpty((String)entityName)) {
            String hisEntity = EntityCheckHisUtil.getHisEntity(ctx, entityName);
            if (!StringUtils.isEmpty((String)entityName)) {
                return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)hisEntity));
            }
        }
        return null;
    }

    public static EntityObjectInfo getHisEntityObjectInfo(Context ctx, EntityObjectInfo entity) {
        String hisEntity;
        if (entity != null && !StringUtils.isEmpty((String)(hisEntity = EntityCheckHisUtil.getHisEntity(ctx, entity)))) {
            return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)hisEntity));
        }
        return null;
    }

    public static List<String> getPropertiesNotInHisEntity(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        return EntityCheckHisUtil.getPropertiesNotInHisEntity(ctx, entity);
    }

    public static List<String> getPropertiesNotInHisEntity(Context ctx, EntityObjectInfo entity) {
        if (entity == null || entity.getType() == null) {
            return null;
        }
        String hisEntityName = EntityCheckHisUtil.getHisEntity(ctx, entity);
        if (StringUtils.isEmpty((String)hisEntityName)) {
            return null;
        }
        EntityObjectInfo hisEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)hisEntityName));
        PropertyCollection propertyCollection = entity.getProperties();
        if (propertyCollection != null) {
            return EntityCheckHisUtil.getProperties(propertyCollection, hisEntity);
        }
        return null;
    }

    private static List<String> getProperties(PropertyCollection propertyCollection, EntityObjectInfo hisEntity) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < propertyCollection.size(); ++i) {
            String name;
            PropertyInfo propertyInfo;
            PropertyInfo info = propertyCollection.get(i);
            if (info == null || !info.isConfigured() || (propertyInfo = hisEntity.getPropertyByName(name = info.getName())) != null) continue;
            list.add(name);
        }
        return list;
    }

    public static boolean isPropertyInHisEntity(Context ctx, String entityName, String propertyName) {
        if (!StringUtils.isEmpty((String)entityName) && !StringUtils.isEmpty((String)propertyName)) {
            EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            return EntityCheckHisUtil.isPropertyInHisEntity(ctx, entity, propertyName);
        }
        return false;
    }

    public static boolean isPropertyInHisEntity(Context ctx, EntityObjectInfo entity, String propertyName) {
        if (entity != null && !StringUtils.isEmpty((String)propertyName)) {
            EntityObjectInfo hisEntity = EntityCheckHisUtil.getHisEntityObjectInfo(ctx, entity);
            return hisEntity.getPropertyByName(propertyName) != null;
        }
        return false;
    }
}

