/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.shr.base.syssetting.EntityF7ConfigCollection;
import com.kingdee.shr.base.syssetting.EntityF7ConfigFactory;
import com.kingdee.shr.base.syssetting.EntityF7ConfigInfo;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class EntityF7ConfigHelper {
    private static final String CACHE_TYPE = "shr.entityF7Config";

    public static Map<String, String> getDefaultF7Config(String entityName) throws BOSException {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        Map<String, String> item = (Map<String, String>)CacheService.getInstance().get(CACHE_TYPE, entityName);
        if (item == null) {
            item = EntityF7ConfigHelper.initEntityF7Config(entityName);
        }
        return item;
    }

    private static Map<String, String> initEntityF7Config(String entityName) throws BOSException {
        EntityF7ConfigCollection collection = EntityF7ConfigHelper.getEntityF7ConfigCollection(entityName);
        if (null == collection || collection.size() <= 0) {
            return null;
        }
        EntityF7ConfigInfo info = collection.get(0);
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("f7", info.getF7());
        item.put("functionName", info.getFunctionName());
        item.put("param", info.getParam());
        item.put("displayFormat", info.getDisplayFormat());
        CacheService.getInstance().put(CACHE_TYPE, info.getEntityName(), item);
        return item;
    }

    private static EntityF7ConfigCollection getEntityF7ConfigCollection(String entityName) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entityName"));
        sic.add(new SelectorItemInfo("f7"));
        sic.add(new SelectorItemInfo("functionName"));
        sic.add(new SelectorItemInfo("param"));
        sic.add(new SelectorItemInfo("displayFormat"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entityName", (Object)entityName));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        return EntityF7ConfigFactory.getRemoteInstance().getEntityF7ConfigCollection(viewInfo);
    }

    public static void remove(String entityName) {
        CacheService.getInstance().remove(CACHE_TYPE, entityName);
    }

    public static void removeAll() {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }
}

