/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.weibo.util.HttpClientTool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.cloudservice.ICloudServiceURLConfig;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SendMessageUtil {
    protected static Logger logger = Logger.getLogger(SendMessageUtil.class);

    public static Map<String, String> sendSMS(Context ctx, String phoneNumber, String content, String service) throws EASBizException, BOSException {
        return SendMessageUtil.sendSMSService(ctx, phoneNumber, content, service);
    }

    private static Map<String, String> sendSMSService(Context ctx, String phoneNumber, String content, String service) throws EASBizException, BOSException {
        CloudServiceConfigInfo enterpriseInfo = null;
        HashMap<String, String> result = new HashMap<String, String>();
        Object signature = null;
        Map response = null;
        try {
            ICloudServiceConfig irecConfig = CloudServiceConfigFactory.getRemoteInstance();
            CloudServiceConfigCollection collection = irecConfig.getCloudServiceConfigCollection();
            if (collection != null && collection.size() > 0) {
                enterpriseInfo = collection.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            result.put("is_success", "no_success");
            result.put("message", SHRSysSettingResourceUtil.getResource("message_send_fail", ctx));
            return result;
        }
        if (enterpriseInfo == null) {
            result.put("is_success", "no_success");
            result.put("message", SHRSysSettingResourceUtil.getResource("not_register_cloudservice", ctx));
            return result;
        }
        String serviceURL = "";
        ICloudServiceURLConfig icUrlConfig = CloudServiceURLConfigFactory.getLocalInstance((Context)ctx);
        CloudServiceURLConfigInfo csConfigInfo = icUrlConfig.getCloudServiceURLConfigInfo(" where state=1 and serviceType=4");
        if (csConfigInfo != null) {
            serviceURL = csConfigInfo.getServiceURL();
        }
        if (StringUtils.isEmpty((CharSequence)serviceURL)) {
            result.put("is_success", "no_success");
            result.put("message", SHRSysSettingResourceUtil.getResource("cloudmsg_link_null", ctx));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, String> map2 = new HashMap<String, String>();
        map1.put("enterprise", enterpriseInfo.getServiceID());
        map1.put("key", enterpriseInfo.getServiceKey());
        map1.put("signature", (String)signature);
        map2.put("phone", phoneNumber);
        map2.put("content", content);
        map2.put("service", service);
        String map1str = JSONObject.toJSONString(map1);
        String map2str = JSONObject.toJSONString(map2);
        map.put("checkinfo", map1str);
        map.put("sms", map2str);
        response = HttpClientTool.httpPost((String)serviceURL, map);
        if (response != null) {
            Object rep = response.get("HTTP_CLIENT_USER_RESULT");
            if (rep == null || rep.equals("") || rep.toString().length() == 0) {
                result.put("is_success", "no_success");
                result.put("message", SHRSysSettingResourceUtil.getResource("client_request_fail", ctx));
                return result;
            }
            JSONObject objResult = JSONObject.parseObject((String)rep.toString());
            String code = objResult.get((Object)"code").toString();
            String is_success = objResult.get((Object)"is_success").toString();
            String uuid = objResult.get((Object)"uuid").toString();
            String message = objResult.get((Object)"message").toString();
            result.put("code", code);
            result.put("is_success", is_success);
            result.put("uuid", uuid);
            result.put("message", message);
        } else {
            result.put("is_success", "no_success");
            result.put("message", SHRSysSettingResourceUtil.getResource("message_send_fail", ctx));
        }
        return result;
    }
}

