/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.json.adapter.BOSUuidTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.BosObjectCollectionTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.DateTypeAdapter;
import com.kingdee.shr.base.syssetting.json.adapter.EnumTypeAdapter;
import com.kingdee.util.enums.Enum;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class JSONUtils {
    protected static Logger logger = Logger.getLogger(JSONUtils.class);
    public static final String QUOTES_PREFIX = "${quote_2312415321232}";
    public static final String LEFT_BRACKETS_PREFIX = "${leftbracket_2312415321232}";
    public static final String RIGHT_BRACKETS_PREFIX = "${rightbracket_2312415321232}";

    public static String convertObjectToJson(Object object) {
        return JSONUtils.convertObjectToJson(JSONUtils.getContext(), object);
    }

    private static Context getContext() {
        if (null == ContextUtils.getContextFromSession()) {
            return null;
        }
        return ContextUtils.getContextFromSession();
    }

    public static String convertObjectToJson(Context ctx, Object object) {
        if (object == null || object.equals("")) {
            return "\"\"";
        }
        Gson gson = JSONUtils.getGson(ctx);
        String result = gson.toJson(object);
        if (result == null) {
            return "\"\"";
        }
        result = JSONUtils.processJsonResult(result);
        return result;
    }

    public static String processJsonResult(String result) {
        result = result.replace(QUOTES_PREFIX, "\"");
        result = result.replace("\"${leftbracket_2312415321232}", "{");
        result = result.replace(LEFT_BRACKETS_PREFIX, "{");
        result = result.replace("${rightbracket_2312415321232}\"", "}");
        result = result.replace(RIGHT_BRACKETS_PREFIX, "}");
        return result;
    }

    public static Object doOrgConvert(String orgType, Object value) throws EASBizException, BOSException {
        if (orgType == null || value == null || !(value instanceof CtrlUnitInfo)) {
            return value;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        return NewOrgUnitHelper.getTypedOrgUnit((String)((CtrlUnitInfo)value).getId().toString(), (SelectorItemCollection)sic, (OrgType)JSONUtils.getOrgType(orgType));
    }

    private static OrgType getOrgType(String orgTypeStr) {
        Set allOrgType = OrgTypeInfoMgr.getInstance().getAllOrgType();
        Object[] arrayOrgType = allOrgType.toArray();
        for (int i = 0; i < arrayOrgType.length; ++i) {
            OrgType orgType = (OrgType)arrayOrgType[i];
            if (!orgType.getName().equals(orgTypeStr)) continue;
            return orgType;
        }
        return OrgType.NONE;
    }

    public static String convertObjectToJsonForF7(String orgType, Object value) throws EASBizException, BOSException {
        if (value == null || value instanceof String && "".equals(((String)value).trim())) {
            return "null";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return JSONUtils.convertObjectToJson(JSONUtils.doOrgConvert(orgType, value));
    }

    public static Object convertJsonToObject(String json, Class clz) {
        return JSONUtils.convertJsonToObject(JSONUtils.getContext(), json, clz);
    }

    public static Object convertJsonToObject(Context ctx, String json, Class clz) {
        Gson gson = JSONUtils.getGson(ctx);
        return gson.fromJson(json, clz);
    }

    public static HashMap convertJsonToObject(String json) {
        return JSONUtils.convertJsonToObject(JSONUtils.getContext(), json);
    }

    public static HashMap convertJsonToObject(Context ctx, String json) {
        Gson gson = JSONUtils.getGson(ctx);
        return (HashMap)gson.fromJson(json.toString(), HashMap.class);
    }

    public static String encodeJson(String json) {
        StringBuilder encodedJson = new StringBuilder();
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c > '\u007f') {
                encodedJson.append("\\u").append(Integer.toHexString(c));
                continue;
            }
            encodedJson.append(c);
        }
        return encodedJson.toString();
    }

    public static Gson getGson() {
        return JSONUtils.getGson(JSONUtils.getContext());
    }

    public static Gson getGson(Context ctx) {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.serializeNulls();
        builder.serializeSpecialFloatingPointValues();
        builder.registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(BOSUuid.class, (Object)new BOSUuidTypeAdapter());
        builder.registerTypeHierarchyAdapter(IObjectCollection.class, (Object)new BosObjectCollectionTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(BizEnumValueDTO.class, (Object)new EnumTypeAdapter());
        builder.registerTypeHierarchyAdapter(Enum.class, (Object)new EnumTypeAdapter());
        return builder.create();
    }
}

