/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.osf.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.ServiceInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.shr.osf.log.IOsfLogService;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractOsfLogService
implements IOsfLogService {
    private static Logger logger = Logger.getLogger(AbstractOsfLogService.class);

    @Override
    public void process(Context ctx, ServiceInfo serviceInfo, Map param, Object result, long cost) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("functionName", "OSF");
            map.put("operate", MessageFormat.format("{0} {1}", "OSF", serviceInfo.getServiceName()));
            map.put("operateObj", MessageFormat.format("cost {0} ms, {1} s", cost, (double)cost / 1000.0));
            HashMap<String, Object> logData = this.assembleLogData(ctx, map);
            logData.put("param", param);
            this.writeLog(ctx, logData);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void writeLog(Context var1, HashMap<String, Object> var2) throws BOSException;

    protected void writeLogToAppLog(Context ctx, HashMap<String, Object> logData) throws BOSException {
        AppLogFactory.getLocalInstance((Context)ctx).writeLog(logData);
        LogUtil.afterLog((Context)ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)logData.get("FID").toString())));
    }

    protected final HashMap<String, Object> assembleLogData(Context ctx, Map<String, String> map) {
        if (null == ctx || null == map || map.isEmpty()) {
            return null;
        }
        HashMap<String, Object> logData = new HashMap<String, Object>();
        String fMethodDescriptionL2 = "";
        if (!StringUtils.isEmpty((String)map.get("operate"))) {
            fMethodDescriptionL2 = map.get("operate").length() > 255 ? map.get("operate").substring(0, 255) : map.get("operate");
        }
        LogServerUtil.setLogInfo(null, (Context)ctx, logData);
        logData.put("FIsSuccessed", "0");
        logData.put("FItemName", "manual_default_logitem");
        logData.put("FMethodDescription_L1", fMethodDescriptionL2);
        logData.put("FMethodDescription_L2", fMethodDescriptionL2);
        logData.put("FMethodDescription_L3", fMethodDescriptionL2);
        logData.put("FEntityAlias_L1", map.get("functionName"));
        logData.put("FEntityAlias_L2", map.get("functionName"));
        logData.put("FEntityAlias_L2", map.get("functionName"));
        logData.put("FInstanceNo", map.get("operateObj"));
        logData.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        return logData;
    }
}

