/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ueditor;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.IViewImageReferences;
import com.kingdee.shr.base.syssetting.ViewImageReferencesCollection;
import com.kingdee.shr.base.syssetting.ViewImageReferencesFactory;
import com.kingdee.shr.base.syssetting.ViewImageReferencesInfo;
import com.kingdee.shr.baseconfig.DocumentationConfigCollection;
import com.kingdee.shr.baseconfig.DocumentationConfigExtCollection;
import com.kingdee.shr.baseconfig.DocumentationConfigExtFactory;
import com.kingdee.shr.baseconfig.DocumentationConfigFactory;
import com.kingdee.shr.baseconfig.DocumentationConfigInfo;
import com.kingdee.shr.baseconfig.IDocumentationConfig;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.ueditor.define.State;
import com.kingdee.shr.ueditor.upload.Uploader;
import com.kingdee.shr.ueditor.util.FileUtil;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipOutputStream;
import org.operamasks.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public final class UeditorHelper {
    private static final Logger logger = LoggerFactory.getLogger(UeditorHelper.class);
    private static final String IMAGE_RENAME_PATH = "imageRenamePath";
    private static final String UEDITOR = "ueditor";
    private static final String IMAGE_NAME = "imageName";
    private static final String DATA_BASE = "dataBase";
    private static final String EXPLANATORY = "explanatory";

    private UeditorHelper() {
    }

    public static String uploadImage(Map<String, Object> configMap, Map<String, MultipartFile> fileMap, boolean isAjaxUpload) {
        String path = configMap.get("rootPath").toString() + configMap.get(IMAGE_RENAME_PATH).toString();
        File file = new File(path);
        if (file.exists()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (configMap.get("noRename").equals("true")) {
            configMap.put("savePath", configMap.get(IMAGE_RENAME_PATH));
        }
        configMap.remove(IMAGE_RENAME_PATH);
        configMap.remove("noRename");
        State state = new Uploader(configMap, isAjaxUpload, fileMap).doExec();
        return state != null ? state.toJSONString() : "";
    }

    public static String getFileAddress(String parentPath) {
        return parentPath + UEDITOR;
    }

    public static String imagesAnalysis(String realPath, Context ctx) throws BOSException {
        realPath = realPath + File.separator;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String ais = ctx.getAIS();
        IDocumentationConfig iDocumentationConfig = DocumentationConfigFactory.getLocalInstance((Context)ctx);
        DocumentationConfigCollection documentationConfigCollection = iDocumentationConfig.getDocumentationConfigCollection();
        HashMap resourcesMap = new HashMap();
        CoreBaseCollection addDatas = new CoreBaseCollection();
        ArrayList<String> quoteList = new ArrayList<String>();
        for (int i = 0; i < documentationConfigCollection.size(); ++i) {
            DocumentationConfigInfo documentationConfigInfo = documentationConfigCollection.get(i);
            BOSUuid id = documentationConfigInfo.getId();
            StringBuilder oqlSbEx = new StringBuilder("select * where parent in (");
            oqlSbEx.append("'").append(id.toString()).append("'").append(")");
            DocumentationConfigExtCollection extCollection = DocumentationConfigExtFactory.getLocalInstance((Context)ctx).getDocumentationConfigExtCollection(oqlSbEx.toString());
            List<String> contentInfo = UeditorHelper.getContentInfo(documentationConfigInfo, extCollection);
            if (contentInfo.isEmpty()) continue;
            String content = "";
            for (String contentStr : contentInfo) {
                content = content + contentStr;
            }
            ArrayList<String> exitList = new ArrayList<String>();
            ArrayList<String> noExitList = new ArrayList<String>();
            if (StringUtils.isEmpty((String)content)) {
                return null;
            }
            UeditorHelper.getImageNoExistsUrl(realPath, content, exitList, noExitList);
            quoteList.addAll(exitList);
            if (noExitList.isEmpty()) continue;
            for (String resourcesUrl : new HashSet<String>(noExitList)) {
                HashMap<String, Object> urlMap = new HashMap<String, Object>();
                urlMap.put(IMAGE_NAME, FileUtil.getFileNameByUrl(resourcesUrl));
                urlMap.put(DATA_BASE, ais);
                urlMap.put("updateTime", documentationConfigInfo.getLastUpdateTime());
                urlMap.put("updateBy", documentationConfigInfo.getLastUpdateUser());
                urlMap.put("code", documentationConfigInfo.getNumber());
                String explanatory = SHRServerResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "explanation_of_results_use", ctx, "'" + documentationConfigInfo.getNumber() + "'", UeditorHelper.getFilterAddress(resourcesUrl).replace("\\", File.separator));
                urlMap.put(EXPLANATORY, explanatory);
                resourcesMap.put(resourcesUrl, urlMap);
            }
        }
        for (Map.Entry stringMapEntry : resourcesMap.entrySet()) {
            ViewImageReferencesInfo info = new ViewImageReferencesInfo();
            Iterator valueMap = (Map)stringMapEntry.getValue();
            info.setImageName(valueMap.get(IMAGE_NAME).toString());
            info.setCode(valueMap.get("code").toString());
            info.setExplanatory(valueMap.get(EXPLANATORY).toString());
            info.setLastUpdateTime((Timestamp)valueMap.get("updateTime"));
            info.setLastUpdateUser((UserInfo)valueMap.get("updateBy"));
            info.setDataBase(valueMap.get(DATA_BASE).toString());
            addDatas.add((CoreBaseInfo)info);
        }
        ArrayList<String> nonQuoteList = new ArrayList<String>();
        File file = new File(realPath + UEDITOR);
        if (file.exists()) {
            UeditorHelper.getNonQuoteList(file, nonQuoteList, new HashSet<String>(quoteList));
        }
        if (!nonQuoteList.isEmpty()) {
            HashMap nonQuoteMap = new HashMap();
            for (String resourcesUrl : new HashSet<String>(nonQuoteList)) {
                HashMap<String, String> urlMap = new HashMap<String, String>();
                urlMap.put(IMAGE_NAME, FileUtil.getFileNameByUrl(resourcesUrl));
                urlMap.put(DATA_BASE, ais);
                urlMap.put("code", null);
                String[] ueditorList = resourcesUrl.split(UEDITOR);
                String explanatory = SHRServerResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "explanation_of_results_no_use", ctx, ueditorList[1].replace("\\", File.separator));
                urlMap.put(EXPLANATORY, explanatory);
                nonQuoteMap.put(resourcesUrl, urlMap);
            }
            for (Map.Entry stringMapEntry : nonQuoteMap.entrySet()) {
                ViewImageReferencesInfo info = new ViewImageReferencesInfo();
                Map valueMap = (Map)stringMapEntry.getValue();
                info.setImageName((String)valueMap.get(IMAGE_NAME));
                info.setCode((String)valueMap.get("code"));
                info.setExplanatory((String)valueMap.get(EXPLANATORY));
                info.setDataBase((String)valueMap.get(DATA_BASE));
                addDatas.add((CoreBaseInfo)info);
            }
        }
        try {
            IViewImageReferences localInstance = ViewImageReferencesFactory.getLocalInstance(ctx);
            ViewImageReferencesCollection collection = localInstance.getViewImageReferencesCollection();
            IObjectPK[] objectPKArr = new IObjectPK[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                objectPKArr[i] = new ObjectUuidPK(collection.get(i).getId());
            }
            localInstance.deleteBatchData(objectPKArr);
            localInstance.saveBatchData(addDatas);
        }
        catch (EASBizException e) {
            resultMap.put("data", null);
            resultMap.put("result", "fail");
            return ((Object)resultMap).toString();
        }
        resultMap.put("data", "");
        resultMap.put("result", "SUCCESS");
        return JSONObject.toJSONString(resultMap);
    }

    private static void getNonQuoteList(File file, List<String> nonQuoteList, Set<String> quoteSet) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File newFile : fileArray = file.listFiles()) {
                UeditorHelper.getNonQuoteList(newFile, nonQuoteList, quoteSet);
            }
        } else {
            String path = file.getPath();
            if (!quoteSet.contains(path.replace("\\", "/"))) {
                nonQuoteList.add(file.getPath());
            }
        }
    }

    private static String getFilterAddress(String filterLength) {
        if (StringUtils.isEmpty((String)filterLength)) {
            return "";
        }
        String urlAddress = "";
        String[] split = filterLength.replace("\\", "/").split("/");
        urlAddress = split[0];
        if (split.length >= 3) {
            urlAddress = split[0] + "/" + split[1] + "/" + split[2];
        }
        return urlAddress;
    }

    private static List<String> getContentInfo(DocumentationConfigInfo documentationConfigInfo, DocumentationConfigExtCollection documentationConfigExtCollection) {
        ArrayList<String> contents = new ArrayList<String>();
        if (null != documentationConfigInfo) {
            contents.add(documentationConfigInfo.getContent());
            contents.add(documentationConfigInfo.getContent(Locale.SIMPLIFIED_CHINESE));
            contents.add(documentationConfigInfo.getContent(Locale.ENGLISH));
            contents.add(documentationConfigInfo.getContent(Locale.TRADITIONAL_CHINESE));
        }
        for (int i = 0; i < documentationConfigExtCollection.size(); ++i) {
            contents.add(documentationConfigExtCollection.get(i).getContent());
            contents.add(documentationConfigExtCollection.get(i).getContent(Locale.SIMPLIFIED_CHINESE));
            contents.add(documentationConfigExtCollection.get(i).getContent(Locale.ENGLISH));
            contents.add(documentationConfigExtCollection.get(i).getContent(Locale.TRADITIONAL_CHINESE));
        }
        return contents;
    }

    public static byte[] createZip(String sourceFilePath, Set<String> urlSet) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream((OutputStream)outputStream);
        File file = new File(sourceFilePath);
        FileUtil.handlerFile(zip, file, "", urlSet);
        IOUtils.closeQuietly((OutputStream)zip);
        return outputStream.toByteArray();
    }

    private static void getImageNoExistsUrl(String realPath, String content, List<String> exitList, List<String> nonExitList) {
        for (String srcStr : content.split("src=\"")) {
            String addressUrl = UeditorHelper.getImagesAddress(srcStr);
            if (addressUrl == null) continue;
            if (addressUrl.contains("?random=")) {
                addressUrl = addressUrl.substring(0, addressUrl.lastIndexOf("?random="));
            }
            boolean isImage = FileUtil.isImage(addressUrl.substring(addressUrl.lastIndexOf(".") + 1));
            File file = new File(realPath + addressUrl);
            if (isImage && !file.exists()) {
                nonExitList.add(addressUrl);
            }
            if (!isImage) continue;
            exitList.add((realPath + addressUrl).replace("\\", "/"));
        }
    }

    public static List<String> getAllAddress(String realPath, String content) {
        ArrayList<String> contentList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)content)) {
            return contentList;
        }
        for (String srcStr : content.split("src=\"")) {
            String addressUrl = UeditorHelper.getImagesAddress(srcStr);
            if (StringUtils.isEmpty((String)addressUrl)) continue;
            if (addressUrl.contains("?random=")) {
                addressUrl = addressUrl.substring(0, addressUrl.lastIndexOf("?random="));
            }
            boolean isImageFile = FileUtil.isImageType(realPath + addressUrl);
            File file = new File(realPath + addressUrl);
            if (!isImageFile || !file.exists()) continue;
            String url = realPath + addressUrl;
            contentList.add(url.replace("\\", "/"));
        }
        return contentList;
    }

    private static String getImagesAddress(String srcStr) {
        if (!srcStr.contains(UEDITOR)) {
            return null;
        }
        String[] temp = srcStr.split("\"");
        return temp[0];
    }

    public static Set<String> getAllContentUrl(Context context, String realPath) throws BOSException {
        IDocumentationConfig iDocumentationConfig = DocumentationConfigFactory.getLocalInstance((Context)context);
        DocumentationConfigCollection documentationConfigCollection = iDocumentationConfig.getDocumentationConfigCollection();
        ArrayList<String> contentList = new ArrayList<String>();
        for (int i = 0; i < documentationConfigCollection.size(); ++i) {
            List<String> allAddress;
            DocumentationConfigInfo documentationConfigInfo = documentationConfigCollection.get(i);
            String content = documentationConfigInfo.getContent();
            String content1 = documentationConfigInfo.getContent(Locale.SIMPLIFIED_CHINESE);
            String content2 = documentationConfigInfo.getContent(Locale.ENGLISH);
            String content3 = documentationConfigInfo.getContent(Locale.TRADITIONAL_CHINESE);
            if (StringUtils.isEmpty((String)(content = content + content1 + content2 + content3)) || (allAddress = UeditorHelper.getAllAddress(realPath, content)).size() <= 0) continue;
            contentList.addAll(allAddress);
        }
        return new HashSet<String>(contentList);
    }
}

