/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula;

import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.shr.validaterule.formula.ISalaryCalculator;
import com.kingdee.shr.validaterule.formula.SalaryCalculator2;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CalculatorManager2 {
    static final long IDLE_TIMEOUT = 60000L;
    private static MonitorTask monitorTask = null;
    private static Map<String, CalculatorTask> taskMap = new ConcurrentHashMap<String, CalculatorTask>();

    private CalculatorManager2() {
    }

    public static void addTask(ISalaryCalculator calculator, Future future) {
        taskMap.put(calculator.getUID(), new CalculatorTask(calculator, future));
    }

    public static Future findTaskFuture(String uid) {
        CalculatorTask task = taskMap.get(uid);
        if (task == null) {
            return null;
        }
        return task.getFuture();
    }

    public static ISalaryCalculator findTask(String uid) {
        CalculatorTask task = taskMap.get(uid);
        if (task == null) {
            return null;
        }
        return task.getCalculator();
    }

    public static RuntimeMessage getRuntimeMessage(String uid) {
        ISalaryCalculator task = CalculatorManager2.findTask(uid);
        if (task == null) {
            return null;
        }
        RuntimeMessage runtimeMessage = new RuntimeMessage();
        SalaryCalculator2 taskImpl = (SalaryCalculator2)task;
        runtimeMessage.setMessage(taskImpl.getCalMessage());
        double finishBar = 0.0;
        if (taskImpl.getSalaryCalExecutor2() != null) {
            int status = task.getStatus();
            double relFinishBar = taskImpl.getFinishedPer();
            boolean isExecuteFinished = taskImpl.getSalaryCalExecutor2().isExecuteFinished();
            double ext_finishedPer = taskImpl.getSalaryCalExecutor2().getExt_finishedPer();
            finishBar = 40.0 + ext_finishedPer;
            if (isExecuteFinished && relFinishBar > finishBar) {
                finishBar = relFinishBar;
            }
            runtimeMessage.setExt_finishedPer(ext_finishedPer);
            runtimeMessage.setStatus(status);
        } else {
            double relFinishBar = taskImpl.getFinishedPer();
            finishBar = relFinishBar > 40.0 ? 40.0 : relFinishBar;
            runtimeMessage.setStatus(1);
            if (task.getStatus() == 4) {
                runtimeMessage.setStatus(4);
            }
        }
        BigDecimal curFinishBar = BigDecimal.valueOf(finishBar).setScale(2, RoundingMode.UP);
        runtimeMessage.setFinishBar(curFinishBar.doubleValue());
        return runtimeMessage;
    }

    public static ISalaryCalculator removeTask(String uid, String cause) {
        if (uid == null || "".equals(uid)) {
            return null;
        }
        CalculatorTask task = taskMap.remove(uid);
        if (task != null) {
            return task.calculator;
        }
        return null;
    }

    private static void cleanFinishedTask() {
        HashMap<String, CalculatorTask> map = new HashMap<String, CalculatorTask>(taskMap);
        for (String key : map.keySet()) {
            CalculatorTask task = (CalculatorTask)map.get(key);
            if (!task.getFuture().isDone() || !task.isRestAliveOver()) continue;
            CalculatorManager2.removeTask(key, null);
        }
    }

    static {
        monitorTask = new MonitorTask();
        monitorTask.start();
    }

    static class CalculatorTask {
        private ISalaryCalculator calculator;
        private Future future;
        private Integer restAlive = 2;
        private long startTime = System.currentTimeMillis();

        CalculatorTask() {
        }

        CalculatorTask(ISalaryCalculator calculator, Future future) {
            this.calculator = calculator;
            this.future = future;
        }

        ISalaryCalculator getCalculator() {
            return this.calculator;
        }

        Future getFuture() {
            return this.future;
        }

        boolean isRestAliveOver() {
            if (this.restAlive == 0) {
                return true;
            }
            this.restAlive = this.restAlive - 1;
            return false;
        }

        long getAliveTimeMillis() {
            long endTime = System.currentTimeMillis();
            return endTime - this.startTime;
        }
    }

    public static class RuntimeMessage {
        double finishBar;
        double ext_finishedPer;
        int status;
        String message;

        public double getFinishBar() {
            return this.finishBar;
        }

        public void setFinishBar(double finishBar) {
            this.finishBar = finishBar;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public double getExt_finishedPer() {
            return this.ext_finishedPer;
        }

        public void setExt_finishedPer(double ext_finishedPer) {
            this.ext_finishedPer = ext_finishedPer;
        }
    }

    static class MonitorTask
    extends Thread {
        MonitorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                MonitorTask monitorTask = this;
                synchronized (monitorTask) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                CalculatorManager2.cleanFinishedTask();
            }
        }
    }
}

