/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.webservice.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.shr.webservice.adapter.BOSUuidTypeAdapter;
import com.kingdee.shr.webservice.adapter.BizEnumAdapter;
import com.kingdee.shr.webservice.adapter.BosObjectCollectionTypeAdapter;
import com.kingdee.shr.webservice.adapter.BosObjectTypeAdapter;
import com.kingdee.shr.webservice.adapter.DateTypeAdapter;
import com.kingdee.shr.webservice.adapter.EnumTypeAdapter;
import com.kingdee.util.enums.Enum;
import java.sql.Timestamp;
import java.util.Date;

public class OSFWebServiceJSONUtils {
    public static final String WAF_ENUM_VALUE_KEY = "isenum";
    public static final String QUOTES_PREFIX = "${quote_2312415321232}";
    public static final String LEFT_BRACKETS_PREFIX = "${leftbracket_2312415321232}";
    public static final String RIGHT_BRACKETS_PREFIX = "${rightbracket_2312415321232}";

    public static String convertObjectToJson(Context ctx, Object object) {
        if (object == null || object.equals("")) {
            return "{}";
        }
        Gson gson = OSFWebServiceJSONUtils.getGson(ctx);
        String result = gson.toJson(object);
        if (result == null) {
            return "{}";
        }
        result = OSFWebServiceJSONUtils.processJsonResult(result);
        return result;
    }

    public static <T> T convertJsonToObject(Context ctx, String json, Class<T> clz) {
        Gson gson = OSFWebServiceJSONUtils.getGson(ctx);
        return (T)gson.fromJson(json.toString(), clz);
    }

    private static Gson getGson(Context ctx) {
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        builder.disableHtmlEscaping();
        builder.serializeSpecialFloatingPointValues();
        builder.registerTypeHierarchyAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(Timestamp.class, (Object)new DateTypeAdapter());
        builder.registerTypeHierarchyAdapter(BOSUuid.class, (Object)new BOSUuidTypeAdapter());
        builder.registerTypeHierarchyAdapter(IObjectValue.class, (Object)new BosObjectTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(IObjectCollection.class, (Object)new BosObjectCollectionTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(OrgUnitInfo.class, (Object)new BosObjectTypeAdapter(ctx));
        builder.registerTypeHierarchyAdapter(BizEnumValueDTO.class, (Object)new BizEnumAdapter(ctx));
        builder.registerTypeHierarchyAdapter(Enum.class, (Object)new EnumTypeAdapter());
        return builder.create();
    }

    private static String processJsonResult(String result) {
        result = result.replace(QUOTES_PREFIX, "\"");
        result = result.replace("\"${leftbracket_2312415321232}", "{");
        result = result.replace(LEFT_BRACKETS_PREFIX, "{");
        result = result.replace("${rightbracket_2312415321232}\"", "}");
        result = result.replace(RIGHT_BRACKETS_PREFIX, "}");
        return result;
    }
}

