/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.toolset.client;

import com.kingdee.eas.toolset.client.EASLoginUI;
import com.kingdee.eas.toolset.client.ProgressPane;
import com.kingdee.eas.toolset.util.ClassUtil;
import com.kingdee.eas.toolset.util.ETSContext;
import com.kingdee.eas.toolset.util.FileUtil;
import com.kingdee.eas.toolset.util.FrameUtil;
import com.kingdee.eas.toolset.util.HttpUtil;
import com.kingdee.eas.toolset.util.MapDBUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class RunBySelfUI
extends JFrame
implements ActionListener {
    JComboBox cmbConnect;
    JTextField serverIP;
    JTextField serverPort;
    JTextField httpPort;
    JLabel lblUserName;
    JLabel lblIP;
    JLabel lblPort;
    JLabel lblMsg;
    JLabel lblConnect;
    JButton btnOk;
    JComboBox clientPath;
    JButton btnLinkClient;
    PropertyChangeListener l;
    JFrame f;
    JTabbedPane tabPane;
    ProgressPane progress;

    public RunBySelfUI() {
        this.jbinit();
        this.f = this;
        this.onLoad();
    }

    public void onLoad() {
        this.getDefaultConnectParams();
        this.addListeners();
        this.setDefaultCloseOperation(3);
    }

    private boolean loadServerLibs() {
        String ip = this.serverIP.getText();
        String port = this.httpPort.getText();
        String localPath = String.valueOf(ETSContext.getETSHome()) + "/lib/" + ip + "-" + port;
        String localSpPath = String.valueOf(localPath) + "/sp";
        File f = new File(localSpPath);
        if (f.exists()) {
            File[] jars = f.listFiles();
            if (jars != null && jars.length > 0) {
                ClassUtil.loadJars(jars);
            }
            if ((f = new File(localPath)).exists() && (jars = f.listFiles()) != null && jars.length > 0) {
                ClassUtil.loadJars(jars);
            }
            if ((f = new File(String.valueOf(localPath) + "/ext")).exists() && (jars = f.listFiles()) != null && jars.length > 0) {
                ClassUtil.loadJars(jars);
            }
            return true;
        }
        if (!HttpUtil.isConnect(String.valueOf(ip) + " " + port)) {
            JOptionPane.showMessageDialog(this, "\u670d\u52a1\u5668ip:http\u7aef\u53e3\u8fde\u63a5\u5931\u8d25!");
            return false;
        }
        String serverPath = "http://" + ip + ":" + port + "/easWebClient/lib/";
        String str = FileUtil.loadStrFromFile(String.valueOf(ETSContext.getETSHome()) + "/config/jarlist.list", true);
        if (str != null) {
            String[] split = str.split("\n");
            int total = 0;
            int i = 0;
            while (i < split.length) {
                str = split[i];
                total = str.indexOf("@") > 0 ? (total += 2) : ++total;
                ++i;
            }
            if (split != null) {
                f.mkdirs();
                this.btnOk.setVisible(false);
                this.progress.setVisible(true);
                this.progress.setMaximum(total);
                boolean value = false;
                int i2 = 0;
                while (i2 < split.length) {
                    str = split[i2];
                    if (!str.isEmpty()) {
                        String[] jars = str.split("@");
                        this.progress.addValue();
                        int b = HttpUtil.downloadFile(serverPath, jars[0], String.valueOf(localPath) + "/sp", this.progress);
                        if (jars.length > 1) {
                            this.progress.addValue();
                            if (HttpUtil.downloadFile(serverPath, jars[1], localPath, this.progress) == -1 && b == -1) {
                                JOptionPane.showMessageDialog(this, "\u4e0b\u8f7d" + jars[1] + "\u51fa\u9519");
                                return false;
                            }
                        } else if (b == -1) {
                            JOptionPane.showMessageDialog(this, "\u4e0b\u8f7d" + jars[0] + "\u51fa\u9519");
                            return false;
                        }
                    }
                    ++i2;
                }
                if (f.exists()) {
                    this.progress.setMsg("\u4e0b\u8f7dEAS\u5ba2\u6237\u7aef\u7ec4\u4ef6\u5b8c\u6210");
                    File[] jars = f.listFiles();
                    if (jars != null && jars.length > 0) {
                        ClassUtil.loadJars(jars);
                    }
                    if ((f = new File(localPath)).exists() && (jars = f.listFiles()) != null && jars.length > 0) {
                        ClassUtil.loadJars(jars);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void addListeners() {
        this.btnOk.removeActionListener(this);
        this.btnOk.addActionListener(this);
        this.btnOk.registerKeyboardAction(this, KeyStroke.getKeyStroke(10, 0), 2);
        this.cmbConnect.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String item = (String)e.getItem();
                    String[] split = item.split(":");
                    RunBySelfUI.this.serverIP.setText(split[0]);
                    RunBySelfUI.this.serverPort.setText(split[1]);
                    RunBySelfUI.this.httpPort.setText(split[2]);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (RunBySelfUI.this.serverIP.getText() == null || RunBySelfUI.this.serverIP.getText().isEmpty()) {
                    RunBySelfUI.this.serverIP.requestFocus();
                } else if (RunBySelfUI.this.serverPort.getText() == null || RunBySelfUI.this.serverPort.getText().isEmpty()) {
                    RunBySelfUI.this.serverPort.requestFocus();
                } else if (RunBySelfUI.this.httpPort.getText() == null || RunBySelfUI.this.httpPort.getText().isEmpty()) {
                    RunBySelfUI.this.httpPort.requestFocus();
                }
            }
        });
    }

    private void getDefaultConnectParams() {
        if (this.clientPath.getItemCount() > 0) {
            this.clientPath.setSelectedIndex(0);
        } else {
            String etsHome = ETSContext.getETSHome();
            etsHome = etsHome.substring(0, etsHome.toLowerCase().lastIndexOf("eastoolsetclient"));
            File f = new File(etsHome = String.valueOf(etsHome) + "client");
            if (f.exists() && (f = new File(String.valueOf(etsHome) + "/lib")).exists()) {
                this.clientPath.addItem(etsHome);
            }
        }
        if (this.cmbConnect.getItemCount() > 0) {
            this.cmbConnect.setSelectedIndex(0);
            String item = (String)this.cmbConnect.getItemAt(0);
            String[] split = item.split(":");
            this.serverIP.setText(split[0]);
            this.serverPort.setText(split[1]);
            this.httpPort.setText(split[2]);
        }
    }

    private void jbinit() {
        int w = 400;
        int h = 260;
        FrameUtil.onCenter(this, w, h);
        this.setResizable(false);
        this.setTitle("EAS\u670d\u52a1\u5668\u8fde\u63a5\u914d\u7f6e");
        this.tabPane = new JTabbedPane();
        this.lblConnect = new JLabel("\u5386\u53f2\u8fde\u63a5");
        JButton btnDel = new JButton("\u5220\u9664");
        btnDel.setPreferredSize(new Dimension(20, 20));
        btnDel.setMargin(new Insets(0, 0, 0, 0));
        btnDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String item = (String)RunBySelfUI.this.cmbConnect.getSelectedItem();
                if (item != null) {
                    MapDBUtil.deleteServerConnector(item);
                    RunBySelfUI.this.cmbConnect.removeItem(item);
                }
            }
        });
        this.cmbConnect = new JComboBox<Object>(MapDBUtil.getServerConnectors());
        this.serverIP = new JTextField();
        this.serverPort = new JTextField();
        this.httpPort = new JTextField();
        JPanel panel = new JPanel();
        this.lblUserName = new JLabel();
        this.lblIP = new JLabel();
        this.lblPort = new JLabel();
        this.lblMsg = new JLabel();
        this.btnOk = new JButton("\u786e\u5b9a");
        this.btnOk.setPreferredSize(new Dimension(100, 30));
        JButton btnDelLink = new JButton("\u5220\u9664");
        btnDelLink.setMargin(new Insets(0, 2, 0, 2));
        btnDelLink.setPreferredSize(new Dimension(45, 25));
        btnDelLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String item = (String)RunBySelfUI.this.clientPath.getSelectedItem();
                if (item != null) {
                    MapDBUtil.deleteLinkClientPath(item);
                    RunBySelfUI.this.clientPath.removeItem(item);
                }
            }
        });
        this.btnLinkClient = new JButton("\u9009\u62e9\u76ee\u5f55");
        this.btnLinkClient.setPreferredSize(new Dimension(75, 25));
        this.btnLinkClient.setMargin(new Insets(0, 2, 0, 2));
        this.btnLinkClient.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RunBySelfUI.this.actionLinkClient();
            }
        });
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        panel.setLayout(null);
        cont.add((Component)this.tabPane, "Center");
        panel.add(this.lblUserName);
        panel.add(this.lblConnect);
        panel.add(this.httpPort);
        panel.add(this.cmbConnect);
        panel.add(this.lblIP);
        panel.add(this.serverIP);
        panel.add(this.lblPort);
        panel.add(this.serverPort);
        panel.add(this.lblMsg);
        panel.add(btnDel);
        this.lblMsg.setForeground(Color.red);
        this.lblIP.setText("\u670d\u52a1\u5668IP");
        this.lblPort.setText("RPC\u7aef\u53e3");
        this.lblUserName.setText("HTTP\u7aef\u53e3");
        this.btnOk.setText("\u786e\u5b9a");
        JPanel footPane = new JPanel();
        footPane.add(this.btnOk);
        cont.add((Component)footPane, "South");
        int y = 25;
        int n = 32;
        int height = 24;
        int lblX = 40;
        int compX = 120;
        int lblWidth = 100;
        int compWidth = 195;
        this.lblConnect.setBounds(lblX, y, lblWidth, height);
        this.cmbConnect.setBounds(compX, y, compWidth, height);
        btnDel.setBounds(compX + 200, y, 45, 25);
        this.lblIP.setBounds(lblX, y += n, lblWidth, height);
        this.serverIP.setBounds(compX, y, compWidth, height);
        this.lblPort.setBounds(lblX, y += n, lblWidth, height);
        this.serverPort.setBounds(compX, y, compWidth, height);
        this.lblUserName.setBounds(lblX, y += n, lblWidth, height);
        this.httpPort.setBounds(compX, y, compWidth, height);
        this.lblMsg.setBounds(lblX, (y += n) + 5, 180, height);
        JPanel clientLinkPane = new JPanel();
        JTextPane text = new JTextPane();
        text.setEditable(false);
        text.setPreferredSize(new Dimension(350, 110));
        text.setBorder(new EtchedBorder(0));
        this.appendStyledText(text, "\u5173\u8054EAS\u5ba2\u6237\u7aef\u8bf4\u660e\uff1a", Color.black, 13, true);
        StringBuffer desc = new StringBuffer();
        desc.append("\n      \u6b64\u8fde\u63a5\u6a21\u5f0f\u901a\u8fc7\u6307\u5b9aEAS\u5ba2\u6237\u7aef\u6240\u5728\u76ee\u5f55\uff0c");
        desc.append("\n      \u501f\u52a9EAS\u5ba2\u6237\u7aef\u7ec4\u4ef6\u4e0eEAS\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5\u3002");
        this.appendStyledText(text, desc.toString(), Color.blue, 13, false);
        desc.setLength(0);
        desc.append("\n    * \u9700\u6307\u5b9aEAS\u5ba2\u6237\u7aef\u5b89\u88c5\u76ee\u5f55client\u6587\u4ef6\u5939");
        desc.append("\n          \u4f8b:   D:/kingdee/eas/client");
        this.appendStyledText(text, desc.toString(), Color.red, 13, false);
        this.clientPath = new JComboBox<Object>(MapDBUtil.getLinkClientPath());
        this.clientPath.setPreferredSize(new Dimension(265, 25));
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setLayout(new FlowLayout(0, 0, 0));
        toolbar.add(this.clientPath);
        toolbar.add(btnDelLink);
        toolbar.add(this.btnLinkClient);
        clientLinkPane.add((Component)toolbar, "North");
        clientLinkPane.add((Component)text, "Center");
        this.progress = new ProgressPane();
        this.progress.setVisible(false);
        footPane.add(this.progress);
        this.tabPane.add("\u5173\u8054EAS\u5ba2\u6237\u7aef", clientLinkPane);
        this.tabPane.add("\u76f4\u8fdeEAS\u670d\u52a1\u5668", panel);
    }

    public void appendStyledText(JTextPane text, String str, Color color, int size, boolean isBold) {
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setForeground(set, color);
        StyleConstants.setBold(set, true);
        StyleConstants.setFontSize(set, size);
        Document doc = text.getDocument();
        try {
            doc.insertString(doc.getLength(), str, set);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void actionLinkClient() {
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle("\u8bf7\u9009\u62e9EAS\u5ba2\u6237\u7aef\u5b89\u88c5client\u76ee\u5f55");
        fd.setFileSelectionMode(1);
        fd.showOpenDialog(null);
        File f = fd.getSelectedFile();
        if (f == null) {
            return;
        }
        String path = f.getAbsolutePath();
        if (!(f = new File(String.valueOf(path) + "/bin")).exists()) {
            JOptionPane.showMessageDialog(this, "\u65e0\u6548\u7684EAS\u5ba2\u6237\u7aef\u5b89\u88c5\u76ee\u5f55!\n\u7f3a\u5c11/bin\u76ee\u5f55");
            return;
        }
        f = new File(String.valueOf(path) + "/lib");
        if (!f.exists()) {
            JOptionPane.showMessageDialog(this, "\u65e0\u6548\u7684EAS\u5ba2\u6237\u7aef\u5b89\u88c5\u76ee\u5f55!\n\u7f3a\u5c11/lib\u76ee\u5f55");
            return;
        }
        f = new File(String.valueOf(path) + "/metas");
        if (!f.exists()) {
            JOptionPane.showMessageDialog(this, "\u65e0\u6548\u7684EAS\u5ba2\u6237\u7aef\u5b89\u88c5\u76ee\u5f55!\n\u7f3a\u5c11/metas\u76ee\u5f55");
            return;
        }
        boolean b = false;
        int i = 0;
        while (i < this.clientPath.getItemCount()) {
            String item = (String)this.clientPath.getItemAt(i);
            if (path.equals(item)) {
                b = true;
            }
            ++i;
        }
        if (!b) {
            this.clientPath.addItem(path);
        }
        this.clientPath.setSelectedItem(path);
    }

    public void actionPerformed(ActionEvent e) {
        this.btnOk.setEnabled(false);
        if (this.tabPane.getSelectedIndex() == 1) {
            final String ip = this.serverIP.getText();
            final String port = this.httpPort.getText();
            final String rpcPort = this.serverPort.getText();
            if (ip == null || ip.isEmpty()) {
                JOptionPane.showMessageDialog(this, "\u8bf7\u8f93\u5165EAS\u670d\u52a1\u5668IP");
                this.btnOk.setEnabled(true);
                this.serverIP.requestFocus();
                return;
            }
            if (rpcPort == null || rpcPort.isEmpty()) {
                JOptionPane.showMessageDialog(this, "\u8bf7\u8f93\u5165RPC\u7aef\u53e3");
                this.btnOk.setEnabled(true);
                this.serverPort.requestFocus();
                return;
            }
            if (port == null || port.isEmpty()) {
                JOptionPane.showMessageDialog(this, "\u8bf7\u8f93\u5165HTTP\u7aef\u53e3");
                this.btnOk.setEnabled(true);
                this.httpPort.requestFocus();
                return;
            }
            Thread t = new Thread(new Runnable(){

                public void run() {
                    if (RunBySelfUI.this.loadServerLibs()) {
                        try {
                            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ETSContext.setIp(ip);
                        ETSContext.setHttpPort(port);
                        ETSContext.setRpcPort(rpcPort);
                        MapDBUtil.addServerConnector(String.valueOf(ip) + ":" + rpcPort + ":" + port);
                        try {
                            EASLoginUI ui = new EASLoginUI();
                            RunBySelfUI.this.f.setVisible(false);
                            ui.setVisible(true);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(RunBySelfUI.this.f, "\u542f\u52a8EAS\u767b\u9646\u7a97\u53e3\u5931\u8d25.");
                            RunBySelfUI.this.progress.setVisible(false);
                            RunBySelfUI.this.btnOk.setEnabled(true);
                            RunBySelfUI.this.btnOk.setVisible(true);
                        }
                    } else {
                        RunBySelfUI.this.progress.setVisible(false);
                        RunBySelfUI.this.btnOk.setEnabled(true);
                        RunBySelfUI.this.btnOk.setVisible(true);
                    }
                }
            });
            t.start();
        } else {
            String client = (String)this.clientPath.getSelectedItem();
            if (client == null || client.isEmpty()) {
                JOptionPane.showMessageDialog(this, "\u8bf7\u6307\u5b9aEAS\u5ba2\u6237\u7aef\u5b89\u88c5client\u76ee\u5f55!");
                this.btnOk.setEnabled(true);
                return;
            }
            if (this.loadClientLibs()) {
                try {
                    UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                ETSContext.initClientEnv(client);
                MapDBUtil.addLinkClientPath(client);
                EASLoginUI ui = new EASLoginUI();
                this.f.setVisible(false);
                ui.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, "\u52a0\u8f7dEAS\u5ba2\u6237\u7aef\u7ec4\u4ef6\u5931\u8d25!");
                this.btnOk.setEnabled(true);
            }
        }
    }

    private boolean loadClientLibs() {
        String[] split;
        String clientLib = this.clientPath.getSelectedItem() + "/lib/";
        String str = FileUtil.loadStrFromFile(String.valueOf(ETSContext.getETSHome()) + "/config/jarlist.list", true);
        if (str != null && (split = str.split("\n")) != null) {
            int i = 0;
            while (i < split.length) {
                str = split[i];
                if (!str.isEmpty()) {
                    String[] jars = str.split("@");
                    ClassUtil.loadJar(String.valueOf(clientLib) + jars[0]);
                    if (jars.length > 1) {
                        ClassUtil.loadJar(String.valueOf(clientLib) + jars[1]);
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

